<?php

namespace ContainerEzuW3vx;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/*
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class App_KernelProdContainer extends Container
{
    protected $targetDir;
    protected $parameters = [];
    protected \Closure $getService;

    public function __construct(private array $buildParameters = [], protected string $containerDir = __DIR__)
    {
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            'api_platform.symfony.parameter_validator' => 'getApiPlatform_Symfony_ParameterValidatorService',
            'cache.security_is_granted_attribute_expression_language' => 'getCache_SecurityIsGrantedAttributeExpressionLanguageService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'event_dispatcher' => 'getEventDispatcherService',
            'http_kernel' => 'getHttpKernelService',
            'monolog.logger.security' => 'getMonolog_Logger_SecurityService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
            'translator' => 'getTranslatorService',
        ];
        $this->fileMap = [
            '2fa_failed' => 'get2faFailedService',
            '2fa_required' => 'get2faRequiredService',
            '2fa_success' => 'get2faSuccessService',
            'App\\Authentication\\Controller\\SecurityController' => 'getSecurityControllerService',
            'App\\Engine\\Controller\\IndexController' => 'getIndexControllerService',
            'Nbgrp\\OneloginSamlBundle\\Controller\\AssertionConsumerService' => 'getAssertionConsumerServiceService',
            'Nbgrp\\OneloginSamlBundle\\Controller\\Login' => 'getLoginService',
            'Nbgrp\\OneloginSamlBundle\\Controller\\Logout' => 'getLogoutService',
            'Nbgrp\\OneloginSamlBundle\\Controller\\Metadata' => 'getMetadataService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'api_platform.action.documentation' => 'getApiPlatform_Action_DocumentationService',
            'api_platform.action.entrypoint' => 'getApiPlatform_Action_EntrypointService',
            'api_platform.action.exception' => 'getApiPlatform_Action_ExceptionService',
            'api_platform.action.not_exposed' => 'getApiPlatform_Action_NotExposedService',
            'api_platform.action.not_found' => 'getApiPlatform_Action_NotFoundService',
            'api_platform.action.placeholder' => 'getApiPlatform_Action_PlaceholderService',
            'api_platform.graphql.action.entrypoint' => 'getApiPlatform_Graphql_Action_EntrypointService',
            'api_platform.graphql.action.graphiql' => 'getApiPlatform_Graphql_Action_GraphiqlService',
            'api_platform.graphql.action.graphql_playground' => 'getApiPlatform_Graphql_Action_GraphqlPlaygroundService',
            'api_platform.jsonld.action.context' => 'getApiPlatform_Jsonld_Action_ContextService',
            'api_platform.swagger_ui.action' => 'getApiPlatform_SwaggerUi_ActionService',
            'api_success_handler' => 'getApiSuccessHandlerService',
            'app.system-configs' => 'getApp_SystemconfigsService',
            'app.version.provider' => 'getApp_Version_ProviderService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.rate_limiter' => 'getCache_RateLimiterService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache.validator_expression_language' => 'getCache_ValidatorExpressionLanguageService',
            'cache_warmer' => 'getCacheWarmerService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'container.get_routing_condition_service' => 'getContainer_GetRoutingConditionServiceService',
            'debug.error_handler_configurator' => 'getDebug_ErrorHandlerConfiguratorService',
            'error_controller' => 'getErrorControllerService',
            'graphql.introspection_manager' => 'getGraphql_IntrospectionManagerService',
            'legacy.route.handler' => 'getLegacy_Route_HandlerService',
            'messenger.default_bus' => 'getMessenger_DefaultBusService',
            'monolog.logger.auth' => 'getMonolog_Logger_AuthService',
            'monolog.logger.deprecation' => 'getMonolog_Logger_DeprecationService',
            'monolog.logger.install' => 'getMonolog_Logger_InstallService',
            'monolog.logger.upgrade' => 'getMonolog_Logger_UpgradeService',
            'routing.loader' => 'getRouting_LoaderService',
            'saml_user_factory' => 'getSamlUserFactoryService',
            'scheb_two_factor.firewall_context' => 'getSchebTwoFactor_FirewallContextService',
            'scheb_two_factor.form_controller' => 'getSchebTwoFactor_FormControllerService',
            'scheb_two_factor.security.totp_authenticator' => 'getSchebTwoFactor_Security_TotpAuthenticatorService',
            'scheb_two_factor.security.totp_factory' => 'getSchebTwoFactor_Security_TotpFactoryService',
            'security.app_secret_generator' => 'getSecurity_AppSecretGeneratorService',
            'services_resetter' => 'getServicesResetterService',
            'shivas_versioning.cache.version' => 'getShivasVersioning_Cache_VersionService',
        ];
        $this->aliases = [
            'ApiPlatform\\Action\\NotExposedAction' => 'api_platform.action.not_exposed',
            'ApiPlatform\\Action\\NotFoundAction' => 'api_platform.action.not_found',
            'ApiPlatform\\Action\\PlaceholderAction' => 'api_platform.action.placeholder',
            'api_platform.action.delete_item' => 'api_platform.action.placeholder',
            'api_platform.action.get_collection' => 'api_platform.action.placeholder',
            'api_platform.action.get_item' => 'api_platform.action.placeholder',
            'api_platform.action.patch_item' => 'api_platform.action.placeholder',
            'api_platform.action.post_collection' => 'api_platform.action.placeholder',
            'api_platform.action.put_item' => 'api_platform.action.placeholder',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
            'entity_manager' => 'doctrine.orm.default_entity_manager',
        ];

        $this->privates['service_container'] = static function ($container) {
            include_once \dirname(__DIR__, 3).'/core/backend/Install/Service/InstallationUtilsTrait.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Engine/LegacyHandler/LegacyHandler.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Process/Service/ActionNameMapperInterface.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Engine/LegacyHandler/ActionNameMapperHandler.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Engine/LegacyHandler/LegacyScopeState.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Module/Service/ModuleNameMapperInterface.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Module/LegacyHandler/ModuleNameMapperHandler.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Routes/EventListener/LegacyRedirectListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/event-dispatcher/EventSubscriberInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/Util/TargetPathTrait.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Routes/EventSubscriber/RequestSubscriber.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Routes/Service/RouteConverterInterface.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Routes/LegacyHandler/RouteConverterHandler.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Routes/Service/LegacyRedirectHandler.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Routes/Service/LegacyApiRedirectHandler.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Routes/Service/LegacyAssetRedirectHandler.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Routes/Service/LegacyNonViewActionRedirectHandler.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Security/CSRFCookieListener.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Security/CSRFTokenManager.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Security/CSRFValidationListener.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Security/RouteMatcherInterface.php';
            include_once \dirname(__DIR__, 3).'/core/backend/Security/RouteMatcher.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/ResponseListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/LocaleListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/ErrorListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/CacheAttributeListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php';
            include_once \dirname(__DIR__, 3).'/vendor/psr/container/src/ContainerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php';
            include_once \dirname(__DIR__, 3).'/vendor/psr/event-dispatcher/src/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/event-dispatcher/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/event-dispatcher/EventDispatcher.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/runtime/RunnerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/runtime/Runner/Symfony/HttpKernelRunner.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/runtime/Runner/Symfony/ResponseRunner.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/runtime/RuntimeInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/runtime/GenericRuntime.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/runtime/SymfonyRuntime.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/HttpKernelInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/TerminableInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/HttpKernel.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/Controller/ControllerResolverInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/framework-bundle/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/Controller/ArgumentResolver.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/service-contracts/ServiceProviderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/service-contracts/ServiceLocatorTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/dependency-injection/ServiceLocator.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-foundation/RequestStack.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/config/ConfigCacheFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/config/ResourceCheckerConfigCacheFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/psr/cache/src/CacheItemPoolInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/Adapter/AdapterInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache-contracts/CacheInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/psr/log/Psr/Log/LoggerAwareInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/service-contracts/ResetInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/ResettableInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/psr/log/Psr/Log/LoggerAwareTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/Traits/AbstractAdapterTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache-contracts/CacheTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/Traits/ContractsTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/Adapter/AbstractAdapter.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/routing/RequestContext.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/expression-language/ExpressionFunctionProviderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/RouterListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-access/PropertyAccessorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-access/PropertyAccessor.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/SerializerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/NormalizerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/DenormalizerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/EncoderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/DecoderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Serializer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/SerializerAwareInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/SerializerAwareTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Serializer/LegacyOpenApiNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Serializer/CacheableSupportsMethodInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Serializer/ApiGatewayNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Serializer/OpenApiNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/AbstractNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/ObjectNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/JsonEncoder.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/CacheableSupportsMethodInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/AbstractConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/Serializer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Problem/Serializer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/GraphQl/Serializer/Exception/ValidationExceptionNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/GraphQl/Serializer/Exception/HttpExceptionNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/GraphQl/Serializer/Exception/RuntimeExceptionNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/GraphQl/Serializer/Exception/ErrorNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Validator/Serializer/ValidationExceptionNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Util/ClassInfoTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Util/CloneTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/ContextTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/InputOutputMetadataTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/OperationContextTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/AbstractItemNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonLd/Serializer/JsonLdContextTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonLd/Serializer/ItemNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/Serializer/DocumentationNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/Serializer/EntrypointNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/Serializer/ErrorNormalizerTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/Serializer/ErrorNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/ItemNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Problem/Serializer/ErrorNormalizerTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Problem/Serializer/ErrorNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/messenger/Transport/Serialization/Normalizer/FlattenExceptionNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/ProblemNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/UidNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/CacheKeyTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/GraphQl/Serializer/ItemNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/MimeMessageNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/PropertyNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/DataUriNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/TranslatableNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/NormalizerAwareInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/Serializer/CollectionFiltersNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/Serializer/PartialCollectionViewNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/AbstractCollectionNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/Serializer/CollectionNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonLd/Serializer/ObjectNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/GraphQl/Serializer/ObjectNormalizer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/NormalizationAwareInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/XmlEncoder.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/YamlEncoder.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Encoder/CsvEncoder.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/JsonEncoder.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/YamlEncoder.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/NameConverter/NameConverterInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyAccessExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyListExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyInitializableExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyInfoCacheExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyInfoExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/property-info/Extractor/ReflectionExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/web-link/HttpHeaderSerializer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/web-link/EventListener/AddLinkHeaderListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/EventListener/SessionListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-csrf/CsrfTokenManagerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-csrf/CsrfTokenManager.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/Mapping/Factory/MetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/Validator/ValidatorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/ValidatorBuilder.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/Validation.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/ConstraintValidatorFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/ContainerConstraintValidatorFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/PruneableInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/Traits/ProxyTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/Adapter/PhpArrayAdapter.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/ObjectInitializerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/doctrine-bridge/Validator/DoctrineInitializer.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/Mapping/Loader/AutoMappingTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/validator/Mapping/Loader/PropertyInfoLoader.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/doctrine-bridge/Validator/DoctrineLoader.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/mime/MimeTypeGuesserInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/mime/MimeTypesInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/mime/MimeTypes.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authorization/AuthorizationChecker.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/service-contracts/ServiceSubscriberInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/expression-language/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authorization/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Security/Core/Authorization/ExpressionLanguageProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authorization/AccessDecisionManager.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Role/RoleHierarchyInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Role/RoleHierarchy.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/Firewall.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-bundle/EventListener/FirewallListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/FirewallMapInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-bundle/Security/FirewallMap.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/Logout/LogoutUrlGenerator.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/HttpUtils.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/EventListener/IsGrantedAttributeListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/Firewall/FirewallListenerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/Firewall/AbstractListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-http/Firewall/ContextListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Security/TwoFactor/TwoFactorFirewallConfig.php';
            include_once \dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Security/Http/Utils/RequestDataReader.php';
            include_once \dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Event/TwoFactorFormListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TwoFactorProviderPreparationListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/persistence/src/Persistence/ConnectionRegistry.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/persistence/src/Persistence/ManagerRegistry.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/persistence/src/Persistence/AbstractManagerRegistry.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/doctrine-bridge/ManagerRegistry.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/Registry.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/event-manager/src/EventManager.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/doctrine-bridge/ContainerAwareEventManager.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/dbal/src/Connection.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/ConnectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/dbal/src/Configuration.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/dbal/src/Schema/SchemaManagerFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/dbal/src/Schema/LegacySchemaManagerFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/Dbal/SchemaAssetsFilterManager.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/Dbal/RegexSchemaAssetFilter.php';
            include_once \dirname(__DIR__, 3).'/vendor/doctrine/dbal/src/Tools/DsnParser.php';
            include_once \dirname(__DIR__, 3).'/vendor/psr/log/Psr/Log/LoggerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/ResettableInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Logger.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php';
            include_once \dirname(__DIR__, 3).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/monolog-bridge/Handler/CompatibilityHandler.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/monolog-bridge/Handler/CompatibilityProcessingHandler.php';
            include_once \dirname(__DIR__, 3).'/vendor/nelmio/cors-bundle/EventListener/CorsListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/nelmio/cors-bundle/Options/ResolverInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/nelmio/cors-bundle/Options/Resolver.php';
            include_once \dirname(__DIR__, 3).'/vendor/nelmio/cors-bundle/Options/ProviderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/nelmio/cors-bundle/Options/ConfigProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/nelmio/cors-bundle/EventListener/CacheableResponseVaryListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/ProviderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/CallableProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/willdurand/negotiation/src/Negotiation/AbstractNegotiator.php';
            include_once \dirname(__DIR__, 3).'/vendor/willdurand/negotiation/src/Negotiation/Negotiator.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Api/ResourceClassResolverInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/ResourceClassResolver.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/routing/RequestContextAwareInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/routing/Matcher/UrlMatcherInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/routing/Generator/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/routing/RouterInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Api/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Routing/Router.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/Factory/CacheClassMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/Mapping/Factory/ClassMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/Loader/LoaderChain.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/serializer/Mapping/Loader/AttributeLoader.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Api/IriConverterInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Routing/SkolemIriConverter.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Api/IdentifiersExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Util/ResourceClassInfoTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/IdentifiersExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Api/UriVariablesConverterInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Api/UriVariablesConverter.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/UriVariablesResolverTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Routing/IriConverter.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/Util/OperationRequestInitiatorTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/EventListener/AddFormatListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Util/ContentNegotiationTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/Provider/ContentNegotiationProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/EventListener/ReadListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Security/State/AccessCheckerProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Bundle/SwaggerUi/SwaggerUiProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/EventListener/DeserializeListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/Provider/DeserializeProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ResourceNameCollectionFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Util/CachedTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/CachedResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ExtractorResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ClassNameResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/AttributesResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/PropertyNameCollectionFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/CachedPropertyNameCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/ExtractorPropertyNameCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/PropertyInfoPropertyNameCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/ResourceExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/AbstractResourceExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/ResourceExtractorTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/XmlResourceExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/PropertyExtractorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/AbstractPropertyExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/XmlPropertyExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/PropertyMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/CachedPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/Metadata/Property/Factory/SchemaPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Validator/Metadata/Property/ValidatorPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/ExtractorPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/AttributePropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/IdentifierPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/DefaultPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/SerializerPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Doctrine/Orm/Metadata/Property/DoctrineOrmPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Property/Factory/PropertyInfoPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ResourceMetadataCollectionFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/CachedResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Doctrine/Orm/Metadata/Resource/DoctrineOrmResourceCollectionMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Messenger/Metadata/MessengerResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/PhpDocResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/AlternateUriResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Util/AttributeFilterExtractorTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/FiltersResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/FormatsResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/InputOutputResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/OperationDefaultsTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/OperationNameResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/LinkResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/LinkFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/PropertyLinkFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Doctrine/Orm/Metadata/Resource/DoctrineOrmLinkFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/LinkFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/MainControllerResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/UriTemplateResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Operation/PathSegmentNameGeneratorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Operation/DashPathSegmentNameGenerator.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/NotExposedOperationResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ExtractorResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ParameterResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/DeprecationResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Resource/Factory/AttributesResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Operation/Factory/OperationMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Operation/Factory/OperationMetadataFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/YamlResourceExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/Extractor/YamlPropertyExtractor.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/TypeFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/TypeFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/SchemaFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/SchemaFactoryAwareInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/BackwardCompatibleSchemaFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Hydra/JsonSchema/SchemaFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/ResourceMetadataTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/SchemaFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/DefinitionNameFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonSchema/DefinitionNameFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/SerializerContextBuilderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Serializer/SerializerContextBuilder.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/SerializerContextBuilderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/SerializerFilterContextBuilder.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Serializer/SerializerContextBuilder.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Options.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Factory/OpenApiFactoryInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Serializer/NormalizeOperationNameTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/OpenApi/Factory/OpenApiFactory.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/Pagination/PaginationOptions.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonLd/ContextBuilderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonLd/AnonymousContextBuilderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/JsonLd/ContextBuilder.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Validator/State/ParameterValidatorProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/Provider/ParameterProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/State/Provider/ReadProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/EventListener/QueryParameterValidateListener.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Validator/State/QueryParameterValidateProvider.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/ParameterValidator/FilterLocatorTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/ParameterValidator/ParameterValidator.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Api/QueryParameterValidator/QueryParameterValidator.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Metadata/ResourceAccessCheckerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Security/ResourceAccessCheckerInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Security/ResourceAccessChecker.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Security/Authentication/AuthenticationTrustResolver.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.php';
            include_once \dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TwoFactorProviderRegistry.php';
            include_once \dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/PreparationRecorderInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TokenPreparationRecorder.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation-contracts/TranslatorInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation/TranslatorBagInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation-contracts/LocaleAwareInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation/Translator.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/framework-bundle/Translation/Translator.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation/Formatter/MessageFormatterInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation/Formatter/IntlFormatterInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation/Formatter/MessageFormatter.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation-contracts/TranslatorTrait.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/translation/IdentityTranslator.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/routing/Matcher/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/routing/Router.php';
            include_once \dirname(__DIR__, 3).'/vendor/symfony/framework-bundle/Routing/Router.php';
        };
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true): mixed
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    protected function createProxy($class, \Closure $factory)
    {
        class_exists($class, false) || require __DIR__.'/'.$class.'.php';

        return $factory();
    }

    /*
     * Gets the public 'api_platform.symfony.parameter_validator' shared service.
     *
     * @return \ApiPlatform\Symfony\Validator\State\ParameterValidatorProvider
     */
    protected static function getApiPlatform_Symfony_ParameterValidatorService($container)
    {
        $a = ($container->privates['api_platform.state_provider.locator'] ?? self::getApiPlatform_StateProvider_LocatorService($container));

        if (isset($container->services['api_platform.symfony.parameter_validator'])) {
            return $container->services['api_platform.symfony.parameter_validator'];
        }

        return $container->services['api_platform.symfony.parameter_validator'] = new \ApiPlatform\Symfony\Validator\State\ParameterValidatorProvider(new \ApiPlatform\State\Provider\ParameterProvider(new \ApiPlatform\State\Provider\ReadProvider($a, ($container->privates['api_platform.openapi.serializer_context_builder'] ?? self::getApiPlatform_Openapi_SerializerContextBuilderService($container))), ($container->privates['.service_locator.sL05zc0'] ?? self::get_ServiceLocator_SL05zc0Service($container))), ($container->privates['validator'] ?? self::getValidatorService($container)));
    }

    /*
     * Gets the public 'cache.security_is_granted_attribute_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SecurityIsGrantedAttributeExpressionLanguageService($container)
    {
        return $container->services['cache.security_is_granted_attribute_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('AYg9w387Gv', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected static function getDoctrineService($container)
    {
        return $container->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($container, $container->parameters['doctrine.connections'], $container->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /*
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected static function getDoctrine_Dbal_DefaultConnectionService($container)
    {
        $a = new \Doctrine\DBAL\Configuration();
        $a->setAutoCommit(true);
        $a->setSchemaManagerFactory(new \Doctrine\DBAL\Schema\LegacySchemaManagerFactory());
        $a->setSchemaAssetsFilter(new \Doctrine\Bundle\DoctrineBundle\Dbal\SchemaAssetsFilterManager([new \Doctrine\Bundle\DoctrineBundle\Dbal\RegexSchemaAssetFilter('/^(users|migration_versions|)$/')]));
        $a->setMiddlewares([]);

        return $container->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory([], new \Doctrine\DBAL\Tools\DsnParser(['db2' => 'ibm_db2', 'mssql' => 'pdo_sqlsrv', 'mysql' => 'pdo_mysql', 'mysql2' => 'pdo_mysql', 'postgres' => 'pdo_pgsql', 'postgresql' => 'pdo_pgsql', 'pgsql' => 'pdo_pgsql', 'sqlite' => 'pdo_sqlite', 'sqlite3' => 'pdo_sqlite'])))->createConnection(['url' => $container->getEnv('DATABASE_URL'), 'driver' => 'pdo_mysql', 'charset' => 'UTF8', 'host' => 'localhost', 'port' => NULL, 'user' => 'root', 'password' => NULL, 'driverOptions' => [], 'defaultTableOptions' => ['charset' => 'utf8', 'collate' => 'utf8_unicode_ci']], $a, ($container->privates['doctrine.dbal.default_connection.event_manager'] ?? self::getDoctrine_Dbal_DefaultConnection_EventManagerService($container)), []);
    }

    /*
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected static function getDoctrine_Orm_DefaultEntityManagerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['doctrine.orm.default_entity_manager'] = $container->createProxy('EntityManagerGhost6410e2e', static fn () => \EntityManagerGhost6410e2e::createLazyGhost(static fn ($proxy) => self::getDoctrine_Orm_DefaultEntityManagerService($container, $proxy)));
        }

        include_once \dirname(__DIR__, 3).'/vendor/doctrine/common/src/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/persistence/src/Persistence/ObjectManager.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/EntityManagerInterface.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/EntityManager.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Configuration.php';
        include_once \dirname(__DIR__, 3).'/vendor/symfony/cache/Adapter/ArrayAdapter.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/MappingDriver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/Mapping/MappingDriver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/MappingDriverChain.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Mapping/Driver/CompatibilityAnnotationDriver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/ColocatedMappingDriver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Mapping/Driver/ReflectionBasedDriver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Mapping/Driver/AttributeDriver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Mapping/NamingStrategy.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Mapping/UnderscoreNamingStrategy.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Mapping/QuoteStrategy.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Internal/SQLResultCasing.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Mapping/DefaultQuoteStrategy.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Mapping/EntityListenerResolver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/Mapping/EntityListenerServiceResolver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/Mapping/ContainerEntityListenerResolver.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/orm/src/Repository/RepositoryFactory.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/Repository/RepositoryFactoryCompatibility.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/Repository/ContainerRepositoryFactory.php';
        include_once \dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/src/ManagerConfigurator.php';

        $a = new \Doctrine\ORM\Configuration();

        $b = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();
        $b->addDriver(new \Doctrine\ORM\Mapping\Driver\AttributeDriver($container->parameters['api_platform.resource_class_directories'], true), 'App');

        $a->setEntityNamespaces(['App' => 'App']);
        $a->setMetadataCache(new \Symfony\Component\Cache\Adapter\PhpArrayAdapter(($container->targetDir.''.'/doctrine/orm/default_metadata.php'), new \Symfony\Component\Cache\Adapter\ArrayAdapter()));
        $a->setQueryCache(($container->privates['doctrine.system_cache_pool'] ?? self::getDoctrine_SystemCachePoolService($container)));
        $a->setResultCache(($container->privates['doctrine.result_cache_pool'] ?? self::getDoctrine_ResultCachePoolService($container)));
        $a->setMetadataDriverImpl(new \Doctrine\Bundle\DoctrineBundle\Mapping\MappingDriver($b, new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'doctrine.ulid_generator' => ['privates', 'doctrine.ulid_generator', 'getDoctrine_UlidGeneratorService', true],
            'doctrine.uuid_generator' => ['privates', 'doctrine.uuid_generator', 'getDoctrine_UuidGeneratorService', true],
        ], [
            'doctrine.ulid_generator' => '?',
            'doctrine.uuid_generator' => '?',
        ])));
        $a->setProxyDir(($container->targetDir.''.'/doctrine/orm/Proxies'));
        $a->setProxyNamespace('Proxies');
        $a->setAutoGenerateProxyClasses(false);
        $a->setSchemaIgnoreClasses([]);
        $a->setClassMetadataFactoryName('Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ClassMetadataFactory');
        $a->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $a->setNamingStrategy(new \Doctrine\ORM\Mapping\UnderscoreNamingStrategy(0, true));
        $a->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $a->setEntityListenerResolver(new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver($container));
        $a->setLazyGhostObjectEnabled(true);
        $a->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(($container->privates['api_platform.graphql.mutation_resolver_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], []))));

        $instance = ($lazyLoad->__construct(($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), $a, ($container->privates['doctrine.dbal.default_connection.event_manager'] ?? self::getDoctrine_Dbal_DefaultConnection_EventManagerService($container))) && false ?: $lazyLoad);

        (new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator([], []))->configure($instance);

        return $instance;
    }

    /*
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected static function getEventDispatcherService($container)
    {
        $container->services['event_dispatcher'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('kernel.request', [#[\Closure(name: 'App\\Routes\\EventListener\\LegacyRedirectListener')] fn () => ($container->privates['App\\Routes\\EventListener\\LegacyRedirectListener'] ?? self::getLegacyRedirectListenerService($container)), '__invoke'], 2050);
        $instance->addListener('kernel.response', [#[\Closure(name: 'App\\Security\\CSRFCookieListener')] fn () => ($container->privates['App\\Security\\CSRFCookieListener'] ?? self::getCSRFCookieListenerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'App\\Security\\CSRFValidationListener')] fn () => ($container->privates['App\\Security\\CSRFValidationListener'] ?? self::getCSRFValidationListenerService($container)), 'onKernelRequest'], 12);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_provider', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserProviderListener')] fn () => ($container->privates['security.listener.user_provider'] ?? $container->load('getSecurity_Listener_UserProviderService')), 'checkPassport'], 1024);
        $instance->addListener('kernel.response', [#[\Closure(name: 'security.context_listener.0', class: 'Symfony\\Component\\Security\\Http\\Firewall\\ContextListener')] fn () => ($container->privates['security.context_listener.0'] ?? self::getSecurity_ContextListener_0Service($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'nelmio_cors.cors_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CorsListener')] fn () => ($container->privates['nelmio_cors.cors_listener'] ?? self::getNelmioCors_CorsListenerService($container)), 'onKernelRequest'], 250);
        $instance->addListener('kernel.response', [#[\Closure(name: 'nelmio_cors.cors_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CorsListener')] fn () => ($container->privates['nelmio_cors.cors_listener'] ?? self::getNelmioCors_CorsListenerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'nelmio_cors.cacheable_response_vary_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CacheableResponseVaryListener')] fn () => ($container->privates['nelmio_cors.cacheable_response_vary_listener'] ??= new \Nelmio\CorsBundle\EventListener\CacheableResponseVaryListener()), 'onResponse'], -10);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'api_platform.listener.exception', class: 'ApiPlatform\\Symfony\\EventListener\\ExceptionListener')] fn () => ($container->privates['api_platform.listener.exception'] ?? $container->load('getApiPlatform_Listener_ExceptionService')), 'onKernelException'], -96);
        $instance->addListener('kernel.request', [#[\Closure(name: 'api_platform.listener.request.add_format', class: 'ApiPlatform\\Symfony\\EventListener\\AddFormatListener')] fn () => ($container->privates['api_platform.listener.request.add_format'] ?? self::getApiPlatform_Listener_Request_AddFormatService($container)), 'onKernelRequest'], 28);
        $instance->addListener('kernel.request', [#[\Closure(name: 'api_platform.listener.request.read', class: 'ApiPlatform\\Symfony\\EventListener\\ReadListener')] fn () => ($container->privates['api_platform.listener.request.read'] ?? self::getApiPlatform_Listener_Request_ReadService($container)), 'onKernelRequest'], 4);
        $instance->addListener('kernel.request', [#[\Closure(name: 'api_platform.listener.request.deserialize', class: 'ApiPlatform\\Symfony\\EventListener\\DeserializeListener')] fn () => ($container->privates['api_platform.listener.request.deserialize'] ?? self::getApiPlatform_Listener_Request_DeserializeService($container)), 'onKernelRequest'], 2);
        $instance->addListener('kernel.view', [#[\Closure(name: 'api_platform.listener.view.write', class: 'ApiPlatform\\Symfony\\EventListener\\WriteListener')] fn () => ($container->privates['api_platform.listener.view.write'] ?? $container->load('getApiPlatform_Listener_View_WriteService')), 'onKernelView'], 32);
        $instance->addListener('kernel.view', [#[\Closure(name: 'api_platform.listener.view.serialize', class: 'ApiPlatform\\Symfony\\EventListener\\SerializeListener')] fn () => ($container->privates['api_platform.listener.view.serialize'] ?? $container->load('getApiPlatform_Listener_View_SerializeService')), 'onKernelView'], 16);
        $instance->addListener('kernel.view', [#[\Closure(name: 'api_platform.listener.view.respond', class: 'ApiPlatform\\Symfony\\EventListener\\RespondListener')] fn () => ($container->privates['api_platform.listener.view.respond'] ?? $container->load('getApiPlatform_Listener_View_RespondService')), 'onKernelView'], 8);
        $instance->addListener('kernel.view', [#[\Closure(name: 'api_platform.listener.view.validate', class: 'ApiPlatform\\Symfony\\EventListener\\ValidateListener')] fn () => ($container->privates['api_platform.listener.view.validate'] ?? $container->load('getApiPlatform_Listener_View_ValidateService')), 'onKernelView'], 64);
        $instance->addListener('kernel.request', [#[\Closure(name: 'api_platform.listener.view.validate_query_parameters', class: 'ApiPlatform\\Symfony\\EventListener\\QueryParameterValidateListener')] fn () => ($container->privates['api_platform.listener.view.validate_query_parameters'] ?? self::getApiPlatform_Listener_View_ValidateQueryParametersService($container)), 'onKernelRequest'], 16);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'Nbgrp\\OneloginSamlBundle\\EventListener\\Security\\SamlLogoutListener')] fn () => ($container->privates['Nbgrp\\OneloginSamlBundle\\EventListener\\Security\\SamlLogoutListener'] ?? $container->load('getSamlLogoutListenerService')), 'processSingleLogout'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'Nbgrp\\OneloginSamlBundle\\EventListener\\User\\DeferredUserListener')] fn () => ($container->privates['Nbgrp\\OneloginSamlBundle\\EventListener\\User\\DeferredUserListener'] ??= new \Nbgrp\OneloginSamlBundle\EventListener\User\DeferredUserListener()), 'dispatchDeferredEvent'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'App\\Routes\\EventSubscriber\\RequestSubscriber')] fn () => ($container->privates['App\\Routes\\EventSubscriber\\RequestSubscriber'] ?? self::getRequestSubscriberService($container)), 'onKernelRequest'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'App\\Security\\CheckExternalAuthOnlyCredentialsListener')] fn () => ($container->privates['App\\Security\\CheckExternalAuthOnlyCredentialsListener'] ??= new \App\Security\CheckExternalAuthOnlyCredentialsListener()), 'onCheckPassport'], 200);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'App\\Security\\LoginSuccessEventListener')] fn () => ($container->privates['App\\Security\\LoginSuccessEventListener'] ?? $container->load('getLoginSuccessEventListenerService')), 'onLoginSuccess'], 0);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'argument_resolver.request_payload', class: 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver')] fn () => ($container->privates['argument_resolver.request_payload'] ?? self::getArgumentResolver_RequestPayloadService($container)), 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'response_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ResponseListener')] fn () => ($container->privates['response_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8', false)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'validate_request_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ValidateRequestListener')] fn () => ($container->privates['validate_request_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()), 'onKernelRequest'], 256);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onKernelException'], -128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'removeCspHeader'], -128);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelControllerArguments'], 10);
        $instance->addListener('kernel.response', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelResponse'], -10);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ?? $container->load('getConsole_ErrorListenerService')), 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ?? $container->load('getConsole_ErrorListenerService')), 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [#[\Closure(name: 'console.suggest_missing_package_subscriber', class: 'Symfony\\Bundle\\FrameworkBundle\\EventListener\\SuggestMissingPackageSubscriber')] fn () => ($container->privates['console.suggest_missing_package_subscriber'] ??= new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()), 'onConsoleError'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.envelope_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\EnvelopeListener')] fn () => ($container->privates['mailer.envelope_listener'] ??= new \Symfony\Component\Mailer\EventListener\EnvelopeListener(NULL, NULL)), 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.message_logger_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessageLoggerListener')] fn () => ($container->privates['mailer.message_logger_listener'] ??= new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()), 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.messenger_transport_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessengerTransportListener')] fn () => ($container->privates['mailer.messenger_transport_listener'] ??= new \Symfony\Component\Mailer\EventListener\MessengerTransportListener()), 'onMessage'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'))), 'configure'], 2048);
        $instance->addListener('console.command', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'))), 'configure'], 2048);
        $instance->addListener('kernel.request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelException'], -64);
        $instance->addListener('kernel.response', [#[\Closure(name: 'web_link.add_link_header_listener', class: 'Symfony\\Component\\WebLink\\EventListener\\AddLinkHeaderListener')] fn () => ($container->privates['web_link.add_link_header_listener'] ?? self::getWebLink_AddLinkHeaderListenerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'session_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\SessionListener')] fn () => ($container->privates['session_listener'] ?? self::getSessionListenerService($container)), 'onKernelRequest'], 128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'session_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\SessionListener')] fn () => ($container->privates['session_listener'] ?? self::getSessionListenerService($container)), 'onKernelResponse'], -1000);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.retry.send_failed_message_for_retry_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\SendFailedMessageForRetryListener')] fn () => ($container->privates['messenger.retry.send_failed_message_for_retry_listener'] ?? $container->load('getMessenger_Retry_SendFailedMessageForRetryListenerService')), 'onMessageFailed'], 100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.failure.add_error_details_stamp_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\AddErrorDetailsStampListener')] fn () => ($container->privates['messenger.failure.add_error_details_stamp_listener'] ??= new \Symfony\Component\Messenger\EventListener\AddErrorDetailsStampListener()), 'onMessageFailed'], 200);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.dispatch_pcntl_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\DispatchPcntlSignalListener')] fn () => ($container->privates['messenger.listener.dispatch_pcntl_signal_listener'] ??= new \Symfony\Component\Messenger\EventListener\DispatchPcntlSignalListener()), 'onWorkerRunning'], 100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerStartedEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_restart_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnRestartSignalListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_restart_signal_listener'] ?? $container->load('getMessenger_Listener_StopWorkerOnRestartSignalListenerService')), 'onWorkerStarted'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_restart_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnRestartSignalListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_restart_signal_listener'] ?? $container->load('getMessenger_Listener_StopWorkerOnRestartSignalListenerService')), 'onWorkerRunning'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_stop_exception_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnCustomStopExceptionListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_stop_exception_listener'] ??= new \Symfony\Component\Messenger\EventListener\StopWorkerOnCustomStopExceptionListener()), 'onMessageFailed'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_stop_exception_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnCustomStopExceptionListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_stop_exception_listener'] ??= new \Symfony\Component\Messenger\EventListener\StopWorkerOnCustomStopExceptionListener()), 'onWorkerRunning'], 0);
        $instance->addListener('Symfony\\Component\\Notifier\\Event\\MessageEvent', [#[\Closure(name: 'notifier.notification_logger_listener', class: 'Symfony\\Component\\Notifier\\EventListener\\NotificationLoggerListener')] fn () => ($container->privates['notifier.notification_logger_listener'] ??= new \Symfony\Component\Notifier\EventListener\NotificationLoggerListener()), 'onNotification'], -255);
        $instance->addListener('kernel.view', [#[\Closure(name: 'controller.template_attribute_listener', class: 'Symfony\\Bridge\\Twig\\EventListener\\TemplateAttributeListener')] fn () => ($container->privates['controller.template_attribute_listener'] ?? $container->load('getController_TemplateAttributeListenerService')), 'onKernelView'], -128);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'twig.mailer.message_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessageListener')] fn () => ($container->privates['twig.mailer.message_listener'] ?? $container->load('getTwig_Mailer_MessageListenerService')), 'onMessage'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\EventListener\\FirewallListener')] fn () => ($container->privates['security.firewall'] ?? self::getSecurity_FirewallService($container)), 'configureLogoutUrlGenerator'], 8);
        $instance->addListener('kernel.request', [#[\Closure(name: 'security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\EventListener\\FirewallListener')] fn () => ($container->privates['security.firewall'] ?? self::getSecurity_FirewallService($container)), 'onKernelRequest'], 8);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\EventListener\\FirewallListener')] fn () => ($container->privates['security.firewall'] ?? self::getSecurity_FirewallService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.is_granted_attribute_listener', class: 'Symfony\\Component\\Security\\Http\\EventListener\\IsGrantedAttributeListener')] fn () => ($container->privates['controller.is_granted_attribute_listener'] ?? self::getController_IsGrantedAttributeListenerService($container)), 'onKernelControllerArguments'], 20);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.check_authenticator_credentials', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CheckCredentialsListener')] fn () => ($container->privates['security.listener.check_authenticator_credentials'] ?? $container->load('getSecurity_Listener_CheckAuthenticatorCredentialsService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.password_migrating', class: 'Symfony\\Component\\Security\\Http\\EventListener\\PasswordMigratingListener')] fn () => ($container->privates['security.listener.password_migrating'] ?? $container->load('getSecurity_Listener_PasswordMigratingService')), 'onLoginSuccess'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'security.authentication.kernel_exception_listener.two_factor.main', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\Firewall\\ExceptionListener')] fn () => ($container->privates['security.authentication.kernel_exception_listener.two_factor.main'] ?? $container->load('getSecurity_Authentication_KernelExceptionListener_TwoFactor_MainService')), 'onKernelException'], 2);
        $instance->addListener('kernel.request', [#[\Closure(name: 'security.authentication.form_listener.two_factor.main', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Event\\TwoFactorFormListener')] fn () => ($container->privates['security.authentication.form_listener.two_factor.main'] ?? self::getSecurity_Authentication_FormListener_TwoFactor_MainService($container)), 'onKernelRequest'], 0);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.main', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.main'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_MainService($container)), 'onLogin'], 9223372036854775807);
        $instance->addListener('scheb_two_factor.authentication.require', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.main', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.main'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_MainService($container)), 'onAccessDenied'], 0);
        $instance->addListener('scheb_two_factor.authentication.form', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.main', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.main'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_MainService($container)), 'onTwoFactorForm'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.main', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.main'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_MainService($container)), 'onKernelResponse'], 1);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageHandledEvent', [#[\Closure(name: 'doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager', class: 'Symfony\\Bridge\\Doctrine\\Messenger\\DoctrineClearEntityManagerWorkerSubscriber')] fn () => ($container->privates['doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager'] ?? $container->load('getDoctrine_Orm_Messenger_EventSubscriber_DoctrineClearEntityManagerService')), 'onWorkerMessageHandled'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager', class: 'Symfony\\Bridge\\Doctrine\\Messenger\\DoctrineClearEntityManagerWorkerSubscriber')] fn () => ($container->privates['doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager'] ?? $container->load('getDoctrine_Orm_Messenger_EventSubscriber_DoctrineClearEntityManagerService')), 'onWorkerMessageFailed'], 0);
        $instance->addListener('console.command', [#[\Closure(name: 'monolog.handler.console', class: 'Symfony\\Bridge\\Monolog\\Handler\\ConsoleHandler')] fn () => ($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)), 'onCommand'], 255);
        $instance->addListener('console.terminate', [#[\Closure(name: 'monolog.handler.console', class: 'Symfony\\Bridge\\Monolog\\Handler\\ConsoleHandler')] fn () => ($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)), 'onTerminate'], -255);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.check_two_factor_code', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\CheckTwoFactorCodeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.check_two_factor_code'] ?? $container->load('getSchebTwoFactor_Security_Listener_CheckTwoFactorCodeService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.suppress_remember_me', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\SuppressRememberMeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.suppress_remember_me'] ??= new \Scheb\TwoFactorBundle\Security\Http\EventListener\SuppressRememberMeListener()), 'onSuccessfulLogin'], -63);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'scheb_two_factor.security.authentication_success_event_suppressor', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Event\\AuthenticationSuccessEventSuppressor')] fn () => ($container->privates['scheb_two_factor.security.authentication_success_event_suppressor'] ??= new \Scheb\TwoFactorBundle\Security\TwoFactor\Event\AuthenticationSuccessEventSuppressor()), 'onLogin'], 9223372036854775806);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.check_backup_code', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\CheckBackupCodeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.check_backup_code'] ?? $container->load('getSchebTwoFactor_Security_Listener_CheckBackupCodeService')), 'checkPassport'], 16);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.csrf_protection', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfProtectionListener')] fn () => ($container->privates['security.listener.csrf_protection'] ?? $container->load('getSecurity_Listener_CsrfProtectionService')), 'checkPassport'], 512);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.csrf_token_clearing', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfTokenClearingLogoutListener')] fn () => ($container->privates['security.logout.listener.csrf_token_clearing'] ?? $container->load('getSecurity_Logout_Listener_CsrfTokenClearingService')), 'onLogout'], 0);

        return $instance;
    }

    /*
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected static function getHttpKernelService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['http_kernel'])) {
            return $container->services['http_kernel'];
        }
        $b = new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($container, ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)));
        $b->allowControllers(['Symfony\\Bundle\\FrameworkBundle\\Controller\\AbstractController', 'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController']);
        $b->allowControllers(['App\\Kernel', 'App\\Authentication\\Controller\\SecurityController', 'App\\Engine\\Controller\\IndexController', 'Doctrine\\Bundle\\DoctrineBundle\\Controller\\ProfilerController', 'Nbgrp\\OneloginSamlBundle\\Controller\\AssertionConsumerService', 'Nbgrp\\OneloginSamlBundle\\Controller\\Login', 'Nbgrp\\OneloginSamlBundle\\Controller\\Logout', 'Nbgrp\\OneloginSamlBundle\\Controller\\Metadata']);

        return $container->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel($a, $b, ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory(), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['security.user_value_resolver'] ?? $container->load('getSecurity_UserValueResolverService'));
            yield 1 => ($container->privates['security.security_token_value_resolver'] ?? $container->load('getSecurity_SecurityTokenValueResolverService'));
            yield 2 => ($container->privates['doctrine.orm.entity_value_resolver'] ?? $container->load('getDoctrine_Orm_EntityValueResolverService'));
            yield 3 => ($container->privates['argument_resolver.backed_enum_resolver'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\BackedEnumValueResolver());
            yield 4 => ($container->privates['argument_resolver.datetime'] ?? $container->load('getArgumentResolver_DatetimeService'));
            yield 5 => ($container->privates['argument_resolver.request_attribute'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestAttributeValueResolver());
            yield 6 => ($container->privates['argument_resolver.request'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestValueResolver());
            yield 7 => ($container->privates['argument_resolver.session'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\SessionValueResolver());
            yield 8 => ($container->privates['api_platform.argument_resolver.payload'] ?? $container->load('getApiPlatform_ArgumentResolver_PayloadService'));
            yield 9 => ($container->privates['Nbgrp\\OneloginSamlBundle\\Onelogin\\AuthArgumentResolver'] ?? $container->load('getAuthArgumentResolverService'));
            yield 10 => ($container->privates['argument_resolver.service'] ?? $container->load('getArgumentResolver_ServiceService'));
            yield 11 => ($container->privates['argument_resolver.default'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\DefaultValueResolver());
            yield 12 => ($container->privates['argument_resolver.variadic'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\VariadicValueResolver());
        }, 13), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Nbgrp\\OneloginSamlBundle\\Onelogin\\AuthArgumentResolver' => ['privates', 'Nbgrp\\OneloginSamlBundle\\Onelogin\\AuthArgumentResolver', 'getAuthArgumentResolverService', true],
            'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver' => ['privates', 'doctrine.orm.entity_value_resolver', 'getDoctrine_Orm_EntityValueResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => ['privates', 'argument_resolver.backed_enum_resolver', 'getArgumentResolver_BackedEnumResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => ['privates', 'argument_resolver.datetime', 'getArgumentResolver_DatetimeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => ['privates', 'argument_resolver.default', 'getArgumentResolver_DefaultService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => ['privates', 'argument_resolver.query_parameter_value_resolver', 'getArgumentResolver_QueryParameterValueResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => ['privates', 'argument_resolver.request_attribute', 'getArgumentResolver_RequestAttributeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => ['privates', 'argument_resolver.request_payload', 'getArgumentResolver_RequestPayloadService', false],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => ['privates', 'argument_resolver.request', 'getArgumentResolver_RequestService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => ['privates', 'argument_resolver.service', 'getArgumentResolver_ServiceService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => ['privates', 'argument_resolver.session', 'getArgumentResolver_SessionService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => ['privates', 'argument_resolver.variadic', 'getArgumentResolver_VariadicService', true],
            'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver' => ['privates', 'security.security_token_value_resolver', 'getSecurity_SecurityTokenValueResolverService', true],
            'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver' => ['privates', 'security.user_value_resolver', 'getSecurity_UserValueResolverService', true],
            'api_platform.argument_resolver.payload' => ['privates', 'api_platform.argument_resolver.payload', 'getApiPlatform_ArgumentResolver_PayloadService', true],
        ], [
            'Nbgrp\\OneloginSamlBundle\\Onelogin\\AuthArgumentResolver' => 'Nbgrp\\OneloginSamlBundle\\Onelogin\\AuthArgumentResolver',
            'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver' => 'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver',
            'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver' => 'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver',
            'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver' => 'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver',
            'api_platform.argument_resolver.payload' => 'ApiPlatform\\Symfony\\Bundle\\ArgumentResolver\\PayloadArgumentResolver',
        ])), true);
    }

    /*
     * Gets the public 'monolog.logger.security' shared service.
     *
     * @return \Monolog\Logger
     */
    protected static function getMonolog_Logger_SecurityService($container)
    {
        $container->services['monolog.logger.security'] = $instance = new \Monolog\Logger('security');

        $instance->pushHandler(($container->privates['monolog.handler.security'] ?? self::getMonolog_Handler_SecurityService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));

        return $instance;
    }

    /*
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected static function getRequestStackService($container)
    {
        return $container->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /*
     * Gets the public 'router' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Routing\Router
     */
    protected static function getRouterService($container)
    {
        $a = new \Monolog\Logger('router');
        $a->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $a->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        $container->services['router'] = $instance = new \Symfony\Bundle\FrameworkBundle\Routing\Router((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'routing.loader' => ['services', 'routing.loader', 'getRouting_LoaderService', true],
        ], [
            'routing.loader' => 'Symfony\\Component\\Config\\Loader\\LoaderInterface',
        ]))->withContext('router.default', $container), 'kernel::loadRoutes', ['cache_dir' => $container->targetDir.'', 'debug' => false, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => NULL, 'resource_type' => 'service'], ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['parameter_bag'] ??= new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container)), $a, 'en');

        $instance->setConfigCacheFactory(($container->privates['config_cache_factory'] ??= new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory()));
        $instance->addExpressionLanguageProvider(($container->privates['router.expression_language_provider'] ?? self::getRouter_ExpressionLanguageProviderService($container)));

        return $instance;
    }

    /*
     * Gets the public 'translator' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Translation\Translator
     */
    protected static function getTranslatorService($container)
    {
        $container->services['translator'] = $instance = new \Symfony\Bundle\FrameworkBundle\Translation\Translator(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'translation.loader.csv' => ['privates', 'translation.loader.csv', 'getTranslation_Loader_CsvService', true],
            'translation.loader.dat' => ['privates', 'translation.loader.dat', 'getTranslation_Loader_DatService', true],
            'translation.loader.ini' => ['privates', 'translation.loader.ini', 'getTranslation_Loader_IniService', true],
            'translation.loader.json' => ['privates', 'translation.loader.json', 'getTranslation_Loader_JsonService', true],
            'translation.loader.mo' => ['privates', 'translation.loader.mo', 'getTranslation_Loader_MoService', true],
            'translation.loader.php' => ['privates', 'translation.loader.php', 'getTranslation_Loader_PhpService', true],
            'translation.loader.po' => ['privates', 'translation.loader.po', 'getTranslation_Loader_PoService', true],
            'translation.loader.qt' => ['privates', 'translation.loader.qt', 'getTranslation_Loader_QtService', true],
            'translation.loader.res' => ['privates', 'translation.loader.res', 'getTranslation_Loader_ResService', true],
            'translation.loader.xliff' => ['privates', 'translation.loader.xliff', 'getTranslation_Loader_XliffService', true],
            'translation.loader.yml' => ['privates', 'translation.loader.yml', 'getTranslation_Loader_YmlService', true],
        ], [
            'translation.loader.csv' => '?',
            'translation.loader.dat' => '?',
            'translation.loader.ini' => '?',
            'translation.loader.json' => '?',
            'translation.loader.mo' => '?',
            'translation.loader.php' => '?',
            'translation.loader.po' => '?',
            'translation.loader.qt' => '?',
            'translation.loader.res' => '?',
            'translation.loader.xliff' => '?',
            'translation.loader.yml' => '?',
        ]), new \Symfony\Component\Translation\Formatter\MessageFormatter(new \Symfony\Component\Translation\IdentityTranslator()), 'en', ['translation.loader.php' => ['php'], 'translation.loader.yml' => ['yaml', 'yml'], 'translation.loader.xliff' => ['xlf', 'xliff'], 'translation.loader.po' => ['po'], 'translation.loader.mo' => ['mo'], 'translation.loader.qt' => ['ts'], 'translation.loader.csv' => ['csv'], 'translation.loader.res' => ['res'], 'translation.loader.dat' => ['dat'], 'translation.loader.ini' => ['ini'], 'translation.loader.json' => ['json']], ['cache_dir' => ($container->targetDir.''.'/translations'), 'debug' => false, 'resource_files' => ['af' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.af.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.af.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.af.xlf')], 'ar' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.ar.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.ar.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.ar.xlf')], 'az' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.az.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.az.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.az.xlf')], 'be' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.be.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.be.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.be.xlf')], 'bg' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.bg.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.bg.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.bg.xlf')], 'bs' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.bs.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.bs.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.bs.xlf')], 'ca' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.ca.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.ca.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.ca.xlf')], 'cs' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.cs.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.cs.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.cs.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.cs.yml')], 'cy' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.cy.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.cy.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.cy.xlf')], 'da' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.da.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.da.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.da.xlf')], 'de' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.de.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.de.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.de.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.de.yml')], 'el' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.el.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.el.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.el.xlf')], 'en' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.en.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.en.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.en.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.en.yml')], 'es' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.es.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.es.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.es.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.es.yml')], 'et' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.et.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.et.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.et.xlf')], 'eu' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.eu.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.eu.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.eu.xlf')], 'fa' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.fa.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.fa.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.fa.xlf')], 'fi' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.fi.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.fi.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.fi.xlf')], 'fr' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.fr.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.fr.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.fr.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.fr.yml')], 'gl' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.gl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.gl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.gl.xlf')], 'he' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.he.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.he.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.he.xlf')], 'hr' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.hr.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.hr.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.hr.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.hr.yml')], 'hu' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.hu.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.hu.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.hu.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.hu.yml')], 'hy' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.hy.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.hy.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.hy.xlf')], 'id' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.id.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.id.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.id.xlf')], 'it' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.it.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.it.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.it.xlf')], 'ja' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.ja.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.ja.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.ja.xlf')], 'lb' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.lb.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.lb.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.lb.xlf')], 'lt' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.lt.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.lt.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.lt.xlf')], 'lv' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.lv.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.lv.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.lv.xlf')], 'mk' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.mk.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.mk.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.mk.xlf')], 'mn' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.mn.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.mn.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.mn.xlf')], 'my' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.my.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.my.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.my.xlf')], 'nb' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.nb.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.nb.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.nb.xlf')], 'nl' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.nl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.nl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.nl.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.nl.yml')], 'nn' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.nn.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.nn.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.nn.xlf')], 'no' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.no.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.no.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.no.xlf')], 'pl' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.pl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.pl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.pl.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.pl.yml')], 'pt' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.pt.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.pt.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.pt.xlf')], 'pt_BR' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.pt_BR.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.pt_BR.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf')], 'ro' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.ro.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.ro.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.ro.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.ro.yml')], 'ru' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.ru.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.ru.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.ru.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.ru.yml')], 'sk' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.sk.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.sk.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.sk.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.sk.yml')], 'sl' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.sl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.sl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.sl.xlf')], 'sq' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.sq.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.sq.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.sq.xlf')], 'sr_Cyrl' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.sr_Cyrl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.sr_Cyrl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf')], 'sr_Latn' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.sr_Latn.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.sr_Latn.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf')], 'sv' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.sv.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.sv.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.sv.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.sv.yml')], 'th' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.th.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.th.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.th.xlf')], 'tl' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.tl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.tl.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.tl.xlf')], 'tr' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.tr.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.tr.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.tr.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.tr.yml')], 'uk' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.uk.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.uk.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.uk.xlf'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.uk.yml')], 'ur' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.ur.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.ur.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.ur.xlf')], 'uz' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.uz.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.uz.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.uz.xlf')], 'vi' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.vi.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.vi.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.vi.xlf')], 'zh_CN' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.zh_CN.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.zh_CN.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf')], 'zh_TW' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations/validators.zh_TW.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations/validators.zh_TW.xlf'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf')]], 'scanned_directories' => [(\dirname(__DIR__, 3).'/vendor/symfony/validator/Resources/translations'), (\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/translations'), (\dirname(__DIR__, 3).'/vendor/symfony/security-core/Resources/translations'), (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle/Resources/translations'), (\dirname(__DIR__, 3).'/vendor/symfony/framework-bundle/translations'), (\dirname(__DIR__, 3).'/vendor/symfony/twig-bundle/translations'), (\dirname(__DIR__, 3).'/vendor/symfony/security-bundle/translations'), (\dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle/translations'), (\dirname(__DIR__, 3).'/vendor/symfony/monolog-bundle/translations'), (\dirname(__DIR__, 3).'/vendor/nelmio/cors-bundle/translations'), (\dirname(__DIR__, 3).'/vendor/doctrine/doctrine-migrations-bundle/translations'), (\dirname(__DIR__, 3).'/vendor/shivas/versioning-bundle/src/translations'), (\dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Bundle/translations'), (\dirname(__DIR__, 3).'/vendor/nbgrp/onelogin-saml-bundle/src/translations'), (\dirname(__DIR__, 3).'/vendor/twig/extra-bundle/translations'), (\dirname(__DIR__, 3).'/translations')], 'cache_vary' => ['scanned_directories' => ['vendor/symfony/validator/Resources/translations', 'vendor/symfony/form/Resources/translations', 'vendor/symfony/security-core/Resources/translations', 'vendor/scheb/2fa-bundle/Resources/translations', 'vendor/symfony/framework-bundle/translations', 'vendor/symfony/twig-bundle/translations', 'vendor/symfony/security-bundle/translations', 'vendor/doctrine/doctrine-bundle/translations', 'vendor/symfony/monolog-bundle/translations', 'vendor/nelmio/cors-bundle/translations', 'vendor/doctrine/doctrine-migrations-bundle/translations', 'vendor/shivas/versioning-bundle/src/translations', 'vendor/api-platform/core/src/Symfony/Bundle/translations', 'vendor/nbgrp/onelogin-saml-bundle/src/translations', 'vendor/twig/extra-bundle/translations', 'translations']]], []);

        $instance->setConfigCacheFactory(($container->privates['config_cache_factory'] ??= new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory()));
        $instance->setFallbackLocales(['en']);

        return $instance;
    }

    /*
     * Gets the private '.service_locator.sL05zc0' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function get_ServiceLocator_SL05zc0Service($container)
    {
        return $container->privates['.service_locator.sL05zc0'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'api_platform.serializer.filter_parameter_provider' => ['privates', 'api_platform.serializer.filter_parameter_provider', 'getApiPlatform_Serializer_FilterParameterProviderService', true],
        ], [
            'api_platform.serializer.filter_parameter_provider' => 'ApiPlatform\\Serializer\\Parameter\\SerializerFilterParameterProvider',
        ]);
    }

    /*
     * Gets the private '.service_locator.zJyh7qS' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function get_ServiceLocator_ZJyh7qSService($container)
    {
        return $container->privates['.service_locator.zJyh7qS'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'security.firewall.map.context.dev' => ['privates', 'security.firewall.map.context.dev', 'getSecurity_Firewall_Map_Context_DevService', true],
            'security.firewall.map.context.main' => ['privates', 'security.firewall.map.context.main', 'getSecurity_Firewall_Map_Context_MainService', true],
        ], [
            'security.firewall.map.context.dev' => '?',
            'security.firewall.map.context.main' => '?',
        ]);
    }

    /*
     * Gets the private 'App\Engine\LegacyHandler\ActionNameMapperHandler' shared autowired service.
     *
     * @return \App\Engine\LegacyHandler\ActionNameMapperHandler
     */
    protected static function getActionNameMapperHandlerService($container)
    {
        return $container->privates['App\\Engine\\LegacyHandler\\ActionNameMapperHandler'] = new \App\Engine\LegacyHandler\ActionNameMapperHandler(\dirname(__DIR__, 3), (\dirname(__DIR__, 3).'/public/legacy'), 'SCRMSESSID', 'SCRMSESSID', ($container->privates['App\\Engine\\LegacyHandler\\LegacyScopeState'] ??= new \App\Engine\LegacyHandler\LegacyScopeState()), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'App\Module\LegacyHandler\ModuleNameMapperHandler' shared autowired service.
     *
     * @return \App\Module\LegacyHandler\ModuleNameMapperHandler
     */
    protected static function getModuleNameMapperHandlerService($container)
    {
        return $container->privates['App\\Module\\LegacyHandler\\ModuleNameMapperHandler'] = new \App\Module\LegacyHandler\ModuleNameMapperHandler(\dirname(__DIR__, 3), (\dirname(__DIR__, 3).'/public/legacy'), 'SCRMSESSID', 'SCRMSESSID', ($container->privates['App\\Engine\\LegacyHandler\\LegacyScopeState'] ??= new \App\Engine\LegacyHandler\LegacyScopeState()), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'App\Routes\EventListener\LegacyRedirectListener' shared autowired service.
     *
     * @return \App\Routes\EventListener\LegacyRedirectListener
     */
    protected static function getLegacyRedirectListenerService($container)
    {
        return $container->privates['App\\Routes\\EventListener\\LegacyRedirectListener'] = new \App\Routes\EventListener\LegacyRedirectListener(($container->privates['App\\Routes\\LegacyHandler\\RouteConverterHandler'] ?? self::getRouteConverterHandlerService($container)), ($container->privates['App\\Routes\\Service\\LegacyAssetRedirectHandler'] ?? self::getLegacyAssetRedirectHandlerService($container)), ($container->privates['App\\Routes\\Service\\LegacyApiRedirectHandler'] ?? self::getLegacyApiRedirectHandlerService($container)), ($container->privates['App\\Routes\\Service\\LegacyNonViewActionRedirectHandler'] ?? self::getLegacyNonViewActionRedirectHandlerService($container)));
    }

    /*
     * Gets the private 'App\Routes\EventSubscriber\RequestSubscriber' shared autowired service.
     *
     * @return \App\Routes\EventSubscriber\RequestSubscriber
     */
    protected static function getRequestSubscriberService($container)
    {
        return $container->privates['App\\Routes\\EventSubscriber\\RequestSubscriber'] = new \App\Routes\EventSubscriber\RequestSubscriber(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'App\Routes\LegacyHandler\RouteConverterHandler' shared autowired service.
     *
     * @return \App\Routes\LegacyHandler\RouteConverterHandler
     */
    protected static function getRouteConverterHandlerService($container)
    {
        return $container->privates['App\\Routes\\LegacyHandler\\RouteConverterHandler'] = new \App\Routes\LegacyHandler\RouteConverterHandler(\dirname(__DIR__, 3), (\dirname(__DIR__, 3).'/public/legacy'), 'SCRMSESSID', 'SCRMSESSID', ($container->privates['App\\Engine\\LegacyHandler\\LegacyScopeState'] ??= new \App\Engine\LegacyHandler\LegacyScopeState()), ($container->privates['App\\Module\\LegacyHandler\\ModuleNameMapperHandler'] ?? self::getModuleNameMapperHandlerService($container)), ($container->privates['App\\Engine\\LegacyHandler\\ActionNameMapperHandler'] ?? self::getActionNameMapperHandlerService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'App\Routes\Service\LegacyApiRedirectHandler' shared autowired service.
     *
     * @return \App\Routes\Service\LegacyApiRedirectHandler
     */
    protected static function getLegacyApiRedirectHandlerService($container)
    {
        return $container->privates['App\\Routes\\Service\\LegacyApiRedirectHandler'] = new \App\Routes\Service\LegacyApiRedirectHandler($container->parameters['legacy.api_paths'], '/legacy', $container->parameters['legacy.api_path_files']);
    }

    /*
     * Gets the private 'App\Routes\Service\LegacyAssetRedirectHandler' shared autowired service.
     *
     * @return \App\Routes\Service\LegacyAssetRedirectHandler
     */
    protected static function getLegacyAssetRedirectHandlerService($container)
    {
        return $container->privates['App\\Routes\\Service\\LegacyAssetRedirectHandler'] = new \App\Routes\Service\LegacyAssetRedirectHandler($container->parameters['legacy.asset_paths'], '/legacy');
    }

    /*
     * Gets the private 'App\Routes\Service\LegacyNonViewActionRedirectHandler' shared autowired service.
     *
     * @return \App\Routes\Service\LegacyNonViewActionRedirectHandler
     */
    protected static function getLegacyNonViewActionRedirectHandlerService($container)
    {
        return $container->privates['App\\Routes\\Service\\LegacyNonViewActionRedirectHandler'] = new \App\Routes\Service\LegacyNonViewActionRedirectHandler(($container->privates['App\\Routes\\LegacyHandler\\RouteConverterHandler'] ?? self::getRouteConverterHandlerService($container)), ($container->services['router'] ?? self::getRouterService($container)), '/legacy', $container->parameters['legacy.entrypoint_files']);
    }

    /*
     * Gets the private 'App\Security\CSRFCookieListener' shared autowired service.
     *
     * @return \App\Security\CSRFCookieListener
     */
    protected static function getCSRFCookieListenerService($container)
    {
        return $container->privates['App\\Security\\CSRFCookieListener'] = new \App\Security\CSRFCookieListener(($container->privates['App\\Security\\RouteMatcher'] ??= new \App\Security\RouteMatcher()), [['path' => '(/login$|/2fa/enable|/2fa/enable-finalize|/2fa|/$|/auth$|/logout$|/logged-out$|/session-status|/auth/logout|/auth/login|/auth/session-status)']], 'XSRF-TOKEN', 0, '/', NULL, false, ($container->privates['App\\Security\\CSRFTokenManager'] ?? self::getCSRFTokenManagerService($container)));
    }

    /*
     * Gets the private 'App\Security\CSRFTokenManager' shared autowired service.
     *
     * @return \App\Security\CSRFTokenManager
     */
    protected static function getCSRFTokenManagerService($container)
    {
        return $container->privates['App\\Security\\CSRFTokenManager'] = new \App\Security\CSRFTokenManager(($container->privates['security.csrf.token_manager'] ?? self::getSecurity_Csrf_TokenManagerService($container)), 'angular');
    }

    /*
     * Gets the private 'App\Security\CSRFValidationListener' shared autowired service.
     *
     * @return \App\Security\CSRFValidationListener
     */
    protected static function getCSRFValidationListenerService($container)
    {
        return $container->privates['App\\Security\\CSRFValidationListener'] = new \App\Security\CSRFValidationListener(($container->privates['App\\Security\\CSRFTokenManager'] ?? self::getCSRFTokenManagerService($container)), ($container->privates['App\\Security\\RouteMatcher'] ??= new \App\Security\RouteMatcher()), [['path' => '/api']], 'X-XSRF-TOKEN');
    }

    /*
     * Gets the private 'api_platform.api.identifiers_extractor' shared service.
     *
     * @return \ApiPlatform\Metadata\IdentifiersExtractor
     */
    protected static function getApiPlatform_Api_IdentifiersExtractorService($container)
    {
        return $container->privates['api_platform.api.identifiers_extractor'] = new \ApiPlatform\Metadata\IdentifiersExtractor(($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container)), ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), ($container->privates['property_accessor'] ?? self::getPropertyAccessorService($container)));
    }

    /*
     * Gets the private 'api_platform.cache.metadata.property' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_PropertyService($container)
    {
        return $container->privates['api_platform.cache.metadata.property'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('Ez1Iw0xy8v', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'api_platform.cache.metadata.resource' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_ResourceService($container)
    {
        return $container->privates['api_platform.cache.metadata.resource'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('o1kGR6++LW', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'api_platform.cache.metadata.resource_collection' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_ResourceCollectionService($container)
    {
        return $container->privates['api_platform.cache.metadata.resource_collection'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('g0k4knmHdq', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'api_platform.json_schema.backward_compatible_schema_factory' shared service.
     *
     * @return \ApiPlatform\JsonSchema\BackwardCompatibleSchemaFactory
     */
    protected static function getApiPlatform_JsonSchema_BackwardCompatibleSchemaFactoryService($container)
    {
        $a = ($container->privates['api_platform.json_schema.type_factory'] ?? self::getApiPlatform_JsonSchema_TypeFactoryService($container));

        if (isset($container->privates['api_platform.json_schema.backward_compatible_schema_factory'])) {
            return $container->privates['api_platform.json_schema.backward_compatible_schema_factory'];
        }

        return $container->privates['api_platform.json_schema.backward_compatible_schema_factory'] = new \ApiPlatform\JsonSchema\BackwardCompatibleSchemaFactory(new \ApiPlatform\Hydra\JsonSchema\SchemaFactory(new \ApiPlatform\JsonSchema\SchemaFactory($a, ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), ($container->privates['serializer.name_converter.metadata_aware'] ?? self::getSerializer_NameConverter_MetadataAwareService($container)), ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container)), $container->parameters['api_platform.jsonschema_formats'], new \ApiPlatform\JsonSchema\DefinitionNameFactory($container->parameters['api_platform.jsonschema_formats']))));
    }

    /*
     * Gets the private 'api_platform.json_schema.type_factory' shared service.
     *
     * @return \ApiPlatform\JsonSchema\TypeFactory
     */
    protected static function getApiPlatform_JsonSchema_TypeFactoryService($container)
    {
        $container->privates['api_platform.json_schema.type_factory'] = $instance = new \ApiPlatform\JsonSchema\TypeFactory(($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container)));

        $instance->setSchemaFactory(($container->privates['api_platform.json_schema.backward_compatible_schema_factory'] ?? self::getApiPlatform_JsonSchema_BackwardCompatibleSchemaFactoryService($container)));

        return $instance;
    }

    /*
     * Gets the private 'api_platform.jsonld.context_builder' shared service.
     *
     * @return \ApiPlatform\JsonLd\ContextBuilder
     */
    protected static function getApiPlatform_Jsonld_ContextBuilderService($container)
    {
        return $container->privates['api_platform.jsonld.context_builder'] = new \ApiPlatform\JsonLd\ContextBuilder(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)), ($container->privates['api_platform.symfony.iri_converter.skolem'] ?? self::getApiPlatform_Symfony_IriConverter_SkolemService($container)), ($container->privates['serializer.name_converter.metadata_aware'] ?? self::getSerializer_NameConverter_MetadataAwareService($container)));
    }

    /*
     * Gets the private 'api_platform.listener.request.add_format' shared service.
     *
     * @return \ApiPlatform\Symfony\EventListener\AddFormatListener
     */
    protected static function getApiPlatform_Listener_Request_AddFormatService($container)
    {
        return $container->privates['api_platform.listener.request.add_format'] = new \ApiPlatform\Symfony\EventListener\AddFormatListener(new \ApiPlatform\State\Provider\ContentNegotiationProvider(NULL, ($container->privates['api_platform.negotiator'] ??= new \Negotiation\Negotiator()), $container->parameters['api_platform.formats'], $container->parameters['api_platform.error_formats']), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)));
    }

    /*
     * Gets the private 'api_platform.listener.request.deserialize' shared service.
     *
     * @return \ApiPlatform\Symfony\EventListener\DeserializeListener
     */
    protected static function getApiPlatform_Listener_Request_DeserializeService($container)
    {
        $a = ($container->privates['serializer'] ?? self::getSerializerService($container));

        if (isset($container->privates['api_platform.listener.request.deserialize'])) {
            return $container->privates['api_platform.listener.request.deserialize'];
        }

        return $container->privates['api_platform.listener.request.deserialize'] = new \ApiPlatform\Symfony\EventListener\DeserializeListener(new \ApiPlatform\Symfony\Security\State\AccessCheckerProvider(new \ApiPlatform\State\Provider\DeserializeProvider(NULL, $a, ($container->privates['api_platform.openapi.serializer_context_builder'] ?? self::getApiPlatform_Openapi_SerializerContextBuilderService($container)), ($container->services['translator'] ?? self::getTranslatorService($container))), ($container->privates['api_platform.security.resource_access_checker'] ?? self::getApiPlatform_Security_ResourceAccessCheckerService($container)), 'post_denormalize'), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)));
    }

    /*
     * Gets the private 'api_platform.listener.request.read' shared service.
     *
     * @return \ApiPlatform\Symfony\EventListener\ReadListener
     */
    protected static function getApiPlatform_Listener_Request_ReadService($container)
    {
        $a = ($container->services['api_platform.symfony.parameter_validator'] ?? self::getApiPlatform_Symfony_ParameterValidatorService($container));

        if (isset($container->privates['api_platform.listener.request.read'])) {
            return $container->privates['api_platform.listener.request.read'];
        }

        return $container->privates['api_platform.listener.request.read'] = new \ApiPlatform\Symfony\EventListener\ReadListener(new \ApiPlatform\Symfony\Security\State\AccessCheckerProvider(new \ApiPlatform\Symfony\Bundle\SwaggerUi\SwaggerUiProvider($a, ($container->privates['api_platform.openapi.factory'] ?? self::getApiPlatform_Openapi_FactoryService($container))), ($container->privates['api_platform.security.resource_access_checker'] ?? self::getApiPlatform_Security_ResourceAccessCheckerService($container))), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), NULL, ($container->privates['api_platform.uri_variables.converter'] ?? self::getApiPlatform_UriVariables_ConverterService($container)));
    }

    /*
     * Gets the private 'api_platform.listener.view.validate_query_parameters' shared service.
     *
     * @return \ApiPlatform\Symfony\EventListener\QueryParameterValidateListener
     */
    protected static function getApiPlatform_Listener_View_ValidateQueryParametersService($container)
    {
        return $container->privates['api_platform.listener.view.validate_query_parameters'] = new \ApiPlatform\Symfony\EventListener\QueryParameterValidateListener(new \ApiPlatform\Symfony\Validator\State\QueryParameterValidateProvider(NULL, new \ApiPlatform\Api\QueryParameterValidator\QueryParameterValidator(($container->privates['api_platform.filter_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], [])))), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), true);
    }

    /*
     * Gets the private 'api_platform.metadata.operation.metadata_factory' shared service.
     *
     * @return \ApiPlatform\Metadata\Operation\Factory\OperationMetadataFactory
     */
    protected static function getApiPlatform_Metadata_Operation_MetadataFactoryService($container)
    {
        return $container->privates['api_platform.metadata.operation.metadata_factory'] = new \ApiPlatform\Metadata\Operation\Factory\OperationMetadataFactory(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)));
    }

    /*
     * Gets the private 'api_platform.metadata.property.metadata_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Property\Factory\CachedPropertyMetadataFactory
     */
    protected static function getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)
    {
        $a = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));

        return $container->privates['api_platform.metadata.property.metadata_factory.cached'] = new \ApiPlatform\Metadata\Property\Factory\CachedPropertyMetadataFactory(($container->privates['api_platform.cache.metadata.property'] ?? self::getApiPlatform_Cache_Metadata_PropertyService($container)), new \ApiPlatform\JsonSchema\Metadata\Property\Factory\SchemaPropertyMetadataFactory($a, new \ApiPlatform\Symfony\Validator\Metadata\Property\ValidatorPropertyMetadataFactory(($container->privates['validator'] ?? self::getValidatorService($container)), new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyMetadataFactory(($container->privates['api_platform.metadata.property_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\AttributePropertyMetadataFactory(new \ApiPlatform\Metadata\Property\Factory\IdentifierPropertyMetadataFactory($a, new \ApiPlatform\Metadata\Property\Factory\DefaultPropertyMetadataFactory(new \ApiPlatform\Metadata\Property\Factory\SerializerPropertyMetadataFactory(($container->privates['api_platform.serializer.mapping.cache_class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_CacheClassMetadataFactoryService($container)), new \ApiPlatform\Doctrine\Orm\Metadata\Property\DoctrineOrmPropertyMetadataFactory(($container->services['doctrine'] ?? self::getDoctrineService($container)), new \ApiPlatform\Metadata\Property\Factory\PropertyInfoPropertyMetadataFactory(($container->privates['property_info.cache'] ?? self::getPropertyInfo_CacheService($container)), new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyMetadataFactory(($container->privates['api_platform.metadata.property_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlPropertyExtractor([], $container))))), $a))))), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['api_platform.metadata.property_schema.choice_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaChoiceRestriction());
            yield 1 => ($container->privates['api_platform.metadata.property_schema.collection_restriction'] ?? $container->load('getApiPlatform_Metadata_PropertySchema_CollectionRestrictionService'));
            yield 2 => ($container->privates['api_platform.metadata.property_schema.count_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaCountRestriction());
            yield 3 => ($container->privates['api_platform.metadata.property_schema.greater_than_or_equal_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaGreaterThanOrEqualRestriction());
            yield 4 => ($container->privates['api_platform.metadata.property_schema.greater_than_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaGreaterThanRestriction());
            yield 5 => ($container->privates['api_platform.metadata.property_schema.length_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLengthRestriction());
            yield 6 => ($container->privates['api_platform.metadata.property_schema.less_than_or_equal_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLessThanOrEqualRestriction());
            yield 7 => ($container->privates['api_platform.metadata.property_schema.less_than_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLessThanRestriction());
            yield 8 => ($container->privates['api_platform.metadata.property_schema.one_of_restriction'] ?? $container->load('getApiPlatform_Metadata_PropertySchema_OneOfRestrictionService'));
            yield 9 => ($container->privates['api_platform.metadata.property_schema.range_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaRangeRestriction());
            yield 10 => ($container->privates['api_platform.metadata.property_schema.regex_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaRegexRestriction());
            yield 11 => ($container->privates['api_platform.metadata.property_schema.format_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaFormat());
            yield 12 => ($container->privates['api_platform.metadata.property_schema.unique_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaUniqueRestriction());
        }, 13))));
    }

    /*
     * Gets the private 'api_platform.metadata.property.name_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Property\Factory\CachedPropertyNameCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)
    {
        return $container->privates['api_platform.metadata.property.name_collection_factory.cached'] = new \ApiPlatform\Metadata\Property\Factory\CachedPropertyNameCollectionFactory(($container->privates['api_platform.cache.metadata.property'] ?? self::getApiPlatform_Cache_Metadata_PropertyService($container)), new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyNameCollectionFactory(($container->privates['api_platform.metadata.property_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyNameCollectionFactory(($container->privates['api_platform.metadata.property_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\PropertyInfoPropertyNameCollectionFactory(($container->privates['property_info.cache'] ?? self::getPropertyInfo_CacheService($container))))));
    }

    /*
     * Gets the private 'api_platform.metadata.resource.metadata_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Resource\Factory\CachedResourceMetadataCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)
    {
        $a = ($container->services['doctrine'] ?? self::getDoctrineService($container));
        $b = ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container));
        $c = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));

        $d = new \ApiPlatform\Doctrine\Orm\Metadata\Resource\DoctrineOrmLinkFactory($a, $b, $c, new \ApiPlatform\Metadata\Resource\Factory\LinkFactory($b, ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), $c));
        $e = ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container));

        return $container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] = new \ApiPlatform\Metadata\Resource\Factory\CachedResourceMetadataCollectionFactory(($container->privates['api_platform.cache.metadata.resource_collection'] ?? self::getApiPlatform_Cache_Metadata_ResourceCollectionService($container)), new \ApiPlatform\Doctrine\Orm\Metadata\Resource\DoctrineOrmResourceCollectionMetadataFactory($a, new \ApiPlatform\Symfony\Messenger\Metadata\MessengerResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\PhpDocResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\AlternateUriResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\FiltersResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\FormatsResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\InputOutputResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\OperationNameResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\LinkResourceMetadataCollectionFactory($d, new \ApiPlatform\Metadata\Resource\Factory\MainControllerResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\UriTemplateResourceMetadataCollectionFactory($d, new \ApiPlatform\Metadata\Operation\DashPathSegmentNameGenerator(), new \ApiPlatform\Metadata\Resource\Factory\NotExposedOperationResourceMetadataCollectionFactory($d, new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceMetadataCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceMetadataCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ParameterResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\DeprecationResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\AttributesResourceMetadataCollectionFactory(NULL, $e, $container->parameters['api_platform.defaults'], true)), ($container->privates['api_platform.filter_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], []))), $container->parameters['api_platform.defaults'], $e, true), $container->parameters['api_platform.defaults'], $e, true))), true)))), $container->parameters['api_platform.formats'], $container->parameters['api_platform.patch_formats'], $container->parameters['api_platform.error_formats'])))))));
    }

    /*
     * Gets the private 'api_platform.metadata.resource.name_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Resource\Factory\CachedResourceNameCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)
    {
        return $container->privates['api_platform.metadata.resource.name_collection_factory.cached'] = new \ApiPlatform\Metadata\Resource\Factory\CachedResourceNameCollectionFactory(($container->privates['api_platform.cache.metadata.resource'] ?? self::getApiPlatform_Cache_Metadata_ResourceService($container)), new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceNameCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ClassNameResourceNameCollectionFactory($container->parameters['api_platform.class_name_resources'], new \ApiPlatform\Metadata\Resource\Factory\AttributesResourceNameCollectionFactory($container->parameters['api_platform.resource_class_directories'], new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceNameCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlResourceExtractor([], $container)))))));
    }

    /*
     * Gets the private 'api_platform.openapi.factory' shared service.
     *
     * @return \ApiPlatform\OpenApi\Factory\OpenApiFactory
     */
    protected static function getApiPlatform_Openapi_FactoryService($container)
    {
        return $container->privates['api_platform.openapi.factory'] = new \ApiPlatform\OpenApi\Factory\OpenApiFactory(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), ($container->privates['api_platform.json_schema.backward_compatible_schema_factory'] ?? self::getApiPlatform_JsonSchema_BackwardCompatibleSchemaFactoryService($container)), ($container->privates['api_platform.json_schema.type_factory'] ?? self::getApiPlatform_JsonSchema_TypeFactoryService($container)), ($container->privates['api_platform.filter_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], [])), $container->parameters['api_platform.formats'], ($container->privates['api_platform.openapi.options'] ?? self::getApiPlatform_Openapi_OptionsService($container)), new \ApiPlatform\State\Pagination\PaginationOptions(true, 'page', false, 'itemsPerPage', false, 'pagination', 30, NULL, false, false, 'partial'), ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)));
    }

    /*
     * Gets the private 'api_platform.openapi.options' shared service.
     *
     * @return \ApiPlatform\OpenApi\Options
     */
    protected static function getApiPlatform_Openapi_OptionsService($container)
    {
        return $container->privates['api_platform.openapi.options'] = new \ApiPlatform\OpenApi\Options('SuiteCRM API', '', '8.5.0', true, 'oauth2', 'password', '/oauth/v2/token', '/oauth/v2/auth', '', [], [], NULL, NULL, NULL, NULL, NULL, NULL, true);
    }

    /*
     * Gets the private 'api_platform.openapi.serializer_context_builder' shared service.
     *
     * @return \ApiPlatform\OpenApi\Serializer\SerializerContextBuilder
     */
    protected static function getApiPlatform_Openapi_SerializerContextBuilderService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        return $container->privates['api_platform.openapi.serializer_context_builder'] = new \ApiPlatform\OpenApi\Serializer\SerializerContextBuilder(new \ApiPlatform\Serializer\SerializerFilterContextBuilder($a, ($container->privates['api_platform.filter_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], [])), new \ApiPlatform\Serializer\SerializerContextBuilder($a, false)));
    }

    /*
     * Gets the private 'api_platform.resource_class_resolver' shared service.
     *
     * @return \ApiPlatform\Metadata\ResourceClassResolver
     */
    protected static function getApiPlatform_ResourceClassResolverService($container)
    {
        return $container->privates['api_platform.resource_class_resolver'] = new \ApiPlatform\Metadata\ResourceClassResolver(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)));
    }

    /*
     * Gets the private 'api_platform.router' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\Router
     */
    protected static function getApiPlatform_RouterService($container)
    {
        return $container->privates['api_platform.router'] = new \ApiPlatform\Symfony\Routing\Router(($container->services['router'] ?? self::getRouterService($container)), 1);
    }

    /*
     * Gets the private 'api_platform.security.resource_access_checker' shared service.
     *
     * @return \ApiPlatform\Symfony\Security\ResourceAccessChecker
     */
    protected static function getApiPlatform_Security_ResourceAccessCheckerService($container)
    {
        return $container->privates['api_platform.security.resource_access_checker'] = new \ApiPlatform\Symfony\Security\ResourceAccessChecker(($container->privates['security.expression_language'] ?? self::getSecurity_ExpressionLanguageService($container)), ($container->privates['scheb_two_factor.security.authentication.trust_resolver'] ?? self::getSchebTwoFactor_Security_Authentication_TrustResolverService($container)), ($container->privates['security.role_hierarchy'] ??= new \Symfony\Component\Security\Core\Role\RoleHierarchy([])), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), ($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container)), false);
    }

    /*
     * Gets the private 'api_platform.serializer.mapping.cache_class_metadata_factory' shared service.
     *
     * @return \Symfony\Component\Serializer\Mapping\Factory\CacheClassMetadataFactory
     */
    protected static function getApiPlatform_Serializer_Mapping_CacheClassMetadataFactoryService($container)
    {
        $a = \Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($container->targetDir.''.'/serialization.php'), ($container->privates['cache.serializer'] ?? self::getCache_SerializerService($container)));

        return $container->privates['api_platform.serializer.mapping.cache_class_metadata_factory'] = new \Symfony\Component\Serializer\Mapping\Factory\CacheClassMetadataFactory(new \ApiPlatform\Serializer\Mapping\Factory\ClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Factory\CacheClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Loader\LoaderChain([new \Symfony\Component\Serializer\Mapping\Loader\AttributeLoader(NULL)])), $a)), $a);
    }

    /*
     * Gets the private 'api_platform.state_provider.locator' shared service.
     *
     * @return \ApiPlatform\State\CallableProvider
     */
    protected static function getApiPlatform_StateProvider_LocatorService($container)
    {
        return $container->privates['api_platform.state_provider.locator'] = new \ApiPlatform\State\CallableProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider' => ['privates', 'api_platform.doctrine.orm.state.collection_provider', 'getApiPlatform_Doctrine_Orm_State_CollectionProviderService', true],
            'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider' => ['privates', 'api_platform.doctrine.orm.state.item_provider', 'getApiPlatform_Doctrine_Orm_State_ItemProviderService', true],
            'ApiPlatform\\OpenApi\\State\\OpenApiProvider' => ['privates', 'api_platform.openapi.provider', 'getApiPlatform_Openapi_ProviderService', true],
            'ApiPlatform\\State\\CreateProvider' => ['privates', 'api_platform.state_provider.create', 'getApiPlatform_StateProvider_CreateService', true],
            'ApiPlatform\\State\\ObjectProvider' => ['privates', 'api_platform.state_provider.object', 'getApiPlatform_StateProvider_ObjectService', true],
            'App\\Data\\DataProvider\\RecordListStateProvider' => ['privates', 'App\\Data\\DataProvider\\RecordListStateProvider', 'getRecordListStateProviderService', true],
            'App\\Data\\DataProvider\\RecordStateProvider' => ['privates', 'App\\Data\\DataProvider\\RecordStateProvider', 'getRecordStateProviderService', true],
            'App\\FieldDefinitions\\DataProvider\\FieldDefinitionStateProvider' => ['privates', 'App\\FieldDefinitions\\DataProvider\\FieldDefinitionStateProvider', 'getFieldDefinitionStateProviderService', true],
            'App\\Languages\\DataProvider\\AppListStringsStateProvider' => ['privates', 'App\\Languages\\DataProvider\\AppListStringsStateProvider', 'getAppListStringsStateProviderService', true],
            'App\\Languages\\DataProvider\\AppStringsStateProvider' => ['privates', 'App\\Languages\\DataProvider\\AppStringsStateProvider', 'getAppStringsStateProviderService', true],
            'App\\Languages\\DataProvider\\ModStringsStateProvider' => ['privates', 'App\\Languages\\DataProvider\\ModStringsStateProvider', 'getModStringsStateProviderService', true],
            'App\\Metadata\\DataProvider\\AppMetadataStateProvider' => ['privates', 'App\\Metadata\\DataProvider\\AppMetadataStateProvider', 'getAppMetadataStateProviderService', true],
            'App\\Metadata\\DataProvider\\ModuleMetadataStateProvider' => ['privates', 'App\\Metadata\\DataProvider\\ModuleMetadataStateProvider', 'getModuleMetadataStateProviderService', true],
            'App\\Navbar\\DataProvider\\NavbarStateProvider' => ['privates', 'App\\Navbar\\DataProvider\\NavbarStateProvider', 'getNavbarStateProviderService', true],
            'App\\Process\\DataProvider\\ProcessStateProvider' => ['privates', 'App\\Process\\DataProvider\\ProcessStateProvider', 'getProcessStateProviderService', true],
            'App\\Statistics\\DataProvider\\BatchedStatisticsStateProvider' => ['privates', 'App\\Statistics\\DataProvider\\BatchedStatisticsStateProvider', 'getBatchedStatisticsStateProviderService', true],
            'App\\Statistics\\DataProvider\\StatisticsStateProvider' => ['privates', 'App\\Statistics\\DataProvider\\StatisticsStateProvider', 'getStatisticsStateProviderService', true],
            'App\\SystemConfig\\DataProvider\\SystemConfigStateProvider' => ['privates', 'App\\SystemConfig\\DataProvider\\SystemConfigStateProvider', 'getSystemConfigStateProviderService', true],
            'App\\Themes\\DataProvider\\ThemeImagesStateProvider' => ['privates', 'App\\Themes\\DataProvider\\ThemeImagesStateProvider', 'getThemeImagesStateProviderService', true],
            'App\\UserPreferences\\DataProvider\\UserPreferenceStateProvider' => ['privates', 'App\\UserPreferences\\DataProvider\\UserPreferenceStateProvider', 'getUserPreferenceStateProviderService', true],
            'App\\ViewDefinitions\\DataProvider\\ViewDefinitionStateProvider' => ['privates', 'App\\ViewDefinitions\\DataProvider\\ViewDefinitionStateProvider', 'getViewDefinitionStateProviderService', true],
            'api_platform.doctrine.orm.state.collection_provider' => ['privates', 'api_platform.doctrine.orm.state.collection_provider', 'getApiPlatform_Doctrine_Orm_State_CollectionProviderService', true],
            'api_platform.doctrine.orm.state.item_provider' => ['privates', 'api_platform.doctrine.orm.state.item_provider', 'getApiPlatform_Doctrine_Orm_State_ItemProviderService', true],
            'api_platform.openapi.provider' => ['privates', 'api_platform.openapi.provider', 'getApiPlatform_Openapi_ProviderService', true],
            'api_platform.state.error_provider' => ['privates', 'api_platform.state.error_provider', 'getApiPlatform_State_ErrorProviderService', true],
            'api_platform.state_provider.create' => ['privates', 'api_platform.state_provider.create', 'getApiPlatform_StateProvider_CreateService', true],
            'api_platform.state_provider.object' => ['privates', 'api_platform.state_provider.object', 'getApiPlatform_StateProvider_ObjectService', true],
            'api_platform.validator.state.error_provider' => ['privates', 'api_platform.validator.state.error_provider', 'getApiPlatform_Validator_State_ErrorProviderService', true],
        ], [
            'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider' => 'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider',
            'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider' => 'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider',
            'ApiPlatform\\OpenApi\\State\\OpenApiProvider' => 'ApiPlatform\\OpenApi\\State\\OpenApiProvider',
            'ApiPlatform\\State\\CreateProvider' => 'ApiPlatform\\State\\CreateProvider',
            'ApiPlatform\\State\\ObjectProvider' => 'ApiPlatform\\State\\ObjectProvider',
            'App\\Data\\DataProvider\\RecordListStateProvider' => 'App\\Data\\DataProvider\\RecordListStateProvider',
            'App\\Data\\DataProvider\\RecordStateProvider' => 'App\\Data\\DataProvider\\RecordStateProvider',
            'App\\FieldDefinitions\\DataProvider\\FieldDefinitionStateProvider' => 'App\\FieldDefinitions\\DataProvider\\FieldDefinitionStateProvider',
            'App\\Languages\\DataProvider\\AppListStringsStateProvider' => 'App\\Languages\\DataProvider\\AppListStringsStateProvider',
            'App\\Languages\\DataProvider\\AppStringsStateProvider' => 'App\\Languages\\DataProvider\\AppStringsStateProvider',
            'App\\Languages\\DataProvider\\ModStringsStateProvider' => 'App\\Languages\\DataProvider\\ModStringsStateProvider',
            'App\\Metadata\\DataProvider\\AppMetadataStateProvider' => 'App\\Metadata\\DataProvider\\AppMetadataStateProvider',
            'App\\Metadata\\DataProvider\\ModuleMetadataStateProvider' => 'App\\Metadata\\DataProvider\\ModuleMetadataStateProvider',
            'App\\Navbar\\DataProvider\\NavbarStateProvider' => 'App\\Navbar\\DataProvider\\NavbarStateProvider',
            'App\\Process\\DataProvider\\ProcessStateProvider' => 'App\\Process\\DataProvider\\ProcessStateProvider',
            'App\\Statistics\\DataProvider\\BatchedStatisticsStateProvider' => 'App\\Statistics\\DataProvider\\BatchedStatisticsStateProvider',
            'App\\Statistics\\DataProvider\\StatisticsStateProvider' => 'App\\Statistics\\DataProvider\\StatisticsStateProvider',
            'App\\SystemConfig\\DataProvider\\SystemConfigStateProvider' => 'App\\SystemConfig\\DataProvider\\SystemConfigStateProvider',
            'App\\Themes\\DataProvider\\ThemeImagesStateProvider' => 'App\\Themes\\DataProvider\\ThemeImagesStateProvider',
            'App\\UserPreferences\\DataProvider\\UserPreferenceStateProvider' => 'App\\UserPreferences\\DataProvider\\UserPreferenceStateProvider',
            'App\\ViewDefinitions\\DataProvider\\ViewDefinitionStateProvider' => 'App\\ViewDefinitions\\DataProvider\\ViewDefinitionStateProvider',
            'api_platform.doctrine.orm.state.collection_provider' => 'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider',
            'api_platform.doctrine.orm.state.item_provider' => 'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider',
            'api_platform.openapi.provider' => 'ApiPlatform\\OpenApi\\State\\OpenApiProvider',
            'api_platform.state.error_provider' => 'ApiPlatform\\State\\ErrorProvider',
            'api_platform.state_provider.create' => 'ApiPlatform\\State\\CreateProvider',
            'api_platform.state_provider.object' => 'ApiPlatform\\State\\ObjectProvider',
            'api_platform.validator.state.error_provider' => 'ApiPlatform\\Symfony\\Validator\\State\\ErrorProvider',
        ]));
    }

    /*
     * Gets the private 'api_platform.symfony.iri_converter' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\IriConverter
     */
    protected static function getApiPlatform_Symfony_IriConverterService($container)
    {
        $a = ($container->privates['api_platform.state_provider.locator'] ?? self::getApiPlatform_StateProvider_LocatorService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }

        return $container->privates['api_platform.symfony.iri_converter'] = new \ApiPlatform\Symfony\Routing\IriConverter($a, ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)), ($container->privates['api_platform.api.identifiers_extractor'] ?? self::getApiPlatform_Api_IdentifiersExtractorService($container)), ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container)), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), ($container->privates['api_platform.uri_variables.converter'] ?? self::getApiPlatform_UriVariables_ConverterService($container)), ($container->privates['api_platform.symfony.iri_converter.skolem'] ?? self::getApiPlatform_Symfony_IriConverter_SkolemService($container)), ($container->privates['api_platform.metadata.operation.metadata_factory'] ?? self::getApiPlatform_Metadata_Operation_MetadataFactoryService($container)));
    }

    /*
     * Gets the private 'api_platform.symfony.iri_converter.skolem' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\SkolemIriConverter
     */
    protected static function getApiPlatform_Symfony_IriConverter_SkolemService($container)
    {
        return $container->privates['api_platform.symfony.iri_converter.skolem'] = new \ApiPlatform\Symfony\Routing\SkolemIriConverter(($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)));
    }

    /*
     * Gets the private 'api_platform.uri_variables.converter' shared service.
     *
     * @return \ApiPlatform\Api\UriVariablesConverter
     */
    protected static function getApiPlatform_UriVariables_ConverterService($container)
    {
        return $container->privates['api_platform.uri_variables.converter'] = new \ApiPlatform\Api\UriVariablesConverter(($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['api_platform.uri_variables.transformer.integer'] ??= new \ApiPlatform\Api\UriVariableTransformer\IntegerUriVariableTransformer());
            yield 1 => ($container->privates['api_platform.uri_variables.transformer.date_time'] ??= new \ApiPlatform\Api\UriVariableTransformer\DateTimeUriVariableTransformer());
        }, 2));
    }

    /*
     * Gets the private 'argument_resolver.request_payload' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestPayloadValueResolver
     */
    protected static function getArgumentResolver_RequestPayloadService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['argument_resolver.request_payload'] = $container->createProxy('RequestPayloadValueResolverGhostDc06dea', static fn () => \RequestPayloadValueResolverGhostDc06dea::createLazyGhost(static fn ($proxy) => self::getArgumentResolver_RequestPayloadService($container, $proxy)));
        }

        include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/Controller/ValueResolverInterface.php';
        include_once \dirname(__DIR__, 3).'/vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestPayloadValueResolver.php';

        return ($lazyLoad->__construct(($container->privates['serializer'] ?? self::getSerializerService($container)), ($container->privates['validator'] ?? self::getValidatorService($container)), ($container->services['translator'] ?? self::getTranslatorService($container))) && false ?: $lazyLoad);
    }

    /*
     * Gets the private 'cache.property_access' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_PropertyAccessService($container)
    {
        return $container->privates['cache.property_access'] = \Symfony\Component\PropertyAccess\PropertyAccessor::createCache('QIvx9GFSnD', 0, $container->getParameter('container.build_id'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'cache.property_info' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_PropertyInfoService($container)
    {
        return $container->privates['cache.property_info'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('c5RrVWdYAm', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'cache.security_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SecurityExpressionLanguageService($container)
    {
        return $container->privates['cache.security_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('8c02xzioNq', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'cache.serializer' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SerializerService($container)
    {
        return $container->privates['cache.serializer'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('UE+3Hjss43', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'cache.validator' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_ValidatorService($container)
    {
        return $container->privates['cache.validator'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('cMOf89erqY', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'controller.is_granted_attribute_listener' shared service.
     *
     * @return \Symfony\Component\Security\Http\EventListener\IsGrantedAttributeListener
     */
    protected static function getController_IsGrantedAttributeListenerService($container)
    {
        return $container->privates['controller.is_granted_attribute_listener'] = new \Symfony\Component\Security\Http\EventListener\IsGrantedAttributeListener(($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container)), new \Symfony\Component\ExpressionLanguage\ExpressionLanguage(($container->services['cache.security_is_granted_attribute_expression_language'] ?? self::getCache_SecurityIsGrantedAttributeExpressionLanguageService($container))));
    }

    /*
     * Gets the private 'doctrine.dbal.default_connection.event_manager' shared service.
     *
     * @return \Symfony\Bridge\Doctrine\ContainerAwareEventManager
     */
    protected static function getDoctrine_Dbal_DefaultConnection_EventManagerService($container)
    {
        return $container->privates['doctrine.dbal.default_connection.event_manager'] = new \Symfony\Bridge\Doctrine\ContainerAwareEventManager(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'App\\Security\\TwoFactor\\EventListener\\TotpEncryptionListener' => ['privates', 'App\\Security\\TwoFactor\\EventListener\\TotpEncryptionListener', 'getTotpEncryptionListenerService', true],
            'doctrine.orm.default_listeners.attach_entity_listeners' => ['privates', 'doctrine.orm.default_listeners.attach_entity_listeners', 'getDoctrine_Orm_DefaultListeners_AttachEntityListenersService', true],
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener' => ['privates', 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener', 'getDoctrine_Orm_Listeners_DoctrineDbalCacheAdapterSchemaListenerService', true],
            'doctrine.orm.listeners.doctrine_token_provider_schema_listener' => ['privates', 'doctrine.orm.listeners.doctrine_token_provider_schema_listener', 'getDoctrine_Orm_Listeners_DoctrineTokenProviderSchemaListenerService', true],
            'doctrine.orm.listeners.lock_store_schema_listener' => ['privates', 'doctrine.orm.listeners.lock_store_schema_listener', 'getDoctrine_Orm_Listeners_LockStoreSchemaListenerService', true],
            'doctrine.orm.listeners.pdo_session_handler_schema_listener' => ['privates', 'doctrine.orm.listeners.pdo_session_handler_schema_listener', 'getDoctrine_Orm_Listeners_PdoSessionHandlerSchemaListenerService', true],
            'doctrine.orm.messenger.doctrine_schema_listener' => ['privates', 'doctrine.orm.messenger.doctrine_schema_listener', 'getDoctrine_Orm_Messenger_DoctrineSchemaListenerService', true],
        ], [
            'App\\Security\\TwoFactor\\EventListener\\TotpEncryptionListener' => '?',
            'doctrine.orm.default_listeners.attach_entity_listeners' => '?',
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener' => '?',
            'doctrine.orm.listeners.doctrine_token_provider_schema_listener' => '?',
            'doctrine.orm.listeners.lock_store_schema_listener' => '?',
            'doctrine.orm.listeners.pdo_session_handler_schema_listener' => '?',
            'doctrine.orm.messenger.doctrine_schema_listener' => '?',
        ]), [[['prePersist'], 'App\\Security\\TwoFactor\\EventListener\\TotpEncryptionListener'], [['preUpdate'], 'App\\Security\\TwoFactor\\EventListener\\TotpEncryptionListener'], [['postLoad'], 'App\\Security\\TwoFactor\\EventListener\\TotpEncryptionListener'], [['postGenerateSchema'], 'doctrine.orm.messenger.doctrine_schema_listener'], [['onSchemaCreateTable'], 'doctrine.orm.messenger.doctrine_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.doctrine_token_provider_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.pdo_session_handler_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.lock_store_schema_listener'], [['loadClassMetadata'], 'doctrine.orm.default_listeners.attach_entity_listeners']]);
    }

    /*
     * Gets the private 'doctrine.result_cache_pool' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getDoctrine_ResultCachePoolService($container)
    {
        return $container->privates['doctrine.result_cache_pool'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('X++WnTRQmz', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'doctrine.system_cache_pool' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getDoctrine_SystemCachePoolService($container)
    {
        return $container->privates['doctrine.system_cache_pool'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('0d6JkVB7+t', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected static function getExceptionListenerService($container)
    {
        return $container->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('error_controller', ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)), false, []);
    }

    /*
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected static function getLocaleAwareListenerService($container)
    {
        return $container->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['slugger'] ??= new \Symfony\Component\String\Slugger\AsciiSlugger('en'));
            yield 1 => ($container->services['translator'] ?? self::getTranslatorService($container));
            yield 2 => ($container->privates['translation.locale_switcher'] ?? $container->load('getTranslation_LocaleSwitcherService'));
        }, 3), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected static function getLocaleListenerService($container)
    {
        return $container->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), 'en', ($container->services['router'] ?? self::getRouterService($container)), false, []);
    }

    /*
     * Gets the private 'mime_types' shared service.
     *
     * @return \Symfony\Component\Mime\MimeTypes
     */
    protected static function getMimeTypesService($container)
    {
        $container->privates['mime_types'] = $instance = new \Symfony\Component\Mime\MimeTypes();

        $instance->setDefault($instance);

        return $instance;
    }

    /*
     * Gets the private 'monolog.handler.console' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Handler\ConsoleHandler
     */
    protected static function getMonolog_Handler_ConsoleService($container)
    {
        return $container->privates['monolog.handler.console'] = new \Symfony\Bridge\Monolog\Handler\ConsoleHandler(NULL, true, [], []);
    }

    /*
     * Gets the private 'monolog.handler.main' shared service.
     *
     * @return \Monolog\Handler\FingersCrossedHandler
     */
    protected static function getMonolog_Handler_MainService($container)
    {
        $a = new \Monolog\Handler\StreamHandler($container->getEnv('default:log.dir:env.logs:LOG_DIR').'/'.$container->getEnv('string:default:log.main.default:MAIN_LOG_FILE_NAME'), $container->getEnv('MAIN_LOG_LEVEL'), true, NULL, false);
        $a->pushProcessor(($container->privates['monolog.processor.psr_log_message'] ??= new \Monolog\Processor\PsrLogMessageProcessor()));

        return $container->privates['monolog.handler.main'] = new \Monolog\Handler\FingersCrossedHandler($a, new \Symfony\Bridge\Monolog\Handler\FingersCrossed\HttpCodeActivationStrategy(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), [['code' => 404, 'urls' => []], ['code' => 405, 'urls' => []]], new \Monolog\Handler\FingersCrossed\ErrorLevelActivationStrategy('info')), 50, true, true, NULL);
    }

    /*
     * Gets the private 'monolog.handler.security' shared service.
     *
     * @return \Monolog\Handler\StreamHandler
     */
    protected static function getMonolog_Handler_SecurityService($container)
    {
        $container->privates['monolog.handler.security'] = $instance = new \Monolog\Handler\StreamHandler($container->getEnv('default:log.dir:env.logs:LOG_DIR').'/'.$container->getEnv('string:default:log.security.default:SECURITY_LOG_FILE_NAME'), $container->getEnv('SECURITY_LOG_LEVEL'), true, NULL, false);

        $instance->pushProcessor(($container->privates['monolog.processor.psr_log_message'] ??= new \Monolog\Processor\PsrLogMessageProcessor()));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger' shared service.
     *
     * @return \Monolog\Logger
     */
    protected static function getMonolog_LoggerService($container)
    {
        $container->privates['monolog.logger'] = $instance = new \Monolog\Logger('app');

        $instance->useMicrosecondTimestamps(true);
        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.cache' shared service.
     *
     * @return \Monolog\Logger
     */
    protected static function getMonolog_Logger_CacheService($container)
    {
        $container->privates['monolog.logger.cache'] = $instance = new \Monolog\Logger('cache');

        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.request' shared service.
     *
     * @return \Monolog\Logger
     */
    protected static function getMonolog_Logger_RequestService($container)
    {
        $container->privates['monolog.logger.request'] = $instance = new \Monolog\Logger('request');

        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /*
     * Gets the private 'nelmio_cors.cors_listener' shared service.
     *
     * @return \Nelmio\CorsBundle\EventListener\CorsListener
     */
    protected static function getNelmioCors_CorsListenerService($container)
    {
        return $container->privates['nelmio_cors.cors_listener'] = new \Nelmio\CorsBundle\EventListener\CorsListener(new \Nelmio\CorsBundle\Options\Resolver([new \Nelmio\CorsBundle\Options\ConfigProvider($container->parameters['nelmio_cors.map'], $container->getParameter('nelmio_cors.defaults'))]));
    }

    /*
     * Gets the private 'parameter_bag' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag
     */
    protected static function getParameterBagService($container)
    {
        return $container->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container);
    }

    /*
     * Gets the private 'property_accessor' shared service.
     *
     * @return \Symfony\Component\PropertyAccess\PropertyAccessor
     */
    protected static function getPropertyAccessorService($container)
    {
        $a = ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());

        return $container->privates['property_accessor'] = new \Symfony\Component\PropertyAccess\PropertyAccessor(3, 2, ($container->privates['cache.property_access'] ?? self::getCache_PropertyAccessService($container)), $a, $a);
    }

    /*
     * Gets the private 'property_info.cache' shared service.
     *
     * @return \Symfony\Component\PropertyInfo\PropertyInfoCacheExtractor
     */
    protected static function getPropertyInfo_CacheService($container)
    {
        return $container->privates['property_info.cache'] = new \Symfony\Component\PropertyInfo\PropertyInfoCacheExtractor(new \Symfony\Component\PropertyInfo\PropertyInfoExtractor(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.serializer_extractor'] ?? $container->load('getPropertyInfo_SerializerExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
            yield 2 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
        }, 3), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($container->privates['property_info.phpstan_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpStanExtractor());
            yield 2 => ($container->privates['property_info.php_doc_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor());
            yield 3 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 4), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.php_doc_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor());
        }, 1), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 2), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 1)), ($container->privates['cache.property_info'] ?? self::getCache_PropertyInfoService($container)));
    }

    /*
     * Gets the private 'router.expression_language_provider' shared service.
     *
     * @return \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider
     */
    protected static function getRouter_ExpressionLanguageProviderService($container)
    {
        return $container->privates['router.expression_language_provider'] = new \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'env' => ['privates', 'container.getenv', 'getContainer_GetenvService', true],
            'service' => ['services', 'container.get_routing_condition_service', 'getContainer_GetRoutingConditionServiceService', true],
        ], [
            'env' => 'Closure',
            'service' => 'Closure',
        ]));
    }

    /*
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected static function getRouter_RequestContextService($container)
    {
        $container->privates['router.request_context'] = $instance = \Symfony\Component\Routing\RequestContext::fromUri('', 'localhost', 'http', 80, 443);

        $instance->setParameter('_functions', ($container->privates['router.expression_language_provider'] ?? self::getRouter_ExpressionLanguageProviderService($container)));

        return $instance;
    }

    /*
     * Gets the private 'router_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\RouterListener
     */
    protected static function getRouterListenerService($container)
    {
        return $container->privates['router_listener'] = new \Symfony\Component\HttpKernel\EventListener\RouterListener(($container->services['router'] ?? self::getRouterService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)), \dirname(__DIR__, 3), false);
    }

    /*
     * Gets the private 'scheb_two_factor.provider_preparation_recorder' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TokenPreparationRecorder
     */
    protected static function getSchebTwoFactor_ProviderPreparationRecorderService($container)
    {
        return $container->privates['scheb_two_factor.provider_preparation_recorder'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TokenPreparationRecorder(($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)));
    }

    /*
     * Gets the private 'scheb_two_factor.provider_registry' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderRegistry
     */
    protected static function getSchebTwoFactor_ProviderRegistryService($container)
    {
        return $container->privates['scheb_two_factor.provider_registry'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderRegistry(new RewindableGenerator(function () use ($container) {
            yield 'totp' => ($container->privates['scheb_two_factor.security.totp.provider'] ?? $container->load('getSchebTwoFactor_Security_Totp_ProviderService'));
        }, 1));
    }

    /*
     * Gets the private 'scheb_two_factor.security.authentication.trust_resolver' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\Authentication\AuthenticationTrustResolver
     */
    protected static function getSchebTwoFactor_Security_Authentication_TrustResolverService($container)
    {
        return $container->privates['scheb_two_factor.security.authentication.trust_resolver'] = new \Scheb\TwoFactorBundle\Security\Authentication\AuthenticationTrustResolver(new \Symfony\Component\Security\Core\Authentication\AuthenticationTrustResolver());
    }

    /*
     * Gets the private 'security.access.decision_manager' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AccessDecisionManager
     */
    protected static function getSecurity_Access_DecisionManagerService($container)
    {
        return $container->privates['security.access.decision_manager'] = new \Symfony\Component\Security\Core\Authorization\AccessDecisionManager(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['security.access.authenticated_voter'] ?? $container->load('getSecurity_Access_AuthenticatedVoterService'));
            yield 1 => ($container->privates['scheb_two_factor.security.access.authenticated_voter'] ??= new \Scheb\TwoFactorBundle\Security\Authorization\Voter\TwoFactorInProgressVoter());
            yield 2 => ($container->privates['security.access.simple_role_voter'] ??= new \Symfony\Component\Security\Core\Authorization\Voter\RoleVoter());
            yield 3 => ($container->privates['security.access.expression_voter'] ?? $container->load('getSecurity_Access_ExpressionVoterService'));
        }, 4), new \Symfony\Component\Security\Core\Authorization\Strategy\AffirmativeStrategy(false));
    }

    /*
     * Gets the private 'security.authentication.form_listener.two_factor.main' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Event\TwoFactorFormListener
     */
    protected static function getSecurity_Authentication_FormListener_TwoFactor_MainService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->privates['security.authentication.form_listener.two_factor.main'])) {
            return $container->privates['security.authentication.form_listener.two_factor.main'];
        }

        return $container->privates['security.authentication.form_listener.two_factor.main'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Event\TwoFactorFormListener(($container->privates['security.firewall_config.two_factor.main'] ?? self::getSecurity_FirewallConfig_TwoFactor_MainService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a);
    }

    /*
     * Gets the private 'security.authentication.provider_preparation_listener.two_factor.main' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderPreparationListener
     */
    protected static function getSecurity_Authentication_ProviderPreparationListener_TwoFactor_MainService($container)
    {
        $a = ($container->privates['scheb_two_factor.provider_registry'] ?? self::getSchebTwoFactor_ProviderRegistryService($container));

        if (isset($container->privates['security.authentication.provider_preparation_listener.two_factor.main'])) {
            return $container->privates['security.authentication.provider_preparation_listener.two_factor.main'];
        }

        return $container->privates['security.authentication.provider_preparation_listener.two_factor.main'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderPreparationListener($a, ($container->privates['scheb_two_factor.provider_preparation_recorder'] ?? self::getSchebTwoFactor_ProviderPreparationRecorderService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)), 'main', true, true);
    }

    /*
     * Gets the private 'security.authorization_checker' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AuthorizationChecker
     */
    protected static function getSecurity_AuthorizationCheckerService($container)
    {
        $a = ($container->privates['security.access.decision_manager'] ?? self::getSecurity_Access_DecisionManagerService($container));

        if (isset($container->privates['security.authorization_checker'])) {
            return $container->privates['security.authorization_checker'];
        }

        return $container->privates['security.authorization_checker'] = new \Symfony\Component\Security\Core\Authorization\AuthorizationChecker(($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a, false, false);
    }

    /*
     * Gets the private 'security.context_listener.0' shared service.
     *
     * @return \Symfony\Component\Security\Http\Firewall\ContextListener
     */
    protected static function getSecurity_ContextListener_0Service($container)
    {
        $a = ($container->privates['security.event_dispatcher.main'] ?? self::getSecurity_EventDispatcher_MainService($container));

        if (isset($container->privates['security.context_listener.0'])) {
            return $container->privates['security.context_listener.0'];
        }

        return $container->privates['security.context_listener.0'] = new \Symfony\Component\Security\Http\Firewall\ContextListener(($container->privates['security.untracked_token_storage'] ??= new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage()), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['security.user.provider.concrete.app_user_provider'] ?? $container->load('getSecurity_User_Provider_Concrete_AppUserProviderService'));
        }, 1), 'main', ($container->services['monolog.logger.security'] ?? self::getMonolog_Logger_SecurityService($container)), $a, ($container->privates['scheb_two_factor.security.authentication.trust_resolver'] ?? self::getSchebTwoFactor_Security_Authentication_TrustResolverService($container)), [($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), 'enableUsageTracking']);
    }

    /*
     * Gets the private 'security.csrf.token_manager' shared service.
     *
     * @return \Symfony\Component\Security\Csrf\CsrfTokenManager
     */
    protected static function getSecurity_Csrf_TokenManagerService($container)
    {
        return $container->privates['security.csrf.token_manager'] = new \Symfony\Component\Security\Csrf\CsrfTokenManager(new \Symfony\Component\Security\Csrf\TokenGenerator\UriSafeTokenGenerator(), ($container->privates['security.csrf.token_storage'] ?? self::getSecurity_Csrf_TokenStorageService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'security.csrf.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Csrf\TokenStorage\SessionTokenStorage
     */
    protected static function getSecurity_Csrf_TokenStorageService($container)
    {
        return $container->privates['security.csrf.token_storage'] = new \Symfony\Component\Security\Csrf\TokenStorage\SessionTokenStorage(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'security.event_dispatcher.main' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected static function getSecurity_EventDispatcher_MainService($container)
    {
        $container->privates['security.event_dispatcher.main'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'App\\Security\\LegacySessionLogoutListener')] fn () => ($container->privates['App\\Security\\LegacySessionLogoutListener'] ?? $container->load('getLegacySessionLogoutListenerService')), 'onSymfonyComponentSecurityHttpEventLogoutEvent'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'App\\Security\\Ldap\\AppCheckLdapCredentialsListener')] fn () => ($container->privates['App\\Security\\Ldap\\AppCheckLdapCredentialsListener'] ?? $container->load('getAppCheckLdapCredentialsListenerService')), 'onCheckPassport'], 144);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.session.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\SessionStrategyListener')] fn () => ($container->privates['security.listener.session.main'] ?? $container->load('getSecurity_Listener_Session_MainService')), 'onSuccessfulLogin'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.default.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\DefaultLogoutListener')] fn () => ($container->privates['security.logout.listener.default.main'] ?? $container->load('getSecurity_Logout_Listener_Default_MainService')), 'onLogout'], 64);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.session.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\SessionLogoutListener')] fn () => ($container->privates['security.logout.listener.session.main'] ??= new \Symfony\Component\Security\Http\EventListener\SessionLogoutListener()), 'onLogout'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.login_throttling.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\LoginThrottlingListener')] fn () => ($container->privates['security.listener.login_throttling.main'] ?? $container->load('getSecurity_Listener_LoginThrottling_MainService')), 'checkPassport'], 2080);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginFailureEvent', [#[\Closure(name: 'security.listener.login_throttling.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\LoginThrottlingListener')] fn () => ($container->privates['security.listener.login_throttling.main'] ?? $container->load('getSecurity_Listener_LoginThrottling_MainService')), 'onFailedLogin'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.login_throttling.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\LoginThrottlingListener')] fn () => ($container->privates['security.listener.login_throttling.main'] ?? $container->load('getSecurity_Listener_LoginThrottling_MainService')), 'onSuccessfulLogin'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\AuthenticationTokenCreatedEvent', [#[\Closure(name: 'security.authentication.token_created_listener.two_factor.main', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Event\\AuthenticationTokenListener')] fn () => ($container->privates['security.authentication.token_created_listener.two_factor.main'] ?? $container->load('getSecurity_Authentication_TokenCreatedListener_TwoFactor_MainService')), 'onAuthenticationTokenCreated'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_checker.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserCheckerListener')] fn () => ($container->privates['security.listener.user_checker.main'] ?? $container->load('getSecurity_Listener_UserChecker_MainService')), 'preCheckCredentials'], 256);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'security.listener.user_checker.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserCheckerListener')] fn () => ($container->privates['security.listener.user_checker.main'] ?? $container->load('getSecurity_Listener_UserChecker_MainService')), 'postCheckCredentials'], 256);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_provider', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserProviderListener')] fn () => ($container->privates['security.listener.user_provider'] ?? $container->load('getSecurity_Listener_UserProviderService')), 'checkPassport'], 1024);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'Nbgrp\\OneloginSamlBundle\\EventListener\\Security\\SamlLogoutListener')] fn () => ($container->privates['Nbgrp\\OneloginSamlBundle\\EventListener\\Security\\SamlLogoutListener'] ?? $container->load('getSamlLogoutListenerService')), 'processSingleLogout'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'Nbgrp\\OneloginSamlBundle\\EventListener\\User\\DeferredUserListener')] fn () => ($container->privates['Nbgrp\\OneloginSamlBundle\\EventListener\\User\\DeferredUserListener'] ??= new \Nbgrp\OneloginSamlBundle\EventListener\User\DeferredUserListener()), 'dispatchDeferredEvent'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'App\\Security\\CheckExternalAuthOnlyCredentialsListener')] fn () => ($container->privates['App\\Security\\CheckExternalAuthOnlyCredentialsListener'] ??= new \App\Security\CheckExternalAuthOnlyCredentialsListener()), 'onCheckPassport'], 200);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'App\\Security\\LoginSuccessEventListener')] fn () => ($container->privates['App\\Security\\LoginSuccessEventListener'] ?? $container->load('getLoginSuccessEventListenerService')), 'onLoginSuccess'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.check_authenticator_credentials', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CheckCredentialsListener')] fn () => ($container->privates['security.listener.check_authenticator_credentials'] ?? $container->load('getSecurity_Listener_CheckAuthenticatorCredentialsService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.password_migrating', class: 'Symfony\\Component\\Security\\Http\\EventListener\\PasswordMigratingListener')] fn () => ($container->privates['security.listener.password_migrating'] ?? $container->load('getSecurity_Listener_PasswordMigratingService')), 'onLoginSuccess'], 0);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.main', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.main'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_MainService($container)), 'onLogin'], 9223372036854775807);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.check_two_factor_code', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\CheckTwoFactorCodeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.check_two_factor_code'] ?? $container->load('getSchebTwoFactor_Security_Listener_CheckTwoFactorCodeService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.suppress_remember_me', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\SuppressRememberMeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.suppress_remember_me'] ??= new \Scheb\TwoFactorBundle\Security\Http\EventListener\SuppressRememberMeListener()), 'onSuccessfulLogin'], -63);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'scheb_two_factor.security.authentication_success_event_suppressor', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Event\\AuthenticationSuccessEventSuppressor')] fn () => ($container->privates['scheb_two_factor.security.authentication_success_event_suppressor'] ??= new \Scheb\TwoFactorBundle\Security\TwoFactor\Event\AuthenticationSuccessEventSuppressor()), 'onLogin'], 9223372036854775806);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.check_backup_code', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\CheckBackupCodeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.check_backup_code'] ?? $container->load('getSchebTwoFactor_Security_Listener_CheckBackupCodeService')), 'checkPassport'], 16);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.csrf_protection', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfProtectionListener')] fn () => ($container->privates['security.listener.csrf_protection'] ?? $container->load('getSecurity_Listener_CsrfProtectionService')), 'checkPassport'], 512);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.csrf_token_clearing', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfTokenClearingLogoutListener')] fn () => ($container->privates['security.logout.listener.csrf_token_clearing'] ?? $container->load('getSecurity_Logout_Listener_CsrfTokenClearingService')), 'onLogout'], 0);

        return $instance;
    }

    /*
     * Gets the private 'security.expression_language' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\ExpressionLanguage
     */
    protected static function getSecurity_ExpressionLanguageService($container)
    {
        $container->privates['security.expression_language'] = $instance = new \Symfony\Component\Security\Core\Authorization\ExpressionLanguage(($container->privates['cache.security_expression_language'] ?? self::getCache_SecurityExpressionLanguageService($container)));

        $instance->registerProvider(new \ApiPlatform\Symfony\Security\Core\Authorization\ExpressionLanguageProvider());

        return $instance;
    }

    /*
     * Gets the private 'security.firewall' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\EventListener\FirewallListener
     */
    protected static function getSecurity_FirewallService($container)
    {
        $a = ($container->privates['security.firewall.map'] ?? self::getSecurity_Firewall_MapService($container));

        if (isset($container->privates['security.firewall'])) {
            return $container->privates['security.firewall'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->privates['security.firewall'])) {
            return $container->privates['security.firewall'];
        }

        return $container->privates['security.firewall'] = new \Symfony\Bundle\SecurityBundle\EventListener\FirewallListener($a, $b, ($container->privates['security.logout_url_generator'] ?? self::getSecurity_LogoutUrlGeneratorService($container)));
    }

    /*
     * Gets the private 'security.firewall.map' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Security\FirewallMap
     */
    protected static function getSecurity_Firewall_MapService($container)
    {
        $a = ($container->privates['.service_locator.zJyh7qS'] ?? self::get_ServiceLocator_ZJyh7qSService($container));

        if (isset($container->privates['security.firewall.map'])) {
            return $container->privates['security.firewall.map'];
        }

        return $container->privates['security.firewall.map'] = new \Symfony\Bundle\SecurityBundle\Security\FirewallMap($a, new RewindableGenerator(function () use ($container) {
            yield 'security.firewall.map.context.dev' => ($container->privates['.security.request_matcher.kLbKLHa'] ?? $container->load('get_Security_RequestMatcher_KLbKLHaService'));
            yield 'security.firewall.map.context.main' => NULL;
        }, 2));
    }

    /*
     * Gets the private 'security.firewall_config.two_factor.main' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\TwoFactorFirewallConfig
     */
    protected static function getSecurity_FirewallConfig_TwoFactor_MainService($container)
    {
        return $container->privates['security.firewall_config.two_factor.main'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\TwoFactorFirewallConfig(['check_path' => 'app_2fa_check', 'prepare_on_login' => true, 'prepare_on_access_denied' => true, 'auth_code_parameter_name' => '_auth_code', 'default_target_path' => '/', 'provider' => 'app_user_provider', 'authentication_required_handler' => '2fa_required', 'success_handler' => '2fa_success', 'failure_handler' => '2fa_failed', 'post_only' => true, 'auth_form_path' => '/2fa', 'always_use_default_target_path' => false, 'trusted_parameter_name' => '_trusted', 'remember_me_sets_trusted' => false, 'multi_factor' => false, 'enable_csrf' => false, 'csrf_parameter' => '_csrf_token', 'csrf_token_id' => 'two_factor'], 'main', ($container->privates['security.http_utils'] ?? self::getSecurity_HttpUtilsService($container)), new \Scheb\TwoFactorBundle\Security\Http\Utils\RequestDataReader());
    }

    /*
     * Gets the private 'security.http_utils' shared service.
     *
     * @return \Symfony\Component\Security\Http\HttpUtils
     */
    protected static function getSecurity_HttpUtilsService($container)
    {
        $a = ($container->services['router'] ?? self::getRouterService($container));

        return $container->privates['security.http_utils'] = new \Symfony\Component\Security\Http\HttpUtils($a, $a, '{^https?://%s$}i', '{^https://%s$}i');
    }

    /*
     * Gets the private 'security.logout_url_generator' shared service.
     *
     * @return \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator
     */
    protected static function getSecurity_LogoutUrlGeneratorService($container)
    {
        $container->privates['security.logout_url_generator'] = $instance = new \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->services['router'] ?? self::getRouterService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)));

        $instance->registerListener('main', 'app_logout', 'logout', '_csrf_token', NULL, NULL);

        return $instance;
    }

    /*
     * Gets the private 'security.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage
     */
    protected static function getSecurity_TokenStorageService($container)
    {
        return $container->privates['security.token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage(($container->privates['security.untracked_token_storage'] ??= new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage()), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
        ], [
            'request_stack' => '?',
        ]));
    }

    /*
     * Gets the private 'serializer' shared service.
     *
     * @return \Symfony\Component\Serializer\Serializer
     */
    protected static function getSerializerService($container)
    {
        $a = ($container->privates['api_platform.symfony.iri_converter'] ?? self::getApiPlatform_Symfony_IriConverterService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $b = ($container->privates['property_accessor'] ?? self::getPropertyAccessorService($container));
        $c = ($container->privates['property_info.cache'] ?? self::getPropertyInfo_CacheService($container));
        $d = new \Symfony\Component\Serializer\Encoder\JsonEncoder(NULL, NULL);

        $e = new \ApiPlatform\OpenApi\Serializer\LegacyOpenApiNormalizer(new \ApiPlatform\OpenApi\Serializer\ApiGatewayNormalizer(new \ApiPlatform\OpenApi\Serializer\OpenApiNormalizer(new \Symfony\Component\Serializer\Serializer([new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer(NULL, NULL, $b, $c)], [$d]))));
        $f = ($container->privates['serializer.name_converter.metadata_aware'] ?? self::getSerializer_NameConverter_MetadataAwareService($container));
        $g = ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container));
        $h = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));
        $i = ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container));
        $j = ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container));
        $k = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));
        $l = ($container->privates['api_platform.jsonld.context_builder'] ?? self::getApiPlatform_Jsonld_ContextBuilderService($container));
        $m = ($container->privates['api_platform.serializer.mapping.cache_class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_CacheClassMetadataFactoryService($container));
        $n = ($container->privates['api_platform.security.resource_access_checker'] ?? self::getApiPlatform_Security_ResourceAccessCheckerService($container));

        $o = new \ApiPlatform\JsonLd\Serializer\ItemNormalizer($h, $i, $j, $a, $k, $l, $b, $f, $m, [], $n, NULL);
        $p = new \ApiPlatform\Serializer\ItemNormalizer($i, $j, $a, $k, $b, $f, $m, NULL, $h, $n, [], NULL);
        $q = ($container->services['translator'] ?? self::getTranslatorService($container));
        $r = ($container->privates['api_platform.api.identifiers_extractor'] ?? self::getApiPlatform_Api_IdentifiersExtractorService($container));
        $s = new \Symfony\Component\Serializer\Mapping\ClassDiscriminatorFromClassMetadata($m);
        $t = new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer($m, $f, $b, $c, $s, NULL, [], $c);
        $u = new \Symfony\Component\Serializer\Encoder\YamlEncoder(NULL, NULL);

        return $container->privates['serializer'] = new \Symfony\Component\Serializer\Serializer([new \Symfony\Component\Serializer\Normalizer\UnwrappingDenormalizer($b), $e, $e, new \ApiPlatform\Serializer\ConstraintViolationListNormalizer([], $f), new \ApiPlatform\Hydra\Serializer\ConstraintViolationListNormalizer($g, [], $f), new \ApiPlatform\Problem\Serializer\ConstraintViolationListNormalizer([], $f), new \ApiPlatform\GraphQl\Serializer\Exception\ValidationExceptionNormalizer($container->parameters['api_platform.exception_to_status']), new \ApiPlatform\GraphQl\Serializer\Exception\HttpExceptionNormalizer(), new \ApiPlatform\GraphQl\Serializer\Exception\RuntimeExceptionNormalizer(), new \ApiPlatform\GraphQl\Serializer\Exception\ErrorNormalizer(), $e, new \ApiPlatform\Symfony\Validator\Serializer\ValidationExceptionNormalizer($o, $f), new \ApiPlatform\Hydra\Serializer\DocumentationNormalizer($h, $i, $j, $k, $g, $f), new \ApiPlatform\Hydra\Serializer\EntrypointNormalizer($h, $a, $g), new \ApiPlatform\Hydra\Serializer\ErrorNormalizer($g, false, []), new \ApiPlatform\Symfony\Validator\Serializer\ValidationExceptionNormalizer($p, $f), new \ApiPlatform\Problem\Serializer\ErrorNormalizer(false, []), new \Symfony\Component\Messenger\Transport\Serialization\Normalizer\FlattenExceptionNormalizer(), new \Symfony\Component\Serializer\Normalizer\ProblemNormalizer(false, translator: $q), new \Symfony\Component\Serializer\Normalizer\UidNormalizer(), $o, new \ApiPlatform\GraphQl\Serializer\ItemNormalizer($i, $j, $a, $r, $k, $b, $f, $m, NULL, $h, $n), $p, new \Symfony\Component\Serializer\Normalizer\DateTimeNormalizer(), new \Symfony\Component\Serializer\Normalizer\ConstraintViolationListNormalizer([], $f), new \Symfony\Component\Serializer\Normalizer\MimeMessageNormalizer(new \Symfony\Component\Serializer\Normalizer\PropertyNormalizer($m, $f, $c, $s, NULL, [])), new \Symfony\Component\Serializer\Normalizer\DateTimeZoneNormalizer(), new \Symfony\Component\Serializer\Normalizer\DateIntervalNormalizer(), new \Symfony\Component\Serializer\Normalizer\FormErrorNormalizer(), new \Symfony\Component\Serializer\Normalizer\BackedEnumNormalizer(), new \Symfony\Component\Serializer\Normalizer\DataUriNormalizer(($container->privates['mime_types'] ?? self::getMimeTypesService($container))), new \Symfony\Component\Serializer\Normalizer\TranslatableNormalizer($q), new \Symfony\Component\Serializer\Normalizer\JsonSerializableNormalizer(NULL, NULL), new \ApiPlatform\Hydra\Serializer\CollectionFiltersNormalizer(new \ApiPlatform\Hydra\Serializer\PartialCollectionViewNormalizer(new \ApiPlatform\Hydra\Serializer\CollectionNormalizer($l, $k, $a, NULL), 'page', 'pagination', $h, $b, 1), $h, $k, ($container->privates['api_platform.filter_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], []))), new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \ApiPlatform\JsonLd\Serializer\ObjectNormalizer($t, $a, $l), new \ApiPlatform\GraphQl\Serializer\ObjectNormalizer($t, $a, $r), $t], [new \Symfony\Component\Serializer\Encoder\XmlEncoder(), $d, $u, new \Symfony\Component\Serializer\Encoder\CsvEncoder(), new \ApiPlatform\Serializer\JsonEncoder('jsonopenapi', NULL), new \ApiPlatform\Serializer\YamlEncoder('yamlopenapi', $u), new \ApiPlatform\Serializer\JsonEncoder('jsonld', NULL), new \ApiPlatform\Serializer\JsonEncoder('jsonproblem')]);
    }

    /*
     * Gets the private 'serializer.name_converter.metadata_aware' shared service.
     *
     * @return \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter
     */
    protected static function getSerializer_NameConverter_MetadataAwareService($container)
    {
        return $container->privates['serializer.name_converter.metadata_aware'] = new \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter(($container->privates['api_platform.serializer.mapping.cache_class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_CacheClassMetadataFactoryService($container)));
    }

    /*
     * Gets the private 'session_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SessionListener
     */
    protected static function getSessionListenerService($container)
    {
        return $container->privates['session_listener'] = new \Symfony\Component\HttpKernel\EventListener\SessionListener(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'session_factory' => ['privates', 'session.factory', 'getSession_FactoryService', true],
        ], [
            'logger' => '?',
            'session_factory' => '?',
        ]), false, $container->parameters['session.storage.options']);
    }

    /*
     * Gets the private 'validator' shared service.
     *
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    protected static function getValidatorService($container)
    {
        return $container->privates['validator'] = ($container->privates['validator.builder'] ?? self::getValidator_BuilderService($container))->getValidator();
    }

    /*
     * Gets the private 'validator.builder' shared service.
     *
     * @return \Symfony\Component\Validator\ValidatorBuilder
     */
    protected static function getValidator_BuilderService($container)
    {
        $container->privates['validator.builder'] = $instance = \Symfony\Component\Validator\Validation::createValidatorBuilder();

        $a = ($container->privates['property_info.cache'] ?? self::getPropertyInfo_CacheService($container));

        $instance->setConstraintValidatorFactory(new \Symfony\Component\Validator\ContainerConstraintValidatorFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => ['privates', 'validator.email', 'getValidator_EmailService', true],
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
            'Symfony\\Component\\Validator\\Constraints\\NoSuspiciousCharactersValidator' => ['privates', 'validator.no_suspicious_characters', 'getValidator_NoSuspiciousCharactersService', true],
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => ['privates', 'validator.not_compromised_password', 'getValidator_NotCompromisedPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\WhenValidator' => ['privates', 'validator.when', 'getValidator_WhenService', true],
            'doctrine.orm.validator.unique' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'security.validator.user_password' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'validator.expression' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
        ], [
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => '?',
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NoSuspiciousCharactersValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\WhenValidator' => '?',
            'doctrine.orm.validator.unique' => '?',
            'security.validator.user_password' => '?',
            'validator.expression' => '?',
        ])));
        $instance->setGroupProviderLocator(($container->privates['api_platform.graphql.mutation_resolver_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], [])));
        if ($container->has('translator')) {
            $instance->setTranslator(($container->services['translator'] ?? self::getTranslatorService($container)));
        }
        $instance->setTranslationDomain('validators');
        $instance->addXmlMappings([(\dirname(__DIR__, 3).'/vendor/symfony/form/Resources/config/validation.xml')]);
        $instance->enableAttributeMapping(true);
        $instance->addMethodMapping('loadValidatorMetadata');
        $instance->setMappingCache(\Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($container->targetDir.''.'/validation.php'), ($container->privates['cache.validator'] ?? self::getCache_ValidatorService($container))));
        $instance->addObjectInitializers([new \Symfony\Bridge\Doctrine\Validator\DoctrineInitializer(($container->services['doctrine'] ?? self::getDoctrineService($container)))]);
        $instance->addLoader(new \Symfony\Component\Validator\Mapping\Loader\PropertyInfoLoader($a, $a, $a, NULL));
        $instance->addLoader(new \Symfony\Bridge\Doctrine\Validator\DoctrineLoader(($container->services['doctrine.orm.default_entity_manager'] ?? self::getDoctrine_Orm_DefaultEntityManagerService($container)), NULL));

        return $instance;
    }

    /*
     * Gets the private 'web_link.add_link_header_listener' shared service.
     *
     * @return \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener
     */
    protected static function getWebLink_AddLinkHeaderListenerService($container)
    {
        return $container->privates['web_link.add_link_header_listener'] = new \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener(($container->privates['web_link.http_header_serializer'] ??= new \Symfony\Component\WebLink\HttpHeaderSerializer()));
    }

    /*
     * Gets the private 'web_link.http_header_serializer' shared service.
     *
     * @return \Symfony\Component\WebLink\HttpHeaderSerializer
     */
    protected static function getWebLink_HttpHeaderSerializerService($container)
    {
        return $container->privates['web_link.http_header_serializer'] = new \Symfony\Component\WebLink\HttpHeaderSerializer();
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new ParameterNotFoundException($name);
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (!isset($this->parameterBag)) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.runtime_mode' => false,
        'kernel.runtime_mode.web' => false,
        'kernel.runtime_mode.cli' => false,
        'kernel.runtime_mode.worker' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
        'graphql.graphql_show_docs' => false,
        'saml.autocreate.attributes_map' => false,
        'secret' => false,
        'auth_type' => false,
        'site.url' => false,
        'kernel.secret' => false,
        'router.cache_dir' => false,
        'serializer.mapping.cache.file' => false,
        'validator.mapping.cache.file' => false,
        'doctrine.orm.proxy_dir' => false,
        'nelmio_cors.defaults' => false,
        'nbgrp_onelogin_saml.onelogin_settings' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        $container = $this;
        $value = match ($name) {
            'kernel.runtime_environment' => $container->getEnv('default:kernel.environment:APP_RUNTIME_ENV'),
            'kernel.runtime_mode' => $container->getEnv('query_string:default:container.runtime_mode:APP_RUNTIME_MODE'),
            'kernel.runtime_mode.web' => $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'),
            'kernel.runtime_mode.cli' => $container->getEnv('not:default:kernel.runtime_mode.web:'),
            'kernel.runtime_mode.worker' => $container->getEnv('bool:default::key:worker:default:kernel.runtime_mode:'),
            'kernel.build_dir' => $container->targetDir.'',
            'kernel.cache_dir' => $container->targetDir.'',
            'graphql.graphql_show_docs' => $container->getEnv('default::bool:GRAPHQL_SHOW_DOCS'),
            'saml.autocreate.attributes_map' => $container->getEnv('json:SAML_AUTOCREATE_ATTRIBUTES_MAP'),
            'secret' => $container->getEnv('APP_SECRET'),
            'auth_type' => $container->getEnv('AUTH_TYPE'),
            'site.url' => $container->getEnv('SITE_URL'),
            'kernel.secret' => $container->getEnv('APP_SECRET'),
            'router.cache_dir' => $container->targetDir.'',
            'serializer.mapping.cache.file' => ($container->targetDir.''.'/serialization.php'),
            'validator.mapping.cache.file' => ($container->targetDir.''.'/validation.php'),
            'doctrine.orm.proxy_dir' => ($container->targetDir.''.'/doctrine/orm/Proxies'),
            'nelmio_cors.defaults' => [
                'allow_origin' => [
                    0 => $container->getEnv('CORS_ALLOW_ORIGIN'),
                ],
                'allow_credentials' => false,
                'allow_headers' => [
                    0 => 'content-type',
                    1 => 'authorization',
                ],
                'expose_headers' => [
                    0 => 'Link',
                ],
                'allow_methods' => [
                    0 => 'GET',
                    1 => 'OPTIONS',
                    2 => 'POST',
                    3 => 'PUT',
                    4 => 'PATCH',
                    5 => 'DELETE',
                ],
                'max_age' => 3600,
                'hosts' => [

                ],
                'origin_regex' => true,
                'forced_allow_origin_value' => NULL,
                'skip_same_as_origin' => true,
            ],
            'nbgrp_onelogin_saml.onelogin_settings' => [
                'default' => [
                    'idp' => [
                        'entityId' => $container->getEnv('SAML_IDP_ENTITY_ID'),
                        'singleSignOnService' => [
                            'url' => $container->getEnv('SAML_IDP_SSO_URL'),
                            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                        ],
                        'singleLogoutService' => [
                            'url' => $container->getEnv('SAML_IDP_SLO_URL'),
                            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                        ],
                        'x509cert' => $container->getEnv('SAML_IDP_X509CERT'),
                    ],
                    'sp' => [
                        'entityId' => $container->getEnv('string:default:site.url:SAML_SP_ENTITY_ID'),
                        'assertionConsumerService' => [
                            'url' => $container->getEnv('string:SITE_URL').'/saml/acs',
                            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                        ],
                        'singleLogoutService' => [
                            'url' => $container->getEnv('string:SITE_URL').'/saml/logout',
                            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                        ],
                        'privateKey' => $container->getEnv('SAML_SP_PRIVATE_KEY'),
                        'x509cert' => $container->getEnv('SAML_SP_CERT'),
                    ],
                    'baseurl' => $container->getEnv('string:SITE_URL').'/saml',
                    'strict' => $container->getEnv('bool:SAML_STRICT'),
                    'debug' => $container->getEnv('bool:SAML_DEBUG'),
                    'security' => [
                        'nameIdEncrypted' => $container->getEnv('bool:SAML_NAME_ID_ENCRYPTED'),
                        'authnRequestsSigned' => $container->getEnv('bool:SAML_AUTHN_REQUESTS_SIGNED'),
                        'logoutRequestSigned' => $container->getEnv('bool:SAML_LOGOUT_REQUEST_SIGNED'),
                        'logoutResponseSigned' => $container->getEnv('bool:SAML_LOGOUT_RESPONSE_SIGNED'),
                        'signMetadata' => $container->getEnv('bool:SAML_SIGN_METADATA'),
                        'wantMessagesSigned' => $container->getEnv('bool:SAML_WANT_MESSAGES_SIGNED'),
                        'wantAssertionsEncrypted' => $container->getEnv('bool:SAML_WANT_ASSERTIONS_ENCRYPTED'),
                        'wantAssertionsSigned' => $container->getEnv('bool:SAML_WANT_ASSERTIONS_SIGNED'),
                        'wantNameId' => $container->getEnv('bool:SAML_WANT_NAME_ID'),
                        'wantNameIdEncrypted' => $container->getEnv('bool:SAML_WANT_NAME_ID_ENCRYPTED'),
                        'requestedAuthnContext' => $container->getEnv('bool:SAML_REQUESTED_AUTHN_CONTEXT'),
                        'wantXMLValidation' => $container->getEnv('bool:SAML_WANT_XML_VALIDATION'),
                        'relaxDestinationValidation' => $container->getEnv('bool:SAML_RELAX_DESTINATION_VALIDATION'),
                        'destinationStrictlyMatches' => $container->getEnv('bool:SAML_DESTINATION_STRICTLY_MATCHES'),
                        'allowRepeatAttributeName' => $container->getEnv('bool:SAML_ALLOW_REPEAT_ATTRIBUTE_NAME'),
                        'rejectUnsolicitedResponsesWithInResponseTo' => $container->getEnv('bool:SAML_REJECT_UNSOLICITED_RESPONSES_WITH_IN_RESPONSE_TO'),
                        'signatureAlgorithm' => 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha256',
                        'digestAlgorithm' => 'http://www.w3.org/2001/04/xmlenc#sha256',
                        'encryption_algorithm' => 'http://www.w3.org/2001/04/xmlenc#aes256-cbc',
                        'lowercaseUrlencoding' => $container->getEnv('bool:SAML_LOWERCASE_URL_ENCODING'),
                    ],
                    'contactPerson' => [
                        'technical' => [
                            'givenName' => $container->getEnv('SAML_CONTACT_TECHNICAL_GIVEN_NAME'),
                            'emailAddress' => $container->getEnv('SAML_CONTACT_TECHNICAL_EMAIL_ADDRESS'),
                        ],
                        'support' => [
                            'givenName' => $container->getEnv('SAML_CONTACT_SUPPORT_GIVEN_NAME'),
                            'emailAddress' => $container->getEnv('SAML_CONTACT_SUPPORT_EMAIL_ADDRESS'),
                        ],
                        'administrative' => [
                            'givenName' => $container->getEnv('SAML_CONTACT_ADMINISTRATIVE_GIVEN_NAME'),
                            'emailAddress' => $container->getEnv('SAML_CONTACT_ADMINISTRATIVE_EMAIL_ADDRESS'),
                        ],
                    ],
                    'organization' => [
                        'en_US' => [
                            'name' => $container->getEnv('SAML_ORGANIZATION_NAME'),
                            'displayname' => $container->getEnv('SAML_ORGANIZATION_DISPLAY_NAME'),
                            'url' => $container->getEnv('SAML_ORGANIZATION_URL'),
                        ],
                    ],
                    'compress' => [
                        'requests' => $container->getEnv('bool:SAML_COMPRESS_REQUESTS'),
                        'responses' => $container->getEnv('bool:SAML_COMPRESS_RESPONSES'),
                    ],
                ],
            ],
            default => throw new ParameterNotFoundException($name),
        };
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 3),
            'kernel.environment' => 'prod',
            'kernel.debug' => false,
            'kernel.logs_dir' => (\dirname(__DIR__, 3).'/logs/prod'),
            'kernel.bundles' => [
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
                'TwigBundle' => 'Symfony\\Bundle\\TwigBundle\\TwigBundle',
                'SecurityBundle' => 'Symfony\\Bundle\\SecurityBundle\\SecurityBundle',
                'DoctrineBundle' => 'Doctrine\\Bundle\\DoctrineBundle\\DoctrineBundle',
                'MonologBundle' => 'Symfony\\Bundle\\MonologBundle\\MonologBundle',
                'NelmioCorsBundle' => 'Nelmio\\CorsBundle\\NelmioCorsBundle',
                'DoctrineMigrationsBundle' => 'Doctrine\\Bundle\\MigrationsBundle\\DoctrineMigrationsBundle',
                'ShivasVersioningBundle' => 'Shivas\\VersioningBundle\\ShivasVersioningBundle',
                'ApiPlatformBundle' => 'ApiPlatform\\Symfony\\Bundle\\ApiPlatformBundle',
                'NbgrpOneloginSamlBundle' => 'Nbgrp\\OneloginSamlBundle\\NbgrpOneloginSamlBundle',
                'TwigExtraBundle' => 'Twig\\Extra\\TwigExtraBundle\\TwigExtraBundle',
                'SchebTwoFactorBundle' => 'Scheb\\TwoFactorBundle\\SchebTwoFactorBundle',
            ],
            'kernel.bundles_metadata' => [
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/symfony/framework-bundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
                'TwigBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/symfony/twig-bundle'),
                    'namespace' => 'Symfony\\Bundle\\TwigBundle',
                ],
                'SecurityBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/symfony/security-bundle'),
                    'namespace' => 'Symfony\\Bundle\\SecurityBundle',
                ],
                'DoctrineBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/doctrine/doctrine-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\DoctrineBundle',
                ],
                'MonologBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/symfony/monolog-bundle'),
                    'namespace' => 'Symfony\\Bundle\\MonologBundle',
                ],
                'NelmioCorsBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/nelmio/cors-bundle'),
                    'namespace' => 'Nelmio\\CorsBundle',
                ],
                'DoctrineMigrationsBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/doctrine/doctrine-migrations-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\MigrationsBundle',
                ],
                'ShivasVersioningBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/shivas/versioning-bundle/src'),
                    'namespace' => 'Shivas\\VersioningBundle',
                ],
                'ApiPlatformBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/api-platform/core/src/Symfony/Bundle'),
                    'namespace' => 'ApiPlatform\\Symfony\\Bundle',
                ],
                'NbgrpOneloginSamlBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/nbgrp/onelogin-saml-bundle/src'),
                    'namespace' => 'Nbgrp\\OneloginSamlBundle',
                ],
                'TwigExtraBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/twig/extra-bundle'),
                    'namespace' => 'Twig\\Extra\\TwigExtraBundle',
                ],
                'SchebTwoFactorBundle' => [
                    'path' => (\dirname(__DIR__, 3).'/vendor/scheb/2fa-bundle'),
                    'namespace' => 'Scheb\\TwoFactorBundle',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'App_KernelProdContainer',
            'container.dumper.inline_class_loader' => true,
            'auth.logout.redirect' => false,
            'auth.logout.path' => 'logout',
            'auth.logout.after_logout_path' => './',
            'auth.session-expired.redirect' => false,
            'auth.session-expired.path' => 'Login',
            'auth.logout' => [
                'path' => 'logout',
                'redirect' => false,
                'after_logout_path' => './',
            ],
            'auth.session-expired' => [
                'path' => 'Login',
                'redirect' => false,
            ],
            'extensions' => [
                'defaultExt' => [
                    'remoteEntry' => '../extensions/defaultExt/remoteEntry.js',
                    'remoteName' => 'defaultExt',
                    'enabled' => false,
                    'extension_name' => 'Default Extension',
                    'extension_uri' => 'https://suitecrm.com',
                    'description' => 'An example Extension template or for simple instance customisations',
                    'version' => '1.0.0',
                    'author' => 'SalesAgility',
                    'author_uri' => 'https://www.salesagility.com',
                    'license' => 'GPL3',
                ],
            ],
            'ldap.autocreate.extra_fields_map' => NULL,
            'ldap.extra_fields' => [

            ],
            'legacy.api_paths' => [
                'Api/access_token' => 'Api/index.php/access_token',
                'Api/V8' => 'Api/index.php/V8',
                'Api' => 'Api/index.php',
                'service/v4_1' => 'service/v4_1',
            ],
            'legacy.api_path_files' => [
                'Api/access_token' => [
                    'file' => 'index.php',
                    'dir' => 'Api',
                ],
                'Api/V8' => [
                    'file' => 'index.php',
                    'dir' => 'Api',
                ],
                'Api' => [
                    'file' => 'index.php',
                    'dir' => 'Api',
                ],
                'service/v4_1/rest.php' => [
                    'file' => 'rest.php',
                    'dir' => 'service/v4_1',
                ],
                'service/v4_1/soap.php' => [
                    'file' => 'soap.php',
                    'dir' => 'service/v4_1',
                ],
                'service/v4_1' => [
                    'file' => 'rest.php',
                    'dir' => 'service/v4_1',
                ],
                'service/v4/rest.php' => [
                    'file' => 'rest.php',
                    'dir' => 'service/v4',
                ],
                'service/v4/soap.php' => [
                    'file' => 'soap.php',
                    'dir' => 'service/v4',
                ],
                'service/v4' => [
                    'file' => 'rest.php',
                    'dir' => 'service/v4',
                ],
            ],
            'legacy.asset_paths' => [
                0 => 'cache',
                1 => 'include',
                2 => 'themes',
                3 => 'custom',
                4 => 'vendor',
                5 => 'modules',
                6 => 'public',
                7 => 'upload',
            ],
            'legacy.copy_asset_paths' => [
                'vendor/tinymce/tinymce' => 'vendor/tinymce/tinymce',
                'vendor/gymadarasz' => 'vendor/gymadarasz',
            ],
            'legacy.cache_reset_actions' => [
                'Login' => [
                    0 => 'index',
                ],
                'users' => [
                    0 => 'edit',
                    1 => 'Wizard',
                    2 => '2fa-config',
                ],
                'administration' => [
                    0 => 'repair',
                    1 => 'UpgradeWizard',
                    2 => 'ConfigureTabs',
                    3 => 'Locale',
                    4 => 'PasswordManager',
                    5 => 'ThemeSettings',
                    6 => 'Languages',
                ],
                'module-builder' => [
                    0 => 'index',
                ],
                'configurator' => [
                    0 => 'edit',
                ],
                'currencies' => [
                    0 => 'index',
                ],
                'security-groups' => [
                    0 => 'index',
                    1 => 'config',
                ],
                'studio' => [
                    0 => 'wizard',
                ],
            ],
            'legacy.datetime_format_map' => [
                'A' => 'a',
                'a' => 'aaaaaa',
                'D' => 'E',
                'd' => 'dd',
                'F' => 'MMMM',
                'G' => 'H',
                'g' => 'h',
                'H' => 'HH',
                'h' => 'hh',
                'i' => 'mm',
                'M' => 'MMM',
                'm' => 'MM',
                'n' => 'M',
                'P' => 'ZZZZZ',
                's' => 'ss',
                'w' => 'e',
                'Y' => 'yyyy',
                'y' => 'yy',
            ],
            'legacy.entrypoint_files' => [
                'campaign_tracker.php' => [
                    'file' => 'campaign_tracker.php',
                    'dir' => '',
                ],
                'ical_server.php' => [
                    'file' => 'ical_server.php',
                    'dir' => '',
                ],
                'soap.php' => [
                    'file' => 'soap.php',
                    'dir' => '',
                ],
                'vcal_server.php' => [
                    'file' => 'vcal_server.php',
                    'dir' => '',
                ],
            ],
            'legacy.exposed_system_configs' => [
                'default_language' => true,
                'passwordsetting' => [
                    'forgotpasswordON' => true,
                ],
                'languages' => true,
                'disabled_languages' => true,
                'default_module' => true,
                'default_theme' => true,
                'module_name_map' => true,
                'action_name_map' => true,
                'system_name' => true,
                'subpanel_pagination_type' => true,
                'listview_pagination_type' => true,
                'classicview_routing_exclusions' => true,
                'default_decimal_seperator' => true,
                'default_number_grouping_seperator' => true,
                'default_currency_significant_digits' => true,
                'datef' => true,
                'timef' => true,
                'snooze_alert_timer' => true,
                'currency' => true,
                'currencies' => true,
                'list_max_entries_per_page' => true,
                'list_max_entries_per_subpanel' => true,
                'list_max_entries_per_modal' => true,
                'list_max_entries_per_record_thread' => true,
                'record_modal_pagination_type' => true,
                'cache_reset_actions' => true,
                'navigation_tab_limits' => true,
                'filter_range_search_types' => true,
                'listview_column_limits' => true,
                'listview_settings_limits' => true,
                'listview_actions_limits' => true,
                'listview_line_actions_limits' => true,
                'listview_url_query_filter_mapping' => true,
                'module_routing' => true,
                'recordview_actions_limits' => true,
                'recordview_subpanel_button_limits' => true,
                'convert_ignore' => true,
                'subpanelview_actions_limits' => true,
                'ui' => true,
                'extensions' => true,
                'logout' => true,
                'session-expired' => true,
                'site_url' => true,
                'login_language' => true,
                'enable_record_pagination' => true,
                'auth_type' => true,
            ],
            'legacy.exposed_user_preferences' => [
                'global' => [
                    'sort_modules_by_name' => true,
                    'navigation_paradigm' => true,
                    'swap_shortcuts' => true,
                    'subpanel_tabs' => true,
                    'subpanel_pagination_type' => true,
                    'listview_pagination_type' => true,
                    'count_collapsed_subpanels' => true,
                    'user_theme' => true,
                    'module_favicon' => true,
                    'no_opps' => true,
                    'reminder_time' => true,
                    'email_reminder_time' => true,
                    'reminder_checked' => true,
                    'email_reminder_checked' => true,
                    'timezone' => true,
                    'ut' => true,
                    'currency' => true,
                    'default_currency_significant_digits' => true,
                    'num_grp_sep' => true,
                    'dec_sep' => true,
                    'fdow' => true,
                    'datef' => true,
                    'timef' => true,
                    'mail_fromname' => true,
                    'mail_fromaddress' => true,
                    'mail_sendtype' => true,
                    'mail_smtpserver' => true,
                    'mail_smtpport' => true,
                    'mail_smtpuser' => true,
                    'mail_smtppass' => true,
                    'default_locale_name_format' => true,
                    'export_delimiter' => true,
                    'default_export_charset' => true,
                    'use_real_names' => true,
                    'mail_smtpauth_req' => true,
                    'mail_smtpssl' => true,
                    'signature_default' => true,
                    'signature_prepend' => true,
                    'email_link_type' => true,
                    'editor_type' => true,
                    'email_show_counts' => true,
                    'email_editor_option' => true,
                    'default_email_charset' => true,
                    'calendar_publish_key' => true,
                    'record_modal_pagination_type' => true,
                    'subtheme' => true,
                    'syncGCal' => true,
                    'listview_max_height' => true,
                    'list_max_entries_per_page' => true,
                    'subpanel_max_height' => true,
                    'list_max_entries_per_subpanel' => true,
                    'record_modal_max_height' => true,
                    'ui' => true,
                    'snooze_alert_timer' => true,
                    'language' => true,
                    'is_two_factor_enabled' => true,
                ],
            ],
            'legacy.frontend_excluded_modules' => [
                0 => 'EmailText',
                1 => 'TeamMemberships',
                2 => 'TeamSets',
                3 => 'TeamSetModule',
            ],
            'massupdate' => [
                'excludedFields' => [
                    0 => 'date_modified',
                    1 => 'date_entered',
                    2 => 'created_by',
                    3 => 'modified_user_id',
                    4 => 'deleted',
                    5 => 'modified_by_name',
                    6 => 'assigned_user_id',
                ],
                'activeByDefaultRelateModules' => [
                    0 => 'Accounts',
                    1 => 'Contacts',
                    2 => 'Users',
                    3 => 'Employee',
                    4 => 'Releases',
                ],
                'activeByDefaultFields' => [
                    0 => 'reports_to_name',
                ],
                'activeByDefaultTypes' => [
                    0 => 'parent',
                    1 => 'bool',
                    2 => 'enum',
                    3 => 'dynamicenum',
                    4 => 'multienum',
                    5 => 'radioenum',
                    6 => 'datetimecombo',
                    7 => 'datetime',
                    8 => 'date',
                ],
                'includedTypes' => [
                    0 => 'relate',
                    1 => 'parent',
                    2 => 'int',
                    3 => 'bool',
                    4 => 'enum',
                    5 => 'dynamicenum',
                    6 => 'multienum',
                    7 => 'radioenum',
                    8 => 'datetimecombo',
                    9 => 'datetime',
                    10 => 'date',
                ],
            ],
            'legacy.menu_item_map' => [
                'default' => [
                    'List' => [
                        'icon' => 'view',
                    ],
                    'View' => [
                        'icon' => 'view',
                    ],
                    'Add' => [
                        'icon' => 'plus',
                        'actionLabelKey' => 'LBL_NEW',
                    ],
                    'Create' => [
                        'icon' => 'plus',
                        'actionLabelKey' => 'LBL_NEW',
                    ],
                    'Import' => [
                        'icon' => 'download',
                        'actionLabelKey' => 'LBL_IMPORT',
                    ],
                    'Security_Groups' => [
                        'icon' => 'view',
                    ],
                    'Schedule_Call' => [
                        'icon' => 'plus',
                    ],
                    'Schedule_Meetings' => [
                        'icon' => 'plus',
                    ],
                    'Schedule_Meeting' => [
                        'icon' => 'plus',
                    ],
                ],
                'contacts' => [
                    'Create_Contact_Vcard' => [
                        'icon' => 'plus',
                    ],
                ],
                'calls' => [
                    'Calls' => [
                        'icon' => 'plus',
                    ],
                ],
                'calendar' => [
                    'Calendar' => [
                        'icon' => 'plus',
                    ],
                    'Today' => [
                        'icon' => 'calendar',
                    ],
                ],
                'workflow' => [
                    'View_Process_Audit' => [
                        'icon' => 'view',
                    ],
                ],
                'workflow-processed' => [
                    'View_Process_Audit' => [
                        'icon' => 'view',
                    ],
                ],
                'mail-merge' => [
                    'Documents' => [
                        'icon' => 'view',
                    ],
                ],
                'email-templates' => [
                    'View_Email_Templates' => [
                        'icon' => 'view',
                    ],
                    'View_Create_Email_Templates' => [
                        'icon' => 'plus',
                    ],
                ],
                'campaigns' => [
                    'View_Create_Email_Templates' => [
                        'icon' => 'plus',
                    ],
                    'View_Email_Templates' => [
                        'icon' => 'view',
                    ],
                    'Setup_Email' => [
                        'icon' => 'email',
                    ],
                    'View_Diagnostics' => [
                        'icon' => 'view',
                    ],
                    'Create_Person_Form' => [
                        'icon' => 'person',
                    ],
                ],
                'leads' => [
                    'Create_Lead_Vcard' => [
                        'icon' => 'plus',
                    ],
                ],
                'inbound-email' => [
                    'Setup_Email' => [
                        'icon' => 'email',
                    ],
                    'CreatePersonal' => [
                        'icon' => 'plus',
                    ],
                    'CreateGroup' => [
                        'icon' => 'plus',
                    ],
                    'CreateBounce' => [
                        'icon' => 'plus',
                    ],
                ],
                'external-oauth-provider' => [
                    'CreatePersonal' => [
                        'icon' => 'plus',
                    ],
                    'CreateGroup' => [
                        'icon' => 'plus',
                    ],
                ],
                'external-oauth-connection' => [
                    'CreatePersonal' => [
                        'icon' => 'plus',
                    ],
                    'CreateGroup' => [
                        'icon' => 'plus',
                    ],
                ],
                'outbound-email-accounts' => [
                    'CreatePersonal' => [
                        'icon' => 'plus',
                    ],
                    'CreateGroup' => [
                        'icon' => 'plus',
                    ],
                ],
                'schedulers' => [
                    'Schedulers' => [
                        'icon' => 'view',
                    ],
                ],
                'address-cache' => [
                    'Createjjwg_Address_Cache' => [
                        'icon' => 'plus',
                    ],
                    'jjwg_Address_Cache' => [
                        'icon' => 'view',
                    ],
                ],
                'maps' => [
                    'List_Maps' => [
                        'icon' => 'view',
                    ],
                    'Quick_Radius_Map' => [
                        'icon' => 'view',
                    ],
                ],
                'security-groups' => [
                    'Create_Security_Group' => [
                        'icon' => 'plus',
                    ],
                    'Security_Groups' => [
                        'icon' => 'view',
                    ],
                    'Security_Suite_Settings' => [
                        'icon' => 'padlock',
                    ],
                    'Role_Management' => [
                        'icon' => 'view',
                    ],
                ],
                'acl-roles' => [
                    'Role_Management' => [
                        'icon' => 'view',
                    ],
                    'Security_Groups' => [
                        'icon' => 'view',
                        'actionLabelKey' => 'LBL_SECURITYGROUPS',
                    ],
                    'List_By_User' => [
                        'icon' => 'view',
                        'actionLabelKey' => 'LIST_ROLES_BY_USER',
                    ],
                ],
                'connectors' => [
                    'icon_Connectors' => [
                        'icon' => 'view',
                    ],
                    'icon_ConnectorConfig_16' => [
                        'icon' => 'view',
                    ],
                    'icon_ConnectorEnable_16' => [
                        'icon' => 'view',
                    ],
                    'icon_ConnectorMap_16' => [
                        'icon' => 'view',
                    ],
                ],
                'configurator' => [
                    'Administration' => [
                        'icon' => 'view',
                    ],
                    'Leads' => [
                        'icon' => 'view',
                    ],
                ],
                'help' => [
                    'Administration' => [
                        'icon' => 'view',
                    ],
                    'Accounts' => [
                        'icon' => 'view',
                    ],
                    'Opportunities' => [
                        'icon' => 'view',
                    ],
                    'Cases' => [
                        'icon' => 'view',
                    ],
                    'Notes' => [
                        'icon' => 'view',
                    ],
                    'Calls' => [
                        'icon' => 'view',
                    ],
                    'Emails' => [
                        'icon' => 'view',
                    ],
                    'Meetings' => [
                        'icon' => 'view',
                    ],
                    'Tasks' => [
                        'icon' => 'view',
                    ],
                ],
                'project' => [
                    'Resource_Chart' => [
                        'icon' => 'piechart',
                    ],
                    'View_Project_Tasks' => [
                        'icon' => 'view',
                    ],
                ],
                'project-task' => [
                    'View_Project_Tasks' => [
                        'icon' => 'view',
                    ],
                ],
                'roles' => [
                    'Role_Management' => [
                        'icon' => 'view',
                    ],
                ],
                'users' => [
                    'Create_Group_User' => [
                        'icon' => 'plus',
                    ],
                    'Create_Security_Group' => [
                        'icon' => 'plus',
                    ],
                    'Security_Groups' => [
                        'icon' => 'view',
                        'actionLabelKey' => 'LBL_SECURITYGROUPS',
                    ],
                    'Role_Management' => [
                        'icon' => 'view',
                    ],
                    'Security_Suite_Settings' => [
                        'icon' => 'view',
                    ],
                ],
            ],
            'legacy.system_config_key_map' => [
                'datef' => 'date_format',
                'timef' => 'time_format',
            ],
            'legacy.user_preferences_key_map' => [
                'datef' => 'date_format',
                'timef' => 'time_format',
            ],
            'module.base_actions' => [
                'default' => [
                    'actions' => [
                        'index' => [
                            'key' => 'index',
                            'labelKey' => 'LBL_LISTVIEW',
                            'acl' => [
                                0 => 'list',
                            ],
                        ],
                        'list' => [
                            'key' => 'index',
                            'labelKey' => 'LBL_LISTVIEW',
                            'acl' => [
                                0 => 'list',
                            ],
                        ],
                        'view' => [
                            'key' => 'view',
                            'labelKey' => 'LBL_DETAILVIEW',
                            'acl' => [
                                0 => 'view',
                            ],
                        ],
                        'record' => [
                            'key' => 'view',
                            'labelKey' => 'LBL_DETAILVIEW',
                            'acl' => [
                                0 => 'view',
                            ],
                        ],
                        'create' => [
                            'key' => 'create',
                            'labelKey' => 'LBL_NEW',
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'edit' => [
                            'key' => 'edit',
                            'labelKey' => 'LBL_EDIT',
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'save' => [
                            'key' => 'save',
                            'labelKey' => 'LBL_SAVE_BUTTON_LABEL',
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'saveNew' => [
                            'key' => 'saveNew',
                            'labelKey' => 'LBL_SAVE_BUTTON_LABEL',
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'delete' => [
                            'key' => 'delete',
                            'labelKey' => 'LBL_DELETE',
                            'asyncProcess' => true,
                            'acl' => [
                                0 => 'delete',
                            ],
                        ],
                        'duplicate' => [
                            'key' => 'duplicate',
                            'labelKey' => 'LBL_DUPLICATE_BUTTON',
                            'asyncProcess' => true,
                            'acl' => [
                                0 => 'export',
                                1 => 'edit',
                            ],
                        ],
                        'audit' => [
                            'key' => 'audit',
                            'labelKey' => 'LNK_VIEW_CHANGE_LOG',
                            'asyncProcess' => true,
                            'availability' => [
                                0 => 'audited',
                                1 => 'acls',
                            ],
                        ],
                        'merge-records' => [
                            'key' => 'merge-records',
                            'labelKey' => 'LBL_DUP_MERGE',
                            'asyncProcess' => true,
                            'availability' => [
                                0 => 'duplicate-merge',
                                1 => 'acls',
                            ],
                            'acl' => [
                                0 => 'edit',
                                1 => 'delete',
                            ],
                        ],
                        'export' => [
                            'key' => 'export',
                            'labelKey' => 'LBL_EXPORT',
                            'acl' => [
                                0 => 'export',
                            ],
                        ],
                        'massupdate' => [
                            'key' => 'massupdate',
                            'labelKey' => 'LBL_MASS_UPDATE',
                            'availability' => [
                                0 => 'acls',
                                1 => 'massupdate',
                            ],
                            'acl' => [
                                0 => 'massupdate',
                            ],
                        ],
                    ],
                ],
            ],
            'module.filter.range_search_types' => [
                0 => 'int',
                1 => 'currency',
                2 => 'float',
                3 => 'double',
                4 => 'decimal',
                5 => 'uint',
                6 => 'ulong',
                7 => 'long',
                8 => 'short',
                9 => 'tinyint',
            ],
            'legacy.action_resolver' => [
                'merge-records' => [
                    'index' => 'action_module',
                    'Step1' => 'action_module',
                ],
                'import' => [
                    'index' => 'import_module',
                    'step1' => 'import_module',
                    'Last' => 'import_module',
                ],
            ],
            'module.listview.actions_limits' => [
                'XSmall' => 3,
                'Small' => 3,
                'Medium' => 3,
                'Large' => 3,
                'XLarge' => 4,
            ],
            'module.listview.bulk_action' => [
                'default' => [
                    'actions' => [
                        'delete' => [
                            'key' => 'delete',
                            'labelKey' => 'LBL_DELETE',
                            'params' => [
                                'min' => 1,
                                'displayConfirmation' => true,
                                'confirmationLabel' => 'NTC_DELETE_CONFIRMATION_MULTIPLE',
                            ],
                            'acl' => [
                                0 => 'delete',
                            ],
                        ],
                        'export' => [
                            'key' => 'export',
                            'labelKey' => 'LBL_EXPORT',
                            'params' => [
                                'min' => 1,
                            ],
                            'acl' => [
                                0 => 'export',
                            ],
                        ],
                        'merge' => [
                            'key' => 'merge',
                            'labelKey' => 'LBL_MERGE_DUPLICATES',
                            'params' => [
                                'min' => 2,
                                'max' => 5,
                            ],
                            'acl' => [
                                0 => 'edit',
                                1 => 'delete',
                            ],
                        ],
                        'massupdate' => [
                            'key' => 'massupdate',
                            'labelKey' => 'LBL_MASS_UPDATE',
                            'params' => [
                                'allowAll' => false,
                                'min' => 2,
                                'max' => 200,
                                'recordPanel' => [
                                    'title' => 'LBL_MASS_UPDATE',
                                    'mode' => 'massupdate',
                                    'actions' => [
                                        0 => [
                                            'key' => 'cancel',
                                            'labelKey' => 'LBL_CANCEL',
                                            'modes' => [
                                                0 => 'massupdate',
                                            ],
                                        ],
                                        1 => [
                                            'key' => 'bulk-action',
                                            'labelKey' => 'LBL_SUBMIT_BUTTON_LABEL',
                                            'modes' => [
                                                0 => 'massupdate',
                                            ],
                                            'klass' => [
                                                0 => 'btn',
                                                1 => 'btn-danger',
                                                2 => 'btn-sm',
                                            ],
                                            'params' => [
                                                'allowAll' => false,
                                                'min' => 2,
                                                'max' => 200,
                                                'bulkAction' => 'massupdate',
                                                'displayConfirmation' => true,
                                                'confirmationLabel' => 'LBL_BULK_ACTION_MASS_UPDATE_CONFIRMATION',
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                            'acl' => [
                                0 => 'massupdate',
                            ],
                            'availability' => [
                                0 => 'acls',
                                1 => 'massupdate',
                            ],
                        ],
                    ],
                ],
                'modules' => [
                    'employees' => [
                        'exclude' => [
                            0 => 'delete',
                            1 => 'merge',
                        ],
                    ],
                    'inbound-emails' => [
                        'exclude' => [
                            0 => 'merge',
                            1 => 'massupdate',
                            2 => 'export',
                        ],
                    ],
                    'outbound-email-accounts' => [
                        'exclude' => [
                            0 => 'merge',
                            1 => 'massupdate',
                            2 => 'export',
                        ],
                    ],
                    'external-oauth-connection' => [
                        'exclude' => [
                            0 => 'merge',
                            1 => 'massupdate',
                            2 => 'export',
                        ],
                    ],
                    'external-oauth-provider' => [
                        'exclude' => [
                            0 => 'merge',
                            1 => 'massupdate',
                            2 => 'export',
                        ],
                    ],
                ],
            ],
            'module.listview.column_limits' => [
                'without_sidebar' => [
                    'XSmall' => 1,
                    'Small' => 3,
                    'Medium' => 5,
                    'Large' => 7,
                    'XLarge' => 8,
                ],
                'with_sidebar' => [
                    'XSmall' => 1,
                    'Small' => 3,
                    'Medium' => 4,
                    'Large' => 6,
                    'XLarge' => 7,
                ],
            ],
            'module.listview.line_action' => [
                'default' => [
                    'actions' => [
                        'create' => [
                            'key' => 'create',
                            'related_modules' => [
                                'calls' => [
                                    'name' => 'create-calls',
                                    'module' => 'calls',
                                    'icon' => 'phone',
                                    'labelKey' => 'LBL_SCHEDULE_CALL',
                                    'params' => [
                                        'create' => [
                                            'module' => 'calls',
                                            'returnAction' => 'DetailView',
                                        ],
                                    ],
                                ],
                                'meetings' => [
                                    'name' => 'create-meetings',
                                    'module' => 'meetings',
                                    'icon' => 'calendar',
                                    'labelKey' => 'LBL_SCHEDULE_MEETING',
                                    'params' => [
                                        'create' => [
                                            'module' => 'meetings',
                                            'returnAction' => 'DetailView',
                                        ],
                                    ],
                                ],
                                'tasks' => [
                                    'name' => 'create-tasks',
                                    'module' => 'tasks',
                                    'icon' => 'list',
                                    'labelKey' => 'LBL_CREATE_TASK',
                                    'params' => [
                                        'create' => [
                                            'module' => 'tasks',
                                            'returnAction' => 'DetailView',
                                        ],
                                    ],
                                ],
                                'emails' => [
                                    'name' => 'create-emails',
                                    'module' => 'emails',
                                    'icon' => 'email',
                                    'action' => 'compose',
                                    'labelKey' => 'LBL_COMPOSE_EMAIL_BUTTON_LABEL',
                                    'params' => [
                                        'create' => [
                                            'module' => 'emails',
                                            'returnAction' => 'index',
                                        ],
                                    ],
                                ],
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                    ],
                ],
            ],
            'module.listview.line_actions_limits' => [
                'without_sidebar' => [
                    'XSmall' => 5,
                    'Small' => 5,
                    'Medium' => 5,
                    'Large' => 7,
                    'XLarge' => 8,
                ],
                'with_sidebar' => [
                    'XSmall' => 5,
                    'Small' => 5,
                    'Medium' => 5,
                    'Large' => 6,
                    'XLarge' => 7,
                ],
            ],
            'module.listview.settings_limits' => [
                'XSmall' => 3,
                'Small' => 3,
                'Medium' => 5,
                'Large' => 5,
                'XLarge' => 5,
            ],
            'module.listview.sidebar_widgets' => [
                'default' => [
                    'widgets' => [

                    ],
                ],
                'modules' => NULL,
            ],
            'module.listview.table_action' => [
                'default' => [
                    'actions' => [
                        'select-columns' => [
                            'key' => 'select-columns',
                            'icon' => 'column_chooser',
                            'titleKey' => 'LBL_COLUMNS',
                            'params' => [
                                'expanded' => true,
                            ],
                            'modes' => [
                                0 => 'list',
                            ],
                            'klass' => [
                                0 => 'column-chooser-button',
                            ],
                        ],
                    ],
                ],
                'modules' => NULL,
            ],
            'module.listview.url_query_filter_mapping' => [
                '{field}_range_choice' => [
                    'not_equal' => [
                        'range_{field}' => 'target',
                    ],
                    'between' => [
                        'start_range_{field}' => 'start',
                        'end_range_{field}' => 'end',
                    ],
                    'greater_than' => [
                        'range_{field}' => 'target',
                    ],
                    'less_than' => [
                        'range_{field}' => 'target',
                    ],
                    'last_7_days' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'next_7_days' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'last_30_days' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'next_30_days' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'last_month' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'this_month' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'next_month' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'last_year' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'this_year' => [
                        '{field}_range_choice' => 'operator',
                    ],
                    'next_year' => [
                        '{field}_range_choice' => 'operator',
                    ],
                ],
                '{field}_filter_type' => [
                    'equal' => [
                        '{field}_filter_value' => 'target',
                    ],
                    'not_equal' => [
                        '{field}_filter_value' => 'target',
                    ],
                    'between' => [
                        '{field}_filter_start' => 'start',
                        '{field}_filter_end' => 'end',
                    ],
                    'greater_than' => [
                        '{field}_filter_start' => 'target',
                    ],
                    'less_than' => [
                        '{field}_filter_end' => 'target',
                    ],
                    'last_7_days' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'next_7_days' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'last_30_days' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'next_30_days' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'last_month' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'this_month' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'next_month' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'last_year' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'this_year' => [
                        '{field}_filter_type' => 'operator',
                    ],
                    'next_year' => [
                        '{field}_filter_type' => 'operator',
                    ],
                ],
            ],
            'legacy.module_routing' => [
                'home' => [
                    'index' => false,
                    'list' => false,
                    'record' => false,
                ],
                'saved-search' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'calls-reschedule' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'calls' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'tasks' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'meetings' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'notes' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'leads' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'contacts' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'accounts' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'opportunities' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'email-templates' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'campaigns' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'prospects' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'prospect-lists' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'documents' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'cases' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'project' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'project-task' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'bugs' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'business-hours' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'roles' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'users' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'employees' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'template-section-line' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'surveys' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'survey-responses' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'survey-question-responses' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'survey-questions' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'survey-question-options' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'project-templates' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'task-templates' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'knowledge-base-categories' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'knowledge-base' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'events' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'event-locations' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'contracts' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'invoices' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'pdf-templates' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'product-categories' => [
                    'index' => true,
                    'list' => true,
                    'record' => true,
                ],
                'products' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'quotes' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'products-quotes' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'maps' => [
                    'index' => false,
                    'list' => false,
                    'record' => false,
                ],
                'markers' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'areas' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'address-cache' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'case-events' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'case-updates' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'reports' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'scheduled-reports' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'workflow' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'workflow-processed' => [
                    'index' => false,
                    'list' => false,
                    'record' => false,
                ],
                'security-groups' => [
                    'index' => false,
                    'list' => false,
                    'record' => false,
                ],
                'acl-roles' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'schedulers' => [
                    'index' => false,
                    'list' => false,
                    'record' => false,
                ],
                'oauth-keys' => [
                    'index' => false,
                    'list' => false,
                    'record' => false,
                ],
                'outbound-email-accounts' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'inbound-email' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'external-oauth-provider' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'external-oauth-connection' => [
                    'index' => true,
                    'list' => true,
                    'record' => false,
                ],
                'emails' => [
                    'index' => false,
                    'list' => false,
                    'record' => false,
                ],
                'calendar' => [
                    'index' => false,
                    'list' => false,
                    'record' => false,
                ],
            ],
            'module.recordview.actions' => [
                'default' => [
                    'actions' => [
                        'edit' => [
                            'key' => 'edit',
                            'labelKey' => 'LBL_EDIT',
                            'params' => [
                                'expanded' => true,
                            ],
                            'modes' => [
                                0 => 'detail',
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'save' => [
                            'key' => 'save',
                            'labelKey' => 'LBL_SAVE_BUTTON_LABEL',
                            'params' => [
                                'expanded' => true,
                            ],
                            'modes' => [
                                0 => 'edit',
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'saveNew' => [
                            'key' => 'saveNew',
                            'labelKey' => 'LBL_SAVE_BUTTON_LABEL',
                            'params' => [
                                'expanded' => true,
                            ],
                            'modes' => [
                                0 => 'create',
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'cancel' => [
                            'key' => 'cancel',
                            'labelKey' => 'LBL_CANCEL',
                            'params' => [
                                'expanded' => true,
                            ],
                            'modes' => [
                                0 => 'edit',
                            ],
                        ],
                        'cancelCreate' => [
                            'key' => 'cancelCreate',
                            'labelKey' => 'LBL_CANCEL',
                            'params' => [
                                'expanded' => true,
                            ],
                            'modes' => [
                                0 => 'create',
                            ],
                        ],
                        'saveContinue' => [
                            'key' => 'saveContinue',
                            'labelKey' => 'LBL_SAVE_CONTINUE_LABEL',
                            'params' => [
                                'expanded' => true,
                                'collapsedMobile' => true,
                            ],
                            'modes' => [
                                0 => 'edit',
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'delete' => [
                            'key' => 'delete',
                            'labelKey' => 'LBL_DELETE',
                            'asyncProcess' => true,
                            'params' => [
                                'displayConfirmation' => true,
                                'confirmationLabel' => 'NTC_DELETE_CONFIRMATION',
                            ],
                            'modes' => [
                                0 => 'detail',
                            ],
                            'acl' => [
                                0 => 'delete',
                            ],
                        ],
                        'duplicate' => [
                            'key' => 'duplicate',
                            'labelKey' => 'LBL_DUPLICATE_BUTTON',
                            'asyncProcess' => true,
                            'params' => NULL,
                            'modes' => [
                                0 => 'detail',
                            ],
                            'acl' => [
                                0 => 'export',
                                1 => 'edit',
                            ],
                        ],
                        'audit' => [
                            'key' => 'audit',
                            'labelKey' => 'LNK_VIEW_CHANGE_LOG',
                            'asyncProcess' => true,
                            'params' => NULL,
                            'modes' => [
                                0 => 'detail',
                                1 => 'edit',
                            ],
                            'availability' => [
                                0 => 'audited',
                                1 => 'acls',
                            ],
                        ],
                        'duplicate-merge' => [
                            'key' => 'duplicate-merge',
                            'labelKey' => 'LBL_DUP_MERGE',
                            'asyncProcess' => true,
                            'params' => NULL,
                            'modes' => [
                                0 => 'detail',
                                1 => 'edit',
                            ],
                            'availability' => [
                                0 => 'duplicate-merge',
                                1 => 'acls',
                            ],
                            'acl' => [
                                0 => 'edit',
                                1 => 'delete',
                            ],
                        ],
                    ],
                ],
                'modules' => [
                    'employees' => [
                        'exclude' => [
                            0 => 'delete',
                        ],
                    ],
                ],
            ],
            'module.recordview.actions_limits' => [
                'XSmall' => 3,
                'Small' => 4,
                'Medium' => 4,
                'Large' => 4,
                'XLarge' => 4,
            ],
            'module.recordview.convert_ignore' => [
                'default' => [
                    0 => 'date_entered',
                    1 => 'date_modified',
                    2 => 'modified_by_name',
                    3 => 'modified_user_id',
                    4 => 'id',
                ],
            ],
            'module.recordview.sidebar_widgets' => [
                'default' => [
                    'widgets' => [

                    ],
                ],
                'modules' => NULL,
            ],
            'module.recordview.bottom_widgets' => [
                'default' => [
                    'widgets' => [

                    ],
                ],
                'modules' => NULL,
            ],
            'module.recordview.subpanel_button_limits' => [
                'XSmall' => 1,
                'Small' => 3,
                'Medium' => 3,
                'Large' => 4,
                'XLarge' => 7,
            ],
            'module.recordview.top_widgets' => [
                'default' => [
                    'widget' => [

                    ],
                ],
                'modules' => NULL,
            ],
            'module.subpanelview.actions_limits' => [
                'XSmall' => 2,
                'Small' => 2,
                'Medium' => 2,
                'Large' => 2,
                'XLarge' => 2,
            ],
            'module.subpanel.line_actions' => [
                'default' => [
                    'actions' => [
                        'edit' => [
                            'key' => 'edit',
                            'labelKey' => 'LBL_EDIT_RECORD',
                            'action' => 'edit',
                            'icon' => 'edit',
                            'asyncProcess' => true,
                            'routing' => true,
                            'params' => NULL,
                            'modes' => [
                                0 => 'list',
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'unlink' => [
                            'key' => 'unlink',
                            'labelKey' => 'LBL_UNLINK_RECORD',
                            'action' => 'unlink',
                            'icon' => 'unlink',
                            'asyncProcess' => true,
                            'routing' => false,
                            'params' => [
                                'displayConfirmation' => true,
                                'confirmationLabel' => 'LBL_UNLINK_RELATIONSHIP_CONFIRM',
                            ],
                            'modes' => [
                                0 => 'list',
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                    ],
                ],
            ],
            'module.subpanel.top_actions' => [
                'default' => [
                    'actions' => [
                        'create' => [
                            'key' => 'create',
                            'labelKey' => 'LBL_QUICK_CREATE',
                            'action' => 'create',
                            'params' => NULL,
                            'modes' => [
                                0 => 'list',
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'link' => [
                            'key' => 'select',
                            'labelKey' => 'LBL_LINK',
                            'action' => 'select',
                            'params' => NULL,
                            'modes' => [
                                0 => 'list',
                            ],
                            'acl' => NULL,
                        ],
                        'edit' => [
                            'key' => 'edit',
                            'labelKey' => 'LBL_EDIT',
                            'action' => 'edit',
                            'asyncProcess' => true,
                            'params' => NULL,
                            'modes' => [
                                0 => 'list',
                            ],
                            'acl' => [
                                0 => 'edit',
                            ],
                        ],
                        'show-filter' => [
                            'key' => 'show-filter',
                            'icon' => 'filter',
                            'labelKey' => 'LBL_FILTERS',
                            'action' => 'show-filter',
                            'params' => [
                                'expanded' => true,
                            ],
                            'modes' => [
                                0 => 'list',
                            ],
                            'acl' => NULL,
                        ],
                        'clear-filter' => [
                            'key' => 'clear-filter',
                            'labelKey' => 'LBL_CLEAR_FILTER',
                            'action' => 'clear-filter',
                            'params' => [
                                'expanded' => true,
                            ],
                            'modes' => [
                                0 => 'list',
                            ],
                            'acl' => NULL,
                        ],
                    ],
                ],
            ],
            'module.subpanel.top_buttons' => [
                'SubPanelTopSelectButton' => [
                    'key' => 'select',
                    'labelKey' => 'LBL_LINK',
                    'action' => 'select',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                ],
                'SubPanelTopButtonQuickCreate' => [
                    'key' => 'create',
                    'labelKey' => 'LBL_QUICK_CREATE',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                ],
                'SubPanelTopFilterButton' => [
                    'key' => 'show-filter',
                    'icon' => 'filter',
                    'labelKey' => 'LBL_FILTER',
                    'action' => 'show-filter',
                    'params' => [
                        'expanded' => true,
                    ],
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => NULL,
                ],
                'SubPanelFilterClearButton' => [
                    'key' => 'clear-filter',
                    'labelKey' => 'LBL_CLEAR_FILTER',
                    'action' => 'clear-filter',
                    'params' => [
                        'collapsedMobile' => true,
                        'expanded' => true,
                    ],
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => NULL,
                ],
                'SubPanelTopCreateButton' => [
                    'key' => 'create',
                    'labelKey' => 'LBL_QUICK_CREATE',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                ],
                'SubPanelTopCreateTaskButton' => [
                    'key' => 'create',
                    'labelKey' => 'LNK_NEW_TASK',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                    'module' => 'tasks',
                ],
                'SubPanelTopScheduleMeetingButton' => [
                    'key' => 'create',
                    'labelKey' => 'LNK_NEW_MEETING',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                    'module' => 'meetings',
                ],
                'SubPanelTopScheduleCallButton' => [
                    'key' => 'create',
                    'labelKey' => 'LNK_NEW_CALL',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                    'module' => 'calls',
                ],
                'SubPanelTopComposeEmailButton' => [
                    'key' => 'create',
                    'labelKey' => 'LNK_NEW_EMAIL',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                    'module' => 'emails',
                    'moduleAction' => [
                        0 => 'composeView',
                    ],
                ],
                'SubPanelTopCreateNoteButton' => [
                    'key' => 'create',
                    'labelKey' => 'LNK_NEW_NOTE',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                    'module' => 'notes',
                ],
                'SubPanelTopArchiveEmailButton' => [
                    'key' => 'create',
                    'labelKey' => 'LBL_TRACK_EMAIL_BUTTON_LABEL',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                    'module' => 'emails',
                ],
                'SubPanelTopCreateLeadNameButton' => [
                    'key' => 'create',
                    'labelKey' => 'LBL_QUICK_CREATE',
                    'action' => 'create',
                    'modes' => [
                        0 => 'list',
                    ],
                    'acl' => [
                        0 => 'edit',
                    ],
                    'module' => 'leads',
                ],
            ],
            'navbar.administration_override' => [
                0 => 'configurator',
                1 => 'connectors',
                2 => 'currencies',
                3 => 'emailman',
                4 => 'module-builder',
                5 => 'studio',
                6 => 'sugar-feed',
            ],
            'record.fields.currency_fields_type_map' => [
                'default' => [
                    'currency' => [
                        'display' => 'inline',
                        'showLabel' => [
                            'edit' => [
                                0 => '{currency}',
                                1 => '{currency_id}',
                            ],
                            'filter' => [
                                0 => '*',
                            ],
                        ],
                        'definition' => [
                            '{currency}' => [
                                'logic' => [
                                    'currency' => [
                                        'key' => 'update-currency',
                                        'modes' => [
                                            0 => 'edit',
                                            1 => 'create',
                                            2 => 'massupdate',
                                            3 => 'filter',
                                        ],
                                        'params' => [
                                            'fieldDependencies' => [
                                                0 => '{currency_id}',
                                            ],
                                        ],
                                        'triggeringStatus' => [
                                            0 => 'onAnyLogic',
                                        ],
                                    ],
                                ],
                            ],
                            '{currency_id}' => [
                                'modes' => [
                                    0 => 'edit',
                                    1 => 'create',
                                    2 => 'massupdate',
                                    3 => 'filter',
                                ],
                                'type' => 'enum',
                                'options' => '__no_options__',
                            ],
                            '{base_currency}' => [
                                'display' => 'none',
                                'logic' => [
                                    'currency' => [
                                        'key' => 'update-base-currency',
                                        'modes' => [
                                            0 => 'edit',
                                            1 => 'create',
                                            2 => 'massupdate',
                                            3 => 'filter',
                                        ],
                                        'params' => [
                                            'fieldDependencies' => [
                                                0 => '{currency}',
                                            ],
                                        ],
                                        'triggeringStatus' => [
                                            0 => 'onAnyLogic',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
            'record.fields.legacy_to_frontend_fields_map' => [
                'datetime_map' => [
                    'from' => [
                        'type' => 'datetimecombo',
                    ],
                    'to' => [
                        'type' => 'datetime',
                    ],
                ],
                'wysiwyg_map' => [
                    'from' => [
                        'type' => 'wysiwyg',
                    ],
                    'to' => [
                        'type' => 'html',
                    ],
                ],
                'html_readonly_map' => [
                    'matchAll' => true,
                    'from' => [
                        'type' => 'html',
                        'source' => 'non-db',
                    ],
                    'to' => [
                        'display' => 'readonly',
                    ],
                ],
                'textblock_readonly_map' => [
                    'matchAll' => true,
                    'from' => [
                        'type' => 'textblock',
                    ],
                    'to' => [
                        'type' => 'html',
                        'display' => 'readonly',
                    ],
                ],
            ],
            'record.fields.grouped_fields_type_map' => [
                'fullname' => [
                    'groupFields' => [
                        0 => 'salutation',
                        1 => 'first_name',
                        2 => 'last_name',
                    ],
                    'layout' => [
                        0 => 'salutation',
                        1 => 'first_name',
                        2 => 'last_name',
                    ],
                    'display' => 'inline',
                    'showLabel' => [
                        'edit' => [
                            0 => 'first_name',
                            1 => 'last_name',
                        ],
                        'filter' => [
                            0 => '*',
                        ],
                    ],
                ],
                'address' => [
                    'layout' => [
                        0 => 'street',
                        1 => 'postalcode',
                        2 => 'city',
                        3 => 'state',
                        4 => 'country',
                    ],
                    'display' => 'vertical',
                    'showLabel' => [
                        'edit' => [
                            0 => '*',
                        ],
                        'filter' => [
                            0 => '*',
                        ],
                    ],
                    'replaceAttributes' => [
                        0 => 'name',
                    ],
                    'definition' => [
                        '{name}_street' => [
                            'type' => 'text',
                            'metadata' => [
                                'rows' => 3,
                            ],
                        ],
                    ],
                ],
                'parent' => [
                    'name' => '{name}-group',
                    'display' => 'inline',
                    'groupFields' => [
                        0 => '{name}',
                        1 => '{type_name}',
                        2 => '{id_name}',
                    ],
                    'layout' => [
                        0 => '{name}',
                        1 => '{type_name}',
                    ],
                    'showLabel' => [
                        'edit' => [
                            0 => '*',
                        ],
                        'filter' => [
                            0 => '*',
                        ],
                    ],
                    'replaceAttributes' => [
                        0 => 'name',
                        1 => 'type_name',
                        2 => 'id_name',
                    ],
                    'definition' => [
                        '{name}' => [
                            'type' => 'relate',
                            'rname' => 'name',
                            'module' => 'Accounts',
                            'link' => 'flex',
                            'logic' => [
                                'parent' => [
                                    'key' => 'update-flex-relate-module',
                                    'modes' => [
                                        0 => 'edit',
                                        1 => 'create',
                                        2 => 'massupdate',
                                        3 => 'filter',
                                    ],
                                    'params' => [
                                        'fieldDependencies' => [
                                            0 => '{type_name}',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        '{type_name}' => [
                            'type' => 'enum',
                            'modes' => [
                                0 => 'edit',
                                1 => 'create',
                                2 => 'massupdate',
                                3 => 'filter',
                                4 => 'detail',
                            ],
                        ],
                    ],
                ],
            ],
            'record.fields.view_metadata_field_alias_map' => [
                'type' => [
                    'parent' => [
                        'alias' => '{name}-group',
                    ],
                ],
            ],
            'system.admin_only_module_actions' => [
                'administration' => [
                    '*' => true,
                ],
                'users' => [
                    'list' => true,
                    'index' => true,
                ],
                'sugar-feed' => [
                    'adminsettings' => true,
                ],
                'address-cache' => [
                    '*' => true,
                ],
                'maps' => [
                    'geocoded_counts' => true,
                    'geocoding_test' => true,
                    'config' => true,
                ],
            ],
            'system.settings' => [
                'setup_wizard_route' => [
                    'route' => 'users/Wizard',
                    'queryParams' => NULL,
                ],
            ],
            'upgrades' => [
                'toKeep' => [
                    0 => 'cache',
                    1 => 'extensions',
                    2 => 'public/extensions',
                    3 => 'public/legacy/codeception.dist.yml',
                    4 => 'public/legacy/public',
                    5 => 'public/legacy/tests',
                    6 => 'public/legacy/modules',
                    7 => 'public/legacy/custom',
                    8 => 'public/legacy/cache',
                    9 => 'public/legacy/upload',
                    10 => 'public/legacy/upgrade',
                    11 => 'public/legacy/vendor',
                    12 => 'public/legacy/Api/V8/OAuth2/private.key',
                    13 => 'public/legacy/Api/V8/OAuth2/public.key',
                    14 => 'public/legacy/config.php',
                    15 => 'public/legacy/config_override.php',
                    16 => 'public/legacy/config_si.php',
                    17 => 'public/legacy/suitecrm.log',
                    18 => 'public/legacy/install.log',
                    19 => 'logs',
                    20 => '.env.local',
                    21 => '.env.local.php',
                    22 => '.env.prod.local',
                    23 => '.env.prod.local.php',
                    24 => '.env.dev.local',
                    25 => '.env.dev.local.php',
                    26 => 'angular.json',
                    27 => 'tmp',
                    28 => '.git',
                    29 => '.gitignore',
                ],
                'toKeepIgnore' => [
                    0 => 'public/legacy/modules/Accounts',
                    1 => 'public/legacy/modules/ACL',
                    2 => 'public/legacy/modules/ACLActions',
                    3 => 'public/legacy/modules/ACLRoles',
                    4 => 'public/legacy/modules/Activities',
                    5 => 'public/legacy/modules/Administration',
                    6 => 'public/legacy/modules/Alerts',
                    7 => 'public/legacy/modules/AM_ProjectTemplates',
                    8 => 'public/legacy/modules/AM_TaskTemplates',
                    9 => 'public/legacy/modules/AOBH_BusinessHours',
                    10 => 'public/legacy/modules/AOD_Index',
                    11 => 'public/legacy/modules/AOD_IndexEvent',
                    12 => 'public/legacy/modules/AOK_KnowledgeBase',
                    13 => 'public/legacy/modules/AOK_Knowledge_Base_Categories',
                    14 => 'public/legacy/modules/AOP_Case_Events',
                    15 => 'public/legacy/modules/AOP_Case_Updates',
                    16 => 'public/legacy/modules/AOR_Charts',
                    17 => 'public/legacy/modules/AOR_Conditions',
                    18 => 'public/legacy/modules/AOR_Fields',
                    19 => 'public/legacy/modules/AOR_Reports',
                    20 => 'public/legacy/modules/AOR_Scheduled_Reports',
                    21 => 'public/legacy/modules/AOS_Contracts',
                    22 => 'public/legacy/modules/AOS_Invoices',
                    23 => 'public/legacy/modules/AOS_Line_Item_Groups',
                    24 => 'public/legacy/modules/AOS_PDF_Templates',
                    25 => 'public/legacy/modules/AOS_Product_Categories',
                    26 => 'public/legacy/modules/AOS_Products',
                    27 => 'public/legacy/modules/AOS_Products_Quotes',
                    28 => 'public/legacy/modules/AOS_Quotes',
                    29 => 'public/legacy/modules/AOW_Actions',
                    30 => 'public/legacy/modules/AOW_Conditions',
                    31 => 'public/legacy/modules/AOW_Processed',
                    32 => 'public/legacy/modules/AOW_WorkFlow',
                    33 => 'public/legacy/modules/Audit',
                    34 => 'public/legacy/modules/BeanDictionary.php',
                    35 => 'public/legacy/modules/Bugs',
                    36 => 'public/legacy/modules/Calendar',
                    37 => 'public/legacy/modules/Calls',
                    38 => 'public/legacy/modules/Calls_Reschedule',
                    39 => 'public/legacy/modules/CampaignLog',
                    40 => 'public/legacy/modules/Campaigns',
                    41 => 'public/legacy/modules/CampaignTrackers',
                    42 => 'public/legacy/modules/Cases',
                    43 => 'public/legacy/modules/Charts',
                    44 => 'public/legacy/modules/Configurator',
                    45 => 'public/legacy/modules/Connectors',
                    46 => 'public/legacy/modules/Contacts',
                    47 => 'public/legacy/modules/Currencies',
                    48 => 'public/legacy/modules/Delegates',
                    49 => 'public/legacy/modules/DocumentRevisions',
                    50 => 'public/legacy/modules/Documents',
                    51 => 'public/legacy/modules/DynamicFields',
                    52 => 'public/legacy/modules/EAPM',
                    53 => 'public/legacy/modules/EmailAddresses',
                    54 => 'public/legacy/modules/EmailMan',
                    55 => 'public/legacy/modules/EmailMarketing',
                    56 => 'public/legacy/modules/Emails',
                    57 => 'public/legacy/modules/EmailTemplates',
                    58 => 'public/legacy/modules/EmailText',
                    59 => 'public/legacy/modules/Employees',
                    60 => 'public/legacy/modules/Favorites',
                    61 => 'public/legacy/modules/FP_Event_Locations',
                    62 => 'public/legacy/modules/FP_events',
                    63 => 'public/legacy/modules/Groups',
                    64 => 'public/legacy/modules/Help',
                    65 => 'public/legacy/modules/History',
                    66 => 'public/legacy/modules/Home',
                    67 => 'public/legacy/modules/iCals',
                    68 => 'public/legacy/modules/Import',
                    69 => 'public/legacy/modules/InboundEmail',
                    70 => 'public/legacy/modules/jjwg_Address_Cache',
                    71 => 'public/legacy/modules/jjwg_Areas',
                    72 => 'public/legacy/modules/jjwg_Maps',
                    73 => 'public/legacy/modules/jjwg_Markers',
                    74 => 'public/legacy/modules/LabelEditor',
                    75 => 'public/legacy/modules/Leads',
                    76 => 'public/legacy/modules/MailMerge',
                    77 => 'public/legacy/modules/Meetings',
                    78 => 'public/legacy/modules/MergeRecords',
                    79 => 'public/legacy/modules/ModuleBuilder',
                    80 => 'public/legacy/modules/MySettings',
                    81 => 'public/legacy/modules/Notes',
                    82 => 'public/legacy/modules/OAuth2Clients',
                    83 => 'public/legacy/modules/OAuth2Tokens',
                    84 => 'public/legacy/modules/OAuthKeys',
                    85 => 'public/legacy/modules/OAuthTokens',
                    86 => 'public/legacy/modules/Opportunities',
                    87 => 'public/legacy/modules/OptimisticLock',
                    88 => 'public/legacy/modules/OutboundEmailAccounts',
                    89 => 'public/legacy/modules/Project',
                    90 => 'public/legacy/modules/ProjectTask',
                    91 => 'public/legacy/modules/ProspectLists',
                    92 => 'public/legacy/modules/Prospects',
                    93 => 'public/legacy/modules/Relationships',
                    94 => 'public/legacy/modules/Releases',
                    95 => 'public/legacy/modules/Reminders',
                    96 => 'public/legacy/modules/Reminders_Invitees',
                    97 => 'public/legacy/modules/ResourceCalendar',
                    98 => 'public/legacy/modules/Roles',
                    99 => 'public/legacy/modules/SavedSearch',
                    100 => 'public/legacy/modules/Schedulers',
                    101 => 'public/legacy/modules/SchedulersJobs',
                    102 => 'public/legacy/modules/SecurityGroups',
                    103 => 'public/legacy/modules/Spots',
                    104 => 'public/legacy/modules/Studio',
                    105 => 'public/legacy/modules/SugarFeed',
                    106 => 'public/legacy/modules/SurveyQuestionOptions',
                    107 => 'public/legacy/modules/SurveyQuestionResponses',
                    108 => 'public/legacy/modules/SurveyQuestions',
                    109 => 'public/legacy/modules/SurveyResponses',
                    110 => 'public/legacy/modules/Surveys',
                    111 => 'public/legacy/modules/TableDictionary.php',
                    112 => 'public/legacy/modules/Tasks',
                    113 => 'public/legacy/modules/TemplateSectionLine',
                    114 => 'public/legacy/modules/Trackers',
                    115 => 'public/legacy/modules/UpgradeWizard',
                    116 => 'public/legacy/modules/UserPreferences',
                    117 => 'public/legacy/modules/Users',
                    118 => 'public/legacy/modules/vCals',
                    119 => 'public/legacy/vendor/gymadarasz',
                    120 => 'public/legacy/vendor/tinymce',
                ],
                'toExpand' => [
                    0 => 'public',
                    1 => 'public/legacy',
                    2 => 'public/legacy/modules',
                    3 => 'public/legacy/vendor',
                    4 => 'public/legacy/Api',
                    5 => 'public/legacy/Api/V8',
                    6 => 'public/legacy/Api/V8/OAuth2',
                ],
                'toReAdd' => [
                    0 => 'public/legacy/include/language',
                    1 => 'public/legacy/modules/Accounts/language',
                    2 => 'public/legacy/modules/ACL/language',
                    3 => 'public/legacy/modules/ACLActions/language',
                    4 => 'public/legacy/modules/ACLRoles/language',
                    5 => 'public/legacy/modules/Activities/language',
                    6 => 'public/legacy/modules/Administration/language',
                    7 => 'public/legacy/modules/Alerts/language',
                    8 => 'public/legacy/modules/AM_ProjectTemplates/language',
                    9 => 'public/legacy/modules/AM_TaskTemplates/language',
                    10 => 'public/legacy/modules/AOBH_BusinessHours/language',
                    11 => 'public/legacy/modules/AOD_Index/language',
                    12 => 'public/legacy/modules/AOD_IndexEvent/language',
                    13 => 'public/legacy/modules/AOK_KnowledgeBase/language',
                    14 => 'public/legacy/modules/AOK_Knowledge_Base_Categories/language',
                    15 => 'public/legacy/modules/AOP_Case_Events/language',
                    16 => 'public/legacy/modules/AOP_Case_Updates/language',
                    17 => 'public/legacy/modules/AOR_Charts/language',
                    18 => 'public/legacy/modules/AOR_Conditions/language',
                    19 => 'public/legacy/modules/AOR_Fields/language',
                    20 => 'public/legacy/modules/AOR_Reports/language',
                    21 => 'public/legacy/modules/AOR_Scheduled_Reports/language',
                    22 => 'public/legacy/modules/AOS_Contracts/language',
                    23 => 'public/legacy/modules/AOS_Invoices/language',
                    24 => 'public/legacy/modules/AOS_Line_Item_Groups/language',
                    25 => 'public/legacy/modules/AOS_PDF_Templates/language',
                    26 => 'public/legacy/modules/AOS_Product_Categories/language',
                    27 => 'public/legacy/modules/AOS_Products/language',
                    28 => 'public/legacy/modules/AOS_Products_Quotes/language',
                    29 => 'public/legacy/modules/AOS_Quotes/language',
                    30 => 'public/legacy/modules/AOW_Actions/language',
                    31 => 'public/legacy/modules/AOW_Conditions/language',
                    32 => 'public/legacy/modules/AOW_Processed/language',
                    33 => 'public/legacy/modules/AOW_WorkFlow/language',
                    34 => 'public/legacy/modules/Audit/language',
                    35 => 'public/legacy/modules/BeanDictionary.php/language',
                    36 => 'public/legacy/modules/Bugs/language',
                    37 => 'public/legacy/modules/Calendar/language',
                    38 => 'public/legacy/modules/Calls/language',
                    39 => 'public/legacy/modules/Calls_Reschedule/language',
                    40 => 'public/legacy/modules/CampaignLog/language',
                    41 => 'public/legacy/modules/Campaigns/language',
                    42 => 'public/legacy/modules/CampaignTrackers/language',
                    43 => 'public/legacy/modules/Cases/language',
                    44 => 'public/legacy/modules/Charts/language',
                    45 => 'public/legacy/modules/Configurator/language',
                    46 => 'public/legacy/modules/Connectors/language',
                    47 => 'public/legacy/modules/Contacts/language',
                    48 => 'public/legacy/modules/Currencies/language',
                    49 => 'public/legacy/modules/Delegates/language',
                    50 => 'public/legacy/modules/DocumentRevisions/language',
                    51 => 'public/legacy/modules/Documents/language',
                    52 => 'public/legacy/modules/DynamicFields/language',
                    53 => 'public/legacy/modules/EAPM/language',
                    54 => 'public/legacy/modules/EmailAddresses/language',
                    55 => 'public/legacy/modules/EmailMan/language',
                    56 => 'public/legacy/modules/EmailMarketing/language',
                    57 => 'public/legacy/modules/Emails/language',
                    58 => 'public/legacy/modules/EmailTemplates/language',
                    59 => 'public/legacy/modules/EmailText/language',
                    60 => 'public/legacy/modules/Employees/language',
                    61 => 'public/legacy/modules/Favorites/language',
                    62 => 'public/legacy/modules/FP_Event_Locations/language',
                    63 => 'public/legacy/modules/FP_events/language',
                    64 => 'public/legacy/modules/Groups/language',
                    65 => 'public/legacy/modules/Help/language',
                    66 => 'public/legacy/modules/History/language',
                    67 => 'public/legacy/modules/Home/language',
                    68 => 'public/legacy/modules/iCals/language',
                    69 => 'public/legacy/modules/Import/language',
                    70 => 'public/legacy/modules/InboundEmail/language',
                    71 => 'public/legacy/modules/jjwg_Address_Cache/language',
                    72 => 'public/legacy/modules/jjwg_Areas/language',
                    73 => 'public/legacy/modules/jjwg_Maps/language',
                    74 => 'public/legacy/modules/jjwg_Markers/language',
                    75 => 'public/legacy/modules/LabelEditor/language',
                    76 => 'public/legacy/modules/Leads/language',
                    77 => 'public/legacy/modules/MailMerge/language',
                    78 => 'public/legacy/modules/Meetings/language',
                    79 => 'public/legacy/modules/MergeRecords/language',
                    80 => 'public/legacy/modules/ModuleBuilder/language',
                    81 => 'public/legacy/modules/MySettings/language',
                    82 => 'public/legacy/modules/Notes/language',
                    83 => 'public/legacy/modules/OAuth2Clients/language',
                    84 => 'public/legacy/modules/OAuth2Tokens/language',
                    85 => 'public/legacy/modules/OAuthKeys/language',
                    86 => 'public/legacy/modules/OAuthTokens/language',
                    87 => 'public/legacy/modules/Opportunities/language',
                    88 => 'public/legacy/modules/OptimisticLock/language',
                    89 => 'public/legacy/modules/OutboundEmailAccounts/language',
                    90 => 'public/legacy/modules/Project/language',
                    91 => 'public/legacy/modules/ProjectTask/language',
                    92 => 'public/legacy/modules/ProspectLists/language',
                    93 => 'public/legacy/modules/Prospects/language',
                    94 => 'public/legacy/modules/Relationships/language',
                    95 => 'public/legacy/modules/Releases/language',
                    96 => 'public/legacy/modules/Reminders/language',
                    97 => 'public/legacy/modules/Reminders_Invitees/language',
                    98 => 'public/legacy/modules/ResourceCalendar/language',
                    99 => 'public/legacy/modules/Roles/language',
                    100 => 'public/legacy/modules/SavedSearch/language',
                    101 => 'public/legacy/modules/Schedulers/language',
                    102 => 'public/legacy/modules/SchedulersJobs/language',
                    103 => 'public/legacy/modules/SecurityGroups/language',
                    104 => 'public/legacy/modules/Spots/language',
                    105 => 'public/legacy/modules/Studio/language',
                    106 => 'public/legacy/modules/SugarFeed/language',
                    107 => 'public/legacy/modules/SurveyQuestionOptions/language',
                    108 => 'public/legacy/modules/SurveyQuestionResponses/language',
                    109 => 'public/legacy/modules/SurveyQuestions/language',
                    110 => 'public/legacy/modules/SurveyResponses/language',
                    111 => 'public/legacy/modules/Surveys/language',
                    112 => 'public/legacy/modules/TableDictionary.php/language',
                    113 => 'public/legacy/modules/Tasks/language',
                    114 => 'public/legacy/modules/TemplateSectionLine/language',
                    115 => 'public/legacy/modules/Trackers/language',
                    116 => 'public/legacy/modules/UpgradeWizard/language',
                    117 => 'public/legacy/modules/UserPreferences/language',
                    118 => 'public/legacy/modules/Users/language',
                    119 => 'public/legacy/modules/vCals/language',
                ],
            ],
            'themes.image_paths' => [
                0 => 'legacy/themes/default/images',
                1 => 'legacy/custom/themes/default/images',
                2 => 'dist/themes/default/images',
                3 => 'legacy/themes/<theme>/images',
                4 => 'legacy/custom/themes/<theme>/images',
                5 => 'dist/themes/<theme>/images',
                6 => 'dist/themes/<theme>/images/modules',
            ],
            'themes.image_supported_types' => [
                0 => 'svg',
                1 => 'png',
                2 => 'jpg',
                3 => 'jpeg',
                4 => 'gif',
            ],
            'themes.navigation_tab_limits' => [
                'XSmall' => 1,
                'Small' => 1,
                'Medium' => 3,
                'Large' => 10,
                'XLarge' => 12,
            ],
            'global_recently_viewed_reload_actions' => [
                'any' => [
                    0 => 'detail',
                    1 => 'record',
                    2 => 'list',
                    3 => 'index',
                ],
            ],
            'notifications' => [
                'module' => 'alerts',
                'class' => 'notifications',
                'maxListHeight' => 450,
                'direction' => 'desc',
                'loadMorePosition' => 'bottom',
                'filters' => [
                    'orderBy' => 'snooze',
                    'sortOrder' => 'desc',
                ],
                'autoRefreshFrequency' => 1,
                'autoRefreshDeviationMin' => -15,
                'autoRefreshDeviationMax' => 15,
                'showNoDataMessage' => true,
                'noDataLabel' => 'LBL_NOTIFICATIONS_NONE',
                'create' => NULL,
                'item' => [
                    'collapsible' => false,
                    'collapseLimit' => 200,
                    'itemClass' => 'notifications-item',
                    'buttonGroupClass' => 'd-flex flex-row-reverse align-items-end notifications-actions',
                    'containerClass' => 'flex-row align-items-start py-2 justify-content-start containerClass',
                    'dynamicClass' => [
                        0 => 'is_read',
                    ],
                    'flexDirection' => 'flex-row',
                    'fields' => [
                        'url_redirect' => [
                            'name' => 'url_redirect',
                            'type' => 'varchar',
                        ],
                        'date_start' => [
                            'name' => 'date_start',
                            'dynamicLabelKey' => 'LBL_NOTIFICATION_ITEM_DATE',
                            'type' => 'datetime',
                        ],
                        'is_read' => [
                            'name' => 'is_read',
                            'type' => 'bool',
                        ],
                    ],
                    'layout' => [
                        'body' => [
                            'class' => 'itemContentClass',
                            'rows' => [
                                0 => [
                                    'cols' => [
                                        0 => [
                                            'field' => [
                                                'name' => 'target_module_type',
                                                'type' => 'icon',
                                            ],
                                            'labelDisplay' => 'none',
                                            'hideIfEmpty' => false,
                                            'class' => 'font-weight-bold',
                                        ],
                                    ],
                                ],
                                1 => [
                                    'class' => 'd-flex flex-column flex-grow-1 pl-2 pr-2',
                                    'align' => 'start',
                                    'cols' => [
                                        0 => [
                                            'field' => [
                                                'name' => 'target_module_label',
                                            ],
                                            'labelDisplay' => 'none',
                                            'labelClass' => 'm-0',
                                            'display' => 'readonly',
                                            'hideIfEmpty' => true,
                                            'class' => 'small text-main text-uppercase',
                                        ],
                                        1 => [
                                            'field' => [
                                                'name' => 'name',
                                                'metadata' => [
                                                    'link' => true,
                                                    'linkRoute' => '{{fields.url_redirect.value}}',
                                                ],
                                            ],
                                            'labelDisplay' => 'none',
                                            'labelClass' => 'm-0',
                                            'display' => 'readonly',
                                            'hideIfEmpty' => false,
                                            'class' => 'text-bigger-1',
                                        ],
                                        2 => [
                                            'field' => [
                                                'name' => 'snooze',
                                                'dynamicLabelKey' => 'LBL_NOTIFICATION_ITEM_DATE_ENTERED',
                                                'type' => 'datetime',
                                            ],
                                            'labelClass' => 'm-0',
                                            'labelDisplay' => 'inline',
                                            'display' => 'none',
                                            'hideIfEmpty' => false,
                                            'class' => 'small',
                                        ],
                                        3 => [
                                            'field' => [
                                                'name' => 'date_start',
                                                'dynamicLabelKey' => 'LBL_NOTIFICATION_ITEM_DATE',
                                                'type' => 'datetime',
                                            ],
                                            'labelClass' => 'm-0',
                                            'labelDisplay' => 'inline',
                                            'display' => 'none',
                                            'hideIfEmpty' => true,
                                            'class' => 'small',
                                        ],
                                    ],
                                ],
                                2 => [
                                    'class' => 'd-flex',
                                    'align' => 'start',
                                    'justify' => 'start',
                                    'cols' => [
                                        0 => [
                                            'actionSlot' => 'true',
                                            'class' => 'notification-item-buttons',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        'actions' => [
                            0 => [
                                'key' => 'dismiss-alert',
                                'icon' => 'cross',
                                'titleKey' => 'LBL_DISMISS',
                                'asyncProcess' => true,
                                'params' => [
                                    'inlineConfirmation' => true,
                                    'confirmationLabel' => 'LBL_DISMISS_INLINE_CONFIRM',
                                ],
                                'klass' => [
                                    0 => 'btn fill-complementary fill-hover-complementary-light border-0 btn-sm p-0 m-0',
                                ],
                                'modes' => [
                                    0 => 'detail',
                                    1 => 'edit',
                                ],
                                'acl' => [

                                ],
                            ],
                            1 => [
                                'key' => 'snooze',
                                'icon' => 'snooze',
                                'titleKey' => 'LBL_SNOOZE',
                                'asyncProcess' => true,
                                'params' => [
                                    'inlineConfirmation' => true,
                                    'confirmationDynamicLabel' => 'LBL_SNOOZE_INLINE_CONFIRM',
                                ],
                                'klass' => [
                                    0 => 'btn stroke-complementary fill-complementary fill-hover-complementary-light stroke-hover-complementary-light border-0 btn-sm p-0 m-0 mr-2',
                                ],
                                'modes' => [
                                    0 => 'detail',
                                    1 => 'edit',
                                ],
                                'acl' => [

                                ],
                            ],
                        ],
                    ],
                ],
                'pageSize' => 10,
                'listActionsClass' => 'd-flex align-items-center justify-content-end notification-list-actions pr-2 pt-1',
                'listActionsButtonClass' => 'line-actions-button btn btn-link small',
                'listActionsButtonGroupClass' => 'd-flex justify-content-end',
                'listActions' => [
                    0 => [
                        'key' => 'dismiss-all-alerts',
                        'label' => 'LBL_DISMISS_ALL',
                        'labelKey' => 'LBL_DISMISS_ALL',
                        'asyncProcess' => true,
                        'params' => [
                            'inlineConfirmation' => true,
                            'confirmationLabel' => 'LBL_DISMISS_ALL_INLINE_CONFIRM',
                            'module' => 'alerts',
                        ],
                        'klass' => [
                            0 => '',
                        ],
                        'modes' => [
                            0 => 'detail',
                            1 => 'list',
                        ],
                        'acl' => [

                        ],
                    ],
                    1 => [
                        'key' => 'mark-as-read',
                        'label' => 'LBL_DISMISS_ALL',
                        'labelKey' => 'LBL_DISMISS_ALL',
                        'asyncProcess' => true,
                        'params' => [
                            'displayConfirmation' => true,
                            'confirmationLabel' => 'NTC_DELETE_CONFIRMATION',
                            'module' => 'alerts',
                        ],
                        'klass' => [
                            0 => '',
                        ],
                        'modes' => [

                        ],
                        'acl' => [

                        ],
                    ],
                ],
            ],
            'notifications_reload_actions' => [
                'meetings' => [
                    0 => 'create',
                    1 => 'edit',
                ],
                'calls' => [
                    0 => 'create',
                    1 => 'edit',
                ],
            ],
            'quick_actions' => [
                'max_number' => 7,
                'use_navigation_modules' => true,
                'actions' => NULL,
            ],
            'ui' => [
                'alert_timeout' => 3,
                'user_preferences_save_delay' => 500,
                'loading_display_delay' => 900,
                'table_loading_display_delay' => 800,
                'modal_buttons_collapse_breakpoint' => 4,
                'list_max_entries_per_record_thread' => 10,
                'tinymce' => [
                    'edit' => [
                        'base_url' => './dist/tinymce',
                        'suffix' => '.min',
                        'modelEvents' => 'change',
                        'ignoreEvents' => 'onKeyDown,onKeyPress,onKeyUp,onSelectionChange',
                        'height' => 500,
                        'deprecation_warnings' => false,
                        'menubar' => false,
                        'plugins' => [
                            0 => 'advlist autolink lists link image charmap print preview anchor',
                            1 => 'searchreplace visualblocks code fullscreen',
                            2 => 'insertdatetime media table paste code help wordcount',
                        ],
                        'toolbar' => 'undo redo | formatselect | bold italic backcolor | alignleft aligncenter alignright alignjustify |  bullist numlist outdent indent | removeformat | help',
                        'toolbar_mode' => 'floating',
                        'mobile' => [
                            'theme' => 'mobile',
                        ],
                    ],
                    'detail' => [
                        'base_url' => './dist/tinymce',
                        'suffix' => '.min',
                        'deprecation_warnings' => false,
                        'readonly' => true,
                        'toolbar' => false,
                        'menubar' => false,
                        'statusbar' => false,
                        'inline' => true,
                    ],
                ],
                'navigation_max_module_recently_viewed' => 5,
                'navigation_max_module_favorites' => 5,
                'global_recently_viewed' => 10,
                'subpanel_max_height' => 620,
                'listview_max_height' => 0,
                'record_modal_max_height' => 620,
                'inline_confirmation_loading_delay' => 300,
                'group_field_mobile_breakdown_limit' => 350,
                'multiselect_max_number' => [
                    'XSmall' => 20,
                    'Small' => 20,
                    'Medium' => 20,
                    'Large' => 20,
                    'XLarge' => 20,
                ],
                'displayed_quick_filters' => [
                    'XSmall' => 0,
                    'Small' => 4,
                    'Medium' => 2,
                    'Large' => 3,
                    'XLarge' => 5,
                ],
                'quick_filters_breakdown_threshold' => [
                    'XSmall' => 0,
                    'Small' => 4,
                    'Medium' => 2,
                    'Large' => 3,
                    'XLarge' => 5,
                ],
                'enable_quick_filters' => [
                    'XSmall' => false,
                    'Small' => true,
                    'Medium' => true,
                    'Large' => true,
                    'XLarge' => true,
                ],
                'quick_filters_breakdown_screen_sizes' => [
                    'XSmall' => true,
                    'Small' => true,
                    'Medium' => false,
                    'Large' => false,
                    'XLarge' => false,
                ],
                'widget_swap_screen_sizes' => [
                    'XSmall' => true,
                    'Small' => true,
                    'Medium' => false,
                    'Large' => false,
                    'XLarge' => false,
                ],
                'navbar_truncate_character_sizes' => [
                    'minLength' => 10,
                    'mediumLength' => 16,
                    'maxLength' => 22,
                ],
                'validations' => [
                    'regex' => [
                        'phone' => '^([\\+]?|00)((([(]{0,1}\\s*[0-9]{1,4}\\s*[)]{0,1})\\s*)*|([\\-\\s\\./#x0-9])*)+$',
                        'email' => '^(?:[\\.\\-\\+&#!\\$\\*=\\?\\^_`\\{\\}~\\/\\w]+)@(?:(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|\\w+(?:[\\.-]*\\w+)*(?:\\.[\\w-]{2,})+)$',
                    ],
                ],
            ],
            'ldap.options' => [
                'options' => [

                ],
                'port' => '389',
                'encryption' => 'tls',
            ],
            'legacy.dir' => (\dirname(__DIR__, 3).'/public/legacy'),
            'packages.upgrade.dir' => (\dirname(__DIR__, 3).'/tmp/package/upgrade'),
            'legacy.path' => '/legacy',
            'legacy.session_name' => 'SCRMSESSID',
            'default_session_name' => 'SCRMSESSID',
            'log.dir' => (\dirname(__DIR__, 3).'/logs/prod'),
            'base.log.dir' => (\dirname(__DIR__, 3).'/logs'),
            'log.main.default' => 'prod.log',
            'log.security.default' => 'prod.security.log',
            'log.deprecation.default' => 'prod.deprecation.log',
            'language' => [

            ],
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleSignalEvent' => 'console.signal',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\Form\\Event\\PreSubmitEvent' => 'form.pre_submit',
                'Symfony\\Component\\Form\\Event\\SubmitEvent' => 'form.submit',
                'Symfony\\Component\\Form\\Event\\PostSubmitEvent' => 'form.post_submit',
                'Symfony\\Component\\Form\\Event\\PreSetDataEvent' => 'form.pre_set_data',
                'Symfony\\Component\\Form\\Event\\PostSetDataEvent' => 'form.post_set_data',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationSuccessEvent' => 'security.authentication.success',
                'Symfony\\Component\\Security\\Http\\Event\\InteractiveLoginEvent' => 'security.interactive_login',
                'Symfony\\Component\\Security\\Http\\Event\\SwitchUserEvent' => 'security.switch_user',
            ],
            'fragment.renderer.hinclude.global_template' => NULL,
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => false,
            'kernel.trust_x_sendfile_type_header' => false,
            'kernel.trusted_hosts' => [

            ],
            'kernel.default_locale' => 'en',
            'kernel.enabled_locales' => [

            ],
            'kernel.error_controller' => 'error_controller',
            'debug.file_link_format' => NULL,
            'asset.request_context.base_path' => NULL,
            'asset.request_context.secure' => NULL,
            'translator.logging' => false,
            'translator.default_path' => (\dirname(__DIR__, 3).'/translations'),
            'debug.error_handler.throw_at' => 0,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'kernel::loadRoutes',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'session.metadata.storage_key' => '_sf2_meta',
            'session.storage.options' => [
                'cache_limiter' => '0',
                'cookie_secure' => 'auto',
                'cookie_httponly' => true,
                'cookie_samesite' => 'lax',
                'gc_probability' => 1,
            ],
            'session.save_path' => NULL,
            'session.metadata.update_threshold' => 0,
            'form.type_extension.csrf.enabled' => true,
            'form.type_extension.csrf.field_name' => '_token',
            'validator.translation_domain' => 'validators',
            'data_collector.templates' => [

            ],
            'twig.form.resources' => [
                0 => 'form_div_layout.html.twig',
            ],
            'twig.default_path' => (\dirname(__DIR__, 3).'/templates'),
            'security.role_hierarchy.roles' => [

            ],
            'security.access.denied_url' => NULL,
            'security.authentication.manager.erase_credentials' => true,
            'security.authentication.session_strategy.strategy' => 'migrate',
            'security.authentication.hide_user_not_found' => true,
            'security.firewalls' => [
                0 => 'dev',
                1 => 'main',
            ],
            'security.logout_uris' => [

            ],
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [

            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\ORM\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\ORM\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.metadata.attribute.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AttributeDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => false,
            'doctrine.orm.enable_lazy_ghost_objects' => true,
            'doctrine.orm.proxy_namespace' => 'Proxies',
            'monolog.use_microseconds' => true,
            'monolog.swift_mailer.handlers' => [

            ],
            'monolog.handlers_to_channels' => [
                'monolog.handler.security' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'security',
                    ],
                ],
                'monolog.handler.deprecation' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'deprecation',
                    ],
                ],
                'monolog.handler.console' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                        1 => 'doctrine',
                        2 => 'console',
                        3 => 'upgrade',
                        7 => 'deprecation',
                    ],
                ],
                'monolog.handler.main' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                        1 => 'upgrade',
                        4 => 'deprecation',
                        5 => 'security',
                    ],
                ],
                'monolog.handler.auth' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'auth',
                    ],
                ],
                'monolog.handler.install' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'install',
                    ],
                ],
                'monolog.handler.upgrade' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'upgrade',
                    ],
                ],
            ],
            'nelmio_cors.map' => [
                '^/' => [
                    'skip_same_as_origin' => true,
                ],
            ],
            'nelmio_cors.cors_listener.class' => 'Nelmio\\CorsBundle\\EventListener\\CorsListener',
            'nelmio_cors.options_resolver.class' => 'Nelmio\\CorsBundle\\Options\\Resolver',
            'nelmio_cors.options_provider.config.class' => 'Nelmio\\CorsBundle\\Options\\ConfigProvider',
            'doctrine.migrations.preferred_em' => NULL,
            'doctrine.migrations.preferred_connection' => NULL,
            'api_platform.use_symfony_listeners' => true,
            'api_platform.event_listeners_backward_compatibility_layer' => false,
            'api_platform.enable_entrypoint' => true,
            'api_platform.enable_docs' => true,
            'api_platform.keep_legacy_inflector' => false,
            'api_platform.title' => 'SuiteCRM API',
            'api_platform.description' => '',
            'api_platform.version' => '8.5.0',
            'api_platform.show_webby' => true,
            'api_platform.url_generation_strategy' => 1,
            'api_platform.exception_to_status' => [
                'Symfony\\Component\\Serializer\\Exception\\ExceptionInterface' => 400,
                'ApiPlatform\\Exception\\InvalidArgumentException' => 400,
                'ApiPlatform\\ParameterValidator\\Exception\\ValidationExceptionInterface' => 400,
                'Doctrine\\ORM\\OptimisticLockException' => 409,
            ],
            'api_platform.formats' => [
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'json' => [
                    0 => 'application/json',
                ],
            ],
            'api_platform.patch_formats' => [
                'json' => [
                    0 => 'application/merge-patch+json',
                ],
                'graphql' => [
                    0 => 'application/graphql',
                ],
            ],
            'api_platform.error_formats' => [
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'jsonproblem' => [
                    0 => 'application/problem+json',
                ],
                'json' => [
                    0 => 'application/problem+json',
                    1 => 'application/json',
                ],
            ],
            'api_platform.docs_formats' => [
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'jsonopenapi' => [
                    0 => 'application/vnd.openapi+json',
                ],
                'html' => [
                    0 => 'text/html',
                ],
            ],
            'api_platform.jsonschema_formats' => [
                'jsonld' => true,
            ],
            'api_platform.eager_loading.enabled' => true,
            'api_platform.eager_loading.max_joins' => 30,
            'api_platform.eager_loading.fetch_partial' => false,
            'api_platform.eager_loading.force_eager' => true,
            'api_platform.collection.exists_parameter_name' => 'exists',
            'api_platform.collection.order' => 'ASC',
            'api_platform.collection.order_parameter_name' => 'order',
            'api_platform.collection.order_nulls_comparison' => NULL,
            'api_platform.collection.pagination.enabled' => true,
            'api_platform.collection.pagination.partial' => false,
            'api_platform.collection.pagination.client_enabled' => false,
            'api_platform.collection.pagination.client_items_per_page' => false,
            'api_platform.collection.pagination.client_partial' => false,
            'api_platform.collection.pagination.items_per_page' => 30,
            'api_platform.collection.pagination.maximum_items_per_page' => NULL,
            'api_platform.collection.pagination.page_parameter_name' => 'page',
            'api_platform.collection.pagination.enabled_parameter_name' => 'pagination',
            'api_platform.collection.pagination.items_per_page_parameter_name' => 'itemsPerPage',
            'api_platform.collection.pagination.partial_parameter_name' => 'partial',
            'api_platform.collection.pagination' => [
                'enabled' => true,
                'page_parameter_name' => 'page',
                'enabled_parameter_name' => 'pagination',
                'items_per_page_parameter_name' => 'itemsPerPage',
                'partial_parameter_name' => 'partial',
            ],
            'api_platform.handle_symfony_errors' => false,
            'api_platform.http_cache.etag' => true,
            'api_platform.http_cache.max_age' => NULL,
            'api_platform.http_cache.shared_max_age' => NULL,
            'api_platform.http_cache.vary' => [
                0 => 'Content-Type',
                1 => 'Authorization',
                2 => 'Origin',
            ],
            'api_platform.http_cache.public' => NULL,
            'api_platform.http_cache.invalidation.max_header_length' => 7500,
            'api_platform.http_cache.invalidation.xkey.glue' => ' ',
            'api_platform.asset_package' => NULL,
            'api_platform.defaults' => [
                'extra_properties' => [
                    'standard_put' => true,
                    'rfc_7807_compliant_errors' => true,
                ],
                'stateless' => true,
                'cache_headers' => [
                    'vary' => [
                        0 => 'Content-Type',
                        1 => 'Authorization',
                        2 => 'Origin',
                    ],
                ],
            ],
            'api_platform.rfc_7807_compliant_errors' => true,
            'api_platform.resource_class_directories' => [
                0 => (\dirname(__DIR__, 3).'/core'),
            ],
            'api_platform.class_name_resources' => [
                0 => 'ApiPlatform\\State\\ApiResource\\Error',
                1 => 'ApiPlatform\\Symfony\\Validator\\Exception\\ValidationException',
                2 => 'ApiPlatform\\Validator\\Exception\\ValidationException',
            ],
            'api_platform.oauth.enabled' => true,
            'api_platform.oauth.clientId' => 'scrmfe',
            'api_platform.oauth.clientSecret' => 'scrmfe',
            'api_platform.oauth.type' => 'oauth2',
            'api_platform.oauth.flow' => 'password',
            'api_platform.oauth.tokenUrl' => '/oauth/v2/token',
            'api_platform.oauth.authorizationUrl' => '/oauth/v2/auth',
            'api_platform.oauth.refreshUrl' => '',
            'api_platform.oauth.scopes' => [

            ],
            'api_platform.oauth.pkce' => false,
            'api_platform.openapi.termsOfService' => NULL,
            'api_platform.openapi.contact.name' => NULL,
            'api_platform.openapi.contact.url' => NULL,
            'api_platform.openapi.contact.email' => NULL,
            'api_platform.openapi.license.name' => NULL,
            'api_platform.openapi.license.url' => NULL,
            'api_platform.openapi.overrideResponses' => true,
            'api_platform.swagger.versions' => [
                0 => 3,
            ],
            'api_platform.enable_swagger_ui' => true,
            'api_platform.enable_re_doc' => false,
            'api_platform.swagger.api_keys' => [

            ],
            'api_platform.swagger_ui.extra_configuration' => [

            ],
            'api_platform.graphql.enabled' => true,
            'api_platform.graphql.introspection.enabled' => true,
            'api_platform.graphql.graphiql.enabled' => false,
            'api_platform.graphql.graphql_playground.enabled' => true,
            'api_platform.graphql.collection.pagination' => [
                'enabled' => true,
            ],
            'api_platform.graphql.default_ide' => 'graphql-playground',
            'api_platform.graphql.nesting_separator' => '_',
            'api_platform.validator.legacy_validation_exception' => true,
            'api_platform.validator.serialize_payload_fields' => [

            ],
            'api_platform.validator.query_parameter_validation' => true,
            'api_platform.elasticsearch.enabled' => false,
            'nbgrp_onelogin_saml.use_proxy_vars' => false,
            'nbgrp_onelogin_saml.idp_parameter_name' => 'idp',
            'scheb_two_factor.model_manager_name' => NULL,
            'scheb_two_factor.security_tokens' => [
                0 => 'Symfony\\Component\\Security\\Core\\Authentication\\Token\\UsernamePasswordToken',
                1 => 'Symfony\\Component\\Security\\Http\\Authenticator\\Token\\PostAuthenticationToken',
            ],
            'scheb_two_factor.ip_whitelist' => [

            ],
            'scheb_two_factor.totp.issuer' => 'SuiteCRM',
            'scheb_two_factor.totp.server_name' => 'SuiteCRM',
            'scheb_two_factor.totp.window' => 1,
            'scheb_two_factor.totp.parameters' => [

            ],
            'scheb_two_factor.totp.template' => '@SchebTwoFactor/Authentication/form.html.twig',
            'scheb_two_factor.totp.leeway' => 0,
            'scheb_two_factor.trusted_device.enabled' => false,
            'console.command.ids' => [

            ],
        ];
    }
}
