import { ActionDataSource } from 'common';
import { ListViewStore } from '../store/list-view/list-view.store';
import { MetadataStore } from '../../../store/metadata/metadata.store.service';
import { TableConfig } from '../../../components/table/table.model';
import { LineActionActionManager } from '../../../components/table/line-actions/line-action-manager.service';
import { AsyncActionService } from '../../../services/process/processes/async-action/async-action';
import { MessageService } from '../../../services/message/message.service';
import { ConfirmationModalService } from '../../../services/modals/confirmation-modal.service';
import { LanguageStore } from '../../../store/language/language.store';
import { BulkActionsAdapterFactory } from './bulk-actions.adapter.factory';
import { BulkActionsAdapter } from './bulk-actions.adapter';
import { SelectModalService } from '../../../services/modals/select-modal.service';
import { UserPreferenceStore } from "../../../store/user-preference/user-preference.store";
import { SystemConfigStore } from "../../../store/system-config/system-config.store";
import { ListviewTableActionsAdapterFactory } from "./listview-table-actions.adapter.factory";
import { AppMetadataStore } from "../../../store/app-metadata/app-metadata.store.service";
import * as i0 from "@angular/core";
export declare class TableAdapter {
    protected store: ListViewStore;
    protected metadata: MetadataStore;
    protected actionManager: LineActionActionManager;
    protected asyncActionService: AsyncActionService;
    protected message: MessageService;
    protected confirmation: ConfirmationModalService;
    protected language: LanguageStore;
    protected bulkActionsAdapterFactory: BulkActionsAdapterFactory;
    protected listviewTableActionsAdapterFactory: ListviewTableActionsAdapterFactory;
    protected selectModalService: SelectModalService;
    protected preferences: UserPreferenceStore;
    protected systemConfigs: SystemConfigStore;
    protected appMetadataStore: AppMetadataStore;
    constructor(store: ListViewStore, metadata: MetadataStore, actionManager: LineActionActionManager, asyncActionService: AsyncActionService, message: MessageService, confirmation: ConfirmationModalService, language: LanguageStore, bulkActionsAdapterFactory: BulkActionsAdapterFactory, listviewTableActionsAdapterFactory: ListviewTableActionsAdapterFactory, selectModalService: SelectModalService, preferences: UserPreferenceStore, systemConfigs: SystemConfigStore, appMetadataStore: AppMetadataStore);
    getTable(): TableConfig;
    getLineActionsDataSource(): ActionDataSource;
    getBulkActionsDataSource(store: ListViewStore): BulkActionsAdapter;
    private getTableActions;
    static ɵfac: i0.ɵɵFactoryDeclaration<TableAdapter, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TableAdapter>;
}
//# sourceMappingURL=table.adapter.d.ts.map