/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { ElementRef, OnDestroy, OnInit } from '@angular/core';
import { MenuItem } from 'common';
import { Subject, Subscription } from "rxjs";
import { AppStateStore } from "../../../store/app-state/app-state.store";
import { ModuleNavigation } from "../../../services/navigation/module-navigation/module-navigation.service";
import { MenuItemLinkConfig } from "../menu-item-link/menu-item-link-config.model";
import { SubMenuRecentlyViewedConfig } from "../sub-menu-recently-viewed/sub-menu-recently-viewed-config.model";
import { SubMenuFavoritesConfig } from "../sub-menu-favorites/sub-menu-favorites-config.model";
import * as i0 from "@angular/core";
export declare class BaseMenuItemComponent implements OnInit, OnDestroy {
    protected appStateStore: AppStateStore;
    protected moduleNavigation: ModuleNavigation;
    item: MenuItem;
    index: number;
    topLink: ElementRef;
    showDropdown: import("@angular/core").WritableSignal<boolean>;
    hoverEnabled: import("@angular/core").WritableSignal<boolean>;
    topLinkConfig: MenuItemLinkConfig;
    recentlyViewedConfig: SubMenuRecentlyViewedConfig;
    favoritesConfig: SubMenuFavoritesConfig;
    showRecentlyViewed: Subject<boolean>;
    showFavorites: Subject<boolean>;
    clickType: string;
    subs: Subscription[];
    constructor(appStateStore: AppStateStore, moduleNavigation: ModuleNavigation);
    ngOnInit(): void;
    ngOnDestroy(): void;
    hideDropdown(): void;
    navigate(): void;
    onTopItemClick($event: PointerEvent): void;
    toggleDropdown(): void;
    onTouchStart(): void;
    onTouchEnd(): void;
    onClick(event: any): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<BaseMenuItemComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<BaseMenuItemComponent, "scrm-base-menu-item", never, { "item": { "alias": "item"; "required": false; }; "index": { "alias": "index"; "required": false; }; }, {}, never, never, false, never>;
}
//# sourceMappingURL=base-menu-item.component.d.ts.map