import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
class RecordValidationHandler {
    /**
     * Initialize Record Validators
     * @param record
     */
    initValidators(record) {
        if (!record) {
            return;
        }
        record?.formGroup?.clearValidators();
        const fields = record?.fields ?? {};
        Object.keys(fields).forEach(fieldName => {
            const field = record.fields[fieldName];
            const formControl = field?.formControl ?? null;
            if (!formControl) {
                return;
            }
            this.initFieldValidators(field);
            this.initLineItemsValidators(field);
        });
    }
    /**
     * reset record field validators
     * @param record
     */
    resetValidators(record) {
        if (!record) {
            return;
        }
        record?.formGroup?.clearValidators();
        const fields = record?.fields ?? {};
        Object.keys(fields).forEach(fieldName => {
            const field = record.fields[fieldName];
            this.resetFieldValidators(field);
            this.resetLineItemsValidators(field);
        });
    }
    /**
     * Set field validators
     * @param field
     * @param validators
     * @param asyncValidators
     */
    setFormControlValidators(field, validators, asyncValidators) {
        if (!field?.formControl) {
            return;
        }
        if (validators?.length) {
            field.formControl.setValidators(validators);
        }
        if (asyncValidators?.length) {
            field.formControl.setAsyncValidators(asyncValidators);
        }
    }
    /**
     * Reset field validators
     * @param field
     */
    resetFormControlValidators(field) {
        if (!field?.formControl) {
            return;
        }
        field.formControl.clearValidators();
        field.formControl.clearAsyncValidators();
    }
    /**
     * Initialize Field validators
     * @param field
     */
    initFieldValidators(field) {
        this.resetFormControlValidators(field);
        this.setFormControlValidators(field, field?.validators ?? [], field?.asyncValidators ?? []);
        const fieldAttributes = field?.attributes ?? {};
        Object.keys(fieldAttributes).forEach(fieldAttributeName => {
            const fieldAttribute = fieldAttributes[fieldAttributeName];
            this.resetFormControlValidators(fieldAttribute);
            this.setFormControlValidators(fieldAttribute, fieldAttribute?.validators ?? [], fieldAttribute?.asyncValidators ?? []);
        });
    }
    /**
     * Initialize Field validators
     * @param field
     */
    resetFieldValidators(field) {
        this.resetFormControlValidators(field);
        const fieldAttributes = field?.attributes ?? {};
        Object.keys(fieldAttributes).forEach(fieldAttributeName => {
            const fieldAttribute = fieldAttributes[fieldAttributeName];
            this.resetFormControlValidators(fieldAttribute);
        });
    }
    /**
     * Initialize Line Items validators
     * @param field
     */
    initLineItemsValidators(field) {
        if (!field?.itemFormArray) {
            return;
        }
        const itemFormArraySaveValidators = field?.itemFormArraySaveValidators ?? [];
        if (itemFormArraySaveValidators.length) {
            field.itemFormArray.clearValidators();
            field.itemFormArray.addValidators(itemFormArraySaveValidators);
        }
        const items = field?.items ?? [];
        items.forEach(item => {
            const itemFields = item?.fields ?? {};
            Object.keys(itemFields).forEach(itemFieldName => {
                const itemField = itemFields[itemFieldName];
                this.initFieldValidators(itemField);
            });
        });
    }
    /**
     * Initialize Line Items validators
     * @param field
     */
    resetLineItemsValidators(field) {
        if (!field?.itemFormArray) {
            return;
        }
        field.itemFormArray.clearValidators();
        const items = field?.items ?? [];
        items.forEach(item => {
            const itemFields = item?.fields ?? {};
            Object.keys(itemFields).forEach(itemFieldName => {
                const itemField = itemFields[itemFieldName];
                this.resetFieldValidators(field);
            });
        });
    }
    static { this.ɵfac = function RecordValidationHandler_Factory(t) { return new (t || RecordValidationHandler)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordValidationHandler, factory: RecordValidationHandler.ɵfac, providedIn: 'root' }); }
}
export { RecordValidationHandler };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordValidationHandler, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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