/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2024 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from "@angular/core";
import { of } from "rxjs";
import { isVoid } from "common";
import { map } from "rxjs/operators";
import { SystemConfigStore } from "../../store/system-config/system-config.store";
import { isEmpty } from "lodash-es";
import * as i0 from "@angular/core";
import * as i1 from "../../store/system-config/system-config.store";
class RecordConvertService {
    constructor(systemConfigStore) {
        this.systemConfigStore = systemConfigStore;
    }
    duplicateOnModule(prevRecord, newRecord, vardefs, moduleMetadata) {
        const excludedFields = this.systemConfigStore.getConfigValue('convert_ignore') ?? [];
        const nextModule = newRecord.module ?? '';
        newRecord.id = '';
        newRecord.attributes.id = '';
        Object.keys(vardefs).forEach((fieldName) => {
            if (isVoid(prevRecord?.attributes[fieldName]) || excludedFields?.default.includes(fieldName)) {
                return;
            }
            if (Object.keys(excludedFields).includes(nextModule) && excludedFields[nextModule].includes(fieldName)) {
                return;
            }
            if (moduleMetadata.recordView?.vardefs[fieldName].type != vardefs[fieldName].type) {
                return;
            }
            newRecord.attributes[fieldName] = prevRecord.attributes[fieldName];
        });
        return newRecord;
    }
    getViewFieldsObservable(meta) {
        return of(meta.recordView).pipe(map((recordMetadata) => {
            const fieldsMap = {};
            recordMetadata.panels.forEach(panel => {
                panel.rows.forEach(row => {
                    row.cols.forEach(col => {
                        const fieldName = col.name ?? col.fieldDefinition.name ?? '';
                        fieldsMap[fieldName] = col;
                    });
                });
            });
            Object.keys(recordMetadata.vardefs).forEach(fieldKey => {
                const vardef = recordMetadata.vardefs[fieldKey] ?? null;
                if (!vardef || isEmpty(vardef)) {
                    return;
                }
                // already defined. skip
                if (fieldsMap[fieldKey]) {
                    return;
                }
                if (vardef.type == 'relate') {
                    return;
                }
                fieldsMap[fieldKey] = {
                    name: fieldKey,
                    vardefBased: true,
                    label: vardef.vname ?? '',
                    type: vardef.type ?? '',
                    display: vardef.display ?? '',
                    fieldDefinition: vardef,
                    metadata: vardef.metadata ?? {},
                    logic: vardef.logic ?? {}
                };
            });
            return Object.values(fieldsMap);
        }));
    }
    static { this.ɵfac = function RecordConvertService_Factory(t) { return new (t || RecordConvertService)(i0.ɵɵinject(i1.SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordConvertService, factory: RecordConvertService.ɵfac, providedIn: 'root' }); }
}
export { RecordConvertService };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordConvertService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.SystemConfigStore }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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