/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, Input } from '@angular/core';
import { combineLatestWith, BehaviorSubject, of } from 'rxjs';
import { map, shareReplay } from 'rxjs/operators';
import { SelectionStatus, SortDirection } from 'common';
import { FieldManager } from '../../../services/record/field/field.manager';
import { LoadingBufferFactory } from '../../../services/ui/loading-buffer/loading-buffer.factory';
import * as i0 from "@angular/core";
import * as i1 from "../../../services/record/field/field.manager";
import * as i2 from "../../../services/ui/loading-buffer/loading-buffer.factory";
import * as i3 from "@angular/common";
import * as i4 from "@angular/cdk/table";
import * as i5 from "../../../fields/field.component";
import * as i6 from "../../sort-button/sort-button.component";
import * as i7 from "../../line-action-menu/line-action-menu.component";
import * as i8 from "../../loading-spinner/loading-spinner.component";
import * as i9 from "../../label/label.component";
import * as i10 from "../../popups/components/record-details-popup-button/record-details-popup-button.component";
function TableBodyComponent_ng_container_0_ng_container_3_th_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "th", 13);
} }
function TableBodyComponent_ng_container_0_ng_container_3_td_2_Template(rf, ctx) { if (rf & 1) {
    const _r15 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "td", 14)(1, "label", 15)(2, "input", 16);
    i0.ɵɵlistener("change", function TableBodyComponent_ng_container_0_ng_container_3_td_2_Template_input_change_2_listener() { const restoredCtx = i0.ɵɵrestoreView(_r15); const record_r13 = restoredCtx.$implicit; const ctx_r14 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r14.toggleSelection(record_r13["id"])); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(3, "span", 17);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const record_r13 = ctx.$implicit;
    const vm_r1 = i0.ɵɵnextContext(2).ngIf;
    const ctx_r12 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("checked", record_r13["id"] && vm_r1.selected[record_r13["id"]] || ctx_r12.allSelected(vm_r1.selectionStatus))("disabled", ctx_r12.allSelected(vm_r1.selectionStatus));
} }
function TableBodyComponent_ng_container_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0, 12);
    i0.ɵɵtemplate(1, TableBodyComponent_ng_container_0_ng_container_3_th_1_Template, 1, 0, "th", 7);
    i0.ɵɵtemplate(2, TableBodyComponent_ng_container_0_ng_container_3_td_2_Template, 4, 2, "td", 8);
    i0.ɵɵelementContainerEnd();
} }
function TableBodyComponent_ng_container_0_ng_container_4_th_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "th", 21);
} }
function TableBodyComponent_ng_container_0_ng_container_4_td_2_scrm_record_details_popup_button_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-record-details-popup-button", 24);
} if (rf & 2) {
    const record_r19 = i0.ɵɵnextContext().$implicit;
    const ctx_r20 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("record", record_r19)("columns", ctx_r20.popoverColumns);
} }
function TableBodyComponent_ng_container_0_ng_container_4_td_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "td", 22);
    i0.ɵɵtemplate(1, TableBodyComponent_ng_container_0_ng_container_4_td_2_scrm_record_details_popup_button_1_Template, 1, 2, "scrm-record-details-popup-button", 23);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r18 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r18.popoverColumns.length);
} }
function TableBodyComponent_ng_container_0_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0, 18);
    i0.ɵɵtemplate(1, TableBodyComponent_ng_container_0_ng_container_4_th_1_Template, 1, 0, "th", 19);
    i0.ɵɵtemplate(2, TableBodyComponent_ng_container_0_ng_container_4_td_2_Template, 2, 1, "td", 20);
    i0.ɵɵelementContainerEnd();
} }
function TableBodyComponent_ng_container_0_ng_container_5_th_1_scrm_sort_button_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-sort-button", 31);
} if (rf & 2) {
    const column_r22 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r25 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("state", ctx_r25.getFieldSort(column_r22));
} }
function TableBodyComponent_ng_container_0_ng_container_5_th_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "th", 28);
    i0.ɵɵelement(1, "scrm-label", 29);
    i0.ɵɵtemplate(2, TableBodyComponent_ng_container_0_ng_container_5_th_1_scrm_sort_button_2_Template, 1, 1, "scrm-sort-button", 30);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const column_r22 = i0.ɵɵnextContext().$implicit;
    const ctx_r23 = i0.ɵɵnextContext(2);
    let tmp_0_0;
    i0.ɵɵclassMap(((tmp_0_0 = "primary-table-header " + "column-" + (column_r22 == null ? null : column_r22.name)) !== null && tmp_0_0 !== undefined ? tmp_0_0 : "") + " " + ((tmp_0_0 = "column-type-" + (column_r22 == null ? null : column_r22.type)) !== null && tmp_0_0 !== undefined ? tmp_0_0 : ""));
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", column_r22.label)("module", ctx_r23.config.module || "");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r23.config.sort$ && column_r22.sortable);
} }
function TableBodyComponent_ng_container_0_ng_container_5_td_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "td", 14);
    i0.ɵɵelement(1, "scrm-field", 32);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const record_r28 = ctx.$implicit;
    const column_r22 = i0.ɵɵnextContext().$implicit;
    const ctx_r24 = i0.ɵɵnextContext(2);
    let tmp_0_0;
    i0.ɵɵclassMap(((tmp_0_0 = "column-" + (column_r22 == null ? null : column_r22.name)) !== null && tmp_0_0 !== undefined ? tmp_0_0 : "") + " " + ((tmp_0_0 = "column-type-" + (column_r22 == null ? null : column_r22.type)) !== null && tmp_0_0 !== undefined ? tmp_0_0 : ""));
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("mode", "list")("type", column_r22.type)("field", ctx_r24.getField(column_r22, record_r28))("record", record_r28);
} }
function TableBodyComponent_ng_container_0_ng_container_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0, 25);
    i0.ɵɵtemplate(1, TableBodyComponent_ng_container_0_ng_container_5_th_1_Template, 3, 5, "th", 26);
    i0.ɵɵtemplate(2, TableBodyComponent_ng_container_0_ng_container_5_td_2_Template, 2, 6, "td", 27);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const column_r22 = ctx.$implicit;
    i0.ɵɵproperty("cdkColumnDef", column_r22.name);
} }
function TableBodyComponent_ng_container_0_th_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "th", 13);
} }
function TableBodyComponent_ng_container_0_td_8_scrm_line_action_menu_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-line-action-menu", 34);
} if (rf & 2) {
    const record_r30 = i0.ɵɵnextContext().$implicit;
    const ctx_r31 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("config", ctx_r31.config.lineActions)("activeLineAction", ctx_r31.activeLineAction)("record", record_r30)("wrapperClass", "listview-actions")("klass", "icon-bar");
} }
function TableBodyComponent_ng_container_0_td_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "td", 14);
    i0.ɵɵtemplate(1, TableBodyComponent_ng_container_0_td_8_scrm_line_action_menu_1_Template, 1, 5, "scrm-line-action-menu", 33);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const record_r30 = ctx.$implicit;
    const ctx_r6 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", record_r30 && ctx_r6.config.lineActions);
} }
function TableBodyComponent_ng_container_0_tr_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "tr", 35);
} }
function TableBodyComponent_ng_container_0_tr_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "tr", 36);
} }
function TableBodyComponent_ng_container_0_div_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "p", 37);
    i0.ɵɵelement(2, "scrm-label", 38);
    i0.ɵɵelementEnd()();
} }
function TableBodyComponent_ng_container_0_div_12_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "scrm-loading-spinner", 39);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext().ngIf;
    i0.ɵɵclassProp("m-5", !vm_r1.records || vm_r1.records.length === 0);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("overlay", true);
} }
function TableBodyComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 1)(2, "table", 2);
    i0.ɵɵtemplate(3, TableBodyComponent_ng_container_0_ng_container_3_Template, 3, 0, "ng-container", 3);
    i0.ɵɵtemplate(4, TableBodyComponent_ng_container_0_ng_container_4_Template, 3, 0, "ng-container", 4);
    i0.ɵɵtemplate(5, TableBodyComponent_ng_container_0_ng_container_5_Template, 3, 1, "ng-container", 5);
    i0.ɵɵelementContainerStart(6, 6);
    i0.ɵɵtemplate(7, TableBodyComponent_ng_container_0_th_7_Template, 1, 0, "th", 7);
    i0.ɵɵtemplate(8, TableBodyComponent_ng_container_0_td_8_Template, 2, 1, "td", 8);
    i0.ɵɵelementContainerEnd();
    i0.ɵɵtemplate(9, TableBodyComponent_ng_container_0_tr_9_Template, 1, 0, "tr", 9);
    i0.ɵɵtemplate(10, TableBodyComponent_ng_container_0_tr_10_Template, 1, 0, "tr", 10);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(11, TableBodyComponent_ng_container_0_div_11_Template, 3, 0, "div", 0);
    i0.ɵɵtemplate(12, TableBodyComponent_ng_container_0_div_12_Template, 2, 3, "div", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const vm_r1 = ctx.ngIf;
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("dataSource", ctx_r0.config.dataSource)("trackBy", ctx_r0.trackRecord);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", vm_r1.selection);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.popoverColumns && ctx_r0.popoverColumns.length);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", vm_r1.columns);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("cdkHeaderRowDef", vm_r1.displayedColumns);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("cdkRowDefColumns", vm_r1.displayedColumns);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !vm_r1.loading && vm_r1.records.length === 0);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", vm_r1.loading);
} }
class TableBodyComponent {
    constructor(fieldManager, loadingBufferFactory) {
        this.fieldManager = fieldManager;
        this.loadingBufferFactory = loadingBufferFactory;
        this.activeAction = new BehaviorSubject('');
        this.activeAction$ = this.activeAction.asObservable();
        this.maxColumns = 4;
        this.subs = [];
        this.currentPage = 1;
        this.pageSize = 20;
        this.loadingBuffer = this.loadingBufferFactory.create('table_loading_display_delay');
    }
    ngOnInit() {
        const selection$ = this.config.selection$ || of(null).pipe(shareReplay(1));
        let loading$ = this.initLoading();
        this.activeLineAction = {
            activeAction$: this.activeAction$,
            getActiveAction: () => {
                return this.activeAction.getValue();
            },
            setActiveAction: (key) => {
                this.activeAction.next(key);
            },
            resetActiveAction: () => {
                this.activeAction.next('');
            }
        };
        this.subs.push(this.config.pagination.pagination$.subscribe(pagination => {
            this.pageSize = pagination.pageSize;
            this.currentPage = Math.ceil(pagination.pageLast / pagination.pageSize);
        }));
        this.vm$ = this.config.columns.pipe(combineLatestWith(selection$, this.config.maxColumns$, this.config.dataSource.connect(null), loading$), map(([columns, selection, maxColumns, records, loading]) => {
            const displayedColumns = [];
            this.maxColumns = maxColumns;
            const columnsDefs = this.buildDisplayColumns(columns);
            this.popoverColumns = this.buildHiddenColumns(columns, columnsDefs);
            if (selection) {
                displayedColumns.push('checkbox');
            }
            if (this.popoverColumns && this.popoverColumns.length) {
                displayedColumns.push('show-more');
            }
            displayedColumns.push(...columnsDefs);
            displayedColumns.push('line-actions');
            const selected = selection && selection.selected || {};
            const selectionStatus = selection && selection.status || SelectionStatus.NONE;
            records.forEach((record, index) => {
                if (!record.metadata) {
                    record.metadata = {};
                }
                record.metadata.queryParams = {
                    offset: (index + 1) + ((this.currentPage - 1) * this.pageSize)
                };
            });
            return {
                columns,
                selection,
                selected,
                selectionStatus,
                displayedColumns,
                records: records || [],
                loading
            };
        }));
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    toggleSelection(id) {
        this.config.toggleRecordSelection(id);
    }
    allSelected(status) {
        return status === SelectionStatus.ALL;
    }
    buildDisplayColumns(metaFields) {
        let i = 0;
        let hasLinkField = false;
        const displayedColumns = [];
        const fields = metaFields.filter(function (field) {
            return !field.hasOwnProperty('default')
                || (field.hasOwnProperty('default') && field.default === true);
        });
        while (i < this.maxColumns && i < fields.length) {
            displayedColumns.push(fields[i].name);
            hasLinkField = hasLinkField || fields[i].link;
            i++;
        }
        if (!hasLinkField && (this.maxColumns < fields.length)) {
            for (i = this.maxColumns; i < fields.length; i++) {
                if (fields[i].link) {
                    displayedColumns.splice(-1, 1);
                    displayedColumns.push(fields[i].name);
                    break;
                }
            }
        }
        return displayedColumns;
    }
    buildHiddenColumns(metaFields, displayedColumns) {
        const fields = metaFields.filter(function (field) {
            return !field.hasOwnProperty('default')
                || (field.hasOwnProperty('default') && field.default === true);
        });
        let missingFields = [];
        for (let i = 0; i < fields.length; i++) {
            if (displayedColumns.indexOf(fields[i].name) === -1) {
                missingFields.push(fields[i].name);
            }
        }
        let hiddenColumns = fields.filter(obj => missingFields.includes(obj.name));
        return hiddenColumns;
    }
    getFieldSort(field) {
        return {
            getSortDirection: () => this.config.sort$.pipe(map((sort) => {
                let direction = SortDirection.NONE;
                if (sort.orderBy === field.name) {
                    direction = sort.sortOrder;
                }
                return direction;
            })),
            changeSortDirection: (direction) => {
                this.config.updateSorting(field.name, direction);
            }
        };
    }
    getField(column, record) {
        if (!column || !record) {
            return null;
        }
        return this.fieldManager.addField(record, column);
    }
    initLoading() {
        let loading$ = of(false).pipe(shareReplay(1));
        if (this.config.loading$) {
            this.subs.push(this.config.loading$.subscribe(loading => {
                this.loadingBuffer.updateLoading(loading);
            }));
            loading$ = this.loadingBuffer.loading$;
        }
        return loading$;
    }
    trackRecord(index, item) {
        return item?.id ?? '';
    }
    static { this.ɵfac = function TableBodyComponent_Factory(t) { return new (t || TableBodyComponent)(i0.ɵɵdirectiveInject(i1.FieldManager), i0.ɵɵdirectiveInject(i2.LoadingBufferFactory)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TableBodyComponent, selectors: [["scrm-table-body"]], inputs: { config: "config" }, decls: 2, vars: 3, consts: [[4, "ngIf"], [1, "position-relative", "d-flex", "flex-column"], ["cdk-table", "", "aria-describedby", "table-body", 1, "list-view-table", "striped-table", "table", 3, "dataSource", "trackBy"], ["cdkColumnDef", "checkbox", 4, "ngIf"], ["cdkColumnDef", "show-more", 4, "ngIf"], [3, "cdkColumnDef", 4, "ngFor", "ngForOf"], ["cdkColumnDef", "line-actions"], ["cdk-header-cell", "", "scope", "col", "class", "primary-table-header", 4, "cdkHeaderCellDef"], ["cdk-cell", "", 4, "cdkCellDef"], ["cdk-header-row", "", 4, "cdkHeaderRowDef"], ["cdk-row", "", 4, "cdkRowDef", "cdkRowDefColumns"], [3, "m-5", 4, "ngIf"], ["cdkColumnDef", "checkbox"], ["cdk-header-cell", "", "scope", "col", 1, "primary-table-header"], ["cdk-cell", ""], [1, "checkbox-container"], ["type", "checkbox", "aria-hidden", "true", 3, "checked", "disabled", "change"], [1, "checkmark"], ["cdkColumnDef", "show-more"], ["cdk-header-cell", "", "scope", "col", "class", "primary-table-header show-more-column", 4, "cdkHeaderCellDef"], ["cdk-cell", "", "class", "show-more-column", 4, "cdkCellDef"], ["cdk-header-cell", "", "scope", "col", 1, "primary-table-header", "show-more-column"], ["cdk-cell", "", 1, "show-more-column"], [3, "record", "columns", 4, "ngIf"], [3, "record", "columns"], [3, "cdkColumnDef"], ["cdk-header-cell", "", "scope", "col", 3, "class", 4, "cdkHeaderCellDef"], ["cdk-cell", "", 3, "class", 4, "cdkCellDef"], ["cdk-header-cell", "", "scope", "col"], [3, "labelKey", "module"], [3, "state", 4, "ngIf"], [3, "state"], [3, "mode", "type", "field", "record"], [3, "config", "activeLineAction", "record", "wrapperClass", "klass", 4, "ngIf"], [3, "config", "activeLineAction", "record", "wrapperClass", "klass"], ["cdk-header-row", ""], ["cdk-row", ""], [1, "lead", "text-center", "pt-3"], ["labelKey", "MSG_LIST_VIEW_NO_RESULTS_BASIC"], [3, "overlay"]], template: function TableBodyComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, TableBodyComponent_ng_container_0_Template, 13, 9, "ng-container", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i3.NgForOf, i3.NgIf, i4.CdkTable, i4.CdkRowDef, i4.CdkCellDef, i4.CdkHeaderCellDef, i4.CdkColumnDef, i4.CdkCell, i4.CdkRow, i4.CdkHeaderCell, i4.CdkHeaderRow, i4.CdkHeaderRowDef, i5.FieldComponent, i6.SortButtonComponent, i7.LineActionMenuComponent, i8.LoadingSpinnerComponent, i9.LabelComponent, i10.RecordDetailsPopupButtonComponent, i3.AsyncPipe], encapsulation: 2 }); }
}
export { TableBodyComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TableBodyComponent, [{
        type: Component,
        args: [{ selector: 'scrm-table-body', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n\n<ng-container *ngIf=\"(vm$ | async) as vm\">\n    <div class=\"position-relative d-flex flex-column\">\n        <table cdk-table [dataSource]=\"config.dataSource\" [trackBy]=\"trackRecord\"\n               aria-describedby=\"table-body\"\n               class=\"list-view-table striped-table table\">\n\n            <ng-container cdkColumnDef=\"checkbox\" *ngIf=\"vm.selection\">\n\n                <th cdk-header-cell scope=\"col\" *cdkHeaderCellDef class=\"primary-table-header\"></th>\n\n                <td cdk-cell *cdkCellDef=\"let record\">\n                    <label class=\"checkbox-container\">\n                        <input type=\"checkbox\"\n                               [checked]=\"(record['id'] && vm.selected[record['id']]) || allSelected(vm.selectionStatus) \"\n                               (change)=\"toggleSelection(record['id'])\"\n                               [disabled]=\"allSelected(vm.selectionStatus)\"\n                               aria-hidden=\"true\">\n                        <span class=\"checkmark\"></span>\n                    </label>\n                </td>\n\n            </ng-container>\n\n            <ng-container cdkColumnDef=\"show-more\" *ngIf=\"popoverColumns && popoverColumns.length\">\n\n                <th cdk-header-cell scope=\"col\" *cdkHeaderCellDef class=\"primary-table-header show-more-column\"></th>\n\n                <td cdk-cell *cdkCellDef=\"let record\" class=\"show-more-column\">\n                    <scrm-record-details-popup-button [record]=\"record\" [columns]=\"popoverColumns\"\n                                                      *ngIf=\"popoverColumns.length\"></scrm-record-details-popup-button>\n                </td>\n\n            </ng-container>\n\n            <ng-container *ngFor=\"let column of vm.columns\" [cdkColumnDef]=\"column.name\">\n\n                <th cdk-header-cell\n                    *cdkHeaderCellDef\n                    scope=\"col\"\n                    [class]=\"('primary-table-header ' + 'column-' + column?.name ?? '') + ' ' + ('column-type-' + column?.type ?? '')\">\n\n                    <scrm-label [labelKey]=\"column.label\" [module]=\"config.module || ''\"></scrm-label>\n                    <scrm-sort-button *ngIf=\"config.sort$ && column.sortable\"\n                                      [state]=\"getFieldSort(column)\">\n                    </scrm-sort-button>\n\n                </th>\n\n                <td cdk-cell *cdkCellDef=\"let record\" [class]=\"('column-' + column?.name ?? '') + ' ' + ('column-type-' + column?.type ?? '')\">\n                    <scrm-field [mode]=\"'list'\"\n                                [type]=\"column.type\"\n                                [field]=\"getField(column, record)\"\n                                [record]=\"record\">\n                    </scrm-field>\n                </td>\n\n            </ng-container>\n\n            <ng-container cdkColumnDef=\"line-actions\">\n\n                <th cdk-header-cell scope=\"col\" *cdkHeaderCellDef class=\"primary-table-header\"></th>\n\n                <td cdk-cell *cdkCellDef=\"let record\">\n                    <scrm-line-action-menu *ngIf=\"record && config.lineActions\"\n                                           [config]=\"config.lineActions\"\n                                           [activeLineAction]=\"activeLineAction\"\n                                           [record]=\"record\"\n                                           [wrapperClass]=\"'listview-actions'\"\n                                           [klass]=\"'icon-bar'\">\n                    </scrm-line-action-menu>\n                </td>\n\n            </ng-container>\n\n            <tr cdk-header-row *cdkHeaderRowDef=\"vm.displayedColumns\"></tr>\n            <tr cdk-row *cdkRowDef=\"let row; columns: vm.displayedColumns;\"></tr>\n\n        </table>\n\n        <div *ngIf=\"!vm.loading && vm.records.length === 0\">\n            <p class=\"lead text-center pt-3\">\n                <scrm-label labelKey=\"MSG_LIST_VIEW_NO_RESULTS_BASIC\"></scrm-label>\n            </p>\n        </div>\n        <div *ngIf=\"vm.loading\" [class.m-5]=\"!vm.records || vm.records.length === 0\">\n            <scrm-loading-spinner [overlay]=\"true\"></scrm-loading-spinner>\n        </div>\n    </div>\n</ng-container>\n" }]
    }], function () { return [{ type: i1.FieldManager }, { type: i2.LoadingBufferFactory }]; }, { config: [{
            type: Input
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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