/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, ElementRef, HostListener, signal, ViewChild } from '@angular/core';
import { combineLatestWith } from 'rxjs';
import { filter, map, take } from 'rxjs/operators';
import { NavbarAbstract } from '../navbar.abstract';
import { transition, trigger, useAnimation } from '@angular/animations';
import { backInDown } from 'ng-animate';
import { ActionNameMapper } from '../../../services/navigation/action-name-mapper/action-name-mapper.service';
import { SystemConfigStore } from '../../../store/system-config/system-config.store';
import { NavigationStore } from '../../../store/navigation/navigation.store';
import { UserPreferenceStore } from '../../../store/user-preference/user-preference.store';
import { ScreenSize, ScreenSizeObserverService } from '../../../services/ui/screen-size-observer/screen-size-observer.service';
import { RouteConverter } from '../../../services/navigation/route-converter/route-converter.service';
import { LanguageStore } from '../../../store/language/language.store';
import { ModuleNavigation } from '../../../services/navigation/module-navigation/module-navigation.service';
import { ModuleNameMapper } from '../../../services/navigation/module-name-mapper/module-name-mapper.service';
import { AppStateStore } from '../../../store/app-state/app-state.store';
import { AuthService } from '../../../services/auth/auth.service';
import { ready } from 'common';
import { AsyncActionService } from '../../../services/process/processes/async-action/async-action';
import { NotificationStore } from "../../../store/notification/notification.store";
import { GlobalRecentlyViewedStore } from "../../../store/global-recently-viewed/global-recently-viewed.store";
import { GlobalSearch } from "../../../services/navigation/global-search/global-search.service";
import { BreakpointObserver, Breakpoints } from "@angular/cdk/layout";
import { SearchBarComponent } from "../../search-bar/search-bar.component";
import { NavigationEnd, Router } from "@angular/router";
import { NgbDropdown } from "@ng-bootstrap/ng-bootstrap";
import * as i0 from "@angular/core";
import * as i1 from "../../../store/navigation/navigation.store";
import * as i2 from "../../../store/language/language.store";
import * as i3 from "../../../store/user-preference/user-preference.store";
import * as i4 from "../../../store/system-config/system-config.store";
import * as i5 from "../../../store/app-state/app-state.store";
import * as i6 from "../../../services/auth/auth.service";
import * as i7 from "../../../services/navigation/module-navigation/module-navigation.service";
import * as i8 from "../../../services/ui/screen-size-observer/screen-size-observer.service";
import * as i9 from "../../../services/process/processes/async-action/async-action";
import * as i10 from "../../../store/notification/notification.store";
import * as i11 from "../../../store/global-recently-viewed/global-recently-viewed.store";
import * as i12 from "../../../services/navigation/global-search/global-search.service";
import * as i13 from "@angular/cdk/layout";
import * as i14 from "@angular/router";
import * as i15 from "@angular/common";
import * as i16 from "../../logo/logo.component";
import * as i17 from "../../logout/logout.component";
import * as i18 from "@ng-bootstrap/ng-bootstrap";
import * as i19 from "../../image/image.component";
import * as i20 from "../../label/label.component";
import * as i21 from "../../../containers/notifications/notifications.component";
import * as i22 from "../../search-bar/search-bar.component";
import * as i23 from "../recently-viewed/recently-viewed.component";
import * as i24 from "../menu-item/menu-item.component";
import * as i25 from "../home-menu-item/home-menu-item.component";
import * as i26 from "../grouped-menu-item/grouped-menu-item.component";
import * as i27 from "../menu-items-list/menu-items-list.component";
const _c0 = ["mobileGlobalLinkTitle"];
const _c1 = ["searchTerm"];
const _c2 = ["alertDropdown"];
function BaseNavbarComponent_div_0_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "nav", 5)(1, "div", 6)(2, "ul", 7)(3, "li", 8);
    i0.ɵɵtext(4, "\u00A0 ");
    i0.ɵɵelementEnd()()()();
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "nav", 9)(2, "div", 10)(3, "ul", 7)(4, "li", 11);
    i0.ɵɵelement(5, "scrm-logo-ui");
    i0.ɵɵelementEnd()()()();
    i0.ɵɵelementContainerEnd();
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_2_li_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 29);
    i0.ɵɵelement(1, "scrm-menu-item", 30);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r9 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("item", ctx_r9.navbar.current);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_2_li_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 31);
    i0.ɵɵelement(1, "scrm-grouped-menu-item", 32);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r10 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("item", ctx_r10.navbar.current)("subNavCollapse", ctx_r10.subNavCollapse);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_2_ng_container_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainer(0);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_2_ng_template_19_ng_container_0_hr_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "hr");
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_2_ng_template_19_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 34);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, BaseNavbarComponent_div_0_ng_container_2_ng_container_2_ng_template_19_ng_container_0_hr_3_Template, 1, 0, "hr", 3);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const globalAction_r15 = ctx.$implicit;
    const first_r16 = ctx.first;
    const last_r17 = ctx.last;
    i0.ɵɵadvance(1);
    i0.ɵɵpropertyInterpolate("href", globalAction_r15.link.url, i0.ɵɵsanitizeUrl);
    i0.ɵɵpropertyInterpolate("target", globalAction_r15.link.target);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1("", globalAction_r15.link.label, " ");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", last_r17 === true || first_r16 === true);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_2_ng_template_19_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, BaseNavbarComponent_div_0_ng_container_2_ng_container_2_ng_template_19_ng_container_0_Template, 4, 4, "ng-container", 33);
} if (rf & 2) {
    const ctx_r13 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("ngForOf", ctx_r13.navbar.globalActions);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    const _r20 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "ul", 12)(2, "div", 13)(3, "button", 14);
    i0.ɵɵlistener("click", function BaseNavbarComponent_div_0_ng_container_2_ng_container_2_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r20); const ctx_r19 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r19.toggleSidebar()); });
    i0.ɵɵelement(4, "scrm-image", 15);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "nav", 16)(6, "ul", 17);
    i0.ɵɵtemplate(7, BaseNavbarComponent_div_0_ng_container_2_ng_container_2_li_7_Template, 2, 1, "li", 18);
    i0.ɵɵtemplate(8, BaseNavbarComponent_div_0_ng_container_2_ng_container_2_li_8_Template, 2, 2, "li", 19);
    i0.ɵɵelementEnd()()();
    i0.ɵɵelementStart(9, "div", 20);
    i0.ɵɵtemplate(10, BaseNavbarComponent_div_0_ng_container_2_ng_container_2_ng_container_10_Template, 1, 0, "ng-container", 21);
    i0.ɵɵelementStart(11, "div", 22)(12, "li", 23)(13, "a", 24, 25);
    i0.ɵɵelement(15, "scrm-image", 26);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(16, "div", 27)(17, "span", 28);
    i0.ɵɵtext(18);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(19, BaseNavbarComponent_div_0_ng_container_2_ng_container_2_ng_template_19_Template, 1, 1, "ng-template", 2);
    i0.ɵɵelement(20, "scrm-logout-ui");
    i0.ɵɵelementEnd()()()()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const _r12 = i0.ɵɵreference(14);
    i0.ɵɵnextContext(2);
    const _r4 = i0.ɵɵreference(4);
    const ctx_r7 = i0.ɵɵnextContext();
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("ngClass", ctx_r7.isSmallScreen() && ctx_r7.isSearchBoxVisible() ? "d-none" : "d-block");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r7.navbar.current && !ctx_r7.navbar.current.isGroupedMenu);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", (ctx_r7.navbar.current == null ? null : ctx_r7.navbar.current.submenu) && ctx_r7.navbar.current.isGroupedMenu);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngTemplateOutlet", _r4);
    i0.ɵɵadvance(6);
    i0.ɵɵstyleProp("min-width", _r12.offsetWidth, "px");
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate2("", ctx_r7.navbar.currentUser.firstName, " ", ctx_r7.navbar.currentUser.lastName, "");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r7.navbar.globalActions);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_4_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "li", 44);
    i0.ɵɵelement(2, "scrm-grouped-menu-item", 45);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r25 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("item", ctx_r25.navbar.current)("subNavCollapse", ctx_r25.subNavCollapse)("index", 1);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_4_li_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 46);
    i0.ɵɵelement(1, "scrm-menu-item", 47);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r26 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("item", ctx_r26.navbar.current)("index", 1);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_4_li_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 44);
    i0.ɵɵelement(1, "scrm-grouped-menu-item", 45);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r28 = ctx.$implicit;
    const i_r29 = ctx.index;
    const ctx_r27 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("item", item_r28)("subNavCollapse", ctx_r27.subNavCollapse)("index", i_r29 + 2);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "ul", 40);
    i0.ɵɵtemplate(2, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_4_ng_container_2_Template, 3, 3, "ng-container", 3);
    i0.ɵɵtemplate(3, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_4_li_3_Template, 2, 2, "li", 41);
    i0.ɵɵtemplate(4, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_4_li_4_Template, 2, 3, "li", 42);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(5, "scrm-menu-items-list", 43);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r21 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r21.navbar.current && ctx_r21.navbar.current.isGroupedMenu);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r21.navbar.current && !ctx_r21.navbar.current.isGroupedMenu);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r21.navbar.menu);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("items", ctx_r21.navbar.all.modules)("index", ctx_r21.navbar.menu.length + 2);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_5_li_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 46);
    i0.ɵɵelement(1, "scrm-menu-item", 47);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r30 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("item", ctx_r30.navbar.current)("index", 1);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_5_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "li", 44);
    i0.ɵɵelement(2, "scrm-grouped-menu-item", 45);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r31 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("item", ctx_r31.navbar.current)("subNavCollapse", ctx_r31.subNavCollapse)("index", 1);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_5_li_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 50);
    i0.ɵɵelement(1, "scrm-menu-item", 47);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r33 = ctx.$implicit;
    const i_r34 = ctx.index;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("item", item_r33)("index", i_r34 + 2);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "ul", 7);
    i0.ɵɵtemplate(2, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_5_li_2_Template, 2, 2, "li", 41);
    i0.ɵɵtemplate(3, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_5_ng_container_3_Template, 3, 3, "ng-container", 3);
    i0.ɵɵtemplate(4, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_5_li_4_Template, 2, 2, "li", 48);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(5, "scrm-menu-items-list", 49);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r22 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r22.navbar.current && !ctx_r22.navbar.current.isGroupedMenu);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", (ctx_r22.navbar.current == null ? null : ctx_r22.navbar.current.submenu) && ctx_r22.navbar.current.isGroupedMenu);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r22.navbar.menu);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("items", ctx_r22.navbar.all.modules)("index", ctx_r22.navbar.menu.length + 2);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainer(0);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_15_ng_container_1_hr_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "hr");
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_15_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 34);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_15_ng_container_1_hr_3_Template, 1, 0, "hr", 3);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const globalAction_r36 = ctx.$implicit;
    const first_r37 = ctx.first;
    const last_r38 = ctx.last;
    i0.ɵɵadvance(1);
    i0.ɵɵpropertyInterpolate("href", globalAction_r36.link.url, i0.ɵɵsanitizeUrl);
    i0.ɵɵpropertyInterpolate("target", globalAction_r36.link.target);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1("", globalAction_r36.link.label, " ");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", last_r38 === true || first_r37 === true);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_15_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_15_ng_container_1_Template, 4, 4, "ng-container", 33);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r24 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r24.navbar.globalActions);
} }
function BaseNavbarComponent_div_0_ng_container_2_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "nav", 35)(2, "div", 36);
    i0.ɵɵelement(3, "scrm-home-menu-item", 37);
    i0.ɵɵtemplate(4, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_4_Template, 6, 5, "ng-container", 3);
    i0.ɵɵtemplate(5, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_5_Template, 6, 5, "ng-container", 3);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_6_Template, 1, 0, "ng-container", 21);
    i0.ɵɵelementStart(7, "div", 22)(8, "ul", 7)(9, "li", 23)(10, "a", 38);
    i0.ɵɵelement(11, "scrm-image", 26);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(12, "div", 39)(13, "span", 28);
    i0.ɵɵtext(14);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(15, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_ng_container_15_Template, 2, 1, "ng-container", 3);
    i0.ɵɵelement(16, "scrm-logout-ui");
    i0.ɵɵelementEnd()()()()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext(2).ngIf;
    const _r4 = i0.ɵɵreference(4);
    const ctx_r8 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngbCollapse", ctx_r8.mainNavCollapse);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("active", vm_r1.appState.module && vm_r1.appState.module === "home")("route", ctx_r8.getHomePage());
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", vm_r1.userPreferences["navigation_paradigm"] == "gm");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", vm_r1.userPreferences["navigation_paradigm"] != "gm");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngTemplateOutlet", _r4);
    i0.ɵɵadvance(8);
    i0.ɵɵtextInterpolate2("", ctx_r8.navbar.currentUser.firstName, " ", ctx_r8.navbar.currentUser.lastName, "");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r8.navbar.globalActions);
} }
function BaseNavbarComponent_div_0_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, BaseNavbarComponent_div_0_ng_container_2_ng_container_1_Template, 6, 0, "ng-container", 3);
    i0.ɵɵtemplate(2, BaseNavbarComponent_div_0_ng_container_2_ng_container_2_Template, 21, 9, "ng-container", 3);
    i0.ɵɵtemplate(3, BaseNavbarComponent_div_0_ng_container_2_ng_container_3_Template, 17, 9, "ng-container", 3);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r3.isUserLoggedIn);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r3.isUserLoggedIn && ctx_r3.mobileNavbar);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r3.isUserLoggedIn && !ctx_r3.mobileNavbar);
} }
function BaseNavbarComponent_div_0_ng_template_3_ng_container_7_li_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 73);
    i0.ɵɵelement(2, "scrm-label", 74);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const moduleQuickAction_r46 = i0.ɵɵnextContext().$implicit;
    const ctx_r47 = i0.ɵɵnextContext(4);
    let tmp_1_0;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("routerLink", moduleQuickAction_r46.url)("queryParams", (tmp_1_0 = moduleQuickAction_r46 == null ? null : moduleQuickAction_r46.params) !== null && tmp_1_0 !== undefined ? tmp_1_0 : null);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", moduleQuickAction_r46.labelKey)("module", ctx_r47.navbar.current.module);
} }
function BaseNavbarComponent_div_0_ng_template_3_ng_container_7_li_3_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    const _r52 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 75);
    i0.ɵɵlistener("click", function BaseNavbarComponent_div_0_ng_template_3_ng_container_7_li_3_ng_container_2_Template_a_click_1_listener() { i0.ɵɵrestoreView(_r52); const moduleQuickAction_r46 = i0.ɵɵnextContext().$implicit; const ctx_r50 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r50.handleProcess(moduleQuickAction_r46)); });
    i0.ɵɵelement(2, "scrm-label", 74);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const moduleQuickAction_r46 = i0.ɵɵnextContext().$implicit;
    const ctx_r48 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("labelKey", moduleQuickAction_r46.labelKey)("module", ctx_r48.navbar.current.module);
} }
function BaseNavbarComponent_div_0_ng_template_3_ng_container_7_li_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 72);
    i0.ɵɵtemplate(1, BaseNavbarComponent_div_0_ng_template_3_ng_container_7_li_3_ng_container_1_Template, 3, 4, "ng-container", 3);
    i0.ɵɵtemplate(2, BaseNavbarComponent_div_0_ng_template_3_ng_container_7_li_3_ng_container_2_Template, 3, 2, "ng-container", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const moduleQuickAction_r46 = ctx.$implicit;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !moduleQuickAction_r46.process);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", moduleQuickAction_r46.process);
} }
function BaseNavbarComponent_div_0_ng_template_3_ng_container_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "li", 69);
    i0.ɵɵelement(2, "scrm-label", 70);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, BaseNavbarComponent_div_0_ng_template_3_ng_container_7_li_3_Template, 3, 2, "li", 71);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r41 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("module", ctx_r41.navbar.current.module);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r41.currentQuickActions);
} }
function BaseNavbarComponent_div_0_ng_template_3_ng_container_8_li_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 73);
    i0.ɵɵelement(2, "scrm-label", 74);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const quickAction_r55 = i0.ɵɵnextContext().$implicit;
    let tmp_1_0;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("routerLink", quickAction_r55.url)("queryParams", (tmp_1_0 = quickAction_r55 == null ? null : quickAction_r55.params) !== null && tmp_1_0 !== undefined ? tmp_1_0 : null);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", quickAction_r55.labelKey)("module", quickAction_r55.module);
} }
function BaseNavbarComponent_div_0_ng_template_3_ng_container_8_li_3_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    const _r61 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 75);
    i0.ɵɵlistener("click", function BaseNavbarComponent_div_0_ng_template_3_ng_container_8_li_3_ng_container_2_Template_a_click_1_listener() { i0.ɵɵrestoreView(_r61); const quickAction_r55 = i0.ɵɵnextContext().$implicit; const ctx_r59 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r59.handleProcess(quickAction_r55)); });
    i0.ɵɵelement(2, "scrm-label", 74);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const quickAction_r55 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("labelKey", quickAction_r55.labelKey)("module", quickAction_r55.module);
} }
function BaseNavbarComponent_div_0_ng_template_3_ng_container_8_li_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 72);
    i0.ɵɵtemplate(1, BaseNavbarComponent_div_0_ng_template_3_ng_container_8_li_3_ng_container_1_Template, 3, 4, "ng-container", 3);
    i0.ɵɵtemplate(2, BaseNavbarComponent_div_0_ng_template_3_ng_container_8_li_3_ng_container_2_Template, 3, 2, "ng-container", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const quickAction_r55 = ctx.$implicit;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !quickAction_r55.process);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", quickAction_r55.process);
} }
const _c3 = function () { return []; };
function BaseNavbarComponent_div_0_ng_template_3_ng_container_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "li", 69);
    i0.ɵɵelement(2, "scrm-label", 76);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, BaseNavbarComponent_div_0_ng_template_3_ng_container_8_li_3_Template, 3, 2, "li", 71);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r42 = i0.ɵɵnextContext(3);
    let tmp_0_0;
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngForOf", (tmp_0_0 = ctx_r42 == null ? null : ctx_r42.navigation == null ? null : ctx_r42.navigation.quickActions) !== null && tmp_0_0 !== undefined ? tmp_0_0 : i0.ɵɵpureFunction0(1, _c3));
} }
function BaseNavbarComponent_div_0_ng_template_3_div_24_ng_container_6_span_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const notificationCount_r65 = i0.ɵɵnextContext(2).ngIf;
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(notificationCount_r65);
} }
function BaseNavbarComponent_div_0_ng_template_3_div_24_ng_container_6_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 83);
    i0.ɵɵtemplate(1, BaseNavbarComponent_div_0_ng_template_3_div_24_ng_container_6_span_1_ng_container_1_Template, 2, 1, "ng-container", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const notificationCount_r65 = i0.ɵɵnextContext().ngIf;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", notificationCount_r65 > 0);
} }
function BaseNavbarComponent_div_0_ng_template_3_div_24_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, BaseNavbarComponent_div_0_ng_template_3_div_24_ng_container_6_span_1_Template, 2, 1, "span", 82);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const notificationCount_r65 = ctx.ngIf;
    let tmp_0_0;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", (tmp_0_0 = notificationCount_r65) !== null && tmp_0_0 !== undefined ? tmp_0_0 : false);
} }
function BaseNavbarComponent_div_0_ng_template_3_div_24_Template(rf, ctx) { if (rf & 1) {
    const _r71 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 77, 78)(2, "ul", 53)(3, "li", 23)(4, "a", 79);
    i0.ɵɵlistener("mouseenter", function BaseNavbarComponent_div_0_ng_template_3_div_24_Template_a_mouseenter_4_listener() { i0.ɵɵrestoreView(_r71); const ctx_r70 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r70.markAsRead()); });
    i0.ɵɵelement(5, "scrm-image", 80);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, BaseNavbarComponent_div_0_ng_template_3_div_24_ng_container_6_Template, 2, 1, "ng-container", 3);
    i0.ɵɵpipe(7, "async");
    i0.ɵɵelementStart(8, "div", 81);
    i0.ɵɵlistener("click", function BaseNavbarComponent_div_0_ng_template_3_div_24_Template_div_click_8_listener() { i0.ɵɵrestoreView(_r71); const ctx_r72 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r72.closeNotificationMenu()); });
    i0.ɵɵelement(9, "scrm-notifications");
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const ctx_r44 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(6);
    i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(7, 1, ctx_r44.notificationCount$));
} }
function BaseNavbarComponent_div_0_ng_template_3_Template(rf, ctx) { if (rf & 1) {
    const _r74 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 51)(1, "div", 52)(2, "ul", 53)(3, "li", 23)(4, "a", 54);
    i0.ɵɵelement(5, "scrm-image", 55);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "ul", 56);
    i0.ɵɵtemplate(7, BaseNavbarComponent_div_0_ng_template_3_ng_container_7_Template, 4, 2, "ng-container", 3);
    i0.ɵɵtemplate(8, BaseNavbarComponent_div_0_ng_template_3_ng_container_8_Template, 4, 2, "ng-container", 3);
    i0.ɵɵelementEnd()()()();
    i0.ɵɵelementStart(9, "div", 57)(10, "ul", 53)(11, "li", 23)(12, "a", 58);
    i0.ɵɵelement(13, "scrm-image", 59);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(14, "div", 60);
    i0.ɵɵelement(15, "scrm-recently-viewed", 61);
    i0.ɵɵpipe(16, "slice");
    i0.ɵɵpipe(17, "async");
    i0.ɵɵelementEnd()()()();
    i0.ɵɵelementStart(18, "div", 62)(19, "a", 63);
    i0.ɵɵlistener("click", function BaseNavbarComponent_div_0_ng_template_3_Template_a_click_19_listener() { i0.ɵɵrestoreView(_r74); const ctx_r73 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r73.openSearchBox()); });
    i0.ɵɵelement(20, "scrm-image", 64);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(21, "div", 65)(22, "scrm-search-bar", 66, 67);
    i0.ɵɵlistener("isSearchVisible", function BaseNavbarComponent_div_0_ng_template_3_Template_scrm_search_bar_isSearchVisible_22_listener($event) { i0.ɵɵrestoreView(_r74); const ctx_r75 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r75.closeSearchBox($event)); })("searchExpression", function BaseNavbarComponent_div_0_ng_template_3_Template_scrm_search_bar_searchExpression_22_listener($event) { i0.ɵɵrestoreView(_r74); const ctx_r76 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r76.search($event)); });
    i0.ɵɵelementEnd()()();
    i0.ɵɵtemplate(24, BaseNavbarComponent_div_0_ng_template_3_div_24_Template, 10, 3, "div", 68);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext().ngIf;
    const ctx_r5 = i0.ɵɵnextContext();
    let tmp_2_0;
    let tmp_3_0;
    i0.ɵɵadvance(6);
    i0.ɵɵclassProp("dropdown-menu-right", !ctx_r5.mobileNavbar)("dropdown-menu-right-center", ctx_r5.mobileNavbar);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ((tmp_2_0 = ctx_r5.navbar == null ? null : ctx_r5.navbar.current == null ? null : ctx_r5.navbar.current.module) !== null && tmp_2_0 !== undefined ? tmp_2_0 : "") && ctx_r5.currentQuickActions.length);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ((tmp_3_0 = ctx_r5 == null ? null : ctx_r5.navigation == null ? null : ctx_r5.navigation.quickActions) !== null && tmp_3_0 !== undefined ? tmp_3_0 : i0.ɵɵpureFunction0(23, _c3)).length);
    i0.ɵɵadvance(6);
    i0.ɵɵclassProp("dropdown-menu-right", !ctx_r5.mobileNavbar);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("menuItems", i0.ɵɵpipeBind3(16, 17, i0.ɵɵpipeBind1(17, 21, ctx_r5.recentlyViewed$), 0, ctx_r5.recentlyViewedCount));
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngClass", ctx_r5.isSearchBoxVisible() ? "d-none" : "d-block");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", ctx_r5.isSearchBoxVisible() ? "d-block" : "d-none")("@mobileSearchBarAnm", undefined);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", "LBL_SEARCH")("klass", "search-bar-global")("searchTrigger", "enter")("isMobile", ctx_r5.isSmallScreen());
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r5.notificationsEnabled && ctx_r5.checkAppStrings(vm_r1.appStrings) && ctx_r5.arePreferencesInitialized(vm_r1.userPreferences));
} }
function BaseNavbarComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, BaseNavbarComponent_div_0_ng_template_1_Template, 5, 0, "ng-template", 2);
    i0.ɵɵtemplate(2, BaseNavbarComponent_div_0_ng_container_2_Template, 4, 3, "ng-container", 3);
    i0.ɵɵtemplate(3, BaseNavbarComponent_div_0_ng_template_3_Template, 25, 24, "ng-template", null, 4, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r0.loaded);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.loaded);
} }
class BaseNavbarComponent {
    static { this.instances = []; }
    constructor(navigationStore, languageStore, userPreferenceStore, systemConfigStore, appState, authService, moduleNavigation, screenSize, asyncActionService, notificationStore, globalRecentlyViewedStore, globalSearch, breakpointObserver, router) {
        this.navigationStore = navigationStore;
        this.languageStore = languageStore;
        this.userPreferenceStore = userPreferenceStore;
        this.systemConfigStore = systemConfigStore;
        this.appState = appState;
        this.authService = authService;
        this.moduleNavigation = moduleNavigation;
        this.screenSize = screenSize;
        this.asyncActionService = asyncActionService;
        this.notificationStore = notificationStore;
        this.globalRecentlyViewedStore = globalRecentlyViewedStore;
        this.globalSearch = globalSearch;
        this.breakpointObserver = breakpointObserver;
        this.router = router;
        this.loaded = true;
        this.mainNavCollapse = true;
        this.subNavCollapse = true;
        this.mobileSubNav = false;
        this.backLink = false;
        this.mainNavLink = true;
        this.submenu = [];
        this.moduleNameMapper = new ModuleNameMapper(this.systemConfigStore);
        this.actionNameMapper = new ActionNameMapper(this.systemConfigStore);
        this.routeConverter = new RouteConverter(this.moduleNameMapper, this.actionNameMapper, this.systemConfigStore);
        this.maxTabs = 8;
        this.screen = ScreenSize.Medium;
        this.notificationsEnabled = false;
        this.subs = [];
        this.mobileNavbar = false;
        this.isSmallScreen = signal(false);
        this.isTabletScreen = signal(false);
        this.recentlyViewedCount = 10;
        this.isSearchBoxVisible = signal(false);
        this.languages$ = this.languageStore.vm$;
        this.userPreferences$ = this.userPreferenceStore.userPreferences$;
        this.currentUser$ = this.authService.currentUser$;
        this.appState$ = this.appState.vm$;
        this.navigation$ = this.navigationStore.vm$;
        this.recentlyViewed$ = this.globalRecentlyViewedStore.globalRecentlyViewed$;
        this.vm$ = this.navigation$.pipe(combineLatestWith(this.userPreferences$, this.currentUser$, this.appState$, this.screenSize.screenSize$, this.languages$), map(([navigation, userPreferences, currentUser, appState, screenSize, language]) => {
            if (screenSize) {
                this.screen = screenSize;
                this.onResize();
            }
            if (navigation && navigation.modules) {
                this.navigation = navigation;
            }
            this.calculateMaxTabs(navigation);
            this.getModuleQuickActions(appState.module);
            this.navbar.resetMenu();
            if (ready([language.appStrings, language.modStrings, language.appListStrings, userPreferences, currentUser])) {
                this.navbar.build(navigation, currentUser, this.maxTabs);
            }
            return {
                navigation,
                userPreferences,
                appState,
                appStrings: language.appStrings || {},
                appListStrings: language.appListStrings || {}
            };
        }));
    }
    /**
     * Public API
     */
    onResize() {
        const innerWidth = window.innerWidth;
        this.mobileNavbar = innerWidth <= 768;
        this.isSmallScreen.set(innerWidth < 600);
        this.isTabletScreen.set(innerWidth <= 992);
        this.isSearchBoxVisible.set(innerWidth >= 600);
    }
    ngOnInit() {
        const navbar = new NavbarAbstract(this.routeConverter, this.moduleNavigation, this.userPreferenceStore, this.languageStore, this.appState, this.moduleNameMapper);
        this.setNavbar(navbar);
        this.authService.isUserLoggedIn.subscribe(value => {
            this.isUserLoggedIn = value;
        });
        window.dispatchEvent(new Event('resize'));
        this.notificationCount$ = this.notificationStore.notificationsUnreadTotal$;
        this.recentlyViewedCount = this.systemConfigStore.getUi('global_recently_viewed');
        this.subs.push(this.notificationStore.notificationsEnabled$.subscribe(notificationsEnabled => {
            this.notificationsEnabled = notificationsEnabled;
        }));
        this.subs.push(this.breakpointObserver.observe([
            Breakpoints.XSmall,
        ]).subscribe((result) => {
            let hasSearchTerm;
            if (!!this.searchTermRef?.searchForm.get('searchTerm').value) {
                hasSearchTerm = true;
            }
            else {
                hasSearchTerm = false;
            }
            if (result.matches && !hasSearchTerm) {
                this.isSearchBoxVisible.set(false);
            }
        }));
    }
    ngOnDestroy() {
        this.authService.isUserLoggedIn.unsubscribe();
        this.subs.forEach(sub => sub.unsubscribe());
    }
    checkAppStrings(appStrings) {
        return appStrings && Object.keys(appStrings).length > 0;
    }
    arePreferencesInitialized(preferences) {
        return preferences && Object.keys(preferences).length;
    }
    markAsRead() {
        this.notificationStore.markNotificationsAsRead();
    }
    ngAfterViewInit() {
        if (!this.mobileGlobalLinkTitle?.nativeElement?.offsetWidth) {
            return;
        }
        this.dropdownLength = this.mobileGlobalLinkTitle.nativeElement.offsetWidth;
    }
    /**
     * Change subnavigation
     *
     * @param {object} event triggered
     * @param {object} items
     */
    changeSubNav(event, items) {
        this.mobileSubNav = !this.mobileSubNav;
        this.backLink = !this.backLink;
        this.mainNavLink = !this.mainNavLink;
        this.submenu = items;
    }
    /**
     * Set link flags
     */
    navBackLink() {
        this.mobileSubNav = !this.mobileSubNav;
        this.backLink = !this.backLink;
        this.mainNavLink = !this.mainNavLink;
    }
    /**
     * Get home page
     *
     * @returns {string} homepage
     */
    getHomePage() {
        return this.systemConfigStore.getHomePage();
    }
    /**
     * Internal API
     */
    /**
     * Set navbar model
     *
     * @param {object} navbar model
     */
    setNavbar(navbar) {
        this.navbar = navbar;
        this.loaded = true;
    }
    /**
     * Check if is loaded
     *
     * @returns {{boolean}} is loaded
     */
    isLoaded() {
        return this.loaded;
    }
    calculateMaxTabs(navigation) {
        const sizeMap = this.systemConfigStore.getConfigValue('navigation_tab_limits');
        if (this.screen && sizeMap) {
            let maxTabs = sizeMap[this.screen];
            if (!maxTabs || navigation.maxTabs && navigation.maxTabs < maxTabs) {
                maxTabs = navigation.maxTabs;
            }
            this.maxTabs = maxTabs;
        }
    }
    getModuleQuickActions(module) {
        const moduleNavigation = this?.navigation?.modules[module] ?? null;
        const moduleNavigationMenu = moduleNavigation?.menu ?? [];
        if (moduleNavigation === null || !moduleNavigationMenu.length) {
            this.currentQuickActions = [];
        }
        const actions = [];
        moduleNavigationMenu.forEach(entry => {
            if (!entry.url || !entry.quickAction) {
                return;
            }
            const url = entry?.url ?? '';
            actions.push({
                ...entry,
                url: url.replace('/#/', '/')
            });
        });
        this.currentQuickActions = actions;
    }
    handleProcess(action) {
        if (!action.process) {
            return;
        }
        const processType = action.process;
        const options = {
            action: processType,
            module: action.module,
        };
        this.asyncActionService.run(processType, options).pipe(take(1)).subscribe();
    }
    openSearchBox() {
        if (this.isSmallScreen()) {
            this.isSearchBoxVisible.set(true);
        }
    }
    closeSearchBox(isVisible) {
        this.isSearchBoxVisible.set(isVisible);
    }
    search(searchTerm) {
        const searchController = this.systemConfigStore.getConfigValue('search')?.controller ?? '';
        this.globalSearch.navigateToSearch(searchTerm, searchController).finally();
    }
    toggleSidebar() {
        this.appState.toggleSidebar();
    }
    closeNotificationMenu() {
        this.subs.push(this.router.events.pipe(filter(event => event instanceof NavigationEnd), take(1)).subscribe(() => {
            this.alertDropdown.close();
        }));
    }
    static { this.ɵfac = function BaseNavbarComponent_Factory(t) { return new (t || BaseNavbarComponent)(i0.ɵɵdirectiveInject(i1.NavigationStore), i0.ɵɵdirectiveInject(i2.LanguageStore), i0.ɵɵdirectiveInject(i3.UserPreferenceStore), i0.ɵɵdirectiveInject(i4.SystemConfigStore), i0.ɵɵdirectiveInject(i5.AppStateStore), i0.ɵɵdirectiveInject(i6.AuthService), i0.ɵɵdirectiveInject(i7.ModuleNavigation), i0.ɵɵdirectiveInject(i8.ScreenSizeObserverService), i0.ɵɵdirectiveInject(i9.AsyncActionService), i0.ɵɵdirectiveInject(i10.NotificationStore), i0.ɵɵdirectiveInject(i11.GlobalRecentlyViewedStore), i0.ɵɵdirectiveInject(i12.GlobalSearch), i0.ɵɵdirectiveInject(i13.BreakpointObserver), i0.ɵɵdirectiveInject(i14.Router)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseNavbarComponent, selectors: [["scrm-base-navbar"]], viewQuery: function BaseNavbarComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(_c1, 5);
            i0.ɵɵviewQuery(_c2, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.mobileGlobalLinkTitle = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchTermRef = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.alertDropdown = _t.first);
        } }, hostBindings: function BaseNavbarComponent_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("resize", function BaseNavbarComponent_resize_HostBindingHandler($event) { return ctx.onResize($event); }, false, i0.ɵɵresolveWindow);
        } }, decls: 2, vars: 3, consts: [["class", "top-panel fixed-top", 4, "ngIf"], [1, "top-panel", "fixed-top"], [3, "ngIf"], [4, "ngIf"], ["actionIcons", ""], [1, "navbar", "navbar-expand-lg"], [1, "navbar-collapse", "collapse", "order-4", "order-md-0", "collapsenav"], [1, "navbar-nav"], [1, "top-nav", "nav-item"], [1, "navbar", "ml-0", "pl-0"], [1, "navbar-collapse"], [1, "pl-0"], [1, "navbar", "mobile-nav-block", "mobilenavbar"], [1, "d-flex"], ["type", "button", 1, "navbar-toggler", 3, "click"], ["image", "hamburger", 1, "responsive-menu-toggler"], [1, "navbar-expand", 3, "ngClass"], [1, "navbar-nav", "h-100"], ["class", "top-nav nav-item dropdown mobile-navbar-active-module h-100 non-grouped", 4, "ngIf"], ["class", "top-nav nav-item dropdown mobile-navbar-active-module main-grouped", 4, "ngIf"], [1, "d-flex", "align-items-center"], [4, "ngTemplateOutlet"], ["ngbDropdown", "", 1, "global-links", "action-dropdown"], [1, "global-link-item"], ["ngbDropdownToggle", "", 1, "nav-link", "primary-global-link", "dropdown-toggle"], ["mobileGlobalLinkTitle", ""], ["image", "user", 1, "global-action-icon", "sicon-2x"], ["aria-labelledby", "navbarDropdownMenuLink", "ngbDropdownMenu", "", 1, "dropdown-menu", "global-links-dropdown", "border", "shadow-sm-2"], [1, "global-user-name"], [1, "top-nav", "nav-item", "dropdown", "mobile-navbar-active-module", "h-100", "non-grouped"], [3, "item"], [1, "top-nav", "nav-item", "dropdown", "mobile-navbar-active-module", "main-grouped"], [3, "item", "subNavCollapse"], [4, "ngFor", "ngForOf"], ["ngbDropdownItem", "", 1, "dropdown-item", "global-links-sublink", 3, "href", "target"], [1, "navbar", "navbar-expand-md", "navbar-1"], [1, "navbar-collapse", "collapse", "collapsenav", 3, "ngbCollapse"], [3, "active", "route"], ["ngbDropdownToggle", "", 1, "nav-link", "primary-global-link"], ["aria-labelledby", "navbarDropdownMenuLink", "ngbDropdownMenu", "", 1, "dropdown-menu", "global-links-dropdown", "border", "shadow-sm-2", "dropdown-menu-right"], [1, "navbar-nav", "grouped"], ["class", "top-nav nav-item dropdown non-grouped active", 4, "ngIf"], ["class", "top-nav nav-item dropdown main-grouped", 4, "ngFor", "ngForOf"], ["labelKey", "LBL_TABGROUP_ALL", 3, "items", "index"], [1, "top-nav", "nav-item", "dropdown", "main-grouped"], [3, "item", "subNavCollapse", "index"], [1, "top-nav", "nav-item", "dropdown", "non-grouped", "active"], [3, "item", "index"], ["class", "top-nav nav-item dropdown non-grouped", 4, "ngFor", "ngForOf"], ["labelKey", "LBL_MORE", 3, "items", "index"], [1, "top-nav", "nav-item", "dropdown", "non-grouped"], [1, "action-group", "navbar-action-group"], ["ngbDropdown", "", 1, "action-new", "action-dropdown"], [1, "navbar-nav", "border-0"], ["type", "button", "aria-label", "Quick Create", "ngbDropdownToggle", "", 1, "action-link", "primary-global-link"], ["image", "plus", 1, "action-btn-icon"], ["ngbDropdownMenu", "", 1, "dropdown-menu", "dropdown-menu-left", "border", "shadow-sm-2"], ["ngbDropdown", "", 1, "action-history", "action-dropdown"], ["type", "button", "aria-label", "Recently Viewed", "ngbDropdownToggle", "", 1, "action-link", "primary-global-link"], ["image", "recently_viewed", 1, "action-btn-icon"], ["ngbDropdownMenu", "", 1, "dropdown-menu", "border", "shadow-sm-2", "dropdown-menu-right", "scrollbar-thick", "recently-viewed-nav-header"], ["ngbDropdownItem", "", 1, "recently-viewed", 3, "menuItems"], [1, "d-flex", "align-items-center", "px-1", "action-search"], ["type", "button", "aria-label", "Search", 1, "search-mobile-view", "action-link", "primary-global-link", 3, "ngClass", "click"], ["image", "search", 1, "action-btn-icon"], [3, "ngClass"], [3, "labelKey", "klass", "searchTrigger", "isMobile", "isSearchVisible", "searchExpression"], ["searchTerm", ""], ["class", "action-alert action-dropdown", "ngbDropdown", "", 4, "ngIf"], [1, "new-list-item-header", "font-weight-bold"], ["labelKey", "LBL_MODULE_NAME", 3, "module"], ["class", "new-list-item", "ngbDropdownItem", "", 4, "ngFor", "ngForOf"], ["ngbDropdownItem", "", 1, "new-list-item"], [1, "d-flex", "align-items-center", 3, "routerLink", "queryParams"], [1, "new-list-item-label", 3, "labelKey", "module"], [1, "d-flex", "align-items-center", 3, "click"], ["labelKey", "LBL_QUICK_ACTIONS"], ["ngbDropdown", "", 1, "action-alert", "action-dropdown"], ["alertDropdown", "ngbDropdown"], ["type", "button", "ngbDropdownToggle", "", 1, "action-link", "primary-global-link", 3, "mouseenter"], ["image", "alert", 1, "action-btn-icon"], ["aria-labelledby", "navbarDropdownMenuLink", "ngbDropdownMenu", "", 1, "dropdown-menu", "border", "shadow-sm-2", "dropdown-menu-right", 3, "click"], ["class", "badge badge-position rounded-pill bg-danger text-white", 4, "ngIf"], [1, "badge", "badge-position", "rounded-pill", "bg-danger", "text-white"]], template: function BaseNavbarComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, BaseNavbarComponent_div_0_Template, 5, 2, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i15.NgClass, i15.NgForOf, i15.NgIf, i15.NgTemplateOutlet, i16.LogoUiComponent, i17.LogoutUiComponent, i18.NgbCollapse, i18.NgbDropdown, i18.NgbDropdownToggle, i18.NgbDropdownMenu, i18.NgbDropdownItem, i14.RouterLink, i19.ImageComponent, i20.LabelComponent, i21.NotificationsComponent, i22.SearchBarComponent, i23.RecentlyViewedComponent, i24.MenuItemComponent, i25.HomeMenuItemComponent, i26.GroupedMenuItemComponent, i27.MenuItemsListComponent, i15.AsyncPipe, i15.SlicePipe], encapsulation: 2, data: { animation: [
                trigger('mobileSearchBarAnm', [
                    transition(':enter', useAnimation(backInDown, {
                        params: { timing: 0.5, delay: 0 }
                    })),
                ])
            ] } }); }
}
export { BaseNavbarComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseNavbarComponent, [{
        type: Component,
        args: [{ selector: 'scrm-base-navbar', animations: [
                    trigger('mobileSearchBarAnm', [
                        transition(':enter', useAnimation(backInDown, {
                            params: { timing: 0.5, delay: 0 }
                        })),
                    ])
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<!-- Start of main navbar section -->\n\n<div *ngIf=\"(vm$ | async) as vm\" class=\"top-panel fixed-top\">\n\n    <!-- Start of empty navbar section until data is loaded -->\n\n    <ng-template [ngIf]=\"!loaded\">\n        <nav class=\"navbar navbar-expand-lg\">\n            <div class=\"navbar-collapse collapse order-4 order-md-0 collapsenav\">\n                <ul class=\"navbar-nav\">\n                    <li class=\"top-nav nav-item\">&nbsp;\n                    </li>\n                </ul>\n            </div>\n        </nav>\n    </ng-template>\n\n    <!-- End of empty  section until data is loaded -->\n\n    <!-- Start of empty navbar with logo -->\n\n    <ng-container *ngIf=\"loaded\">\n        <ng-container *ngIf=\"!this.isUserLoggedIn\">\n            <nav class=\"navbar ml-0 pl-0\">\n                <div class=\"navbar-collapse\">\n                    <ul class=\"navbar-nav\">\n                        <li class=\"pl-0\">\n                            <scrm-logo-ui></scrm-logo-ui>\n                        </li>\n                    </ul>\n                </div>\n            </nav>\n        </ng-container>\n\n        <!-- End of empty navbar section with logo -->\n\n        <!-- Start of mobile navigation section -->\n\n        <ng-container *ngIf=\"this.isUserLoggedIn && mobileNavbar\">\n            <ul class=\"navbar mobile-nav-block mobilenavbar\">\n                <div class=\"d-flex\">\n                    <button (click)=\"toggleSidebar()\" class=\"navbar-toggler\" type=\"button\">\n                        <scrm-image class=\"responsive-menu-toggler\" image=\"hamburger\"></scrm-image>\n                    </button>\n                    <nav class=\"navbar-expand\" [ngClass]=\"(isSmallScreen() && isSearchBoxVisible()) ? 'd-none' : 'd-block'\">\n                        <ul class=\"navbar-nav h-100\">\n                            <li *ngIf=\"navbar.current && !navbar.current.isGroupedMenu\" class=\"top-nav nav-item dropdown mobile-navbar-active-module h-100 non-grouped\">\n                                <scrm-menu-item [item]=\"navbar.current\"></scrm-menu-item>\n                            </li>\n                            <li *ngIf=\"navbar.current?.submenu  && navbar.current.isGroupedMenu\" class=\"top-nav nav-item dropdown mobile-navbar-active-module main-grouped\">\n                                <scrm-grouped-menu-item\n                                    [item]=\"navbar.current\"\n                                    [subNavCollapse]=\"subNavCollapse\">\n                                </scrm-grouped-menu-item>\n                            </li>\n                        </ul>\n                    </nav>\n                </div>\n\n                <div class=\"d-flex align-items-center\">\n                    <ng-container *ngTemplateOutlet=\"actionIcons\"></ng-container>\n                    <div class=\"global-links action-dropdown\" ngbDropdown>\n                        <li class=\"global-link-item\">\n                            <a #mobileGlobalLinkTitle class=\"nav-link primary-global-link dropdown-toggle\"\n                               ngbDropdownToggle>\n                                <scrm-image class=\"global-action-icon sicon-2x\" image=\"user\"></scrm-image>\n                            </a>\n                            <div [style.min-width.px]=\"mobileGlobalLinkTitle.offsetWidth\"\n                                 aria-labelledby=\"navbarDropdownMenuLink\"\n                                 class=\"dropdown-menu global-links-dropdown border shadow-sm-2\" ngbDropdownMenu>\n                                <span\n                                    class=\"global-user-name\">{{ navbar.currentUser.firstName }} {{ navbar.currentUser.lastName }}</span>\n                                <ng-template [ngIf]=\"navbar.globalActions\">\n                                    <ng-container\n                                        *ngFor=\"let globalAction of navbar.globalActions; let first = first; let last = last;\">\n                                        <a class=\"dropdown-item global-links-sublink\"\n                                           href=\"{{ globalAction.link.url }}\"\n                                           ngbDropdownItem\n                                           target=\"{{ globalAction.link.target }}\">{{ globalAction.link.label }}\n                                        </a>\n                                        <hr *ngIf=\"last === true || first === true\"/>\n                                    </ng-container>\n                                </ng-template>\n                                <scrm-logout-ui></scrm-logout-ui>\n                            </div>\n                        </li>\n                    </div>\n                </div>\n\n            </ul>\n\n        </ng-container>\n\n        <!-- End of mobile navigation section-->\n\n        <!-- Start of navbar section with data once authenticated -->\n\n        <ng-container *ngIf=\"this.isUserLoggedIn && !mobileNavbar\">\n            <nav class=\"navbar navbar-expand-md navbar-1\">\n                <div [ngbCollapse]=\"mainNavCollapse\" class=\"navbar-collapse collapse collapsenav\">\n                        <scrm-home-menu-item\n                            [active]=\"vm.appState.module && vm.appState.module === 'home'\"\n                            [route]=\"getHomePage()\"\n                        ></scrm-home-menu-item>\n\n                        <!-- Navbar with grouped tabs -->\n\n                        <ng-container *ngIf=\"vm.userPreferences['navigation_paradigm'] == 'gm'\">\n\n                            <ul class=\"navbar-nav grouped\">\n\n                                <ng-container *ngIf=\"navbar.current && navbar.current.isGroupedMenu\">\n                                    <li class=\"top-nav nav-item dropdown main-grouped\">\n                                        <scrm-grouped-menu-item\n                                                [item]=\"navbar.current\"\n                                                [subNavCollapse]=\"subNavCollapse\"\n                                                [index]=\"1\"\n                                        >\n                                        </scrm-grouped-menu-item>\n\n                                    </li>\n                                </ng-container>\n\n                                <li *ngIf=\"navbar.current && !navbar.current.isGroupedMenu\" class=\"top-nav nav-item dropdown non-grouped active\">\n                                    <scrm-menu-item [item]=\"navbar.current\" [index]=\"1\"></scrm-menu-item>\n                                </li>\n\n                                <li *ngFor=\"let item of navbar.menu; let i = index;\" class=\"top-nav nav-item dropdown main-grouped\">\n                                    <scrm-grouped-menu-item\n                                        [item]=\"item\"\n                                        [subNavCollapse]=\"subNavCollapse\"\n                                        [index]=\"i+2\"\n                                    >\n                                    </scrm-grouped-menu-item>\n\n                                </li>\n                            </ul>\n\n                            <scrm-menu-items-list [items]=\"navbar.all.modules\"\n                                                  labelKey=\"LBL_TABGROUP_ALL\"\n                                                  [index]=\"navbar.menu.length + 2\">\n                            </scrm-menu-items-list>\n\n                        </ng-container>\n\n\n                        <!-- END Navbar with grouped tabs -->\n\n                        <!-- Navbar with non-grouped tabs -->\n\n                        <ng-container *ngIf=\"vm.userPreferences['navigation_paradigm'] != 'gm'\">\n\n                            <ul class=\"navbar-nav\">\n                                <li *ngIf=\"navbar.current && !navbar.current.isGroupedMenu\" class=\"top-nav nav-item dropdown non-grouped active\">\n                                    <scrm-menu-item [item]=\"navbar.current\" [index]=\"1\"></scrm-menu-item>\n                                </li>\n\n                                <ng-container *ngIf=\"navbar.current?.submenu  && navbar.current.isGroupedMenu\">\n                                    <li class=\"top-nav nav-item dropdown main-grouped\">\n                                        <scrm-grouped-menu-item\n                                            [item]=\"navbar.current\"\n                                            [subNavCollapse]=\"subNavCollapse\"\n                                            [index]=\"1\">\n                                        </scrm-grouped-menu-item>\n                                    </li>\n                                </ng-container>\n\n                                <li *ngFor=\"let item of navbar.menu; let i = index\" class=\"top-nav nav-item dropdown non-grouped\">\n                                    <scrm-menu-item [item]=\"item\" [index]=\"i+2\"></scrm-menu-item>\n                                </li>\n                            </ul>\n\n                        <scrm-menu-items-list [items]=\"navbar.all.modules\"\n                                              labelKey=\"LBL_MORE\"\n                                                [index]=\"navbar.menu.length + 2\">\n                        </scrm-menu-items-list>\n\n                        </ng-container>\n\n                        <!-- END Navbar with non-grouped tabs -->\n\n                </div>\n\n                <ng-container *ngTemplateOutlet=\"actionIcons\"></ng-container>\n\n                <!-- Global Links -->\n\n                <div class=\"global-links action-dropdown\" ngbDropdown>\n                    <ul class=\"navbar-nav\">\n                        <li class=\"global-link-item\">\n                            <a class=\"nav-link primary-global-link\" ngbDropdownToggle>\n                                <scrm-image class=\"global-action-icon sicon-2x\" image=\"user\"></scrm-image>\n                            </a>\n                            <div aria-labelledby=\"navbarDropdownMenuLink\"\n                                 class=\"dropdown-menu global-links-dropdown border shadow-sm-2 dropdown-menu-right\" ngbDropdownMenu>\n                                <span\n                                    class=\"global-user-name\">{{ navbar.currentUser.firstName }} {{ navbar.currentUser.lastName }}</span>\n                                <ng-container *ngIf=\"navbar.globalActions\">\n                                    <ng-container\n                                        *ngFor=\"let globalAction of navbar.globalActions; let first = first; let last = last;\">\n                                        <a class=\"dropdown-item global-links-sublink\"\n                                           href=\"{{ globalAction.link.url }}\"\n                                           ngbDropdownItem\n                                           target=\"{{ globalAction.link.target }}\">{{ globalAction.link.label }}\n                                        </a>\n                                        <hr *ngIf=\"last === true || first === true\"/>\n                                    </ng-container>\n\n                                </ng-container>\n                                <scrm-logout-ui></scrm-logout-ui>\n                            </div>\n                        </li>\n                    </ul>\n                </div>\n\n                <!-- END Global Links -->\n\n            </nav>\n\n            <!-- End of navbar section with data once authenticated -->\n\n        </ng-container>\n    </ng-container>\n\n    <ng-template #actionIcons>\n        <div class=\"action-group navbar-action-group\">\n            <!--Quick Create-->\n            <div class=\"action-new action-dropdown\" ngbDropdown>\n                <ul class=\"navbar-nav border-0\">\n                    <li class=\"global-link-item\">\n                        <a class=\"action-link primary-global-link\" type=\"button\" aria-label=\"Quick Create\" ngbDropdownToggle>\n                            <scrm-image class=\"action-btn-icon\" image=\"plus\"></scrm-image>\n                        </a>\n                        <ul [class.dropdown-menu-right]=\"!mobileNavbar\"\n                            [class.dropdown-menu-right-center]=\"mobileNavbar\"\n                            class=\"dropdown-menu dropdown-menu-left border shadow-sm-2\" ngbDropdownMenu>\n\n                            <ng-container *ngIf=\"(navbar?.current?.module ?? '') && currentQuickActions.length\">\n                                <li class=\"new-list-item-header font-weight-bold\">\n                                    <scrm-label labelKey=\"LBL_MODULE_NAME\" [module]=\"navbar.current.module\"></scrm-label>\n                                </li>\n                                <li class=\"new-list-item\" *ngFor=\"let moduleQuickAction of currentQuickActions\" ngbDropdownItem>\n                                    <ng-container *ngIf=\"!moduleQuickAction.process\">\n                                        <a [routerLink]=\"moduleQuickAction.url\" [queryParams]=\"moduleQuickAction?.params ?? null\" class=\"d-flex align-items-center\">\n                                            <scrm-label [labelKey]=\"moduleQuickAction.labelKey\" [module]=\"navbar.current.module\" class=\"new-list-item-label\"></scrm-label>\n                                        </a>\n                                    </ng-container>\n                                    <ng-container *ngIf=\"moduleQuickAction.process\">\n                                        <a (click)=\"handleProcess(moduleQuickAction)\" class=\"d-flex align-items-center\">\n                                            <scrm-label [labelKey]=\"moduleQuickAction.labelKey\" [module]=\"navbar.current.module\" class=\"new-list-item-label\"></scrm-label>\n                                        </a>\n                                    </ng-container>\n\n                                </li>\n                            </ng-container>\n\n                            <ng-container *ngIf=\"(this?.navigation?.quickActions ?? []).length\">\n                                <li class=\"new-list-item-header font-weight-bold\">\n                                    <scrm-label labelKey=\"LBL_QUICK_ACTIONS\"></scrm-label>\n                                </li>\n                                <li class=\"new-list-item\" *ngFor=\"let quickAction of (this?.navigation?.quickActions ?? [])\" ngbDropdownItem>\n                                    <ng-container *ngIf=\"!quickAction.process\">\n                                        <a [routerLink]=\"quickAction.url\" [queryParams]=\"quickAction?.params ?? null\" class=\"d-flex align-items-center\">\n                                            <scrm-label [labelKey]=\"quickAction.labelKey\" [module]=\"quickAction.module\" class=\"new-list-item-label\"></scrm-label>\n                                        </a>\n                                    </ng-container>\n                                    <ng-container *ngIf=\"quickAction.process\">\n                                        <a (click)=\"handleProcess(quickAction)\" class=\"d-flex align-items-center\">\n                                            <scrm-label [labelKey]=\"quickAction.labelKey\" [module]=\"quickAction.module\" class=\"new-list-item-label\"></scrm-label>\n                                        </a>\n                                    </ng-container>\n                                </li>\n                            </ng-container>\n                        </ul>\n                    </li>\n                </ul>\n            </div>\n            <!--Recently Viewed-->\n            <div class=\"action-history action-dropdown\" ngbDropdown>\n                <ul class=\"navbar-nav border-0\">\n                    <li class=\"global-link-item\">\n                        <a class=\"action-link primary-global-link\" type=\"button\" aria-label=\"Recently Viewed\" ngbDropdownToggle>\n                            <scrm-image class=\"action-btn-icon\" image=\"recently_viewed\"></scrm-image>\n                        </a>\n                        <div class=\"dropdown-menu border shadow-sm-2 dropdown-menu-right scrollbar-thick recently-viewed-nav-header\"\n                             [class.dropdown-menu-right]=\"!mobileNavbar\" ngbDropdownMenu>\n                                 <scrm-recently-viewed [menuItems]=\"recentlyViewed$ | async | slice:0:recentlyViewedCount\"\n                                                       ngbDropdownItem class=\"recently-viewed\"></scrm-recently-viewed>\n                        </div>\n                    </li>\n                </ul>\n            </div>\n\n            <!--Searchbar-->\n            <div class=\"d-flex align-items-center px-1 action-search\">\n                <a class=\"search-mobile-view action-link primary-global-link\" [ngClass]=\"isSearchBoxVisible() ? 'd-none' : 'd-block'\"\n                   type=\"button\" (click)=\"openSearchBox()\" aria-label=\"Search\">\n                    <scrm-image class=\"action-btn-icon\" image=\"search\"></scrm-image>\n                </a>\n\n                <div [ngClass]=\"isSearchBoxVisible() ? 'd-block' : 'd-none'\" [@mobileSearchBarAnm]>\n                    <scrm-search-bar\n                        [labelKey]=\"'LBL_SEARCH'\"\n                        [klass]=\"'search-bar-global'\"\n                        [searchTrigger]=\"'enter'\"\n                        [isMobile]=\"isSmallScreen()\"\n                        (isSearchVisible)=\"closeSearchBox($event)\"\n                        (searchExpression)=\"search($event)\" #searchTerm>\n                    </scrm-search-bar>\n                </div>\n            </div>\n            <!--Notifications-->\n            <div *ngIf=\"notificationsEnabled && checkAppStrings(vm.appStrings) && arePreferencesInitialized(vm.userPreferences)\"\n                 class=\"action-alert action-dropdown\" ngbDropdown #alertDropdown=\"ngbDropdown\">\n                <ul class=\"navbar-nav border-0\">\n                    <li class=\"global-link-item\">\n                        <a class=\"action-link primary-global-link\" type=\"button\"\n                           (mouseenter)=\"markAsRead()\" ngbDropdownToggle>\n                            <scrm-image class=\"action-btn-icon\" image=\"alert\"></scrm-image>\n                        </a>\n                        <ng-container *ngIf=\"(notificationCount$ | async) as notificationCount\">\n                                    <span *ngIf=\"(notificationCount ?? false)\"\n                                          class=\"badge badge-position rounded-pill bg-danger text-white\">\n                                        <ng-container *ngIf=\"notificationCount > 0\">{{notificationCount }}</ng-container>\n                                    </span>\n                        </ng-container>\n                        <div class=\"dropdown-menu border shadow-sm-2 dropdown-menu-right\" aria-labelledby=\"navbarDropdownMenuLink\"\n                             (click)=\"closeNotificationMenu()\" ngbDropdownMenu>\n                            <scrm-notifications></scrm-notifications>\n                        </div>\n                    </li>\n                </ul>\n            </div>\n\n        </div>\n    </ng-template>\n\n</div>\n\n<!-- End of main navbar section -->\n" }]
    }], function () { return [{ type: i1.NavigationStore }, { type: i2.LanguageStore }, { type: i3.UserPreferenceStore }, { type: i4.SystemConfigStore }, { type: i5.AppStateStore }, { type: i6.AuthService }, { type: i7.ModuleNavigation }, { type: i8.ScreenSizeObserverService }, { type: i9.AsyncActionService }, { type: i10.NotificationStore }, { type: i11.GlobalRecentlyViewedStore }, { type: i12.GlobalSearch }, { type: i13.BreakpointObserver }, { type: i14.Router }]; }, { mobileGlobalLinkTitle: [{
            type: ViewChild,
            args: ['mobileGlobalLinkTitle']
        }], searchTermRef: [{
            type: ViewChild,
            args: ['searchTerm', { static: false }]
        }], alertDropdown: [{
            type: ViewChild,
            args: ['alertDropdown']
        }], onResize: [{
            type: HostListener,
            args: ['window:resize', ['$event']]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS1uYXZiYXIuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vY29yZS9hcHAvY29yZS9zcmMvbGliL2NvbXBvbmVudHMvbmF2YmFyL2Jhc2UtbmF2YmFyL2Jhc2UtbmF2YmFyLmNvbXBvbmVudC50cyIsIi4uLy4uLy4uLy4uLy4uLy4uLy4uL2NvcmUvYXBwL2NvcmUvc3JjL2xpYi9jb21wb25lbnRzL25hdmJhci9iYXNlLW5hdmJhci9iYXNlLW5hdmJhci5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBd0JHO0FBRUgsT0FBTyxFQUFnQixTQUFTLEVBQUUsVUFBVSxFQUFFLFlBQVksRUFBcUIsTUFBTSxFQUFFLFNBQVMsRUFBQyxNQUFNLGVBQWUsQ0FBQztBQUN2SCxPQUFPLEVBQUMsaUJBQWlCLEVBQTJCLE1BQU0sTUFBTSxDQUFDO0FBQ2pFLE9BQU8sRUFBQyxNQUFNLEVBQUUsR0FBRyxFQUFFLElBQUksRUFBQyxNQUFNLGdCQUFnQixDQUFDO0FBRWpELE9BQU8sRUFBQyxjQUFjLEVBQUMsTUFBTSxvQkFBb0IsQ0FBQztBQUNsRCxPQUFPLEVBQUMsVUFBVSxFQUFFLE9BQU8sRUFBRSxZQUFZLEVBQUMsTUFBTSxxQkFBcUIsQ0FBQztBQUN0RSxPQUFPLEVBQUMsVUFBVSxFQUFDLE1BQU0sWUFBWSxDQUFDO0FBQ3RDLE9BQU8sRUFBQyxnQkFBZ0IsRUFBQyxNQUFNLDRFQUE0RSxDQUFDO0FBQzVHLE9BQU8sRUFBQyxpQkFBaUIsRUFBQyxNQUFNLGtEQUFrRCxDQUFDO0FBQ25GLE9BQU8sRUFBMkIsZUFBZSxFQUFDLE1BQU0sNENBQTRDLENBQUM7QUFDckcsT0FBTyxFQUFvQixtQkFBbUIsRUFBQyxNQUFNLHNEQUFzRCxDQUFDO0FBQzVHLE9BQU8sRUFDSCxVQUFVLEVBQ1YseUJBQXlCLEVBQzVCLE1BQU0sd0VBQXdFLENBQUM7QUFDaEYsT0FBTyxFQUFDLGNBQWMsRUFBQyxNQUFNLHNFQUFzRSxDQUFDO0FBQ3BHLE9BQU8sRUFBQyxhQUFhLEVBQWtCLE1BQU0sd0NBQXdDLENBQUM7QUFDdEYsT0FBTyxFQUFDLGdCQUFnQixFQUFDLE1BQU0sMEVBQTBFLENBQUM7QUFDMUcsT0FBTyxFQUFDLGdCQUFnQixFQUFDLE1BQU0sNEVBQTRFLENBQUM7QUFDNUcsT0FBTyxFQUFXLGFBQWEsRUFBQyxNQUFNLDBDQUEwQyxDQUFDO0FBQ2pGLE9BQU8sRUFBQyxXQUFXLEVBQUMsTUFBTSxxQ0FBcUMsQ0FBQztBQUNoRSxPQUFPLEVBQVcsS0FBSyxFQUFpQixNQUFNLFFBQVEsQ0FBQztBQUN2RCxPQUFPLEVBQW1CLGtCQUFrQixFQUFDLE1BQU0sK0RBQStELENBQUM7QUFDbkgsT0FBTyxFQUFDLGlCQUFpQixFQUFDLE1BQU0sZ0RBQWdELENBQUM7QUFDakYsT0FBTyxFQUFDLHlCQUF5QixFQUFDLE1BQU0sb0VBQW9FLENBQUM7QUFDN0csT0FBTyxFQUFDLFlBQVksRUFBQyxNQUFNLGtFQUFrRSxDQUFDO0FBQzlGLE9BQU8sRUFBQyxrQkFBa0IsRUFBRSxXQUFXLEVBQWtCLE1BQU0scUJBQXFCLENBQUM7QUFDckYsT0FBTyxFQUFDLGtCQUFrQixFQUFDLE1BQU0sdUNBQXVDLENBQUM7QUFDekUsT0FBTyxFQUFDLGFBQWEsRUFBRSxNQUFNLEVBQUMsTUFBTSxpQkFBaUIsQ0FBQztBQUN0RCxPQUFPLEVBQUMsV0FBVyxFQUFDLE1BQU0sNEJBQTRCLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztJQ3JCL0MsOEJBQXFDLGFBQUEsWUFBQSxZQUFBO0lBR0ksdUJBQzdCO0lBQUEsaUJBQUssRUFBQSxFQUFBLEVBQUE7OztJQVdqQiw2QkFBMkM7SUFDdkMsOEJBQThCLGNBQUEsWUFBQSxhQUFBO0lBSWQsK0JBQTZCO0lBQ2pDLGlCQUFLLEVBQUEsRUFBQSxFQUFBO0lBSXJCLDBCQUFlOzs7SUFjSyw4QkFBNEk7SUFDeEkscUNBQXlEO0lBQzdELGlCQUFLOzs7SUFEZSxlQUF1QjtJQUF2Qiw0Q0FBdUI7OztJQUUzQyw4QkFBZ0o7SUFDNUksNkNBR3lCO0lBQzdCLGlCQUFLOzs7SUFIRyxlQUF1QjtJQUF2Qiw2Q0FBdUIsMENBQUE7OztJQVN2Qyx3QkFBNkQ7OztJQW9CekMscUJBQTZDOzs7SUFQakQsNkJBQzJGO0lBQ3ZGLDZCQUcyQztJQUFBLFlBQzNDO0lBQUEsaUJBQUk7SUFDSixvSUFBNkM7SUFDakQsMEJBQWU7Ozs7O0lBTFIsZUFBa0M7SUFBbEMsNkVBQWtDO0lBRWxDLGdFQUF1QztJQUFDLGVBQzNDO0lBRDJDLDJEQUMzQztJQUNLLGVBQXFDO0lBQXJDLDhEQUFxQzs7O0lBUDlDLDBJQVFlOzs7SUFQYyxzREFBeUI7Ozs7SUFwQ2xGLDZCQUEwRDtJQUN0RCw4QkFBaUQsY0FBQSxpQkFBQTtJQUVqQyxpTUFBUyxlQUFBLHVCQUFlLENBQUEsSUFBQztJQUM3QixpQ0FBMkU7SUFDL0UsaUJBQVM7SUFDVCwrQkFBd0csYUFBQTtJQUVoRyx1R0FFSztJQUNMLHVHQUtLO0lBQ1QsaUJBQUssRUFBQSxFQUFBO0lBSWIsK0JBQXVDO0lBQ25DLDZIQUE2RDtJQUM3RCxnQ0FBc0QsY0FBQSxpQkFBQTtJQUkxQyxrQ0FBMEU7SUFDOUUsaUJBQUk7SUFDSixnQ0FFb0YsZ0JBQUE7SUFFbkQsYUFBb0U7SUFBQSxpQkFBTztJQUN4RywwSEFVYztJQUNkLGtDQUFpQztJQUNyQyxpQkFBTSxFQUFBLEVBQUEsRUFBQSxFQUFBO0lBTzFCLDBCQUFlOzs7Ozs7SUEvQ3dCLGVBQTRFO0lBQTVFLHNHQUE0RTtJQUUxRixlQUFxRDtJQUFyRCxvRkFBcUQ7SUFHckQsZUFBOEQ7SUFBOUQsb0lBQThEO0lBVzVELGVBQTZCO0lBQTdCLHNDQUE2QjtJQU8vQixlQUF3RDtJQUF4RCxtREFBd0Q7SUFJNUIsZUFBb0U7SUFBcEUsMkdBQW9FO0lBQ3BGLGVBQTZCO0lBQTdCLGtEQUE2Qjs7O0lBdUMxQyw2QkFBcUU7SUFDakUsOEJBQW1EO0lBQy9DLDZDQUt5QjtJQUU3QixpQkFBSztJQUNULDBCQUFlOzs7SUFQQyxlQUF1QjtJQUF2Qiw2Q0FBdUIsMENBQUEsWUFBQTs7O0lBU3ZDLDhCQUFpSDtJQUM3RyxxQ0FBcUU7SUFDekUsaUJBQUs7OztJQURlLGVBQXVCO0lBQXZCLDZDQUF1QixZQUFBOzs7SUFHM0MsOEJBQW9HO0lBQ2hHLDZDQUt5QjtJQUU3QixpQkFBSzs7Ozs7SUFORyxlQUFhO0lBQWIsK0JBQWEsMENBQUEsb0JBQUE7OztJQXRCN0IsNkJBQXdFO0lBRXBFLDhCQUErQjtJQUUzQix5SUFVZTtJQUVmLHNIQUVLO0lBRUwsc0hBUUs7SUFDVCxpQkFBSztJQUVMLDJDQUd1QjtJQUUzQiwwQkFBZTs7O0lBaENRLGVBQW9EO0lBQXBELHFGQUFvRDtJQVk5RCxlQUFxRDtJQUFyRCxzRkFBcUQ7SUFJckMsZUFBZ0I7SUFBaEIsNkNBQWdCO0lBV25CLGVBQTRCO0lBQTVCLGtEQUE0Qix5Q0FBQTs7O0lBZTlDLDhCQUFpSDtJQUM3RyxxQ0FBcUU7SUFDekUsaUJBQUs7OztJQURlLGVBQXVCO0lBQXZCLDZDQUF1QixZQUFBOzs7SUFHM0MsNkJBQStFO0lBQzNFLDhCQUFtRDtJQUMvQyw2Q0FJeUI7SUFDN0IsaUJBQUs7SUFDVCwwQkFBZTs7O0lBTEgsZUFBdUI7SUFBdkIsNkNBQXVCLDBDQUFBLFlBQUE7OztJQU9uQyw4QkFBa0c7SUFDOUYscUNBQTZEO0lBQ2pFLGlCQUFLOzs7O0lBRGUsZUFBYTtJQUFiLCtCQUFhLG9CQUFBOzs7SUFsQnpDLDZCQUF3RTtJQUVwRSw2QkFBdUI7SUFDbkIsc0hBRUs7SUFFTCx5SUFRZTtJQUVmLHNIQUVLO0lBQ1QsaUJBQUs7SUFFVCwyQ0FHdUI7SUFFdkIsMEJBQWU7OztJQXhCRixlQUFxRDtJQUFyRCxzRkFBcUQ7SUFJM0MsZUFBOEQ7SUFBOUQsdUlBQThEO0lBVXhELGVBQWdCO0lBQWhCLDZDQUFnQjtJQUt2QixlQUE0QjtJQUE1QixrREFBNEIseUNBQUE7OztJQVcxRCx3QkFBNkQ7OztJQXNCckMscUJBQTZDOzs7SUFQakQsNkJBQzJGO0lBQ3ZGLDZCQUcyQztJQUFBLFlBQzNDO0lBQUEsaUJBQUk7SUFDSixxSUFBNkM7SUFDakQsMEJBQWU7Ozs7O0lBTFIsZUFBa0M7SUFBbEMsNkVBQWtDO0lBRWxDLGdFQUF1QztJQUFDLGVBQzNDO0lBRDJDLDJEQUMzQztJQUNLLGVBQXFDO0lBQXJDLDhEQUFxQzs7O0lBUmxELDZCQUEyQztJQUN2QywySUFRZTtJQUVuQiwwQkFBZTs7O0lBVGtCLGVBQXlCO0lBQXpCLHNEQUF5Qjs7O0lBdEdsRiw2QkFBMkQ7SUFDdkQsK0JBQThDLGNBQUE7SUFFbEMsMENBR3VCO0lBSXZCLDBIQW9DZTtJQU9mLDBIQTJCZTtJQUl2QixpQkFBTTtJQUVOLDJIQUE2RDtJQUk3RCwrQkFBc0QsWUFBQSxhQUFBLGFBQUE7SUFJdEMsa0NBQTBFO0lBQzlFLGlCQUFJO0lBQ0osZ0NBQ3dHLGdCQUFBO0lBRXZFLGFBQW9FO0lBQUEsaUJBQU87SUFDeEcsNEhBV2U7SUFDZixrQ0FBaUM7SUFDckMsaUJBQU0sRUFBQSxFQUFBLEVBQUEsRUFBQTtJQVcxQiwwQkFBZTs7Ozs7SUExSEYsZUFBK0I7SUFBL0Isb0RBQStCO0lBRXhCLGVBQThEO0lBQTlELGtGQUE4RCwrQkFBQTtJQU1uRCxlQUF1RDtJQUF2RCwyRUFBdUQ7SUEyQ3ZELGVBQXVEO0lBQXZELDJFQUF1RDtJQWlDL0QsZUFBNkI7SUFBN0Isc0NBQTZCO0lBYUMsZUFBb0U7SUFBcEUsMkdBQW9FO0lBQ2xGLGVBQTBCO0lBQTFCLGtEQUEwQjs7O0lBaExyRSw2QkFBNkI7SUFDekIsMkdBVWU7SUFNZiw0R0FxRGU7SUFNZiw0R0E0SGU7SUFDbkIsMEJBQWU7OztJQXhNSSxlQUEwQjtJQUExQiw2Q0FBMEI7SUFnQjFCLGVBQXlDO0lBQXpDLG1FQUF5QztJQTJEekMsZUFBMEM7SUFBMUMsb0VBQTBDOzs7SUFpSjdCLDZCQUFpRDtJQUM3Qyw2QkFBNEg7SUFDeEgsaUNBQThIO0lBQ2xJLGlCQUFJO0lBQ1IsMEJBQWU7Ozs7O0lBSFIsZUFBb0M7SUFBcEMsc0RBQW9DLG1KQUFBO0lBQ3ZCLGVBQXVDO0lBQXZDLHlEQUF1Qyx5Q0FBQTs7OztJQUczRCw2QkFBZ0Q7SUFDNUMsNkJBQWdGO0lBQTdFLDJRQUFTLGVBQUEsNENBQWdDLENBQUEsSUFBQztJQUN6QyxpQ0FBOEg7SUFDbEksaUJBQUk7SUFDUiwwQkFBZTs7OztJQUZLLGVBQXVDO0lBQXZDLHlEQUF1Qyx5Q0FBQTs7O0lBUi9ELDhCQUFnRztJQUM1Riw4SEFJZTtJQUNmLDhIQUllO0lBRW5CLGlCQUFLOzs7SUFYYyxlQUFnQztJQUFoQyxxREFBZ0M7SUFLaEMsZUFBK0I7SUFBL0Isb0RBQStCOzs7SUFWdEQsNkJBQW9GO0lBQ2hGLDhCQUFrRDtJQUM5QyxpQ0FBcUY7SUFDekYsaUJBQUs7SUFDTCxzR0FZSztJQUNULDBCQUFlOzs7SUFmZ0MsZUFBZ0M7SUFBaEMsc0RBQWdDO0lBRW5CLGVBQXNCO0lBQXRCLHFEQUFzQjs7O0lBb0IxRSw2QkFBMkM7SUFDdkMsNkJBQWdIO0lBQzVHLGlDQUFxSDtJQUN6SCxpQkFBSTtJQUNSLDBCQUFlOzs7O0lBSFIsZUFBOEI7SUFBOUIsZ0RBQThCLHVJQUFBO0lBQ2pCLGVBQWlDO0lBQWpDLG1EQUFpQyxrQ0FBQTs7OztJQUdyRCw2QkFBMEM7SUFDdEMsNkJBQTBFO0lBQXZFLHFRQUFTLGVBQUEsc0NBQTBCLENBQUEsSUFBQztJQUNuQyxpQ0FBcUg7SUFDekgsaUJBQUk7SUFDUiwwQkFBZTs7O0lBRkssZUFBaUM7SUFBakMsbURBQWlDLGtDQUFBOzs7SUFSekQsOEJBQTZHO0lBQ3pHLDhIQUllO0lBQ2YsOEhBSWU7SUFDbkIsaUJBQUs7OztJQVZjLGVBQTBCO0lBQTFCLCtDQUEwQjtJQUsxQixlQUF5QjtJQUF6Qiw4Q0FBeUI7Ozs7SUFWaEQsNkJBQW9FO0lBQ2hFLDhCQUFrRDtJQUM5QyxpQ0FBc0Q7SUFDMUQsaUJBQUs7SUFDTCxzR0FXSztJQUNULDBCQUFlOzs7O0lBWnVDLGVBQXlDO0lBQXpDLDJNQUF5Qzs7O0lBK0RuRiw2QkFBNEM7SUFBQSxZQUFzQjtJQUFBLDBCQUFlOzs7SUFBckMsZUFBc0I7SUFBdEIsMkNBQXNCOzs7SUFGdEUsZ0NBQ3FFO0lBQ2pFLHVJQUFpRjtJQUNyRixpQkFBTzs7O0lBRFksZUFBMkI7SUFBM0IsZ0RBQTJCOzs7SUFIMUQsNkJBQXdFO0lBQzVELGlIQUdPO0lBQ25CLDBCQUFlOzs7O0lBSkksZUFBa0M7SUFBbEMsNEdBQWtDOzs7O0lBVGpFLG1DQUNtRixhQUFBLGFBQUEsWUFBQTtJQUlwRSw2TEFBYyxlQUFBLG9CQUFZLENBQUEsSUFBQztJQUMxQixpQ0FBK0Q7SUFDbkUsaUJBQUk7SUFDSixpSEFLZTs7SUFDZiwrQkFDdUQ7SUFBbEQscUxBQVMsZUFBQSwrQkFBdUIsQ0FBQSxJQUFDO0lBQ2xDLHFDQUF5QztJQUM3QyxpQkFBTSxFQUFBLEVBQUEsRUFBQTs7O0lBVFMsZUFBbUM7SUFBbkMsdUVBQW1DOzs7O0lBL0ZsRSwrQkFBOEMsY0FBQSxhQUFBLGFBQUEsWUFBQTtJQU0xQixpQ0FBOEQ7SUFDbEUsaUJBQUk7SUFDSiw4QkFFZ0Y7SUFFNUUsMEdBaUJlO0lBRWYsMEdBZ0JlO0lBQ25CLGlCQUFLLEVBQUEsRUFBQSxFQUFBO0lBS2pCLCtCQUF3RCxjQUFBLGNBQUEsYUFBQTtJQUl4QyxrQ0FBeUU7SUFDN0UsaUJBQUk7SUFDSixnQ0FDaUU7SUFDeEQsNENBQ3FGOzs7SUFDOUYsaUJBQU0sRUFBQSxFQUFBLEVBQUE7SUFNbEIsZ0NBQTBELGFBQUE7SUFFckMsNktBQVMsZUFBQSx1QkFBZSxDQUFBLElBQUM7SUFDdEMsa0NBQWdFO0lBQ3BFLGlCQUFJO0lBRUosZ0NBQW1GLCtCQUFBO0lBTTNFLHFOQUFtQixlQUFBLDhCQUFzQixDQUFBLElBQUMsME1BQ3RCLGVBQUEsc0JBQWMsQ0FBQSxJQURRO0lBRTlDLGlCQUFrQixFQUFBLEVBQUE7SUFJMUIsNEZBb0JNO0lBRVYsaUJBQU07Ozs7OztJQXJHYyxlQUEyQztJQUEzQywyREFBMkMsbURBQUE7SUFJNUIsZUFBbUU7SUFBbkUsNk5BQW1FO0lBbUJuRSxlQUFtRDtJQUFuRCwrTUFBbUQ7SUE2QmpFLGVBQTJDO0lBQTNDLDJEQUEyQztJQUNqQixlQUFtRTtJQUFuRSxpSUFBbUU7SUFTNUMsZUFBdUQ7SUFBdkQsNEVBQXVEO0lBS2hILGVBQXVEO0lBQXZELDRFQUF1RCxrQ0FBQTtJQUVwRCxlQUF5QjtJQUF6Qix1Q0FBeUIsOEJBQUEsMEJBQUEsb0NBQUE7SUFVL0IsZUFBNkc7SUFBN0cseUpBQTZHOzs7SUF0VC9ILDhCQUE2RDtJQUl6RCwwRkFTYztJQU1kLDRGQXlNZTtJQUVmLDZIQStHYztJQUVsQixpQkFBTTs7O0lBM1VXLGVBQWdCO0lBQWhCLHFDQUFnQjtJQWVkLGVBQVk7SUFBWixvQ0FBWTs7QURTL0IsTUFZYSxtQkFBbUI7YUFNWCxjQUFTLEdBQTBCLEVBQUUsQUFBNUIsQ0FBNkI7SUErRXZELFlBQ2MsZUFBZ0MsRUFDaEMsYUFBNEIsRUFDNUIsbUJBQXdDLEVBQ3hDLGlCQUFvQyxFQUNwQyxRQUF1QixFQUN2QixXQUF3QixFQUN4QixnQkFBa0MsRUFDbEMsVUFBcUMsRUFDckMsa0JBQXNDLEVBQ3RDLGlCQUFvQyxFQUNwQyx5QkFBb0QsRUFDcEQsWUFBMEIsRUFDMUIsa0JBQXNDLEVBQ3RDLE1BQWM7UUFiZCxvQkFBZSxHQUFmLGVBQWUsQ0FBaUI7UUFDaEMsa0JBQWEsR0FBYixhQUFhLENBQWU7UUFDNUIsd0JBQW1CLEdBQW5CLG1CQUFtQixDQUFxQjtRQUN4QyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQW1CO1FBQ3BDLGFBQVEsR0FBUixRQUFRLENBQWU7UUFDdkIsZ0JBQVcsR0FBWCxXQUFXLENBQWE7UUFDeEIscUJBQWdCLEdBQWhCLGdCQUFnQixDQUFrQjtRQUNsQyxlQUFVLEdBQVYsVUFBVSxDQUEyQjtRQUNyQyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQW9CO1FBQ3RDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBbUI7UUFDcEMsOEJBQXlCLEdBQXpCLHlCQUF5QixDQUEyQjtRQUNwRCxpQkFBWSxHQUFaLFlBQVksQ0FBYztRQUMxQix1QkFBa0IsR0FBbEIsa0JBQWtCLENBQW9CO1FBQ3RDLFdBQU0sR0FBTixNQUFNLENBQVE7UUEzRjVCLFdBQU0sR0FBRyxJQUFJLENBQUM7UUFFZCxvQkFBZSxHQUFHLElBQUksQ0FBQztRQUN2QixtQkFBYyxHQUFHLElBQUksQ0FBQztRQUN0QixpQkFBWSxHQUFHLEtBQUssQ0FBQztRQUNyQixhQUFRLEdBQUcsS0FBSyxDQUFDO1FBQ2pCLGdCQUFXLEdBQUcsSUFBSSxDQUFDO1FBQ25CLFlBQU8sR0FBUSxFQUFFLENBQUM7UUFDbEIscUJBQWdCLEdBQUcsSUFBSSxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUNoRSxxQkFBZ0IsR0FBRyxJQUFJLGdCQUFnQixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ2hFLG1CQUFjLEdBQUcsSUFBSSxjQUFjLENBQUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUUxRyxZQUFPLEdBQUcsQ0FBQyxDQUFDO1FBQ1osV0FBTSxHQUFlLFVBQVUsQ0FBQyxNQUFNLENBQUM7UUFDdkMseUJBQW9CLEdBQVksS0FBSyxDQUFDO1FBQ3RDLFNBQUksR0FBbUIsRUFBRSxDQUFBO1FBRXpCLGlCQUFZLEdBQUcsS0FBSyxDQUFDO1FBQ3JCLGtCQUFhLEdBQUcsTUFBTSxDQUFVLEtBQUssQ0FBQyxDQUFDO1FBQ3ZDLG1CQUFjLEdBQUcsTUFBTSxDQUFVLEtBQUssQ0FBQyxDQUFDO1FBRXhDLHdCQUFtQixHQUFXLEVBQUUsQ0FBQztRQUdqQyx1QkFBa0IsR0FBRyxNQUFNLENBQVUsS0FBSyxDQUFDLENBQUM7UUFFNUMsZUFBVSxHQUFnQyxJQUFJLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQztRQUNqRSxxQkFBZ0IsR0FBa0MsSUFBSSxDQUFDLG1CQUFtQixDQUFDLGdCQUFnQixDQUFDO1FBQzVGLGlCQUFZLEdBQW9CLElBQUksQ0FBQyxXQUFXLENBQUMsWUFBWSxDQUFDO1FBQzlELGNBQVMsR0FBeUIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUM7UUFDcEQsZ0JBQVcsR0FBMkIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUM7UUFDL0Qsb0JBQWUsR0FBaUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDLHFCQUFxQixDQUFDO1FBSXJHLFFBQUcsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FDdkIsaUJBQWlCLENBQ2IsSUFBSSxDQUFDLGdCQUFnQixFQUNyQixJQUFJLENBQUMsWUFBWSxFQUNqQixJQUFJLENBQUMsU0FBUyxFQUNkLElBQUksQ0FBQyxVQUFVLENBQUMsV0FBVyxFQUMzQixJQUFJLENBQUMsVUFBVSxDQUNsQixFQUNELEdBQUcsQ0FBQyxDQUFDLENBQUMsVUFBVSxFQUFFLGVBQWUsRUFBRSxXQUFXLEVBQUUsUUFBUSxFQUFFLFVBQVUsRUFBRSxRQUFRLENBQUMsRUFBRSxFQUFFO1lBRS9FLElBQUksVUFBVSxFQUFFO2dCQUNaLElBQUksQ0FBQyxNQUFNLEdBQUcsVUFBVSxDQUFDO2dCQUN6QixJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7YUFDbkI7WUFFRCxJQUFJLFVBQVUsSUFBSSxVQUFVLENBQUMsT0FBTyxFQUFFO2dCQUNsQyxJQUFJLENBQUMsVUFBVSxHQUFHLFVBQVUsQ0FBQzthQUNoQztZQUVELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztZQUVsQyxJQUFJLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBRTVDLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxFQUFFLENBQUM7WUFDeEIsSUFBSSxLQUFLLENBQUMsQ0FBQyxRQUFRLENBQUMsVUFBVSxFQUFFLFFBQVEsQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLGNBQWMsRUFBRSxlQUFlLEVBQUUsV0FBVyxDQUFDLENBQUMsRUFBRTtnQkFDMUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQ2IsVUFBVSxFQUNWLFdBQVcsRUFDWCxJQUFJLENBQUMsT0FBTyxDQUNmLENBQUM7YUFDTDtZQUVELE9BQU87Z0JBQ0gsVUFBVTtnQkFDVixlQUFlO2dCQUNmLFFBQVE7Z0JBQ1IsVUFBVSxFQUFFLFFBQVEsQ0FBQyxVQUFVLElBQUksRUFBRTtnQkFDckMsY0FBYyxFQUFFLFFBQVEsQ0FBQyxjQUFjLElBQUksRUFBRTthQUNoRCxDQUFDO1FBQ04sQ0FBQyxDQUFDLENBQ0wsQ0FBQztJQWtCRixDQUFDO0lBRUQ7O09BRUc7SUFHSCxRQUFRO1FBQ0osTUFBTSxVQUFVLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsWUFBWSxHQUFHLFVBQVUsSUFBSSxHQUFHLENBQUM7UUFDdEMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsVUFBVSxHQUFHLEdBQUcsQ0FBQyxDQUFDO1FBQ3pDLElBQUksQ0FBQyxjQUFjLENBQUMsR0FBRyxDQUFDLFVBQVUsSUFBSSxHQUFHLENBQUMsQ0FBQztRQUMzQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsR0FBRyxDQUFDLFVBQVUsSUFBSSxHQUFHLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBRUQsUUFBUTtRQUNKLE1BQU0sTUFBTSxHQUFHLElBQUksY0FBYyxDQUM3QixJQUFJLENBQUMsY0FBYyxFQUNuQixJQUFJLENBQUMsZ0JBQWdCLEVBQ3JCLElBQUksQ0FBQyxtQkFBbUIsRUFDeEIsSUFBSSxDQUFDLGFBQWEsRUFDbEIsSUFBSSxDQUFDLFFBQVEsRUFDYixJQUFJLENBQUMsZ0JBQWdCLENBQ3hCLENBQUM7UUFDRixJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxXQUFXLENBQUMsY0FBYyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUM5QyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztRQUNoQyxDQUFDLENBQUMsQ0FBQztRQUVILE1BQU0sQ0FBQyxhQUFhLENBQUMsSUFBSSxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztRQUUxQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUFDO1FBRTNFLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLHdCQUF3QixDQUFDLENBQUM7UUFFbEYsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxvQkFBb0IsQ0FBQyxFQUFFO1lBQ3pGLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxvQkFBb0IsQ0FBQztRQUNyRCxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRUosSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQztZQUMzQyxXQUFXLENBQUMsTUFBTTtTQUNyQixDQUFDLENBQUMsU0FBUyxDQUFDLENBQUMsTUFBdUIsRUFBRSxFQUFFO1lBQ3JDLElBQUksYUFBYSxDQUFDO1lBQ2xCLElBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsVUFBVSxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQyxLQUFLLEVBQUU7Z0JBQ3pELGFBQWEsR0FBRyxJQUFJLENBQUM7YUFDeEI7aUJBQU07Z0JBQ0gsYUFBYSxHQUFHLEtBQUssQ0FBQzthQUN6QjtZQUNELElBQUksTUFBTSxDQUFDLE9BQU8sSUFBSSxDQUFDLGFBQWEsRUFBRTtnQkFDbEMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQzthQUN0QztRQUNMLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDUixDQUFDO0lBRUQsV0FBVztRQUNQLElBQUksQ0FBQyxXQUFXLENBQUMsY0FBYyxDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQzlDLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUVELGVBQWUsQ0FBQyxVQUFVO1FBQ3RCLE9BQU8sVUFBVSxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBRUQseUJBQXlCLENBQUMsV0FBOEI7UUFDcEQsT0FBTyxXQUFXLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxNQUFNLENBQUM7SUFDMUQsQ0FBQztJQUVELFVBQVU7UUFDTixJQUFJLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsQ0FBQztJQUNyRCxDQUFDO0lBRUQsZUFBZTtRQUNYLElBQUksQ0FBQyxJQUFJLENBQUMscUJBQXFCLEVBQUUsYUFBYSxFQUFFLFdBQVcsRUFBRTtZQUN6RCxPQUFPO1NBQ1Y7UUFDRCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUFDO0lBQy9FLENBQUM7SUFFRDs7Ozs7T0FLRztJQUNJLFlBQVksQ0FBQyxLQUFZLEVBQUUsS0FBaUI7UUFDL0MsSUFBSSxDQUFDLFlBQVksR0FBRyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLFFBQVEsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLFdBQVcsR0FBRyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksV0FBVztRQUNkLElBQUksQ0FBQyxZQUFZLEdBQUcsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxXQUFXLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksV0FBVztRQUNkLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ2hELENBQUM7SUFFRDs7T0FFRztJQUVIOzs7O09BSUc7SUFDTyxTQUFTLENBQUMsTUFBbUI7UUFDbkMsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7UUFDckIsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUM7SUFDdkIsQ0FBQztJQUVEOzs7O09BSUc7SUFDTyxRQUFRO1FBQ2QsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3ZCLENBQUM7SUFFUyxnQkFBZ0IsQ0FBQyxVQUFzQjtRQUM3QyxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsY0FBYyxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDL0UsSUFBSSxJQUFJLENBQUMsTUFBTSxJQUFJLE9BQU8sRUFBRTtZQUV4QixJQUFJLE9BQU8sR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQ25DLElBQUksQ0FBQyxPQUFPLElBQUksVUFBVSxDQUFDLE9BQU8sSUFBSSxVQUFVLENBQUMsT0FBTyxHQUFHLE9BQU8sRUFBRTtnQkFDaEUsT0FBTyxHQUFHLFVBQVUsQ0FBQyxPQUFPLENBQUM7YUFDaEM7WUFFRCxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztTQUMxQjtJQUNMLENBQUM7SUFFRCxxQkFBcUIsQ0FBQyxNQUFjO1FBQ2hDLE1BQU0sZ0JBQWdCLEdBQUcsSUFBSSxFQUFFLFVBQVUsRUFBRSxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksSUFBSSxDQUFDO1FBQ25FLE1BQU0sb0JBQW9CLEdBQUcsZ0JBQWdCLEVBQUUsSUFBSSxJQUFJLEVBQUUsQ0FBQztRQUMxRCxJQUFJLGdCQUFnQixLQUFLLElBQUksSUFBSSxDQUFDLG9CQUFvQixDQUFDLE1BQU0sRUFBRTtZQUMzRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsRUFBRSxDQUFDO1NBQ2pDO1FBRUQsTUFBTSxPQUFPLEdBQUcsRUFBb0IsQ0FBQztRQUVyQyxvQkFBb0IsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDakMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFFO2dCQUNsQyxPQUFPO2FBQ1Y7WUFFRCxNQUFNLEdBQUcsR0FBRyxLQUFLLEVBQUUsR0FBRyxJQUFJLEVBQUUsQ0FBQztZQUU3QixPQUFPLENBQUMsSUFBSSxDQUFDO2dCQUNULEdBQUcsS0FBSztnQkFDUixHQUFHLEVBQUUsR0FBRyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDO2FBQ2YsQ0FBQyxDQUFDO1FBQ3ZCLENBQUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLG1CQUFtQixHQUFHLE9BQU8sQ0FBQztJQUN2QyxDQUFDO0lBRUQsYUFBYSxDQUFDLE1BQW9CO1FBQzlCLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFO1lBQ2pCLE9BQU87U0FDVjtRQUVELE1BQU0sV0FBVyxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFFbkMsTUFBTSxPQUFPLEdBQUc7WUFDWixNQUFNLEVBQUUsV0FBVztZQUNuQixNQUFNLEVBQUUsTUFBTSxDQUFDLE1BQU07U0FDSixDQUFDO1FBRXRCLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLE9BQU8sQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLEVBQUUsQ0FBQztJQUNoRixDQUFDO0lBRUQsYUFBYTtRQUNULElBQUcsSUFBSSxDQUFDLGFBQWEsRUFBRSxFQUFFO1lBQ3JCLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDckM7SUFDTCxDQUFDO0lBRUQsY0FBYyxDQUFDLFNBQWtCO1FBQzdCLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVELE1BQU0sQ0FBQyxVQUFrQjtRQUNyQixNQUFNLGdCQUFnQixHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFDLEVBQUUsVUFBVSxJQUFJLEVBQUUsQ0FBQztRQUMzRixJQUFJLENBQUMsWUFBWSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDO0lBQy9FLENBQUM7SUFFRCxhQUFhO1FBQ1QsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNsQyxDQUFDO0lBRUQscUJBQXFCO1FBQ2pCLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FDbEMsTUFBTSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxZQUFZLGFBQWEsQ0FBQyxFQUMvQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQ1YsQ0FBQyxTQUFTLENBQUMsR0FBRyxFQUFFO1lBQ2IsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUMvQixDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ1IsQ0FBQztvRkF4VFEsbUJBQW1CO29FQUFuQixtQkFBbUI7Ozs7Ozs7Ozs7NEdBQW5CLG9CQUFnQjs7WUN4QzdCLG9FQStVTTs7O1lBL1VBLG9EQUFvQjs4aEJEZ0NWO2dCQUNSLE9BQU8sQ0FBQyxvQkFBb0IsRUFBRTtvQkFDMUIsVUFBVSxDQUFDLFFBQVEsRUFBRSxZQUFZLENBQUMsVUFBVSxFQUFFO3dCQUMxQyxNQUFNLEVBQUUsRUFBQyxNQUFNLEVBQUUsR0FBRyxFQUFFLEtBQUssRUFBRSxDQUFDLEVBQUM7cUJBQ2xDLENBQUMsQ0FBQztpQkFDTixDQUFDO2FBQ0w7O1NBRVEsbUJBQW1CO3VGQUFuQixtQkFBbUI7Y0FaL0IsU0FBUzsyQkFDSSxrQkFBa0IsY0FHaEI7b0JBQ1IsT0FBTyxDQUFDLG9CQUFvQixFQUFFO3dCQUMxQixVQUFVLENBQUMsUUFBUSxFQUFFLFlBQVksQ0FBQyxVQUFVLEVBQUU7NEJBQzFDLE1BQU0sRUFBRSxFQUFDLE1BQU0sRUFBRSxHQUFHLEVBQUUsS0FBSyxFQUFFLENBQUMsRUFBQzt5QkFDbEMsQ0FBQyxDQUFDO3FCQUNOLENBQUM7aUJBQ0w7NGRBSW1DLHFCQUFxQjtrQkFBeEQsU0FBUzttQkFBQyx1QkFBdUI7WUFDVSxhQUFhO2tCQUF4RCxTQUFTO21CQUFDLFlBQVksRUFBRSxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUU7WUFDZCxhQUFhO2tCQUF4QyxTQUFTO21CQUFDLGVBQWU7WUF3RzFCLFFBQVE7a0JBRFAsWUFBWTttQkFBQyxlQUFlLEVBQUUsQ0FBQyxRQUFRLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFN1aXRlQ1JNIGlzIGEgY3VzdG9tZXIgcmVsYXRpb25zaGlwIG1hbmFnZW1lbnQgcHJvZ3JhbSBkZXZlbG9wZWQgYnkgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqIENvcHlyaWdodCAoQykgMjAyMSBTYWxlc0FnaWxpdHkgTHRkLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5IGl0IHVuZGVyXG4gKiB0aGUgdGVybXMgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSB2ZXJzaW9uIDMgYXMgcHVibGlzaGVkIGJ5IHRoZVxuICogRnJlZSBTb2Z0d2FyZSBGb3VuZGF0aW9uIHdpdGggdGhlIGFkZGl0aW9uIG9mIHRoZSBmb2xsb3dpbmcgcGVybWlzc2lvbiBhZGRlZFxuICogdG8gU2VjdGlvbiAxNSBhcyBwZXJtaXR0ZWQgaW4gU2VjdGlvbiA3KGEpOiBGT1IgQU5ZIFBBUlQgT0YgVEhFIENPVkVSRUQgV09SS1xuICogSU4gV0hJQ0ggVEhFIENPUFlSSUdIVCBJUyBPV05FRCBCWSBTQUxFU0FHSUxJVFksIFNBTEVTQUdJTElUWSBESVNDTEFJTVMgVEhFXG4gKiBXQVJSQU5UWSBPRiBOT04gSU5GUklOR0VNRU5UIE9GIFRISVJEIFBBUlRZIFJJR0hUUy5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZGlzdHJpYnV0ZWQgaW4gdGhlIGhvcGUgdGhhdCBpdCB3aWxsIGJlIHVzZWZ1bCwgYnV0IFdJVEhPVVRcbiAqIEFOWSBXQVJSQU5UWTsgd2l0aG91dCBldmVuIHRoZSBpbXBsaWVkIHdhcnJhbnR5IG9mIE1FUkNIQU5UQUJJTElUWSBvciBGSVRORVNTXG4gKiBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlXG4gKiBkZXRhaWxzLlxuICpcbiAqIFlvdSBzaG91bGQgaGF2ZSByZWNlaXZlZCBhIGNvcHkgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogYWxvbmcgd2l0aCB0aGlzIHByb2dyYW0uICBJZiBub3QsIHNlZSA8aHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzLz4uXG4gKlxuICogSW4gYWNjb3JkYW5jZSB3aXRoIFNlY3Rpb24gNyhiKSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4gKiB2ZXJzaW9uIDMsIHRoZXNlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCByZXRhaW4gdGhlIGRpc3BsYXkgb2YgdGhlXG4gKiBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiIGxvZ28uIElmIHRoZSBkaXNwbGF5IG9mIHRoZSBsb2dvcyBpcyBub3QgcmVhc29uYWJseVxuICogZmVhc2libGUgZm9yIHRlY2huaWNhbCByZWFzb25zLCB0aGUgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IGRpc3BsYXlcbiAqIHRoZSB3b3JkcyBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiLlxuICovXG5cbmltcG9ydCB7QWZ0ZXJWaWV3SW5pdCwgQ29tcG9uZW50LCBFbGVtZW50UmVmLCBIb3N0TGlzdGVuZXIsIE9uRGVzdHJveSwgT25Jbml0LCBzaWduYWwsIFZpZXdDaGlsZH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQge2NvbWJpbmVMYXRlc3RXaXRoLCBPYnNlcnZhYmxlLCBTdWJzY3JpcHRpb259IGZyb20gJ3J4anMnO1xuaW1wb3J0IHtmaWx0ZXIsIG1hcCwgdGFrZX0gZnJvbSAncnhqcy9vcGVyYXRvcnMnO1xuaW1wb3J0IHtOYXZiYXJNb2RlbH0gZnJvbSAnLi4vbmF2YmFyLW1vZGVsJztcbmltcG9ydCB7TmF2YmFyQWJzdHJhY3R9IGZyb20gJy4uL25hdmJhci5hYnN0cmFjdCc7XG5pbXBvcnQge3RyYW5zaXRpb24sIHRyaWdnZXIsIHVzZUFuaW1hdGlvbn0gZnJvbSAnQGFuZ3VsYXIvYW5pbWF0aW9ucyc7XG5pbXBvcnQge2JhY2tJbkRvd259IGZyb20gJ25nLWFuaW1hdGUnO1xuaW1wb3J0IHtBY3Rpb25OYW1lTWFwcGVyfSBmcm9tICcuLi8uLi8uLi9zZXJ2aWNlcy9uYXZpZ2F0aW9uL2FjdGlvbi1uYW1lLW1hcHBlci9hY3Rpb24tbmFtZS1tYXBwZXIuc2VydmljZSc7XG5pbXBvcnQge1N5c3RlbUNvbmZpZ1N0b3JlfSBmcm9tICcuLi8uLi8uLi9zdG9yZS9zeXN0ZW0tY29uZmlnL3N5c3RlbS1jb25maWcuc3RvcmUnO1xuaW1wb3J0IHtNb2R1bGVBY3Rpb24sIE5hdmlnYXRpb24sIE5hdmlnYXRpb25TdG9yZX0gZnJvbSAnLi4vLi4vLi4vc3RvcmUvbmF2aWdhdGlvbi9uYXZpZ2F0aW9uLnN0b3JlJztcbmltcG9ydCB7VXNlclByZWZlcmVuY2VNYXAsIFVzZXJQcmVmZXJlbmNlU3RvcmV9IGZyb20gJy4uLy4uLy4uL3N0b3JlL3VzZXItcHJlZmVyZW5jZS91c2VyLXByZWZlcmVuY2Uuc3RvcmUnO1xuaW1wb3J0IHtcbiAgICBTY3JlZW5TaXplLFxuICAgIFNjcmVlblNpemVPYnNlcnZlclNlcnZpY2Vcbn0gZnJvbSAnLi4vLi4vLi4vc2VydmljZXMvdWkvc2NyZWVuLXNpemUtb2JzZXJ2ZXIvc2NyZWVuLXNpemUtb2JzZXJ2ZXIuc2VydmljZSc7XG5pbXBvcnQge1JvdXRlQ29udmVydGVyfSBmcm9tICcuLi8uLi8uLi9zZXJ2aWNlcy9uYXZpZ2F0aW9uL3JvdXRlLWNvbnZlcnRlci9yb3V0ZS1jb252ZXJ0ZXIuc2VydmljZSc7XG5pbXBvcnQge0xhbmd1YWdlU3RvcmUsIExhbmd1YWdlU3RyaW5nc30gZnJvbSAnLi4vLi4vLi4vc3RvcmUvbGFuZ3VhZ2UvbGFuZ3VhZ2Uuc3RvcmUnO1xuaW1wb3J0IHtNb2R1bGVOYXZpZ2F0aW9ufSBmcm9tICcuLi8uLi8uLi9zZXJ2aWNlcy9uYXZpZ2F0aW9uL21vZHVsZS1uYXZpZ2F0aW9uL21vZHVsZS1uYXZpZ2F0aW9uLnNlcnZpY2UnO1xuaW1wb3J0IHtNb2R1bGVOYW1lTWFwcGVyfSBmcm9tICcuLi8uLi8uLi9zZXJ2aWNlcy9uYXZpZ2F0aW9uL21vZHVsZS1uYW1lLW1hcHBlci9tb2R1bGUtbmFtZS1tYXBwZXIuc2VydmljZSc7XG5pbXBvcnQge0FwcFN0YXRlLCBBcHBTdGF0ZVN0b3JlfSBmcm9tICcuLi8uLi8uLi9zdG9yZS9hcHAtc3RhdGUvYXBwLXN0YXRlLnN0b3JlJztcbmltcG9ydCB7QXV0aFNlcnZpY2V9IGZyb20gJy4uLy4uLy4uL3NlcnZpY2VzL2F1dGgvYXV0aC5zZXJ2aWNlJztcbmltcG9ydCB7TWVudUl0ZW0sIHJlYWR5LCBSZWNlbnRseVZpZXdlZH0gZnJvbSAnY29tbW9uJztcbmltcG9ydCB7QXN5bmNBY3Rpb25JbnB1dCwgQXN5bmNBY3Rpb25TZXJ2aWNlfSBmcm9tICcuLi8uLi8uLi9zZXJ2aWNlcy9wcm9jZXNzL3Byb2Nlc3Nlcy9hc3luYy1hY3Rpb24vYXN5bmMtYWN0aW9uJztcbmltcG9ydCB7Tm90aWZpY2F0aW9uU3RvcmV9IGZyb20gXCIuLi8uLi8uLi9zdG9yZS9ub3RpZmljYXRpb24vbm90aWZpY2F0aW9uLnN0b3JlXCI7XG5pbXBvcnQge0dsb2JhbFJlY2VudGx5Vmlld2VkU3RvcmV9IGZyb20gXCIuLi8uLi8uLi9zdG9yZS9nbG9iYWwtcmVjZW50bHktdmlld2VkL2dsb2JhbC1yZWNlbnRseS12aWV3ZWQuc3RvcmVcIjtcbmltcG9ydCB7R2xvYmFsU2VhcmNofSBmcm9tIFwiLi4vLi4vLi4vc2VydmljZXMvbmF2aWdhdGlvbi9nbG9iYWwtc2VhcmNoL2dsb2JhbC1zZWFyY2guc2VydmljZVwiO1xuaW1wb3J0IHtCcmVha3BvaW50T2JzZXJ2ZXIsIEJyZWFrcG9pbnRzLCBCcmVha3BvaW50U3RhdGV9IGZyb20gXCJAYW5ndWxhci9jZGsvbGF5b3V0XCI7XG5pbXBvcnQge1NlYXJjaEJhckNvbXBvbmVudH0gZnJvbSBcIi4uLy4uL3NlYXJjaC1iYXIvc2VhcmNoLWJhci5jb21wb25lbnRcIjtcbmltcG9ydCB7TmF2aWdhdGlvbkVuZCwgUm91dGVyfSBmcm9tIFwiQGFuZ3VsYXIvcm91dGVyXCI7XG5pbXBvcnQge05nYkRyb3Bkb3dufSBmcm9tIFwiQG5nLWJvb3RzdHJhcC9uZy1ib290c3RyYXBcIjtcblxuQENvbXBvbmVudCh7XG4gICAgc2VsZWN0b3I6ICdzY3JtLWJhc2UtbmF2YmFyJyxcbiAgICB0ZW1wbGF0ZVVybDogJy4vYmFzZS1uYXZiYXIuY29tcG9uZW50Lmh0bWwnLFxuICAgIHN0eWxlVXJsczogW10sXG4gICAgYW5pbWF0aW9uczogW1xuICAgICAgICB0cmlnZ2VyKCdtb2JpbGVTZWFyY2hCYXJBbm0nLCBbXG4gICAgICAgICAgICB0cmFuc2l0aW9uKCc6ZW50ZXInLCB1c2VBbmltYXRpb24oYmFja0luRG93biwge1xuICAgICAgICAgICAgICAgIHBhcmFtczoge3RpbWluZzogMC41LCBkZWxheTogMH1cbiAgICAgICAgICAgIH0pKSxcbiAgICAgICAgXSlcbiAgICBdXG59KVxuZXhwb3J0IGNsYXNzIEJhc2VOYXZiYXJDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIE9uRGVzdHJveSwgQWZ0ZXJWaWV3SW5pdCB7XG5cbiAgICBAVmlld0NoaWxkKCdtb2JpbGVHbG9iYWxMaW5rVGl0bGUnKSBtb2JpbGVHbG9iYWxMaW5rVGl0bGU6IEVsZW1lbnRSZWY7XG4gICAgQFZpZXdDaGlsZCgnc2VhcmNoVGVybScsIHsgc3RhdGljOiBmYWxzZSB9KSBzZWFyY2hUZXJtUmVmOiBTZWFyY2hCYXJDb21wb25lbnQ7XG4gICAgQFZpZXdDaGlsZCgnYWxlcnREcm9wZG93bicpIGFsZXJ0RHJvcGRvd246IE5nYkRyb3Bkb3duO1xuXG4gICAgcHJvdGVjdGVkIHN0YXRpYyBpbnN0YW5jZXM6IEJhc2VOYXZiYXJDb21wb25lbnRbXSA9IFtdO1xuXG4gICAgbG9hZGVkID0gdHJ1ZTtcbiAgICBpc1VzZXJMb2dnZWRJbjogYm9vbGVhbjtcbiAgICBtYWluTmF2Q29sbGFwc2UgPSB0cnVlO1xuICAgIHN1Yk5hdkNvbGxhcHNlID0gdHJ1ZTtcbiAgICBtb2JpbGVTdWJOYXYgPSBmYWxzZTtcbiAgICBiYWNrTGluayA9IGZhbHNlO1xuICAgIG1haW5OYXZMaW5rID0gdHJ1ZTtcbiAgICBzdWJtZW51OiBhbnkgPSBbXTtcbiAgICBtb2R1bGVOYW1lTWFwcGVyID0gbmV3IE1vZHVsZU5hbWVNYXBwZXIodGhpcy5zeXN0ZW1Db25maWdTdG9yZSk7XG4gICAgYWN0aW9uTmFtZU1hcHBlciA9IG5ldyBBY3Rpb25OYW1lTWFwcGVyKHRoaXMuc3lzdGVtQ29uZmlnU3RvcmUpO1xuICAgIHJvdXRlQ29udmVydGVyID0gbmV3IFJvdXRlQ29udmVydGVyKHRoaXMubW9kdWxlTmFtZU1hcHBlciwgdGhpcy5hY3Rpb25OYW1lTWFwcGVyLCB0aGlzLnN5c3RlbUNvbmZpZ1N0b3JlKTtcbiAgICBuYXZiYXI6IE5hdmJhck1vZGVsO1xuICAgIG1heFRhYnMgPSA4O1xuICAgIHNjcmVlbjogU2NyZWVuU2l6ZSA9IFNjcmVlblNpemUuTWVkaXVtO1xuICAgIG5vdGlmaWNhdGlvbnNFbmFibGVkOiBib29sZWFuID0gZmFsc2U7XG4gICAgc3ViczogU3Vic2NyaXB0aW9uW10gPSBbXVxuICAgIG5hdmlnYXRpb246IE5hdmlnYXRpb247XG4gICAgbW9iaWxlTmF2YmFyID0gZmFsc2U7XG4gICAgaXNTbWFsbFNjcmVlbiA9IHNpZ25hbDxib29sZWFuPihmYWxzZSk7XG4gICAgaXNUYWJsZXRTY3JlZW4gPSBzaWduYWw8Ym9vbGVhbj4oZmFsc2UpO1xuICAgIGRyb3Bkb3duTGVuZ3RoOiBudW1iZXI7XG4gICAgcmVjZW50bHlWaWV3ZWRDb3VudDogbnVtYmVyID0gMTA7XG5cbiAgICBjdXJyZW50UXVpY2tBY3Rpb25zOiBNb2R1bGVBY3Rpb25bXTtcbiAgICBpc1NlYXJjaEJveFZpc2libGUgPSBzaWduYWw8Ym9vbGVhbj4oZmFsc2UpO1xuXG4gICAgbGFuZ3VhZ2VzJDogT2JzZXJ2YWJsZTxMYW5ndWFnZVN0cmluZ3M+ID0gdGhpcy5sYW5ndWFnZVN0b3JlLnZtJDtcbiAgICB1c2VyUHJlZmVyZW5jZXMkOiBPYnNlcnZhYmxlPFVzZXJQcmVmZXJlbmNlTWFwPiA9IHRoaXMudXNlclByZWZlcmVuY2VTdG9yZS51c2VyUHJlZmVyZW5jZXMkO1xuICAgIGN1cnJlbnRVc2VyJDogT2JzZXJ2YWJsZTxhbnk+ID0gdGhpcy5hdXRoU2VydmljZS5jdXJyZW50VXNlciQ7XG4gICAgYXBwU3RhdGUkOiBPYnNlcnZhYmxlPEFwcFN0YXRlPiA9IHRoaXMuYXBwU3RhdGUudm0kO1xuICAgIG5hdmlnYXRpb24kOiBPYnNlcnZhYmxlPE5hdmlnYXRpb24+ID0gdGhpcy5uYXZpZ2F0aW9uU3RvcmUudm0kO1xuICAgIHJlY2VudGx5Vmlld2VkJDogT2JzZXJ2YWJsZTxSZWNlbnRseVZpZXdlZFtdPiA9IHRoaXMuZ2xvYmFsUmVjZW50bHlWaWV3ZWRTdG9yZS5nbG9iYWxSZWNlbnRseVZpZXdlZCQ7XG5cbiAgICBub3RpZmljYXRpb25Db3VudCQ6IE9ic2VydmFibGU8bnVtYmVyPjtcblxuICAgIHZtJCA9IHRoaXMubmF2aWdhdGlvbiQucGlwZShcbiAgICAgICAgY29tYmluZUxhdGVzdFdpdGgoXG4gICAgICAgICAgICB0aGlzLnVzZXJQcmVmZXJlbmNlcyQsXG4gICAgICAgICAgICB0aGlzLmN1cnJlbnRVc2VyJCxcbiAgICAgICAgICAgIHRoaXMuYXBwU3RhdGUkLFxuICAgICAgICAgICAgdGhpcy5zY3JlZW5TaXplLnNjcmVlblNpemUkLFxuICAgICAgICAgICAgdGhpcy5sYW5ndWFnZXMkLFxuICAgICAgICApLFxuICAgICAgICBtYXAoKFtuYXZpZ2F0aW9uLCB1c2VyUHJlZmVyZW5jZXMsIGN1cnJlbnRVc2VyLCBhcHBTdGF0ZSwgc2NyZWVuU2l6ZSwgbGFuZ3VhZ2VdKSA9PiB7XG5cbiAgICAgICAgICAgIGlmIChzY3JlZW5TaXplKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5zY3JlZW4gPSBzY3JlZW5TaXplO1xuICAgICAgICAgICAgICAgIHRoaXMub25SZXNpemUoKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKG5hdmlnYXRpb24gJiYgbmF2aWdhdGlvbi5tb2R1bGVzKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5uYXZpZ2F0aW9uID0gbmF2aWdhdGlvbjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgdGhpcy5jYWxjdWxhdGVNYXhUYWJzKG5hdmlnYXRpb24pO1xuXG4gICAgICAgICAgICB0aGlzLmdldE1vZHVsZVF1aWNrQWN0aW9ucyhhcHBTdGF0ZS5tb2R1bGUpO1xuXG4gICAgICAgICAgICB0aGlzLm5hdmJhci5yZXNldE1lbnUoKTtcbiAgICAgICAgICAgIGlmIChyZWFkeShbbGFuZ3VhZ2UuYXBwU3RyaW5ncywgbGFuZ3VhZ2UubW9kU3RyaW5ncywgbGFuZ3VhZ2UuYXBwTGlzdFN0cmluZ3MsIHVzZXJQcmVmZXJlbmNlcywgY3VycmVudFVzZXJdKSkge1xuICAgICAgICAgICAgICAgIHRoaXMubmF2YmFyLmJ1aWxkKFxuICAgICAgICAgICAgICAgICAgICBuYXZpZ2F0aW9uLFxuICAgICAgICAgICAgICAgICAgICBjdXJyZW50VXNlcixcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5tYXhUYWJzLFxuICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgbmF2aWdhdGlvbixcbiAgICAgICAgICAgICAgICB1c2VyUHJlZmVyZW5jZXMsXG4gICAgICAgICAgICAgICAgYXBwU3RhdGUsXG4gICAgICAgICAgICAgICAgYXBwU3RyaW5nczogbGFuZ3VhZ2UuYXBwU3RyaW5ncyB8fCB7fSxcbiAgICAgICAgICAgICAgICBhcHBMaXN0U3RyaW5nczogbGFuZ3VhZ2UuYXBwTGlzdFN0cmluZ3MgfHwge31cbiAgICAgICAgICAgIH07XG4gICAgICAgIH0pXG4gICAgKTtcblxuICAgIGNvbnN0cnVjdG9yKFxuICAgICAgICBwcm90ZWN0ZWQgbmF2aWdhdGlvblN0b3JlOiBOYXZpZ2F0aW9uU3RvcmUsXG4gICAgICAgIHByb3RlY3RlZCBsYW5ndWFnZVN0b3JlOiBMYW5ndWFnZVN0b3JlLFxuICAgICAgICBwcm90ZWN0ZWQgdXNlclByZWZlcmVuY2VTdG9yZTogVXNlclByZWZlcmVuY2VTdG9yZSxcbiAgICAgICAgcHJvdGVjdGVkIHN5c3RlbUNvbmZpZ1N0b3JlOiBTeXN0ZW1Db25maWdTdG9yZSxcbiAgICAgICAgcHJvdGVjdGVkIGFwcFN0YXRlOiBBcHBTdGF0ZVN0b3JlLFxuICAgICAgICBwcm90ZWN0ZWQgYXV0aFNlcnZpY2U6IEF1dGhTZXJ2aWNlLFxuICAgICAgICBwcm90ZWN0ZWQgbW9kdWxlTmF2aWdhdGlvbjogTW9kdWxlTmF2aWdhdGlvbixcbiAgICAgICAgcHJvdGVjdGVkIHNjcmVlblNpemU6IFNjcmVlblNpemVPYnNlcnZlclNlcnZpY2UsXG4gICAgICAgIHByb3RlY3RlZCBhc3luY0FjdGlvblNlcnZpY2U6IEFzeW5jQWN0aW9uU2VydmljZSxcbiAgICAgICAgcHJvdGVjdGVkIG5vdGlmaWNhdGlvblN0b3JlOiBOb3RpZmljYXRpb25TdG9yZSxcbiAgICAgICAgcHJvdGVjdGVkIGdsb2JhbFJlY2VudGx5Vmlld2VkU3RvcmU6IEdsb2JhbFJlY2VudGx5Vmlld2VkU3RvcmUsXG4gICAgICAgIHByb3RlY3RlZCBnbG9iYWxTZWFyY2g6IEdsb2JhbFNlYXJjaCxcbiAgICAgICAgcHJvdGVjdGVkIGJyZWFrcG9pbnRPYnNlcnZlcjogQnJlYWtwb2ludE9ic2VydmVyLFxuICAgICAgICBwcm90ZWN0ZWQgcm91dGVyOiBSb3V0ZXJcbiAgICApIHtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBQdWJsaWMgQVBJXG4gICAgICovXG5cbiAgICBASG9zdExpc3RlbmVyKCd3aW5kb3c6cmVzaXplJywgWyckZXZlbnQnXSlcbiAgICBvblJlc2l6ZSgpOiB2b2lkIHtcbiAgICAgICAgY29uc3QgaW5uZXJXaWR0aCA9IHdpbmRvdy5pbm5lcldpZHRoO1xuICAgICAgICB0aGlzLm1vYmlsZU5hdmJhciA9IGlubmVyV2lkdGggPD0gNzY4O1xuICAgICAgICB0aGlzLmlzU21hbGxTY3JlZW4uc2V0KGlubmVyV2lkdGggPCA2MDApO1xuICAgICAgICB0aGlzLmlzVGFibGV0U2NyZWVuLnNldChpbm5lcldpZHRoIDw9IDk5Mik7XG4gICAgICAgIHRoaXMuaXNTZWFyY2hCb3hWaXNpYmxlLnNldChpbm5lcldpZHRoID49IDYwMCk7XG4gICAgfVxuXG4gICAgbmdPbkluaXQoKTogdm9pZCB7XG4gICAgICAgIGNvbnN0IG5hdmJhciA9IG5ldyBOYXZiYXJBYnN0cmFjdChcbiAgICAgICAgICAgIHRoaXMucm91dGVDb252ZXJ0ZXIsXG4gICAgICAgICAgICB0aGlzLm1vZHVsZU5hdmlnYXRpb24sXG4gICAgICAgICAgICB0aGlzLnVzZXJQcmVmZXJlbmNlU3RvcmUsXG4gICAgICAgICAgICB0aGlzLmxhbmd1YWdlU3RvcmUsXG4gICAgICAgICAgICB0aGlzLmFwcFN0YXRlLFxuICAgICAgICAgICAgdGhpcy5tb2R1bGVOYW1lTWFwcGVyXG4gICAgICAgICk7XG4gICAgICAgIHRoaXMuc2V0TmF2YmFyKG5hdmJhcik7XG4gICAgICAgIHRoaXMuYXV0aFNlcnZpY2UuaXNVc2VyTG9nZ2VkSW4uc3Vic2NyaWJlKHZhbHVlID0+IHtcbiAgICAgICAgICAgIHRoaXMuaXNVc2VyTG9nZ2VkSW4gPSB2YWx1ZTtcbiAgICAgICAgfSk7XG5cbiAgICAgICAgd2luZG93LmRpc3BhdGNoRXZlbnQobmV3IEV2ZW50KCdyZXNpemUnKSk7XG5cbiAgICAgICAgdGhpcy5ub3RpZmljYXRpb25Db3VudCQgPSB0aGlzLm5vdGlmaWNhdGlvblN0b3JlLm5vdGlmaWNhdGlvbnNVbnJlYWRUb3RhbCQ7XG5cbiAgICAgICAgdGhpcy5yZWNlbnRseVZpZXdlZENvdW50ID0gdGhpcy5zeXN0ZW1Db25maWdTdG9yZS5nZXRVaSgnZ2xvYmFsX3JlY2VudGx5X3ZpZXdlZCcpO1xuXG4gICAgICAgIHRoaXMuc3Vicy5wdXNoKHRoaXMubm90aWZpY2F0aW9uU3RvcmUubm90aWZpY2F0aW9uc0VuYWJsZWQkLnN1YnNjcmliZShub3RpZmljYXRpb25zRW5hYmxlZCA9PiB7XG4gICAgICAgICAgICB0aGlzLm5vdGlmaWNhdGlvbnNFbmFibGVkID0gbm90aWZpY2F0aW9uc0VuYWJsZWQ7XG4gICAgICAgIH0pKTtcblxuICAgICAgICB0aGlzLnN1YnMucHVzaCh0aGlzLmJyZWFrcG9pbnRPYnNlcnZlci5vYnNlcnZlKFtcbiAgICAgICAgICAgIEJyZWFrcG9pbnRzLlhTbWFsbCxcbiAgICAgICAgXSkuc3Vic2NyaWJlKChyZXN1bHQ6IEJyZWFrcG9pbnRTdGF0ZSkgPT4ge1xuICAgICAgICAgICAgbGV0IGhhc1NlYXJjaFRlcm07XG4gICAgICAgICAgICBpZighIXRoaXMuc2VhcmNoVGVybVJlZj8uc2VhcmNoRm9ybS5nZXQoJ3NlYXJjaFRlcm0nKS52YWx1ZSkge1xuICAgICAgICAgICAgICAgIGhhc1NlYXJjaFRlcm0gPSB0cnVlO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBoYXNTZWFyY2hUZXJtID0gZmFsc2U7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAocmVzdWx0Lm1hdGNoZXMgJiYgIWhhc1NlYXJjaFRlcm0pIHtcbiAgICAgICAgICAgICAgICB0aGlzLmlzU2VhcmNoQm94VmlzaWJsZS5zZXQoZmFsc2UpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KSk7XG4gICAgfVxuXG4gICAgbmdPbkRlc3Ryb3koKTogdm9pZCB7XG4gICAgICAgIHRoaXMuYXV0aFNlcnZpY2UuaXNVc2VyTG9nZ2VkSW4udW5zdWJzY3JpYmUoKTtcbiAgICAgICAgdGhpcy5zdWJzLmZvckVhY2goc3ViID0+IHN1Yi51bnN1YnNjcmliZSgpKTtcbiAgICB9XG5cbiAgICBjaGVja0FwcFN0cmluZ3MoYXBwU3RyaW5ncyk6IGJvb2xlYW4ge1xuICAgICAgICByZXR1cm4gYXBwU3RyaW5ncyAmJiBPYmplY3Qua2V5cyhhcHBTdHJpbmdzKS5sZW5ndGggPiAwO1xuICAgIH1cblxuICAgIGFyZVByZWZlcmVuY2VzSW5pdGlhbGl6ZWQocHJlZmVyZW5jZXM6IFVzZXJQcmVmZXJlbmNlTWFwKSB7XG4gICAgICAgIHJldHVybiBwcmVmZXJlbmNlcyAmJiBPYmplY3Qua2V5cyhwcmVmZXJlbmNlcykubGVuZ3RoO1xuICAgIH1cblxuICAgIG1hcmtBc1JlYWQoKTogdm9pZCB7XG4gICAgICAgIHRoaXMubm90aWZpY2F0aW9uU3RvcmUubWFya05vdGlmaWNhdGlvbnNBc1JlYWQoKTtcbiAgICB9XG5cbiAgICBuZ0FmdGVyVmlld0luaXQoKTogdm9pZCB7XG4gICAgICAgIGlmICghdGhpcy5tb2JpbGVHbG9iYWxMaW5rVGl0bGU/Lm5hdGl2ZUVsZW1lbnQ/Lm9mZnNldFdpZHRoKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5kcm9wZG93bkxlbmd0aCA9IHRoaXMubW9iaWxlR2xvYmFsTGlua1RpdGxlLm5hdGl2ZUVsZW1lbnQub2Zmc2V0V2lkdGg7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQ2hhbmdlIHN1Ym5hdmlnYXRpb25cbiAgICAgKlxuICAgICAqIEBwYXJhbSB7b2JqZWN0fSBldmVudCB0cmlnZ2VyZWRcbiAgICAgKiBAcGFyYW0ge29iamVjdH0gaXRlbXNcbiAgICAgKi9cbiAgICBwdWJsaWMgY2hhbmdlU3ViTmF2KGV2ZW50OiBFdmVudCwgaXRlbXM6IE1lbnVJdGVtW10pOiB2b2lkIHtcbiAgICAgICAgdGhpcy5tb2JpbGVTdWJOYXYgPSAhdGhpcy5tb2JpbGVTdWJOYXY7XG4gICAgICAgIHRoaXMuYmFja0xpbmsgPSAhdGhpcy5iYWNrTGluaztcbiAgICAgICAgdGhpcy5tYWluTmF2TGluayA9ICF0aGlzLm1haW5OYXZMaW5rO1xuICAgICAgICB0aGlzLnN1Ym1lbnUgPSBpdGVtcztcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBTZXQgbGluayBmbGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyBuYXZCYWNrTGluaygpOiB2b2lkIHtcbiAgICAgICAgdGhpcy5tb2JpbGVTdWJOYXYgPSAhdGhpcy5tb2JpbGVTdWJOYXY7XG4gICAgICAgIHRoaXMuYmFja0xpbmsgPSAhdGhpcy5iYWNrTGluaztcbiAgICAgICAgdGhpcy5tYWluTmF2TGluayA9ICF0aGlzLm1haW5OYXZMaW5rO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEdldCBob21lIHBhZ2VcbiAgICAgKlxuICAgICAqIEByZXR1cm5zIHtzdHJpbmd9IGhvbWVwYWdlXG4gICAgICovXG4gICAgcHVibGljIGdldEhvbWVQYWdlKCk6IHN0cmluZyB7XG4gICAgICAgIHJldHVybiB0aGlzLnN5c3RlbUNvbmZpZ1N0b3JlLmdldEhvbWVQYWdlKCk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogSW50ZXJuYWwgQVBJXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBTZXQgbmF2YmFyIG1vZGVsXG4gICAgICpcbiAgICAgKiBAcGFyYW0ge29iamVjdH0gbmF2YmFyIG1vZGVsXG4gICAgICovXG4gICAgcHJvdGVjdGVkIHNldE5hdmJhcihuYXZiYXI6IE5hdmJhck1vZGVsKTogdm9pZCB7XG4gICAgICAgIHRoaXMubmF2YmFyID0gbmF2YmFyO1xuICAgICAgICB0aGlzLmxvYWRlZCA9IHRydWU7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQ2hlY2sgaWYgaXMgbG9hZGVkXG4gICAgICpcbiAgICAgKiBAcmV0dXJucyB7e2Jvb2xlYW59fSBpcyBsb2FkZWRcbiAgICAgKi9cbiAgICBwcm90ZWN0ZWQgaXNMb2FkZWQoKTogYm9vbGVhbiB7XG4gICAgICAgIHJldHVybiB0aGlzLmxvYWRlZDtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgY2FsY3VsYXRlTWF4VGFicyhuYXZpZ2F0aW9uOiBOYXZpZ2F0aW9uKTogdm9pZCB7XG4gICAgICAgIGNvbnN0IHNpemVNYXAgPSB0aGlzLnN5c3RlbUNvbmZpZ1N0b3JlLmdldENvbmZpZ1ZhbHVlKCduYXZpZ2F0aW9uX3RhYl9saW1pdHMnKTtcbiAgICAgICAgaWYgKHRoaXMuc2NyZWVuICYmIHNpemVNYXApIHtcblxuICAgICAgICAgICAgbGV0IG1heFRhYnMgPSBzaXplTWFwW3RoaXMuc2NyZWVuXTtcbiAgICAgICAgICAgIGlmICghbWF4VGFicyB8fCBuYXZpZ2F0aW9uLm1heFRhYnMgJiYgbmF2aWdhdGlvbi5tYXhUYWJzIDwgbWF4VGFicykge1xuICAgICAgICAgICAgICAgIG1heFRhYnMgPSBuYXZpZ2F0aW9uLm1heFRhYnM7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIHRoaXMubWF4VGFicyA9IG1heFRhYnM7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBnZXRNb2R1bGVRdWlja0FjdGlvbnMobW9kdWxlOiBzdHJpbmcpOiB2b2lkIHtcbiAgICAgICAgY29uc3QgbW9kdWxlTmF2aWdhdGlvbiA9IHRoaXM/Lm5hdmlnYXRpb24/Lm1vZHVsZXNbbW9kdWxlXSA/PyBudWxsO1xuICAgICAgICBjb25zdCBtb2R1bGVOYXZpZ2F0aW9uTWVudSA9IG1vZHVsZU5hdmlnYXRpb24/Lm1lbnUgPz8gW107XG4gICAgICAgIGlmIChtb2R1bGVOYXZpZ2F0aW9uID09PSBudWxsIHx8ICFtb2R1bGVOYXZpZ2F0aW9uTWVudS5sZW5ndGgpIHtcbiAgICAgICAgICAgIHRoaXMuY3VycmVudFF1aWNrQWN0aW9ucyA9IFtdO1xuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgYWN0aW9ucyA9IFtdIGFzIE1vZHVsZUFjdGlvbltdO1xuXG4gICAgICAgIG1vZHVsZU5hdmlnYXRpb25NZW51LmZvckVhY2goZW50cnkgPT4ge1xuICAgICAgICAgICAgaWYgKCFlbnRyeS51cmwgfHwgIWVudHJ5LnF1aWNrQWN0aW9uKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBjb25zdCB1cmwgPSBlbnRyeT8udXJsID8/ICcnO1xuXG4gICAgICAgICAgICBhY3Rpb25zLnB1c2goe1xuICAgICAgICAgICAgICAgIC4uLmVudHJ5LFxuICAgICAgICAgICAgICAgIHVybDogdXJsLnJlcGxhY2UoJy8jLycsICcvJylcbiAgICAgICAgICAgIH0gYXMgTW9kdWxlQWN0aW9uKTtcbiAgICAgICAgfSk7XG5cbiAgICAgICAgdGhpcy5jdXJyZW50UXVpY2tBY3Rpb25zID0gYWN0aW9ucztcbiAgICB9XG5cbiAgICBoYW5kbGVQcm9jZXNzKGFjdGlvbjogTW9kdWxlQWN0aW9uKSB7XG4gICAgICAgIGlmICghYWN0aW9uLnByb2Nlc3MpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IHByb2Nlc3NUeXBlID0gYWN0aW9uLnByb2Nlc3M7XG5cbiAgICAgICAgY29uc3Qgb3B0aW9ucyA9IHtcbiAgICAgICAgICAgIGFjdGlvbjogcHJvY2Vzc1R5cGUsXG4gICAgICAgICAgICBtb2R1bGU6IGFjdGlvbi5tb2R1bGUsXG4gICAgICAgIH0gYXMgQXN5bmNBY3Rpb25JbnB1dDtcblxuICAgICAgICB0aGlzLmFzeW5jQWN0aW9uU2VydmljZS5ydW4ocHJvY2Vzc1R5cGUsIG9wdGlvbnMpLnBpcGUodGFrZSgxKSkuc3Vic2NyaWJlKCk7XG4gICAgfVxuXG4gICAgb3BlblNlYXJjaEJveCgpIHtcbiAgICAgICAgaWYodGhpcy5pc1NtYWxsU2NyZWVuKCkpIHtcbiAgICAgICAgICAgIHRoaXMuaXNTZWFyY2hCb3hWaXNpYmxlLnNldCh0cnVlKTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIGNsb3NlU2VhcmNoQm94KGlzVmlzaWJsZTogYm9vbGVhbikge1xuICAgICAgICB0aGlzLmlzU2VhcmNoQm94VmlzaWJsZS5zZXQoaXNWaXNpYmxlKTtcbiAgICB9XG5cbiAgICBzZWFyY2goc2VhcmNoVGVybTogc3RyaW5nKSB7XG4gICAgICAgIGNvbnN0IHNlYXJjaENvbnRyb2xsZXIgPSB0aGlzLnN5c3RlbUNvbmZpZ1N0b3JlLmdldENvbmZpZ1ZhbHVlKCdzZWFyY2gnKT8uY29udHJvbGxlciA/PyAnJztcbiAgICAgICAgdGhpcy5nbG9iYWxTZWFyY2gubmF2aWdhdGVUb1NlYXJjaChzZWFyY2hUZXJtLCBzZWFyY2hDb250cm9sbGVyKS5maW5hbGx5KCk7XG4gICAgfVxuXG4gICAgdG9nZ2xlU2lkZWJhcigpOiB2b2lkIHtcbiAgICAgICAgdGhpcy5hcHBTdGF0ZS50b2dnbGVTaWRlYmFyKCk7XG4gICAgfVxuXG4gICAgY2xvc2VOb3RpZmljYXRpb25NZW51KCkge1xuICAgICAgICB0aGlzLnN1YnMucHVzaCh0aGlzLnJvdXRlci5ldmVudHMucGlwZShcbiAgICAgICAgICAgIGZpbHRlcihldmVudCA9PiBldmVudCBpbnN0YW5jZW9mIE5hdmlnYXRpb25FbmQpLFxuICAgICAgICAgICAgdGFrZSgxKVxuICAgICAgICApLnN1YnNjcmliZSgoKSA9PiB7XG4gICAgICAgICAgICB0aGlzLmFsZXJ0RHJvcGRvd24uY2xvc2UoKTtcbiAgICAgICAgfSkpO1xuICAgIH1cbn1cbiIsIjwhIC0tXG4vKipcbiogU3VpdGVDUk0gaXMgYSBjdXN0b21lciByZWxhdGlvbnNoaXAgbWFuYWdlbWVudCBwcm9ncmFtIGRldmVsb3BlZCBieSBTYWxlc0FnaWxpdHkgTHRkLlxuKiBDb3B5cmlnaHQgKEMpIDIwMjEgU2FsZXNBZ2lsaXR5IEx0ZC5cbipcbiogVGhpcyBwcm9ncmFtIGlzIGZyZWUgc29mdHdhcmU7IHlvdSBjYW4gcmVkaXN0cmlidXRlIGl0IGFuZC9vciBtb2RpZnkgaXQgdW5kZXJcbiogdGhlIHRlcm1zIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgdmVyc2lvbiAzIGFzIHB1Ymxpc2hlZCBieSB0aGVcbiogRnJlZSBTb2Z0d2FyZSBGb3VuZGF0aW9uIHdpdGggdGhlIGFkZGl0aW9uIG9mIHRoZSBmb2xsb3dpbmcgcGVybWlzc2lvbiBhZGRlZFxuKiB0byBTZWN0aW9uIDE1IGFzIHBlcm1pdHRlZCBpbiBTZWN0aW9uIDcoYSk6IEZPUiBBTlkgUEFSVCBPRiBUSEUgQ09WRVJFRCBXT1JLXG4qIElOIFdISUNIIFRIRSBDT1BZUklHSFQgSVMgT1dORUQgQlkgU0FMRVNBR0lMSVRZLCBTQUxFU0FHSUxJVFkgRElTQ0xBSU1TIFRIRVxuKiBXQVJSQU5UWSBPRiBOT04gSU5GUklOR0VNRU5UIE9GIFRISVJEIFBBUlRZIFJJR0hUUy5cbipcbiogVGhpcyBwcm9ncmFtIGlzIGRpc3RyaWJ1dGVkIGluIHRoZSBob3BlIHRoYXQgaXQgd2lsbCBiZSB1c2VmdWwsIGJ1dCBXSVRIT1VUXG4qIEFOWSBXQVJSQU5UWTsgd2l0aG91dCBldmVuIHRoZSBpbXBsaWVkIHdhcnJhbnR5IG9mIE1FUkNIQU5UQUJJTElUWSBvciBGSVRORVNTXG4qIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRS4gU2VlIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgZm9yIG1vcmVcbiogZGV0YWlscy5cbipcbiogWW91IHNob3VsZCBoYXZlIHJlY2VpdmVkIGEgY29weSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4qIGFsb25nIHdpdGggdGhpcyBwcm9ncmFtLiAgSWYgbm90LCBzZWUgaHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzLlxuKlxuKiBJbiBhY2NvcmRhbmNlIHdpdGggU2VjdGlvbiA3KGIpIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiogdmVyc2lvbiAzLCB0aGVzZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgcmV0YWluIHRoZSBkaXNwbGF5IG9mIHRoZVxuKiBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiIGxvZ28uIElmIHRoZSBkaXNwbGF5IG9mIHRoZSBsb2dvcyBpcyBub3QgcmVhc29uYWJseVxuKiBmZWFzaWJsZSBmb3IgdGVjaG5pY2FsIHJlYXNvbnMsIHRoZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgZGlzcGxheVxuKiB0aGUgd29yZHMgXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIi5cbiovXG4tLT5cbjwhLS0gU3RhcnQgb2YgbWFpbiBuYXZiYXIgc2VjdGlvbiAtLT5cblxuPGRpdiAqbmdJZj1cIih2bSQgfCBhc3luYykgYXMgdm1cIiBjbGFzcz1cInRvcC1wYW5lbCBmaXhlZC10b3BcIj5cblxuICAgIDwhLS0gU3RhcnQgb2YgZW1wdHkgbmF2YmFyIHNlY3Rpb24gdW50aWwgZGF0YSBpcyBsb2FkZWQgLS0+XG5cbiAgICA8bmctdGVtcGxhdGUgW25nSWZdPVwiIWxvYWRlZFwiPlxuICAgICAgICA8bmF2IGNsYXNzPVwibmF2YmFyIG5hdmJhci1leHBhbmQtbGdcIj5cbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJuYXZiYXItY29sbGFwc2UgY29sbGFwc2Ugb3JkZXItNCBvcmRlci1tZC0wIGNvbGxhcHNlbmF2XCI+XG4gICAgICAgICAgICAgICAgPHVsIGNsYXNzPVwibmF2YmFyLW5hdlwiPlxuICAgICAgICAgICAgICAgICAgICA8bGkgY2xhc3M9XCJ0b3AtbmF2IG5hdi1pdGVtXCI+Jm5ic3A7XG4gICAgICAgICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICAgICAgPC91bD5cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L25hdj5cbiAgICA8L25nLXRlbXBsYXRlPlxuXG4gICAgPCEtLSBFbmQgb2YgZW1wdHkgIHNlY3Rpb24gdW50aWwgZGF0YSBpcyBsb2FkZWQgLS0+XG5cbiAgICA8IS0tIFN0YXJ0IG9mIGVtcHR5IG5hdmJhciB3aXRoIGxvZ28gLS0+XG5cbiAgICA8bmctY29udGFpbmVyICpuZ0lmPVwibG9hZGVkXCI+XG4gICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCIhdGhpcy5pc1VzZXJMb2dnZWRJblwiPlxuICAgICAgICAgICAgPG5hdiBjbGFzcz1cIm5hdmJhciBtbC0wIHBsLTBcIj5cbiAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwibmF2YmFyLWNvbGxhcHNlXCI+XG4gICAgICAgICAgICAgICAgICAgIDx1bCBjbGFzcz1cIm5hdmJhci1uYXZcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgIDxsaSBjbGFzcz1cInBsLTBcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1sb2dvLXVpPjwvc2NybS1sb2dvLXVpPlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgICAgICAgPC91bD5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgIDwvbmF2PlxuICAgICAgICA8L25nLWNvbnRhaW5lcj5cblxuICAgICAgICA8IS0tIEVuZCBvZiBlbXB0eSBuYXZiYXIgc2VjdGlvbiB3aXRoIGxvZ28gLS0+XG5cbiAgICAgICAgPCEtLSBTdGFydCBvZiBtb2JpbGUgbmF2aWdhdGlvbiBzZWN0aW9uIC0tPlxuXG4gICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCJ0aGlzLmlzVXNlckxvZ2dlZEluICYmIG1vYmlsZU5hdmJhclwiPlxuICAgICAgICAgICAgPHVsIGNsYXNzPVwibmF2YmFyIG1vYmlsZS1uYXYtYmxvY2sgbW9iaWxlbmF2YmFyXCI+XG4gICAgICAgICAgICAgICAgPGRpdiBjbGFzcz1cImQtZmxleFwiPlxuICAgICAgICAgICAgICAgICAgICA8YnV0dG9uIChjbGljayk9XCJ0b2dnbGVTaWRlYmFyKClcIiBjbGFzcz1cIm5hdmJhci10b2dnbGVyXCIgdHlwZT1cImJ1dHRvblwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0taW1hZ2UgY2xhc3M9XCJyZXNwb25zaXZlLW1lbnUtdG9nZ2xlclwiIGltYWdlPVwiaGFtYnVyZ2VyXCI+PC9zY3JtLWltYWdlPlxuICAgICAgICAgICAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICAgICAgICAgICAgPG5hdiBjbGFzcz1cIm5hdmJhci1leHBhbmRcIiBbbmdDbGFzc109XCIoaXNTbWFsbFNjcmVlbigpICYmIGlzU2VhcmNoQm94VmlzaWJsZSgpKSA/ICdkLW5vbmUnIDogJ2QtYmxvY2snXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICA8dWwgY2xhc3M9XCJuYXZiYXItbmF2IGgtMTAwXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPGxpICpuZ0lmPVwibmF2YmFyLmN1cnJlbnQgJiYgIW5hdmJhci5jdXJyZW50LmlzR3JvdXBlZE1lbnVcIiBjbGFzcz1cInRvcC1uYXYgbmF2LWl0ZW0gZHJvcGRvd24gbW9iaWxlLW5hdmJhci1hY3RpdmUtbW9kdWxlIGgtMTAwIG5vbi1ncm91cGVkXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzY3JtLW1lbnUtaXRlbSBbaXRlbV09XCJuYXZiYXIuY3VycmVudFwiPjwvc2NybS1tZW51LWl0ZW0+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bGkgKm5nSWY9XCJuYXZiYXIuY3VycmVudD8uc3VibWVudSAgJiYgbmF2YmFyLmN1cnJlbnQuaXNHcm91cGVkTWVudVwiIGNsYXNzPVwidG9wLW5hdiBuYXYtaXRlbSBkcm9wZG93biBtb2JpbGUtbmF2YmFyLWFjdGl2ZS1tb2R1bGUgbWFpbi1ncm91cGVkXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzY3JtLWdyb3VwZWQtbWVudS1pdGVtXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbaXRlbV09XCJuYXZiYXIuY3VycmVudFwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbc3ViTmF2Q29sbGFwc2VdPVwic3ViTmF2Q29sbGFwc2VcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9zY3JtLWdyb3VwZWQtbWVudS1pdGVtPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICAgICAgICAgICAgICA8L3VsPlxuICAgICAgICAgICAgICAgICAgICA8L25hdj5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cblxuICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJkLWZsZXggYWxpZ24taXRlbXMtY2VudGVyXCI+XG4gICAgICAgICAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nVGVtcGxhdGVPdXRsZXQ9XCJhY3Rpb25JY29uc1wiPjwvbmctY29udGFpbmVyPlxuICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwiZ2xvYmFsLWxpbmtzIGFjdGlvbi1kcm9wZG93blwiIG5nYkRyb3Bkb3duPlxuICAgICAgICAgICAgICAgICAgICAgICAgPGxpIGNsYXNzPVwiZ2xvYmFsLWxpbmstaXRlbVwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxhICNtb2JpbGVHbG9iYWxMaW5rVGl0bGUgY2xhc3M9XCJuYXYtbGluayBwcmltYXJ5LWdsb2JhbC1saW5rIGRyb3Bkb3duLXRvZ2dsZVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbmdiRHJvcGRvd25Ub2dnbGU+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzY3JtLWltYWdlIGNsYXNzPVwiZ2xvYmFsLWFjdGlvbi1pY29uIHNpY29uLTJ4XCIgaW1hZ2U9XCJ1c2VyXCI+PC9zY3JtLWltYWdlPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8ZGl2IFtzdHlsZS5taW4td2lkdGgucHhdPVwibW9iaWxlR2xvYmFsTGlua1RpdGxlLm9mZnNldFdpZHRoXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGFyaWEtbGFiZWxsZWRieT1cIm5hdmJhckRyb3Bkb3duTWVudUxpbmtcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY2xhc3M9XCJkcm9wZG93bi1tZW51IGdsb2JhbC1saW5rcy1kcm9wZG93biBib3JkZXIgc2hhZG93LXNtLTJcIiBuZ2JEcm9wZG93bk1lbnU+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzcGFuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjbGFzcz1cImdsb2JhbC11c2VyLW5hbWVcIj57eyBuYXZiYXIuY3VycmVudFVzZXIuZmlyc3ROYW1lIH19IHt7IG5hdmJhci5jdXJyZW50VXNlci5sYXN0TmFtZSB9fTwvc3Bhbj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPG5nLXRlbXBsYXRlIFtuZ0lmXT1cIm5hdmJhci5nbG9iYWxBY3Rpb25zXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bmctY29udGFpbmVyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKm5nRm9yPVwibGV0IGdsb2JhbEFjdGlvbiBvZiBuYXZiYXIuZ2xvYmFsQWN0aW9uczsgbGV0IGZpcnN0ID0gZmlyc3Q7IGxldCBsYXN0ID0gbGFzdDtcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8YSBjbGFzcz1cImRyb3Bkb3duLWl0ZW0gZ2xvYmFsLWxpbmtzLXN1YmxpbmtcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGhyZWY9XCJ7eyBnbG9iYWxBY3Rpb24ubGluay51cmwgfX1cIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG5nYkRyb3Bkb3duSXRlbVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRhcmdldD1cInt7IGdsb2JhbEFjdGlvbi5saW5rLnRhcmdldCB9fVwiPnt7IGdsb2JhbEFjdGlvbi5saW5rLmxhYmVsIH19XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9hPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxociAqbmdJZj1cImxhc3QgPT09IHRydWUgfHwgZmlyc3QgPT09IHRydWVcIi8+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9uZy10ZW1wbGF0ZT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tbG9nb3V0LXVpPjwvc2NybS1sb2dvdXQtdWk+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgICAgICA8L2xpPlxuICAgICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cblxuICAgICAgICAgICAgPC91bD5cblxuICAgICAgICA8L25nLWNvbnRhaW5lcj5cblxuICAgICAgICA8IS0tIEVuZCBvZiBtb2JpbGUgbmF2aWdhdGlvbiBzZWN0aW9uLS0+XG5cbiAgICAgICAgPCEtLSBTdGFydCBvZiBuYXZiYXIgc2VjdGlvbiB3aXRoIGRhdGEgb25jZSBhdXRoZW50aWNhdGVkIC0tPlxuXG4gICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCJ0aGlzLmlzVXNlckxvZ2dlZEluICYmICFtb2JpbGVOYXZiYXJcIj5cbiAgICAgICAgICAgIDxuYXYgY2xhc3M9XCJuYXZiYXIgbmF2YmFyLWV4cGFuZC1tZCBuYXZiYXItMVwiPlxuICAgICAgICAgICAgICAgIDxkaXYgW25nYkNvbGxhcHNlXT1cIm1haW5OYXZDb2xsYXBzZVwiIGNsYXNzPVwibmF2YmFyLWNvbGxhcHNlIGNvbGxhcHNlIGNvbGxhcHNlbmF2XCI+XG4gICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1ob21lLW1lbnUtaXRlbVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIFthY3RpdmVdPVwidm0uYXBwU3RhdGUubW9kdWxlICYmIHZtLmFwcFN0YXRlLm1vZHVsZSA9PT0gJ2hvbWUnXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBbcm91dGVdPVwiZ2V0SG9tZVBhZ2UoKVwiXG4gICAgICAgICAgICAgICAgICAgICAgICA+PC9zY3JtLWhvbWUtbWVudS1pdGVtPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICA8IS0tIE5hdmJhciB3aXRoIGdyb3VwZWQgdGFicyAtLT5cblxuICAgICAgICAgICAgICAgICAgICAgICAgPG5nLWNvbnRhaW5lciAqbmdJZj1cInZtLnVzZXJQcmVmZXJlbmNlc1snbmF2aWdhdGlvbl9wYXJhZGlnbSddID09ICdnbSdcIj5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx1bCBjbGFzcz1cIm5hdmJhci1uYXYgZ3JvdXBlZFwiPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCJuYXZiYXIuY3VycmVudCAmJiBuYXZiYXIuY3VycmVudC5pc0dyb3VwZWRNZW51XCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bGkgY2xhc3M9XCJ0b3AtbmF2IG5hdi1pdGVtIGRyb3Bkb3duIG1haW4tZ3JvdXBlZFwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzY3JtLWdyb3VwZWQtbWVudS1pdGVtXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbaXRlbV09XCJuYXZiYXIuY3VycmVudFwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbc3ViTmF2Q29sbGFwc2VdPVwic3ViTmF2Q29sbGFwc2VcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW2luZGV4XT1cIjFcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgID5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3Njcm0tZ3JvdXBlZC1tZW51LWl0ZW0+XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvbmctY29udGFpbmVyPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxsaSAqbmdJZj1cIm5hdmJhci5jdXJyZW50ICYmICFuYXZiYXIuY3VycmVudC5pc0dyb3VwZWRNZW51XCIgY2xhc3M9XCJ0b3AtbmF2IG5hdi1pdGVtIGRyb3Bkb3duIG5vbi1ncm91cGVkIGFjdGl2ZVwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tbWVudS1pdGVtIFtpdGVtXT1cIm5hdmJhci5jdXJyZW50XCIgW2luZGV4XT1cIjFcIj48L3Njcm0tbWVudS1pdGVtPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L2xpPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxsaSAqbmdGb3I9XCJsZXQgaXRlbSBvZiBuYXZiYXIubWVudTsgbGV0IGkgPSBpbmRleDtcIiBjbGFzcz1cInRvcC1uYXYgbmF2LWl0ZW0gZHJvcGRvd24gbWFpbi1ncm91cGVkXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1ncm91cGVkLW1lbnUtaXRlbVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtpdGVtXT1cIml0ZW1cIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtzdWJOYXZDb2xsYXBzZV09XCJzdWJOYXZDb2xsYXBzZVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW2luZGV4XT1cImkrMlwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3Njcm0tZ3JvdXBlZC1tZW51LWl0ZW0+XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3VsPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tbWVudS1pdGVtcy1saXN0IFtpdGVtc109XCJuYXZiYXIuYWxsLm1vZHVsZXNcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsYWJlbEtleT1cIkxCTF9UQUJHUk9VUF9BTExcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbaW5kZXhdPVwibmF2YmFyLm1lbnUubGVuZ3RoICsgMlwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvc2NybS1tZW51LWl0ZW1zLWxpc3Q+XG5cbiAgICAgICAgICAgICAgICAgICAgICAgIDwvbmctY29udGFpbmVyPlxuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgIDwhLS0gRU5EIE5hdmJhciB3aXRoIGdyb3VwZWQgdGFicyAtLT5cblxuICAgICAgICAgICAgICAgICAgICAgICAgPCEtLSBOYXZiYXIgd2l0aCBub24tZ3JvdXBlZCB0YWJzIC0tPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICA8bmctY29udGFpbmVyICpuZ0lmPVwidm0udXNlclByZWZlcmVuY2VzWyduYXZpZ2F0aW9uX3BhcmFkaWdtJ10gIT0gJ2dtJ1wiPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPHVsIGNsYXNzPVwibmF2YmFyLW5hdlwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bGkgKm5nSWY9XCJuYXZiYXIuY3VycmVudCAmJiAhbmF2YmFyLmN1cnJlbnQuaXNHcm91cGVkTWVudVwiIGNsYXNzPVwidG9wLW5hdiBuYXYtaXRlbSBkcm9wZG93biBub24tZ3JvdXBlZCBhY3RpdmVcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzY3JtLW1lbnUtaXRlbSBbaXRlbV09XCJuYXZiYXIuY3VycmVudFwiIFtpbmRleF09XCIxXCI+PC9zY3JtLW1lbnUtaXRlbT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9saT5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bmctY29udGFpbmVyICpuZ0lmPVwibmF2YmFyLmN1cnJlbnQ/LnN1Ym1lbnUgICYmIG5hdmJhci5jdXJyZW50LmlzR3JvdXBlZE1lbnVcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxsaSBjbGFzcz1cInRvcC1uYXYgbmF2LWl0ZW0gZHJvcGRvd24gbWFpbi1ncm91cGVkXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tZ3JvdXBlZC1tZW51LWl0ZW1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW2l0ZW1dPVwibmF2YmFyLmN1cnJlbnRcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbc3ViTmF2Q29sbGFwc2VdPVwic3ViTmF2Q29sbGFwc2VcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbaW5kZXhdPVwiMVwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvc2NybS1ncm91cGVkLW1lbnUtaXRlbT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvbmctY29udGFpbmVyPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxsaSAqbmdGb3I9XCJsZXQgaXRlbSBvZiBuYXZiYXIubWVudTsgbGV0IGkgPSBpbmRleFwiIGNsYXNzPVwidG9wLW5hdiBuYXYtaXRlbSBkcm9wZG93biBub24tZ3JvdXBlZFwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tbWVudS1pdGVtIFtpdGVtXT1cIml0ZW1cIiBbaW5kZXhdPVwiaSsyXCI+PC9zY3JtLW1lbnUtaXRlbT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3VsPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1tZW51LWl0ZW1zLWxpc3QgW2l0ZW1zXT1cIm5hdmJhci5hbGwubW9kdWxlc1wiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbGFiZWxLZXk9XCJMQkxfTU9SRVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbaW5kZXhdPVwibmF2YmFyLm1lbnUubGVuZ3RoICsgMlwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9zY3JtLW1lbnUtaXRlbXMtbGlzdD5cblxuICAgICAgICAgICAgICAgICAgICAgICAgPC9uZy1jb250YWluZXI+XG5cbiAgICAgICAgICAgICAgICAgICAgICAgIDwhLS0gRU5EIE5hdmJhciB3aXRoIG5vbi1ncm91cGVkIHRhYnMgLS0+XG5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cblxuICAgICAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nVGVtcGxhdGVPdXRsZXQ9XCJhY3Rpb25JY29uc1wiPjwvbmctY29udGFpbmVyPlxuXG4gICAgICAgICAgICAgICAgPCEtLSBHbG9iYWwgTGlua3MgLS0+XG5cbiAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwiZ2xvYmFsLWxpbmtzIGFjdGlvbi1kcm9wZG93blwiIG5nYkRyb3Bkb3duPlxuICAgICAgICAgICAgICAgICAgICA8dWwgY2xhc3M9XCJuYXZiYXItbmF2XCI+XG4gICAgICAgICAgICAgICAgICAgICAgICA8bGkgY2xhc3M9XCJnbG9iYWwtbGluay1pdGVtXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPGEgY2xhc3M9XCJuYXYtbGluayBwcmltYXJ5LWdsb2JhbC1saW5rXCIgbmdiRHJvcGRvd25Ub2dnbGU+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzY3JtLWltYWdlIGNsYXNzPVwiZ2xvYmFsLWFjdGlvbi1pY29uIHNpY29uLTJ4XCIgaW1hZ2U9XCJ1c2VyXCI+PC9zY3JtLWltYWdlPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8ZGl2IGFyaWEtbGFiZWxsZWRieT1cIm5hdmJhckRyb3Bkb3duTWVudUxpbmtcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY2xhc3M9XCJkcm9wZG93bi1tZW51IGdsb2JhbC1saW5rcy1kcm9wZG93biBib3JkZXIgc2hhZG93LXNtLTIgZHJvcGRvd24tbWVudS1yaWdodFwiIG5nYkRyb3Bkb3duTWVudT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNwYW5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNsYXNzPVwiZ2xvYmFsLXVzZXItbmFtZVwiPnt7IG5hdmJhci5jdXJyZW50VXNlci5maXJzdE5hbWUgfX0ge3sgbmF2YmFyLmN1cnJlbnRVc2VyLmxhc3ROYW1lIH19PC9zcGFuPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bmctY29udGFpbmVyICpuZ0lmPVwibmF2YmFyLmdsb2JhbEFjdGlvbnNcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxuZy1jb250YWluZXJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAqbmdGb3I9XCJsZXQgZ2xvYmFsQWN0aW9uIG9mIG5hdmJhci5nbG9iYWxBY3Rpb25zOyBsZXQgZmlyc3QgPSBmaXJzdDsgbGV0IGxhc3QgPSBsYXN0O1wiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxhIGNsYXNzPVwiZHJvcGRvd24taXRlbSBnbG9iYWwtbGlua3Mtc3VibGlua1wiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaHJlZj1cInt7IGdsb2JhbEFjdGlvbi5saW5rLnVybCB9fVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbmdiRHJvcGRvd25JdGVtXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGFyZ2V0PVwie3sgZ2xvYmFsQWN0aW9uLmxpbmsudGFyZ2V0IH19XCI+e3sgZ2xvYmFsQWN0aW9uLmxpbmsubGFiZWwgfX1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L2E+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGhyICpuZ0lmPVwibGFzdCA9PT0gdHJ1ZSB8fCBmaXJzdCA9PT0gdHJ1ZVwiLz5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvbmctY29udGFpbmVyPlxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvbmctY29udGFpbmVyPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1sb2dvdXQtdWk+PC9zY3JtLWxvZ291dC11aT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICAgICAgICAgIDwvdWw+XG4gICAgICAgICAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgICAgICAgICA8IS0tIEVORCBHbG9iYWwgTGlua3MgLS0+XG5cbiAgICAgICAgICAgIDwvbmF2PlxuXG4gICAgICAgICAgICA8IS0tIEVuZCBvZiBuYXZiYXIgc2VjdGlvbiB3aXRoIGRhdGEgb25jZSBhdXRoZW50aWNhdGVkIC0tPlxuXG4gICAgICAgIDwvbmctY29udGFpbmVyPlxuICAgIDwvbmctY29udGFpbmVyPlxuXG4gICAgPG5nLXRlbXBsYXRlICNhY3Rpb25JY29ucz5cbiAgICAgICAgPGRpdiBjbGFzcz1cImFjdGlvbi1ncm91cCBuYXZiYXItYWN0aW9uLWdyb3VwXCI+XG4gICAgICAgICAgICA8IS0tUXVpY2sgQ3JlYXRlLS0+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwiYWN0aW9uLW5ldyBhY3Rpb24tZHJvcGRvd25cIiBuZ2JEcm9wZG93bj5cbiAgICAgICAgICAgICAgICA8dWwgY2xhc3M9XCJuYXZiYXItbmF2IGJvcmRlci0wXCI+XG4gICAgICAgICAgICAgICAgICAgIDxsaSBjbGFzcz1cImdsb2JhbC1saW5rLWl0ZW1cIj5cbiAgICAgICAgICAgICAgICAgICAgICAgIDxhIGNsYXNzPVwiYWN0aW9uLWxpbmsgcHJpbWFyeS1nbG9iYWwtbGlua1wiIHR5cGU9XCJidXR0b25cIiBhcmlhLWxhYmVsPVwiUXVpY2sgQ3JlYXRlXCIgbmdiRHJvcGRvd25Ub2dnbGU+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0taW1hZ2UgY2xhc3M9XCJhY3Rpb24tYnRuLWljb25cIiBpbWFnZT1cInBsdXNcIj48L3Njcm0taW1hZ2U+XG4gICAgICAgICAgICAgICAgICAgICAgICA8L2E+XG4gICAgICAgICAgICAgICAgICAgICAgICA8dWwgW2NsYXNzLmRyb3Bkb3duLW1lbnUtcmlnaHRdPVwiIW1vYmlsZU5hdmJhclwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NsYXNzLmRyb3Bkb3duLW1lbnUtcmlnaHQtY2VudGVyXT1cIm1vYmlsZU5hdmJhclwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2xhc3M9XCJkcm9wZG93bi1tZW51IGRyb3Bkb3duLW1lbnUtbGVmdCBib3JkZXIgc2hhZG93LXNtLTJcIiBuZ2JEcm9wZG93bk1lbnU+XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bmctY29udGFpbmVyICpuZ0lmPVwiKG5hdmJhcj8uY3VycmVudD8ubW9kdWxlID8/ICcnKSAmJiBjdXJyZW50UXVpY2tBY3Rpb25zLmxlbmd0aFwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bGkgY2xhc3M9XCJuZXctbGlzdC1pdGVtLWhlYWRlciBmb250LXdlaWdodC1ib2xkXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1sYWJlbCBsYWJlbEtleT1cIkxCTF9NT0RVTEVfTkFNRVwiIFttb2R1bGVdPVwibmF2YmFyLmN1cnJlbnQubW9kdWxlXCI+PC9zY3JtLWxhYmVsPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L2xpPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bGkgY2xhc3M9XCJuZXctbGlzdC1pdGVtXCIgKm5nRm9yPVwibGV0IG1vZHVsZVF1aWNrQWN0aW9uIG9mIGN1cnJlbnRRdWlja0FjdGlvbnNcIiBuZ2JEcm9wZG93bkl0ZW0+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bmctY29udGFpbmVyICpuZ0lmPVwiIW1vZHVsZVF1aWNrQWN0aW9uLnByb2Nlc3NcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8YSBbcm91dGVyTGlua109XCJtb2R1bGVRdWlja0FjdGlvbi51cmxcIiBbcXVlcnlQYXJhbXNdPVwibW9kdWxlUXVpY2tBY3Rpb24/LnBhcmFtcyA/PyBudWxsXCIgY2xhc3M9XCJkLWZsZXggYWxpZ24taXRlbXMtY2VudGVyXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzY3JtLWxhYmVsIFtsYWJlbEtleV09XCJtb2R1bGVRdWlja0FjdGlvbi5sYWJlbEtleVwiIFttb2R1bGVdPVwibmF2YmFyLmN1cnJlbnQubW9kdWxlXCIgY2xhc3M9XCJuZXctbGlzdC1pdGVtLWxhYmVsXCI+PC9zY3JtLWxhYmVsPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvbmctY29udGFpbmVyPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPG5nLWNvbnRhaW5lciAqbmdJZj1cIm1vZHVsZVF1aWNrQWN0aW9uLnByb2Nlc3NcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8YSAoY2xpY2spPVwiaGFuZGxlUHJvY2Vzcyhtb2R1bGVRdWlja0FjdGlvbilcIiBjbGFzcz1cImQtZmxleCBhbGlnbi1pdGVtcy1jZW50ZXJcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tbGFiZWwgW2xhYmVsS2V5XT1cIm1vZHVsZVF1aWNrQWN0aW9uLmxhYmVsS2V5XCIgW21vZHVsZV09XCJuYXZiYXIuY3VycmVudC5tb2R1bGVcIiBjbGFzcz1cIm5ldy1saXN0LWl0ZW0tbGFiZWxcIj48L3Njcm0tbGFiZWw+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9hPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9uZy1jb250YWluZXI+XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCIodGhpcz8ubmF2aWdhdGlvbj8ucXVpY2tBY3Rpb25zID8/IFtdKS5sZW5ndGhcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGxpIGNsYXNzPVwibmV3LWxpc3QtaXRlbS1oZWFkZXIgZm9udC13ZWlnaHQtYm9sZFwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tbGFiZWwgbGFiZWxLZXk9XCJMQkxfUVVJQ0tfQUNUSU9OU1wiPjwvc2NybS1sYWJlbD5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGxpIGNsYXNzPVwibmV3LWxpc3QtaXRlbVwiICpuZ0Zvcj1cImxldCBxdWlja0FjdGlvbiBvZiAodGhpcz8ubmF2aWdhdGlvbj8ucXVpY2tBY3Rpb25zID8/IFtdKVwiIG5nYkRyb3Bkb3duSXRlbT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCIhcXVpY2tBY3Rpb24ucHJvY2Vzc1wiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxhIFtyb3V0ZXJMaW5rXT1cInF1aWNrQWN0aW9uLnVybFwiIFtxdWVyeVBhcmFtc109XCJxdWlja0FjdGlvbj8ucGFyYW1zID8/IG51bGxcIiBjbGFzcz1cImQtZmxleCBhbGlnbi1pdGVtcy1jZW50ZXJcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tbGFiZWwgW2xhYmVsS2V5XT1cInF1aWNrQWN0aW9uLmxhYmVsS2V5XCIgW21vZHVsZV09XCJxdWlja0FjdGlvbi5tb2R1bGVcIiBjbGFzcz1cIm5ldy1saXN0LWl0ZW0tbGFiZWxcIj48L3Njcm0tbGFiZWw+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9hPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9uZy1jb250YWluZXI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8bmctY29udGFpbmVyICpuZ0lmPVwicXVpY2tBY3Rpb24ucHJvY2Vzc1wiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxhIChjbGljayk9XCJoYW5kbGVQcm9jZXNzKHF1aWNrQWN0aW9uKVwiIGNsYXNzPVwiZC1mbGV4IGFsaWduLWl0ZW1zLWNlbnRlclwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1sYWJlbCBbbGFiZWxLZXldPVwicXVpY2tBY3Rpb24ubGFiZWxLZXlcIiBbbW9kdWxlXT1cInF1aWNrQWN0aW9uLm1vZHVsZVwiIGNsYXNzPVwibmV3LWxpc3QtaXRlbS1sYWJlbFwiPjwvc2NybS1sYWJlbD5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L2E+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cbiAgICAgICAgICAgICAgICAgICAgICAgIDwvdWw+XG4gICAgICAgICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICAgICAgPC91bD5cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgPCEtLVJlY2VudGx5IFZpZXdlZC0tPlxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cImFjdGlvbi1oaXN0b3J5IGFjdGlvbi1kcm9wZG93blwiIG5nYkRyb3Bkb3duPlxuICAgICAgICAgICAgICAgIDx1bCBjbGFzcz1cIm5hdmJhci1uYXYgYm9yZGVyLTBcIj5cbiAgICAgICAgICAgICAgICAgICAgPGxpIGNsYXNzPVwiZ2xvYmFsLWxpbmstaXRlbVwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgPGEgY2xhc3M9XCJhY3Rpb24tbGluayBwcmltYXJ5LWdsb2JhbC1saW5rXCIgdHlwZT1cImJ1dHRvblwiIGFyaWEtbGFiZWw9XCJSZWNlbnRseSBWaWV3ZWRcIiBuZ2JEcm9wZG93blRvZ2dsZT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1pbWFnZSBjbGFzcz1cImFjdGlvbi1idG4taWNvblwiIGltYWdlPVwicmVjZW50bHlfdmlld2VkXCI+PC9zY3JtLWltYWdlPlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9hPlxuICAgICAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzcz1cImRyb3Bkb3duLW1lbnUgYm9yZGVyIHNoYWRvdy1zbS0yIGRyb3Bkb3duLW1lbnUtcmlnaHQgc2Nyb2xsYmFyLXRoaWNrIHJlY2VudGx5LXZpZXdlZC1uYXYtaGVhZGVyXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NsYXNzLmRyb3Bkb3duLW1lbnUtcmlnaHRdPVwiIW1vYmlsZU5hdmJhclwiIG5nYkRyb3Bkb3duTWVudT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzY3JtLXJlY2VudGx5LXZpZXdlZCBbbWVudUl0ZW1zXT1cInJlY2VudGx5Vmlld2VkJCB8IGFzeW5jIHwgc2xpY2U6MDpyZWNlbnRseVZpZXdlZENvdW50XCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBuZ2JEcm9wZG93bkl0ZW0gY2xhc3M9XCJyZWNlbnRseS12aWV3ZWRcIj48L3Njcm0tcmVjZW50bHktdmlld2VkPlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICAgICAgPC91bD5cbiAgICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgICAgICA8IS0tU2VhcmNoYmFyLS0+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwiZC1mbGV4IGFsaWduLWl0ZW1zLWNlbnRlciBweC0xIGFjdGlvbi1zZWFyY2hcIj5cbiAgICAgICAgICAgICAgICA8YSBjbGFzcz1cInNlYXJjaC1tb2JpbGUtdmlldyBhY3Rpb24tbGluayBwcmltYXJ5LWdsb2JhbC1saW5rXCIgW25nQ2xhc3NdPVwiaXNTZWFyY2hCb3hWaXNpYmxlKCkgPyAnZC1ub25lJyA6ICdkLWJsb2NrJ1wiXG4gICAgICAgICAgICAgICAgICAgdHlwZT1cImJ1dHRvblwiIChjbGljayk9XCJvcGVuU2VhcmNoQm94KClcIiBhcmlhLWxhYmVsPVwiU2VhcmNoXCI+XG4gICAgICAgICAgICAgICAgICAgIDxzY3JtLWltYWdlIGNsYXNzPVwiYWN0aW9uLWJ0bi1pY29uXCIgaW1hZ2U9XCJzZWFyY2hcIj48L3Njcm0taW1hZ2U+XG4gICAgICAgICAgICAgICAgPC9hPlxuXG4gICAgICAgICAgICAgICAgPGRpdiBbbmdDbGFzc109XCJpc1NlYXJjaEJveFZpc2libGUoKSA/ICdkLWJsb2NrJyA6ICdkLW5vbmUnXCIgW0Btb2JpbGVTZWFyY2hCYXJBbm1dPlxuICAgICAgICAgICAgICAgICAgICA8c2NybS1zZWFyY2gtYmFyXG4gICAgICAgICAgICAgICAgICAgICAgICBbbGFiZWxLZXldPVwiJ0xCTF9TRUFSQ0gnXCJcbiAgICAgICAgICAgICAgICAgICAgICAgIFtrbGFzc109XCInc2VhcmNoLWJhci1nbG9iYWwnXCJcbiAgICAgICAgICAgICAgICAgICAgICAgIFtzZWFyY2hUcmlnZ2VyXT1cIidlbnRlcidcIlxuICAgICAgICAgICAgICAgICAgICAgICAgW2lzTW9iaWxlXT1cImlzU21hbGxTY3JlZW4oKVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAoaXNTZWFyY2hWaXNpYmxlKT1cImNsb3NlU2VhcmNoQm94KCRldmVudClcIlxuICAgICAgICAgICAgICAgICAgICAgICAgKHNlYXJjaEV4cHJlc3Npb24pPVwic2VhcmNoKCRldmVudClcIiAjc2VhcmNoVGVybT5cbiAgICAgICAgICAgICAgICAgICAgPC9zY3JtLXNlYXJjaC1iYXI+XG4gICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgIDwhLS1Ob3RpZmljYXRpb25zLS0+XG4gICAgICAgICAgICA8ZGl2ICpuZ0lmPVwibm90aWZpY2F0aW9uc0VuYWJsZWQgJiYgY2hlY2tBcHBTdHJpbmdzKHZtLmFwcFN0cmluZ3MpICYmIGFyZVByZWZlcmVuY2VzSW5pdGlhbGl6ZWQodm0udXNlclByZWZlcmVuY2VzKVwiXG4gICAgICAgICAgICAgICAgIGNsYXNzPVwiYWN0aW9uLWFsZXJ0IGFjdGlvbi1kcm9wZG93blwiIG5nYkRyb3Bkb3duICNhbGVydERyb3Bkb3duPVwibmdiRHJvcGRvd25cIj5cbiAgICAgICAgICAgICAgICA8dWwgY2xhc3M9XCJuYXZiYXItbmF2IGJvcmRlci0wXCI+XG4gICAgICAgICAgICAgICAgICAgIDxsaSBjbGFzcz1cImdsb2JhbC1saW5rLWl0ZW1cIj5cbiAgICAgICAgICAgICAgICAgICAgICAgIDxhIGNsYXNzPVwiYWN0aW9uLWxpbmsgcHJpbWFyeS1nbG9iYWwtbGlua1wiIHR5cGU9XCJidXR0b25cIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgKG1vdXNlZW50ZXIpPVwibWFya0FzUmVhZCgpXCIgbmdiRHJvcGRvd25Ub2dnbGU+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0taW1hZ2UgY2xhc3M9XCJhY3Rpb24tYnRuLWljb25cIiBpbWFnZT1cImFsZXJ0XCI+PC9zY3JtLWltYWdlPlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9hPlxuICAgICAgICAgICAgICAgICAgICAgICAgPG5nLWNvbnRhaW5lciAqbmdJZj1cIihub3RpZmljYXRpb25Db3VudCQgfCBhc3luYykgYXMgbm90aWZpY2F0aW9uQ291bnRcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzcGFuICpuZ0lmPVwiKG5vdGlmaWNhdGlvbkNvdW50ID8/IGZhbHNlKVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjbGFzcz1cImJhZGdlIGJhZGdlLXBvc2l0aW9uIHJvdW5kZWQtcGlsbCBiZy1kYW5nZXIgdGV4dC13aGl0ZVwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCJub3RpZmljYXRpb25Db3VudCA+IDBcIj57e25vdGlmaWNhdGlvbkNvdW50IH19PC9uZy1jb250YWluZXI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3NwYW4+XG4gICAgICAgICAgICAgICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cbiAgICAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJkcm9wZG93bi1tZW51IGJvcmRlciBzaGFkb3ctc20tMiBkcm9wZG93bi1tZW51LXJpZ2h0XCIgYXJpYS1sYWJlbGxlZGJ5PVwibmF2YmFyRHJvcGRvd25NZW51TGlua1wiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIChjbGljayk9XCJjbG9zZU5vdGlmaWNhdGlvbk1lbnUoKVwiIG5nYkRyb3Bkb3duTWVudT5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1ub3RpZmljYXRpb25zPjwvc2NybS1ub3RpZmljYXRpb25zPlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICAgICAgPC91bD5cbiAgICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgIDwvZGl2PlxuICAgIDwvbmctdGVtcGxhdGU+XG5cbjwvZGl2PlxuXG48IS0tIEVuZCBvZiBtYWluIG5hdmJhciBzZWN0aW9uIC0tPlxuIl19