import { ActivatedRouteSnapshot } from '@angular/router';
import { ModuleNameMapper } from '../../../services/navigation/module-name-mapper/module-name-mapper.service';
import { AppStateStore } from '../../../store/app-state/app-state.store';
import { SystemConfigStore } from '../../../store/system-config/system-config.store';
import { NavigationStore } from '../../../store/navigation/navigation.store';
import { UserPreferenceStore } from '../../../store/user-preference/user-preference.store';
import { BaseMetadataResolver } from '../../../services/metadata/base-metadata.resolver';
import { RouteConverter } from '../../../services/navigation/route-converter/route-converter.service';
import { LanguageStore } from '../../../store/language/language.store';
import { ThemeImagesStore } from '../../../store/theme-images/theme-images.store';
import { MessageService } from '../../../services/message/message.service';
import { AppMetadataStore } from '../../../store/app-metadata/app-metadata.store.service';
import { AuthService } from '../../../services/auth/auth.service';
import { RecentlyViewedService } from '../../../services/navigation/recently-viewed/recently-viewed.service';
import { MetadataStore } from '../../../store/metadata/metadata.store.service';
import * as i0 from "@angular/core";
export declare class ClassicViewResolver extends BaseMetadataResolver {
    protected systemConfigStore: SystemConfigStore;
    protected languageStore: LanguageStore;
    protected navigationStore: NavigationStore;
    protected userPreferenceStore: UserPreferenceStore;
    protected themeImagesStore: ThemeImagesStore;
    protected moduleNameMapper: ModuleNameMapper;
    protected routeConverter: RouteConverter;
    protected messageService: MessageService;
    protected appStateStore: AppStateStore;
    protected appMetadata: AppMetadataStore;
    protected auth: AuthService;
    protected recentlyViewed: RecentlyViewedService;
    protected metadataStore: MetadataStore;
    constructor(systemConfigStore: SystemConfigStore, languageStore: LanguageStore, navigationStore: NavigationStore, userPreferenceStore: UserPreferenceStore, themeImagesStore: ThemeImagesStore, moduleNameMapper: ModuleNameMapper, routeConverter: RouteConverter, messageService: MessageService, appStateStore: AppStateStore, appMetadata: AppMetadataStore, auth: AuthService, recentlyViewed: RecentlyViewedService, metadataStore: MetadataStore);
    resolve(route: ActivatedRouteSnapshot): any;
    static ɵfac: i0.ɵɵFactoryDeclaration<ClassicViewResolver, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ClassicViewResolver>;
}
//# sourceMappingURL=classic-view.resolver.d.ts.map