/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from '@angular/core';
import { RecordCancelAction } from './cancel/record-cancel.action';
import { RecordSaveAction } from './save/record-save.action';
import { RecordToggleWidgetsAction } from './toggle-widgets/record-widget-action.service';
import { RecordEditAction } from './edit/record-edit.action';
import { RecordCreateAction } from './create/record-create.action';
import { RecordSaveNewAction } from './save-new/record-save-new.action';
import { CancelCreateAction } from './cancel-create/cancel-create.action';
import { BaseActionManager } from '../../../services/actions/base-action-manager.service';
import { AsyncProcessRecordAction } from './async-process/async-process.service';
import { RecordSaveContinueAction } from "./save-continue/record-save-continue.action";
import * as i0 from "@angular/core";
import * as i1 from "./edit/record-edit.action";
import * as i2 from "./create/record-create.action";
import * as i3 from "./toggle-widgets/record-widget-action.service";
import * as i4 from "./cancel/record-cancel.action";
import * as i5 from "./cancel-create/cancel-create.action";
import * as i6 from "./save/record-save.action";
import * as i7 from "./save-new/record-save-new.action";
import * as i8 from "./save-continue/record-save-continue.action";
import * as i9 from "./async-process/async-process.service";
class RecordActionManager extends BaseActionManager {
    constructor(edit, create, toggleWidgets, cancel, cancelCreate, save, saveNew, saveContinue, async) {
        super();
        this.edit = edit;
        this.create = create;
        this.toggleWidgets = toggleWidgets;
        this.cancel = cancel;
        this.cancelCreate = cancelCreate;
        this.save = save;
        this.saveNew = saveNew;
        this.saveContinue = saveContinue;
        this.async = async;
        edit.modes.forEach(mode => this.actions[mode][edit.key] = edit);
        create.modes.forEach(mode => this.actions[mode][create.key] = create);
        toggleWidgets.modes.forEach(mode => this.actions[mode][toggleWidgets.key] = toggleWidgets);
        cancel.modes.forEach(mode => this.actions[mode][cancel.key] = cancel);
        save.modes.forEach(mode => this.actions[mode][save.key] = save);
        saveNew.modes.forEach(mode => this.actions[mode][saveNew.key] = saveNew);
        saveContinue.modes.forEach(mode => this.actions[mode][saveContinue.key] = saveContinue);
        cancelCreate.modes.forEach(mode => this.actions[mode][cancelCreate.key] = cancelCreate);
        async.modes.forEach(mode => this.actions[mode][async.key] = async);
    }
    static { this.ɵfac = function RecordActionManager_Factory(t) { return new (t || RecordActionManager)(i0.ɵɵinject(i1.RecordEditAction), i0.ɵɵinject(i2.RecordCreateAction), i0.ɵɵinject(i3.RecordToggleWidgetsAction), i0.ɵɵinject(i4.RecordCancelAction), i0.ɵɵinject(i5.CancelCreateAction), i0.ɵɵinject(i6.RecordSaveAction), i0.ɵɵinject(i7.RecordSaveNewAction), i0.ɵɵinject(i8.RecordSaveContinueAction), i0.ɵɵinject(i9.AsyncProcessRecordAction)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordActionManager, factory: RecordActionManager.ɵfac, providedIn: 'root' }); }
}
export { RecordActionManager };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordActionManager, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: i1.RecordEditAction }, { type: i2.RecordCreateAction }, { type: i3.RecordToggleWidgetsAction }, { type: i4.RecordCancelAction }, { type: i5.CancelCreateAction }, { type: i6.RecordSaveAction }, { type: i7.RecordSaveNewAction }, { type: i8.RecordSaveContinueAction }, { type: i9.AsyncProcessRecordAction }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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