import { isTrue } from 'common';
import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export const primaryEmailValidator = (viewField, record) => ((control) => {
    const name = viewField.name || '';
    if (!name || !record || !record.fields) {
        return null;
    }
    const field = record.fields[name] || {};
    const items = field.items;
    if (!field || !items || !items.length) {
        return null;
    }
    let count = 0;
    const activeItems = items.filter(item => !(item && item.attributes && item.attributes.deleted));
    if (activeItems && activeItems.length < 1) {
        return null;
    }
    let nonEmpty = 0;
    activeItems.some(item => {
        const emailField = (item.fields && item.fields['email-fields']) || {};
        const primary = (emailField.attributes && emailField.attributes['primary_address']) || null;
        const emailAddress = (emailField.attributes && emailField.attributes['email_address']) || null;
        if (!emailAddress?.value) {
            return false;
        }
        nonEmpty++;
        if (!primary) {
            return false;
        }
        if (isTrue(primary.value)) {
            count++;
        }
        return count > 1;
    });
    if (count == 1) {
        return null;
    }
    if (count == 0 && nonEmpty === 0) {
        return null;
    }
    if (count == 0) {
        return {
            primaryEmailValidation: {
                valid: false,
                message: {
                    labelKey: 'LBL_NO_PRIMARY_EMAIL_VALIDATION_ERROR',
                    context: {}
                }
            },
        };
    }
    return {
        primaryEmailValidation: {
            valid: false,
            message: {
                labelKey: 'LBL_MULTIPLE_PRIMARY_EMAIL_VALIDATION_ERROR',
                context: {}
            }
        },
    };
});
class PrimaryEmailValidator {
    constructor() {
    }
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        const type = viewField.type || viewField.fieldDefinition.type || '';
        const name = viewField.name || viewField.fieldDefinition.name || '';
        return type === 'line-items' && name === 'email_addresses';
    }
    getValidator(viewField, record) {
        if (!viewField || !viewField.fieldDefinition || !record) {
            return [];
        }
        return [primaryEmailValidator(viewField, record)];
    }
    static { this.ɵfac = function PrimaryEmailValidator_Factory(t) { return new (t || PrimaryEmailValidator)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PrimaryEmailValidator, factory: PrimaryEmailValidator.ɵfac, providedIn: 'root' }); }
}
export { PrimaryEmailValidator };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PrimaryEmailValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();
//# sourceMappingURL=data:application/json;base64,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