/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from '@angular/core';
import { DataTypeFormatter } from '../../services/formatters/data-type.formatter.service';
import { RecordManager } from '../../services/record/record.manager';
import { FieldLogicManager } from '../field-logic/field-logic.manager';
import { BaseLineItemsComponent } from '../base/base-line-items.component';
import { FieldManager } from '../../services/record/field/field.manager';
import { FieldRegistry } from '../field.registry';
import { FieldLogicDisplayManager } from '../field-logic-display/field-logic-display.manager';
import * as i0 from "@angular/core";
import * as i1 from "../../services/formatters/data-type.formatter.service";
import * as i2 from "../field.registry";
import * as i3 from "../../services/record/record.manager";
import * as i4 from "../field-logic/field-logic.manager";
import * as i5 from "../../services/record/field/field.manager";
import * as i6 from "../field-logic-display/field-logic-display.manager";
import * as i7 from "@angular/common";
import * as i8 from "../../components/label/label.component";
import * as i9 from "../dynamic-field/dynamic-field.component";
import * as i10 from "../../components/button/button.component";
import * as i11 from "../../components/dynamic-label/dynamic-label.component";
function LineItemsComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-label", 1);
    i0.ɵɵelementContainerEnd();
} }
function LineItemsComponent_ng_container_1_ng_container_1_ng_container_3_div_1_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "scrm-dynamic-field", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const itemField_r12 = ctx.$implicit;
    const item_r7 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r10 = i0.ɵɵnextContext(3);
    i0.ɵɵclassMapInterpolate2("", itemField_r12.type, " ", itemField_r12.name, "");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("componentType", ctx_r10.getComponentType(itemField_r12.type, itemField_r12.definition))("field", itemField_r12)("klass", ctx_r10.klass)("mode", ctx_r10.mode)("originalMode", ctx_r10.originalMode)("record", item_r7)("parent", ctx_r10.parent)("type", itemField_r12.type);
} }
function LineItemsComponent_ng_container_1_ng_container_1_ng_container_3_div_1_scrm_button_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-button", 11);
} if (rf & 2) {
    const ctx_r14 = i0.ɵɵnextContext(2);
    const item_r7 = ctx_r14.$implicit;
    const i_r8 = ctx_r14.index;
    const ctx_r11 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("config", ctx_r11.getRemoveItemButton(item_r7, i_r8));
} }
function LineItemsComponent_ng_container_1_ng_container_1_ng_container_3_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 6)(1, "div", 7);
    i0.ɵɵtemplate(2, LineItemsComponent_ng_container_1_ng_container_1_ng_container_3_div_1_div_2_Template, 2, 12, "div", 8);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 9);
    i0.ɵɵtemplate(4, LineItemsComponent_ng_container_1_ng_container_1_ng_container_3_div_1_scrm_button_4_Template, 1, 1, "scrm-button", 4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const item_r7 = i0.ɵɵnextContext().$implicit;
    const ctx_r9 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r9.getItemFields(item_r7));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r9.isEditable());
} }
function LineItemsComponent_ng_container_1_ng_container_1_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, LineItemsComponent_ng_container_1_ng_container_1_ng_container_3_div_1_Template, 5, 2, "div", 5);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r7 = ctx.$implicit;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !(item_r7 && item_r7.attributes && item_r7.attributes.deleted));
} }
function LineItemsComponent_ng_container_1_ng_container_1_scrm_button_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-button", 11);
} if (rf & 2) {
    const ctx_r5 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("config", ctx_r5.getAddItemButton());
} }
const _c0 = function (a0) { return { field: a0 }; };
function LineItemsComponent_ng_container_1_ng_container_1_ng_container_6_ng_container_1_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 13);
    i0.ɵɵelement(1, "scrm-dynamic-label", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r18 = ctx.$implicit;
    const ctx_r17 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("context", ctx_r17.getMessageContext(item_r18.value, ctx_r17.record))("fields", i0.ɵɵpureFunction1(3, _c0, ctx_r17.field))("labelKey", ctx_r17.getMessageLabelKey(item_r18.value));
} }
function LineItemsComponent_ng_container_1_ng_container_1_ng_container_6_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, LineItemsComponent_ng_container_1_ng_container_1_ng_container_6_ng_container_1_div_1_Template, 2, 5, "div", 12);
    i0.ɵɵpipe(2, "keyvalue");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r16 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind1(2, 1, ctx_r16.field.itemFormArray.errors));
} }
function LineItemsComponent_ng_container_1_ng_container_1_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, LineItemsComponent_ng_container_1_ng_container_1_ng_container_6_ng_container_1_Template, 3, 3, "ng-container", 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r6 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r6.field.itemFormArray.invalid);
} }
function LineItemsComponent_ng_container_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div")(2, "div");
    i0.ɵɵtemplate(3, LineItemsComponent_ng_container_1_ng_container_1_ng_container_3_Template, 2, 1, "ng-container", 2);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 3);
    i0.ɵɵtemplate(5, LineItemsComponent_ng_container_1_ng_container_1_scrm_button_5_Template, 1, 1, "scrm-button", 4);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(6, LineItemsComponent_ng_container_1_ng_container_1_ng_container_6_Template, 2, 1, "ng-container", 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵclassMapInterpolate2("line-items d-flex flex-column ", ctx_r2.field.type, " ", ctx_r2.field.name, "");
    i0.ɵɵadvance(1);
    i0.ɵɵclassMapInterpolate1("d-flex ", ctx_r2.getDirection(), " justify-content-start align-items-end line-item h-100");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r2.field.items);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r2.isEditable());
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", (ctx_r2.mode === "edit" || ctx_r2.mode === "filter") && ctx_r2.field.itemFormArray && ctx_r2.field.itemFormArray.errors);
} }
function LineItemsComponent_ng_container_1_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 15);
    i0.ɵɵelement(2, "div", 16);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} }
function LineItemsComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, LineItemsComponent_ng_container_1_ng_container_1_Template, 7, 10, "ng-container", 0);
    i0.ɵɵtemplate(2, LineItemsComponent_ng_container_1_ng_container_2_Template, 3, 0, "ng-container", 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r1.field.loading);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r1.field.loading);
} }
class LineItemsComponent extends BaseLineItemsComponent {
    constructor(typeFormatter, registry, recordManager, logic, fieldManager, logicDisplay) {
        super(typeFormatter, registry, recordManager, logic, fieldManager, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.registry = registry;
        this.recordManager = recordManager;
        this.logic = logic;
        this.fieldManager = fieldManager;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        super.ngOnInit();
        this.field.metadata = this?.field?.metadata ?? {};
        const emptyItemInitialized = this?.field?.metadata?.emptyItemInitialized ?? false;
        if (['create'].includes(this.originalMode) && !emptyItemInitialized) {
            this.initEmptyItem();
            this.field.metadata.emptyItemInitialized = true;
        }
    }
    /**
     * Add item button config
     * @returns {object} ButtonInterface
     */
    getAddItemButton() {
        return {
            klass: 'btn btn-sm btn-outline-secondary m-0 border-0',
            icon: 'plus',
            onClick: () => {
                this.addEmptyItem();
            },
        };
    }
    /**
     * Remove item button config
     * @param {object} item
     * @param {number} index
     * @returns {object} ButtonInterface
     */
    getRemoveItemButton(item, index) {
        return {
            klass: 'btn btn-sm btn-outline-secondary m-0 border-0',
            icon: 'minimise',
            onClick: () => {
                this.removeItem(index);
            },
        };
    }
    static { this.ɵfac = function LineItemsComponent_Factory(t) { return new (t || LineItemsComponent)(i0.ɵɵdirectiveInject(i1.DataTypeFormatter), i0.ɵɵdirectiveInject(i2.FieldRegistry), i0.ɵɵdirectiveInject(i3.RecordManager), i0.ɵɵdirectiveInject(i4.FieldLogicManager), i0.ɵɵdirectiveInject(i5.FieldManager), i0.ɵɵdirectiveInject(i6.FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LineItemsComponent, selectors: [["scrm-line-items-field"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 2, consts: [[4, "ngIf"], ["labelKey", "LBL_LINE_ITEMS_FIELD_CONFIG"], [4, "ngFor", "ngForOf"], [1, "line-item-buttons", "d-flex", "justify-content-end", "mt-1"], [3, "config", 4, "ngIf"], ["class", "d-flex flex-row line-item-entry w-100 align-items-end", 4, "ngIf"], [1, "d-flex", "flex-row", "line-item-entry", "w-100", "align-items-end"], [1, "flex-grow-1", "line-item-entry-composite"], [3, "class", 4, "ngFor", "ngForOf"], [1, "line-item-entry-buttons", "mb-1"], [3, "componentType", "field", "klass", "mode", "originalMode", "record", "parent", "type"], [3, "config"], ["class", "invalid-feedback d-block", 4, "ngFor", "ngForOf"], [1, "invalid-feedback", "d-block"], [3, "context", "fields", "labelKey"], [1, "dynamic-field"], [1, "flex-grow-1", "text-break", "rounded", "box-loading", "skeleton-field-content"]], template: function LineItemsComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LineItemsComponent_ng_container_0_Template, 2, 0, "ng-container", 0);
            i0.ɵɵtemplate(1, LineItemsComponent_ng_container_1_Template, 3, 2, "ng-container", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.isConfigured());
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.isConfigured());
        } }, dependencies: [i7.NgForOf, i7.NgIf, i8.LabelComponent, i9.DynamicFieldComponent, i10.ButtonComponent, i11.DynamicLabelComponent, i7.KeyValuePipe], encapsulation: 2 }); }
}
export { LineItemsComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LineItemsComponent, [{
        type: Component,
        args: [{ selector: 'scrm-line-items-field', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"!isConfigured()\">\n    <scrm-label labelKey=\"LBL_LINE_ITEMS_FIELD_CONFIG\"></scrm-label>\n</ng-container>\n\n<ng-container *ngIf=\"isConfigured()\">\n\n    <ng-container *ngIf=\"!field.loading\">\n        <div class=\"line-items d-flex flex-column {{field.type}} {{field.name}}\">\n\n            <div class=\"d-flex {{getDirection()}} justify-content-start align-items-end line-item h-100\">\n                <ng-container *ngFor=\"let item of field.items; index as i\">\n                    <div *ngIf=\"!(item && item.attributes && item.attributes.deleted)\"\n                         class=\"d-flex flex-row line-item-entry w-100 align-items-end\">\n\n                        <div class=\"flex-grow-1 line-item-entry-composite\">\n                            <div *ngFor=\"let itemField of getItemFields(item)\"\n                                 class=\"{{itemField.type}} {{itemField.name}}\">\n                                <scrm-dynamic-field [componentType]=\"getComponentType(itemField.type, itemField.definition)\"\n                                                    [field]=\"itemField\"\n                                                    [klass]=\"klass\"\n                                                    [mode]=\"mode\"\n                                                    [originalMode]=\"originalMode\"\n                                                    [record]=\"item\"\n                                                    [parent]=\"parent\"\n                                                    [type]=\"itemField.type\">\n                                </scrm-dynamic-field>\n                            </div>\n                        </div>\n\n                        <div class=\"line-item-entry-buttons mb-1\">\n                            <scrm-button *ngIf=\"isEditable()\" [config]=\"getRemoveItemButton(item, i)\">\n                            </scrm-button>\n                        </div>\n                    </div>\n                </ng-container>\n\n\n            </div>\n            <div class=\"line-item-buttons d-flex justify-content-end mt-1\">\n                <scrm-button *ngIf=\"isEditable()\" [config]=\"getAddItemButton()\">\n                </scrm-button>\n            </div>\n\n        </div>\n\n        <ng-container *ngIf=\"(mode === 'edit' || mode === 'filter') && field.itemFormArray && field.itemFormArray.errors\">\n            <ng-container *ngIf=\"field.itemFormArray.invalid\">\n                <div *ngFor=\"let item of field.itemFormArray.errors | keyvalue\" class=\"invalid-feedback d-block\">\n                    <scrm-dynamic-label [context]=\"getMessageContext(item.value, record)\"\n                                        [fields]=\"{field: field}\"\n                                        [labelKey]=\"getMessageLabelKey(item.value)\">\n                    </scrm-dynamic-label>\n                </div>\n            </ng-container>\n        </ng-container>\n    </ng-container>\n\n\n    <ng-container *ngIf=\"field.loading\">\n        <div class= \"dynamic-field\">\n            <div class=\"flex-grow-1 text-break rounded box-loading skeleton-field-content\"></div>\n        </div>\n    </ng-container>\n\n</ng-container>\n" }]
    }], function () { return [{ type: i1.DataTypeFormatter }, { type: i2.FieldRegistry }, { type: i3.RecordManager }, { type: i4.FieldLogicManager }, { type: i5.FieldManager }, { type: i6.FieldLogicDisplayManager }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGluZS1pdGVtcy5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9jb3JlL2FwcC9jb3JlL3NyYy9saWIvZmllbGRzL2xpbmUtaXRlbXMvbGluZS1pdGVtcy5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi9jb3JlL2FwcC9jb3JlL3NyYy9saWIvZmllbGRzL2xpbmUtaXRlbXMvbGluZS1pdGVtcy5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBd0JHO0FBRUgsT0FBTyxFQUFDLFNBQVMsRUFBQyxNQUFNLGVBQWUsQ0FBQztBQUN4QyxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSx1REFBdUQsQ0FBQztBQUN4RixPQUFPLEVBQUMsYUFBYSxFQUFDLE1BQU0sc0NBQXNDLENBQUM7QUFDbkUsT0FBTyxFQUFDLGlCQUFpQixFQUFDLE1BQU0sb0NBQW9DLENBQUM7QUFDckUsT0FBTyxFQUFDLHNCQUFzQixFQUFDLE1BQU0sbUNBQW1DLENBQUM7QUFFekUsT0FBTyxFQUFDLFlBQVksRUFBQyxNQUFNLDJDQUEyQyxDQUFDO0FBQ3ZFLE9BQU8sRUFBQyxhQUFhLEVBQUMsTUFBTSxtQkFBbUIsQ0FBQztBQUNoRCxPQUFPLEVBQUMsd0JBQXdCLEVBQUMsTUFBTSxvREFBb0QsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7SUNQNUYsNkJBQXNDO0lBQ2xDLGdDQUFnRTtJQUNwRSwwQkFBZTs7O0lBYWEsMkJBQ21EO0lBQy9DLHlDQVFxQjtJQUN6QixpQkFBTTs7Ozs7SUFWRCw4RUFBNkM7SUFDMUIsZUFBd0U7SUFBeEUsc0dBQXdFLHdCQUFBLHdCQUFBLHNCQUFBLHNDQUFBLG1CQUFBLDBCQUFBLDRCQUFBOzs7SUFhaEcsa0NBQ2M7Ozs7OztJQURvQixtRUFBdUM7OztJQW5CakYsOEJBQ21FLGFBQUE7SUFHM0QsdUhBV007SUFDVixpQkFBTTtJQUVOLDhCQUEwQztJQUN0QyxzSUFDYztJQUNsQixpQkFBTSxFQUFBOzs7O0lBakJ5QixlQUFzQjtJQUF0Qix1REFBc0I7SUFlbkMsZUFBa0I7SUFBbEIsMENBQWtCOzs7SUFwQjVDLDZCQUEyRDtJQUN2RCxnSEFzQk07SUFDViwwQkFBZTs7O0lBdkJMLGVBQTJEO0lBQTNELHFGQUEyRDs7O0lBNEJyRSxrQ0FDYzs7O0lBRG9CLGtEQUE2Qjs7OztJQVEvRCwrQkFBaUc7SUFDN0YseUNBR3FCO0lBQ3pCLGlCQUFNOzs7O0lBSmtCLGVBQWlEO0lBQWpELG1GQUFpRCxxREFBQSx3REFBQTs7O0lBRjdFLDZCQUFrRDtJQUM5QyxnSUFLTTs7SUFDViwwQkFBZTs7O0lBTlcsZUFBd0M7SUFBeEMsa0ZBQXdDOzs7SUFGdEUsNkJBQWtIO0lBQzlHLGtJQU9lO0lBQ25CLDBCQUFlOzs7SUFSSSxlQUFpQztJQUFqQyx5REFBaUM7OztJQXhDeEQsNkJBQXFDO0lBQ2pDLDJCQUF5RSxVQUFBO0lBR2pFLG1IQXdCZTtJQUduQixpQkFBTTtJQUNOLDhCQUErRDtJQUMzRCxpSEFDYztJQUNsQixpQkFBTSxFQUFBO0lBSVYsbUhBU2U7SUFDbkIsMEJBQWU7OztJQWhETixlQUFtRTtJQUFuRSwwR0FBbUU7SUFFL0QsZUFBdUY7SUFBdkYscUhBQXVGO0lBQ3pELGVBQWdCO0lBQWhCLDRDQUFnQjtJQTZCakMsZUFBa0I7SUFBbEIsMENBQWtCO0lBTXpCLGVBQWlHO0lBQWpHLDhJQUFpRzs7O0lBYXBILDZCQUFvQztJQUNoQywrQkFBNEI7SUFDeEIsMEJBQXFGO0lBQ3pGLGlCQUFNO0lBQ1YsMEJBQWU7OztJQTFEbkIsNkJBQXFDO0lBRWpDLHFHQWlEZTtJQUdmLG9HQUllO0lBRW5CLDBCQUFlOzs7SUExREksZUFBb0I7SUFBcEIsNENBQW9CO0lBb0RwQixlQUFtQjtJQUFuQiwyQ0FBbUI7O0FEakR0QyxNQUthLGtCQUFtQixTQUFRLHNCQUFzQjtJQUUxRCxZQUNjLGFBQWdDLEVBQ2hDLFFBQXVCLEVBQ3ZCLGFBQTRCLEVBQzVCLEtBQXdCLEVBQ3hCLFlBQTBCLEVBQzFCLFlBQXNDO1FBRWhELEtBQUssQ0FBQyxhQUFhLEVBQUUsUUFBUSxFQUFFLGFBQWEsRUFBRSxLQUFLLEVBQUUsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO1FBUHZFLGtCQUFhLEdBQWIsYUFBYSxDQUFtQjtRQUNoQyxhQUFRLEdBQVIsUUFBUSxDQUFlO1FBQ3ZCLGtCQUFhLEdBQWIsYUFBYSxDQUFlO1FBQzVCLFVBQUssR0FBTCxLQUFLLENBQW1CO1FBQ3hCLGlCQUFZLEdBQVosWUFBWSxDQUFjO1FBQzFCLGlCQUFZLEdBQVosWUFBWSxDQUEwQjtJQUdwRCxDQUFDO0lBRUQsUUFBUTtRQUNKLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUVqQixJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsR0FBRyxJQUFJLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxFQUFFLENBQUM7UUFDbEQsTUFBTSxvQkFBb0IsR0FBRyxJQUFJLEVBQUUsS0FBSyxFQUFFLFFBQVEsRUFBRSxvQkFBb0IsSUFBSSxLQUFLLENBQUM7UUFDbEYsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBd0IsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLEVBQUU7WUFDN0UsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQ3JCLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLG9CQUFvQixHQUFHLElBQUksQ0FBQztTQUNuRDtJQUNMLENBQUM7SUFFRDs7O09BR0c7SUFDSCxnQkFBZ0I7UUFDWixPQUFPO1lBQ0gsS0FBSyxFQUFFLCtDQUErQztZQUN0RCxJQUFJLEVBQUUsTUFBTTtZQUNaLE9BQU8sRUFBRSxHQUFTLEVBQUU7Z0JBQ2hCLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUN4QixDQUFDO1NBRUosQ0FBQztJQUNOLENBQUM7SUFFRDs7Ozs7T0FLRztJQUNILG1CQUFtQixDQUFDLElBQWUsRUFBRSxLQUFhO1FBQzlDLE9BQU87WUFDSCxLQUFLLEVBQUUsK0NBQStDO1lBQ3RELElBQUksRUFBRSxVQUFVO1lBQ2hCLE9BQU8sRUFBRSxHQUFTLEVBQUU7Z0JBQ2hCLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDM0IsQ0FBQztTQUNKLENBQUM7SUFDTixDQUFDO21GQXJEUSxrQkFBa0I7b0VBQWxCLGtCQUFrQjtZQ2QvQixxRkFFZTtZQUVmLHFGQTREZTs7WUFoRUEsMENBQXFCO1lBSXJCLGVBQW9CO1lBQXBCLHlDQUFvQjs7O1NEVXRCLGtCQUFrQjt1RkFBbEIsa0JBQWtCO2NBTDlCLFNBQVM7MkJBQ0ksdUJBQXVCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTdWl0ZUNSTSBpcyBhIGN1c3RvbWVyIHJlbGF0aW9uc2hpcCBtYW5hZ2VtZW50IHByb2dyYW0gZGV2ZWxvcGVkIGJ5IFNhbGVzQWdpbGl0eSBMdGQuXG4gKiBDb3B5cmlnaHQgKEMpIDIwMjEgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZnJlZSBzb2Z0d2FyZTsgeW91IGNhbiByZWRpc3RyaWJ1dGUgaXQgYW5kL29yIG1vZGlmeSBpdCB1bmRlclxuICogdGhlIHRlcm1zIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgdmVyc2lvbiAzIGFzIHB1Ymxpc2hlZCBieSB0aGVcbiAqIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiAqIHRvIFNlY3Rpb24gMTUgYXMgcGVybWl0dGVkIGluIFNlY3Rpb24gNyhhKTogRk9SIEFOWSBQQVJUIE9GIFRIRSBDT1ZFUkVEIFdPUktcbiAqIElOIFdISUNIIFRIRSBDT1BZUklHSFQgSVMgT1dORUQgQlkgU0FMRVNBR0lMSVRZLCBTQUxFU0FHSUxJVFkgRElTQ0xBSU1TIFRIRVxuICogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGRpc3RyaWJ1dGVkIGluIHRoZSBob3BlIHRoYXQgaXQgd2lsbCBiZSB1c2VmdWwsIGJ1dCBXSVRIT1VUXG4gKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuICogRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFLiBTZWUgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSBmb3IgbW9yZVxuICogZGV0YWlscy5cbiAqXG4gKiBZb3Ugc2hvdWxkIGhhdmUgcmVjZWl2ZWQgYSBjb3B5IG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIGFsb25nIHdpdGggdGhpcyBwcm9ncmFtLiAgSWYgbm90LCBzZWUgPGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy8+LlxuICpcbiAqIEluIGFjY29yZGFuY2Ugd2l0aCBTZWN0aW9uIDcoYikgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogdmVyc2lvbiAzLCB0aGVzZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgcmV0YWluIHRoZSBkaXNwbGF5IG9mIHRoZVxuICogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiAqIGZlYXNpYmxlIGZvciB0ZWNobmljYWwgcmVhc29ucywgdGhlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCBkaXNwbGF5XG4gKiB0aGUgd29yZHMgXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIi5cbiAqL1xuXG5pbXBvcnQge0NvbXBvbmVudH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQge0RhdGFUeXBlRm9ybWF0dGVyfSBmcm9tICcuLi8uLi9zZXJ2aWNlcy9mb3JtYXR0ZXJzL2RhdGEtdHlwZS5mb3JtYXR0ZXIuc2VydmljZSc7XG5pbXBvcnQge1JlY29yZE1hbmFnZXJ9IGZyb20gJy4uLy4uL3NlcnZpY2VzL3JlY29yZC9yZWNvcmQubWFuYWdlcic7XG5pbXBvcnQge0ZpZWxkTG9naWNNYW5hZ2VyfSBmcm9tICcuLi9maWVsZC1sb2dpYy9maWVsZC1sb2dpYy5tYW5hZ2VyJztcbmltcG9ydCB7QmFzZUxpbmVJdGVtc0NvbXBvbmVudH0gZnJvbSAnLi4vYmFzZS9iYXNlLWxpbmUtaXRlbXMuY29tcG9uZW50JztcbmltcG9ydCB7QnV0dG9uSW50ZXJmYWNlLCBFRElUQUJMRV9WSUVXX01PREVTLCBPYmplY3RNYXAsIFZpZXdNb2RlfSBmcm9tICdjb21tb24nO1xuaW1wb3J0IHtGaWVsZE1hbmFnZXJ9IGZyb20gJy4uLy4uL3NlcnZpY2VzL3JlY29yZC9maWVsZC9maWVsZC5tYW5hZ2VyJztcbmltcG9ydCB7RmllbGRSZWdpc3RyeX0gZnJvbSAnLi4vZmllbGQucmVnaXN0cnknO1xuaW1wb3J0IHtGaWVsZExvZ2ljRGlzcGxheU1hbmFnZXJ9IGZyb20gJy4uL2ZpZWxkLWxvZ2ljLWRpc3BsYXkvZmllbGQtbG9naWMtZGlzcGxheS5tYW5hZ2VyJztcblxuQENvbXBvbmVudCh7XG4gICAgc2VsZWN0b3I6ICdzY3JtLWxpbmUtaXRlbXMtZmllbGQnLFxuICAgIHRlbXBsYXRlVXJsOiAnLi9saW5lLWl0ZW1zLmNvbXBvbmVudC5odG1sJyxcbiAgICBzdHlsZVVybHM6IFtdXG59KVxuZXhwb3J0IGNsYXNzIExpbmVJdGVtc0NvbXBvbmVudCBleHRlbmRzIEJhc2VMaW5lSXRlbXNDb21wb25lbnQge1xuXG4gICAgY29uc3RydWN0b3IoXG4gICAgICAgIHByb3RlY3RlZCB0eXBlRm9ybWF0dGVyOiBEYXRhVHlwZUZvcm1hdHRlcixcbiAgICAgICAgcHJvdGVjdGVkIHJlZ2lzdHJ5OiBGaWVsZFJlZ2lzdHJ5LFxuICAgICAgICBwcm90ZWN0ZWQgcmVjb3JkTWFuYWdlcjogUmVjb3JkTWFuYWdlcixcbiAgICAgICAgcHJvdGVjdGVkIGxvZ2ljOiBGaWVsZExvZ2ljTWFuYWdlcixcbiAgICAgICAgcHJvdGVjdGVkIGZpZWxkTWFuYWdlcjogRmllbGRNYW5hZ2VyLFxuICAgICAgICBwcm90ZWN0ZWQgbG9naWNEaXNwbGF5OiBGaWVsZExvZ2ljRGlzcGxheU1hbmFnZXJcbiAgICApIHtcbiAgICAgICAgc3VwZXIodHlwZUZvcm1hdHRlciwgcmVnaXN0cnksIHJlY29yZE1hbmFnZXIsIGxvZ2ljLCBmaWVsZE1hbmFnZXIsIGxvZ2ljRGlzcGxheSk7XG4gICAgfVxuXG4gICAgbmdPbkluaXQoKTogdm9pZCB7XG4gICAgICAgIHN1cGVyLm5nT25Jbml0KCk7XG5cbiAgICAgICAgdGhpcy5maWVsZC5tZXRhZGF0YSA9IHRoaXM/LmZpZWxkPy5tZXRhZGF0YSA/PyB7fTtcbiAgICAgICAgY29uc3QgZW1wdHlJdGVtSW5pdGlhbGl6ZWQgPSB0aGlzPy5maWVsZD8ubWV0YWRhdGE/LmVtcHR5SXRlbUluaXRpYWxpemVkID8/IGZhbHNlO1xuICAgICAgICBpZiAoWydjcmVhdGUnXS5pbmNsdWRlcyh0aGlzLm9yaWdpbmFsTW9kZSBhcyBWaWV3TW9kZSkgJiYgIWVtcHR5SXRlbUluaXRpYWxpemVkKSB7XG4gICAgICAgICAgICB0aGlzLmluaXRFbXB0eUl0ZW0oKTtcbiAgICAgICAgICAgIHRoaXMuZmllbGQubWV0YWRhdGEuZW1wdHlJdGVtSW5pdGlhbGl6ZWQgPSB0cnVlO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQWRkIGl0ZW0gYnV0dG9uIGNvbmZpZ1xuICAgICAqIEByZXR1cm5zIHtvYmplY3R9IEJ1dHRvbkludGVyZmFjZVxuICAgICAqL1xuICAgIGdldEFkZEl0ZW1CdXR0b24oKTogQnV0dG9uSW50ZXJmYWNlIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGtsYXNzOiAnYnRuIGJ0bi1zbSBidG4tb3V0bGluZS1zZWNvbmRhcnkgbS0wIGJvcmRlci0wJyxcbiAgICAgICAgICAgIGljb246ICdwbHVzJyxcbiAgICAgICAgICAgIG9uQ2xpY2s6ICgpOiB2b2lkID0+IHtcbiAgICAgICAgICAgICAgICB0aGlzLmFkZEVtcHR5SXRlbSgpO1xuICAgICAgICAgICAgfSxcblxuICAgICAgICB9O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFJlbW92ZSBpdGVtIGJ1dHRvbiBjb25maWdcbiAgICAgKiBAcGFyYW0ge29iamVjdH0gaXRlbVxuICAgICAqIEBwYXJhbSB7bnVtYmVyfSBpbmRleFxuICAgICAqIEByZXR1cm5zIHtvYmplY3R9IEJ1dHRvbkludGVyZmFjZVxuICAgICAqL1xuICAgIGdldFJlbW92ZUl0ZW1CdXR0b24oaXRlbTogT2JqZWN0TWFwLCBpbmRleDogbnVtYmVyKTogQnV0dG9uSW50ZXJmYWNlIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGtsYXNzOiAnYnRuIGJ0bi1zbSBidG4tb3V0bGluZS1zZWNvbmRhcnkgbS0wIGJvcmRlci0wJyxcbiAgICAgICAgICAgIGljb246ICdtaW5pbWlzZScsXG4gICAgICAgICAgICBvbkNsaWNrOiAoKTogdm9pZCA9PiB7XG4gICAgICAgICAgICAgICAgdGhpcy5yZW1vdmVJdGVtKGluZGV4KTtcbiAgICAgICAgICAgIH0sXG4gICAgICAgIH07XG4gICAgfVxuXG59XG4iLCI8ISAtLVxuLyoqXG4qIFN1aXRlQ1JNIGlzIGEgY3VzdG9tZXIgcmVsYXRpb25zaGlwIG1hbmFnZW1lbnQgcHJvZ3JhbSBkZXZlbG9wZWQgYnkgU2FsZXNBZ2lsaXR5IEx0ZC5cbiogQ29weXJpZ2h0IChDKSAyMDIxIFNhbGVzQWdpbGl0eSBMdGQuXG4qXG4qIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5IGl0IHVuZGVyXG4qIHRoZSB0ZXJtcyBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIHZlcnNpb24gMyBhcyBwdWJsaXNoZWQgYnkgdGhlXG4qIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiogdG8gU2VjdGlvbiAxNSBhcyBwZXJtaXR0ZWQgaW4gU2VjdGlvbiA3KGEpOiBGT1IgQU5ZIFBBUlQgT0YgVEhFIENPVkVSRUQgV09SS1xuKiBJTiBXSElDSCBUSEUgQ09QWVJJR0hUIElTIE9XTkVEIEJZIFNBTEVTQUdJTElUWSwgU0FMRVNBR0lMSVRZIERJU0NMQUlNUyBUSEVcbiogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4qXG4qIFRoaXMgcHJvZ3JhbSBpcyBkaXN0cmlidXRlZCBpbiB0aGUgaG9wZSB0aGF0IGl0IHdpbGwgYmUgdXNlZnVsLCBidXQgV0lUSE9VVFxuKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuKiBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlXG4qIGRldGFpbHMuXG4qXG4qIFlvdSBzaG91bGQgaGF2ZSByZWNlaXZlZCBhIGNvcHkgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuKiBhbG9uZyB3aXRoIHRoaXMgcHJvZ3JhbS4gIElmIG5vdCwgc2VlIGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy5cbipcbiogSW4gYWNjb3JkYW5jZSB3aXRoIFNlY3Rpb24gNyhiKSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4qIHZlcnNpb24gMywgdGhlc2UgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IHJldGFpbiB0aGUgZGlzcGxheSBvZiB0aGVcbiogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiogZmVhc2libGUgZm9yIHRlY2huaWNhbCByZWFzb25zLCB0aGUgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IGRpc3BsYXlcbiogdGhlIHdvcmRzIFwiU3VwZXJjaGFyZ2VkIGJ5IFN1aXRlQ1JNXCIuXG4qL1xuLS0+XG48bmctY29udGFpbmVyICpuZ0lmPVwiIWlzQ29uZmlndXJlZCgpXCI+XG4gICAgPHNjcm0tbGFiZWwgbGFiZWxLZXk9XCJMQkxfTElORV9JVEVNU19GSUVMRF9DT05GSUdcIj48L3Njcm0tbGFiZWw+XG48L25nLWNvbnRhaW5lcj5cblxuPG5nLWNvbnRhaW5lciAqbmdJZj1cImlzQ29uZmlndXJlZCgpXCI+XG5cbiAgICA8bmctY29udGFpbmVyICpuZ0lmPVwiIWZpZWxkLmxvYWRpbmdcIj5cbiAgICAgICAgPGRpdiBjbGFzcz1cImxpbmUtaXRlbXMgZC1mbGV4IGZsZXgtY29sdW1uIHt7ZmllbGQudHlwZX19IHt7ZmllbGQubmFtZX19XCI+XG5cbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJkLWZsZXgge3tnZXREaXJlY3Rpb24oKX19IGp1c3RpZnktY29udGVudC1zdGFydCBhbGlnbi1pdGVtcy1lbmQgbGluZS1pdGVtIGgtMTAwXCI+XG4gICAgICAgICAgICAgICAgPG5nLWNvbnRhaW5lciAqbmdGb3I9XCJsZXQgaXRlbSBvZiBmaWVsZC5pdGVtczsgaW5kZXggYXMgaVwiPlxuICAgICAgICAgICAgICAgICAgICA8ZGl2ICpuZ0lmPVwiIShpdGVtICYmIGl0ZW0uYXR0cmlidXRlcyAmJiBpdGVtLmF0dHJpYnV0ZXMuZGVsZXRlZClcIlxuICAgICAgICAgICAgICAgICAgICAgICAgIGNsYXNzPVwiZC1mbGV4IGZsZXgtcm93IGxpbmUtaXRlbS1lbnRyeSB3LTEwMCBhbGlnbi1pdGVtcy1lbmRcIj5cblxuICAgICAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzcz1cImZsZXgtZ3Jvdy0xIGxpbmUtaXRlbS1lbnRyeS1jb21wb3NpdGVcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8ZGl2ICpuZ0Zvcj1cImxldCBpdGVtRmllbGQgb2YgZ2V0SXRlbUZpZWxkcyhpdGVtKVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjbGFzcz1cInt7aXRlbUZpZWxkLnR5cGV9fSB7e2l0ZW1GaWVsZC5uYW1lfX1cIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tZHluYW1pYy1maWVsZCBbY29tcG9uZW50VHlwZV09XCJnZXRDb21wb25lbnRUeXBlKGl0ZW1GaWVsZC50eXBlLCBpdGVtRmllbGQuZGVmaW5pdGlvbilcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtmaWVsZF09XCJpdGVtRmllbGRcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtrbGFzc109XCJrbGFzc1wiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW21vZGVdPVwibW9kZVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW29yaWdpbmFsTW9kZV09XCJvcmlnaW5hbE1vZGVcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtyZWNvcmRdPVwiaXRlbVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW3BhcmVudF09XCJwYXJlbnRcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFt0eXBlXT1cIml0ZW1GaWVsZC50eXBlXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvc2NybS1keW5hbWljLWZpZWxkPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJsaW5lLWl0ZW0tZW50cnktYnV0dG9ucyBtYi0xXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNjcm0tYnV0dG9uICpuZ0lmPVwiaXNFZGl0YWJsZSgpXCIgW2NvbmZpZ109XCJnZXRSZW1vdmVJdGVtQnV0dG9uKGl0ZW0sIGkpXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9zY3JtLWJ1dHRvbj5cbiAgICAgICAgICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cblxuXG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJsaW5lLWl0ZW0tYnV0dG9ucyBkLWZsZXgganVzdGlmeS1jb250ZW50LWVuZCBtdC0xXCI+XG4gICAgICAgICAgICAgICAgPHNjcm0tYnV0dG9uICpuZ0lmPVwiaXNFZGl0YWJsZSgpXCIgW2NvbmZpZ109XCJnZXRBZGRJdGVtQnV0dG9uKClcIj5cbiAgICAgICAgICAgICAgICA8L3Njcm0tYnV0dG9uPlxuICAgICAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgPG5nLWNvbnRhaW5lciAqbmdJZj1cIihtb2RlID09PSAnZWRpdCcgfHwgbW9kZSA9PT0gJ2ZpbHRlcicpICYmIGZpZWxkLml0ZW1Gb3JtQXJyYXkgJiYgZmllbGQuaXRlbUZvcm1BcnJheS5lcnJvcnNcIj5cbiAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCJmaWVsZC5pdGVtRm9ybUFycmF5LmludmFsaWRcIj5cbiAgICAgICAgICAgICAgICA8ZGl2ICpuZ0Zvcj1cImxldCBpdGVtIG9mIGZpZWxkLml0ZW1Gb3JtQXJyYXkuZXJyb3JzIHwga2V5dmFsdWVcIiBjbGFzcz1cImludmFsaWQtZmVlZGJhY2sgZC1ibG9ja1wiPlxuICAgICAgICAgICAgICAgICAgICA8c2NybS1keW5hbWljLWxhYmVsIFtjb250ZXh0XT1cImdldE1lc3NhZ2VDb250ZXh0KGl0ZW0udmFsdWUsIHJlY29yZClcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtmaWVsZHNdPVwie2ZpZWxkOiBmaWVsZH1cIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtsYWJlbEtleV09XCJnZXRNZXNzYWdlTGFiZWxLZXkoaXRlbS52YWx1ZSlcIj5cbiAgICAgICAgICAgICAgICAgICAgPC9zY3JtLWR5bmFtaWMtbGFiZWw+XG4gICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cbiAgICAgICAgPC9uZy1jb250YWluZXI+XG4gICAgPC9uZy1jb250YWluZXI+XG5cblxuICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCJmaWVsZC5sb2FkaW5nXCI+XG4gICAgICAgIDxkaXYgY2xhc3M9IFwiZHluYW1pYy1maWVsZFwiPlxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cImZsZXgtZ3Jvdy0xIHRleHQtYnJlYWsgcm91bmRlZCBib3gtbG9hZGluZyBza2VsZXRvbi1maWVsZC1jb250ZW50XCI+PC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgIDwvbmctY29udGFpbmVyPlxuXG48L25nLWNvbnRhaW5lcj5cbiJdfQ==