/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { ChangeDetectorRef, Component, computed, HostBinding, Input, signal, Type } from '@angular/core';
import { EDITABLE_VIEW_MODES } from 'common';
import { Router } from '@angular/router';
import { ModuleNameMapper } from '../../services/navigation/module-name-mapper/module-name-mapper.service';
import { ModuleNavigation } from '../../services/navigation/module-navigation/module-navigation.service';
import { DynamicLabelService } from '../../services/language/dynamic-label.service';
import { LinkRouteAsyncActionService } from '../../services/navigation/link-route-async-action/link-route-async-action.service';
import * as i0 from "@angular/core";
import * as i1 from "../../services/navigation/module-navigation/module-navigation.service";
import * as i2 from "../../services/navigation/module-name-mapper/module-name-mapper.service";
import * as i3 from "@angular/router";
import * as i4 from "../../services/language/dynamic-label.service";
import * as i5 from "../../services/navigation/link-route-async-action/link-route-async-action.service";
import * as i6 from "@angular/common";
import * as i7 from "../../components/dynamic-label/dynamic-label.component";
import * as i8 from "ng-dynamic-component";
const _c0 = function (a0, a1, a2, a3, a4, a5) { return { "mode": a0, "originalMode": a1, "field": a2, "klass": a3, "record": a4, "parent": a5 }; };
function DynamicFieldComponent_ng_container_0_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r7 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 1);
    i0.ɵɵlistener("click", function DynamicFieldComponent_ng_container_0_ng_container_1_Template_a_click_1_listener() { i0.ɵɵrestoreView(_r7); const ctx_r6 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r6.onClick()); });
    i0.ɵɵelement(2, "ndc-dynamic", 2);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ndcDynamicComponent", ctx_r3.componentType)("ndcDynamicInputs", i0.ɵɵpureFunction6(2, _c0, ctx_r3.mode, ctx_r3.originalMode, ctx_r3.field, ctx_r3.klass, ctx_r3.record, ctx_r3.parent));
} }
function DynamicFieldComponent_ng_container_0_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 3);
    i0.ɵɵelement(2, "ndc-dynamic", 2);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r4 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("routerLink", ctx_r4.getLink())("queryParams", ctx_r4.record == null ? null : ctx_r4.record.metadata == null ? null : ctx_r4.record.metadata.queryParams);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ndcDynamicComponent", ctx_r4.componentType)("ndcDynamicInputs", i0.ɵɵpureFunction6(4, _c0, ctx_r4.mode, ctx_r4.originalMode, ctx_r4.field, ctx_r4.klass, ctx_r4.record, ctx_r4.parent));
} }
function DynamicFieldComponent_ng_container_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "ndc-dynamic", 2);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r5 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ndcDynamicComponent", ctx_r5.componentType)("ndcDynamicInputs", i0.ɵɵpureFunction6(2, _c0, ctx_r5.mode, ctx_r5.originalMode, ctx_r5.field, ctx_r5.klass, ctx_r5.record, ctx_r5.parent));
} }
function DynamicFieldComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DynamicFieldComponent_ng_container_0_ng_container_1_Template, 3, 9, "ng-container", 0);
    i0.ɵɵtemplate(2, DynamicFieldComponent_ng_container_0_ng_container_2_Template, 3, 11, "ng-container", 0);
    i0.ɵɵtemplate(3, DynamicFieldComponent_ng_container_0_ng_container_3_Template, 2, 9, "ng-container", 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.hasOnClick());
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.isLink() && !ctx_r0.hasOnClick());
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r0.isLink() && !ctx_r0.hasOnClick());
} }
function DynamicFieldComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 4);
    i0.ɵɵelement(2, "div", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} }
const _c1 = function (a0) { return { field: a0 }; };
function DynamicFieldComponent_ng_container_2_ng_container_1_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7);
    i0.ɵɵelement(1, "scrm-dynamic-label", 8);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r10 = ctx.$implicit;
    const ctx_r9 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("context", ctx_r9.getMessageContext(item_r10.value, ctx_r9.record))("fields", i0.ɵɵpureFunction1(3, _c1, ctx_r9.field))("labelKey", ctx_r9.getMessageLabelKey(item_r10.value));
} }
function DynamicFieldComponent_ng_container_2_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DynamicFieldComponent_ng_container_2_ng_container_1_div_1_Template, 2, 5, "div", 6);
    i0.ɵɵpipe(2, "keyvalue");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r8 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind1(2, 1, ctx_r8.field.formControl.errors));
} }
function DynamicFieldComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DynamicFieldComponent_ng_container_2_ng_container_1_Template, 3, 3, "ng-container", 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r2.validateOnlyOnSubmit ? ctx_r2.isInvalid() : ctx_r2.field.formControl.invalid && ctx_r2.field.formControl.touched);
} }
class DynamicFieldComponent {
    constructor(navigation, moduleNameMapper, router, dynamicLabelService, linkRouteAsyncActionService, cd) {
        this.navigation = navigation;
        this.moduleNameMapper = moduleNameMapper;
        this.router = router;
        this.dynamicLabelService = dynamicLabelService;
        this.linkRouteAsyncActionService = linkRouteAsyncActionService;
        this.cd = cd;
        this.record = null;
        this.parent = null;
        this.klass = null;
        this.class = 'dynamic-field';
        this.isInvalid = signal(false);
        this.validateOnlyOnSubmit = false;
    }
    get getRelateLink() {
        let linkModule = this.field.definition.module;
        if (this.field.definition.type_name === 'parent_type') {
            linkModule = this.record.attributes.parent_type;
        }
        if (this.field.definition.id_name && linkModule) {
            const moduleName = this.moduleNameMapper.toFrontend(linkModule);
            return this.navigation.getRecordRouterLink(moduleName, this.record.attributes[this.field.definition.id_name]);
        }
        return '';
    }
    ngOnInit() {
        this.setHostClass();
        this.cd.detectChanges();
        this.validateOnlyOnSubmit = this.record?.metadata?.validateOnlyOnSubmit;
        if (this.record?.validationTriggered) {
            this.isInvalid = computed(() => {
                if (this.validateOnlyOnSubmit && this.record?.validationTriggered() && this.field.formControl?.invalid) {
                    return true;
                }
                return false;
            });
        }
    }
    isLink() {
        if (EDITABLE_VIEW_MODES.includes(this.mode)) {
            return false;
        }
        if (!this.field || !this.record) {
            return false;
        }
        if (this.type === 'relate') {
            return true;
        }
        return !!(this?.field?.metadata && this?.field?.metadata?.link);
    }
    hasOnClick() {
        const fieldMetadata = this?.field?.metadata ?? {};
        const linkAsyncAction = fieldMetadata?.linkAsyncAction ?? null;
        const linkOnClick = fieldMetadata?.onClick ?? null;
        return !!(linkAsyncAction || linkOnClick);
    }
    isEdit() {
        return this.mode === 'edit' || this.mode === 'filter';
    }
    getLink() {
        if (this.type === 'relate') {
            return this.getRelateLink;
        }
        const fieldMetadata = this?.field?.metadata ?? null;
        const linkRoute = fieldMetadata.linkRoute ?? null;
        if (fieldMetadata && linkRoute) {
            return this.dynamicLabelService.parse(linkRoute, {}, this.record.fields);
        }
        return this.navigation.getRecordRouterLink(this.record.module, this.record.id);
    }
    getMessageContext(item, record) {
        const context = item && item.message && item.message.context || {};
        context.module = (record && record.module) || '';
        return context;
    }
    getMessageLabelKey(item) {
        return (item && item.message && item.message.labelKey) || '';
    }
    onClick() {
        const fieldMetadata = this?.field?.metadata ?? null;
        if (fieldMetadata && fieldMetadata.onClick) {
            this.field.metadata.onClick(this.field, this.record);
            return;
        }
        const linkAsyncAction = fieldMetadata.linkAsyncAction ?? null;
        if (fieldMetadata && linkAsyncAction) {
            this.linkRouteAsyncActionService.run(linkAsyncAction, this.field, this.record);
            return;
        }
        this.router.navigateByUrl(this.getLink()).then();
        return false;
    }
    setHostClass() {
        const classes = [];
        classes.push('dynamic-field');
        if (this.mode) {
            classes.push('dynamic-field-mode-' + this.mode);
        }
        if (this.type) {
            classes.push('dynamic-field-type-' + this.type);
        }
        if (this.field && this.field.name) {
            classes.push('dynamic-field-name-' + this.field.name);
        }
        this.class = classes.join(' ');
    }
    static { this.ɵfac = function DynamicFieldComponent_Factory(t) { return new (t || DynamicFieldComponent)(i0.ɵɵdirectiveInject(i1.ModuleNavigation), i0.ɵɵdirectiveInject(i2.ModuleNameMapper), i0.ɵɵdirectiveInject(i3.Router), i0.ɵɵdirectiveInject(i4.DynamicLabelService), i0.ɵɵdirectiveInject(i5.LinkRouteAsyncActionService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DynamicFieldComponent, selectors: [["scrm-dynamic-field"]], hostVars: 2, hostBindings: function DynamicFieldComponent_HostBindings(rf, ctx) { if (rf & 2) {
            i0.ɵɵclassMap(ctx.class);
        } }, inputs: { mode: "mode", originalMode: "originalMode", type: "type", field: "field", record: "record", parent: "parent", klass: "klass", componentType: "componentType" }, decls: 3, vars: 3, consts: [[4, "ngIf"], [1, "clickable", "field-link", 3, "click"], [3, "ndcDynamicComponent", "ndcDynamicInputs"], [1, "field-link", 3, "routerLink", "queryParams"], [1, "dynamic-field"], [1, "flex-grow-1", "text-break", "rounded", "box-loading", "skeleton-field-content"], ["class", "invalid-feedback d-block", 4, "ngFor", "ngForOf"], [1, "invalid-feedback", "d-block"], [3, "context", "fields", "labelKey"]], template: function DynamicFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, DynamicFieldComponent_ng_container_0_Template, 4, 3, "ng-container", 0);
            i0.ɵɵtemplate(1, DynamicFieldComponent_ng_container_1_Template, 3, 0, "ng-container", 0);
            i0.ɵɵtemplate(2, DynamicFieldComponent_ng_container_2_Template, 2, 1, "ng-container", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.field.loading);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.field.loading);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.isEdit() && ctx.field.formControl && ctx.field.formControl.errors);
        } }, dependencies: [i6.NgForOf, i6.NgIf, i3.RouterLink, i7.DynamicLabelComponent, i8.DynamicIoDirective, i8.DynamicComponent, i6.KeyValuePipe], encapsulation: 2 }); }
}
export { DynamicFieldComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DynamicFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-dynamic-field', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"!field.loading\">\n    <ng-container *ngIf=\"hasOnClick()\">\n        <a (click)=\"onClick()\" class=\"clickable field-link\">\n            <ndc-dynamic\n                [ndcDynamicComponent]=\"componentType\"\n                [ndcDynamicInputs]=\"{\n                'mode': mode,\n                'originalMode': originalMode,\n                'field': field,\n                'klass': klass,\n                'record': record,\n                'parent': parent\n            }\"\n            ></ndc-dynamic>\n        </a>\n    </ng-container>\n    <ng-container *ngIf=\"isLink() && !hasOnClick()\">\n        <a [routerLink]=\"getLink()\" [queryParams]=\"record?.metadata?.queryParams\" class=\"field-link\">\n            <ndc-dynamic\n                [ndcDynamicComponent]=\"componentType\"\n                [ndcDynamicInputs]=\"{\n                'mode': mode,\n                'originalMode': originalMode,\n                'field': field,\n                'klass': klass,\n                'record': record,\n                'parent': parent\n            }\"\n            ></ndc-dynamic>\n        </a>\n    </ng-container>\n    <ng-container *ngIf=\"!isLink() && !hasOnClick()\">\n        <ndc-dynamic\n            [ndcDynamicComponent]=\"componentType\"\n            [ndcDynamicInputs]=\"{\n            'mode': mode,\n            'originalMode': originalMode,\n            'field': field,\n            'klass': klass,\n            'record': record,\n            'parent': parent\n        }\"\n        ></ndc-dynamic>\n    </ng-container>\n</ng-container>\n\n<ng-container *ngIf=\"field.loading\">\n   <div class= \"dynamic-field\">\n        <div class=\"flex-grow-1 text-break rounded box-loading skeleton-field-content\"></div>\n   </div>\n</ng-container>\n<ng-container *ngIf=\"isEdit() && field.formControl && field.formControl.errors\">\n    <ng-container *ngIf=\"validateOnlyOnSubmit ? isInvalid() : (field.formControl.invalid && field.formControl.touched)\">\n        <div *ngFor=\"let item of field.formControl.errors | keyvalue\" class=\"invalid-feedback d-block\">\n            <scrm-dynamic-label [context]=\"getMessageContext(item.value, record)\"\n                                [fields]=\"{field: field}\"\n                                [labelKey]=\"getMessageLabelKey(item.value)\">\n            </scrm-dynamic-label>\n        </div>\n    </ng-container>\n</ng-container>\n" }]
    }], function () { return [{ type: i1.ModuleNavigation }, { type: i2.ModuleNameMapper }, { type: i3.Router }, { type: i4.DynamicLabelService }, { type: i5.LinkRouteAsyncActionService }, { type: i0.ChangeDetectorRef }]; }, { mode: [{
            type: Input,
            args: ['mode']
        }], originalMode: [{
            type: Input,
            args: ['originalMode']
        }], type: [{
            type: Input,
            args: ['type']
        }], field: [{
            type: Input,
            args: ['field']
        }], record: [{
            type: Input,
            args: ['record']
        }], parent: [{
            type: Input,
            args: ['parent']
        }], klass: [{
            type: Input,
            args: ['klass']
        }], componentType: [{
            type: Input,
            args: ['componentType']
        }], class: [{
            type: HostBinding,
            args: ['class']
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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