{* modules/crep_Contacts/tpls/DelayReport.tpl *}
<div class="moduleTitle">
    <h2>{$APP.LBL_REPORTS} - Contact Call Delay Report</h2>
</div>

<div class="listViewBody">
    <form method="get" action="index.php" class="edit view" style="margin-bottom:15px;">
        <input type="hidden" name="module" value="crep_Contacts"/>
        <input type="hidden" name="action" value="delayreport"/>
        <div class="form-group">
            <label>
                {$APP.LBL_DELAY_GREATER_THAN}
                <input type="number" name="minutes" value="{$MINUTES}" min="1" class="form-control" style="width:60px; display:inline-block;"/>
                {$APP.LBL_MINUTES}
            </label>
            &nbsp;&nbsp;
            <label>
                {$APP.LBL_FROM}:
                <input type="date" name="start" value="{$START}" class="form-control" style="display:inline-block;"/>
            </label>
            &nbsp;&nbsp;
            <label>
                {$APP.LBL_TO}:
                <input type="date" name="end" value="{$END}" class="form-control" style="display:inline-block;"/>
            </label>
            &nbsp;&nbsp;
            <input type="submit" value="{$APP.LBL_FILTER}" class="btn btn-primary"/>
        </div>
    </form>

    <div class="table-responsive" style="overflow-x: auto;">
        <table class="list view table responsive-table" cellpadding="0" cellspacing="0">
            <thead>
                <tr>
                    <th scope="col" nowrap="nowrap">{$APP.LBL_CONTACT}</th>
                    <th scope="col" nowrap="nowrap">{$APP.LBL_DATE_ENTERED}</th>
                    <th scope="col" nowrap="nowrap">{$APP.LBL_FIRST_CALL}</th>
                    <th scope="col" nowrap="nowrap">{$APP.LBL_DELAY_MINUTES}</th>
                </tr>
            </thead>
            <tbody>
                {if $ROWS|@count > 0}
                    {foreach from=$ROWS item=row}
                        <tr class="{cycle values="oddListRowS1,evenListRowS1"}">
                            <td style="min-width:150px;">
                                <a href="index.php?module=Contacts&action=DetailView&record={$row.id}">
                                    {$row.first_name} {$row.last_name}
                                </a>
                            </td>
                            <td style="min-width:120px;">{$row.date_entered}</td>
                            <td style="min-width:120px;">
                                {if $row.first_call_date}
                                    {$row.first_call_date}
                                {else}
                                    <span style="color:red;">{$APP.LBL_NO_CALL}</span>
                                {/if}
                            </td>
                            <td style="min-width:100px;">{$row.delay_minutes}</td>
                        </tr>
                    {/foreach}
                {else}
                    <tr class="oddListRowS1">
                        <td colspan="4" style="text-align:center; padding:10px;">{$APP.LBL_NO_RECORDS_FOUND}</td>
                    </tr>
                {/if}
            </tbody>
        </table>
    </div>
</div>

<style>
    .listViewBody {
        margin: 10px;
    }
    .responsive-table {
        width: 100%;
        border-collapse: collapse;
    }
    .responsive-table th, .responsive-table td {
        padding: 8px;
        text-align: left;
        vertical-align: middle;
    }
    .table-responsive {
        overflow-x: auto;
    }
    @media (max-width: 768px) {
        .responsive-table th, .responsive-table td {
            min-width: 100px;
        }
    }
</style>