<?php

if (!defined('sugarEntry')) {
    define('sugarEntry', true);
}

require_once('include/entryPoint.php');
require_once('data/BeanFactory.php');
require_once('include/TimeDate.php');

header('Content-Type: application/json');

$username = isset($_GET['username']) ? trim($_GET['username']) : '';

if (empty($username)) {
    die(json_encode(['status' => 'error', 'message' => 'Missing username']));
}

// Search for contact by custom field username_c
global $db;
$username_escaped = $db->quote($username);

// print_r($username_escaped);exit;
// NEW: search by last_name instead of username_c
$query = "SELECT id FROM contacts
          WHERE last_name = '{$username_escaped}'
          LIMIT 1";
$result = $db->query($query);
$row = $db->fetchByAssoc($result);

if (!$row || empty($row['id'])) {
    die(json_encode(['status' => 'error', 'message' => 'Contact not found']));
}

// // Load the contact bean using the found ID
// $contact = BeanFactory::getBean('Contacts', $row['id']);


// Load the contact bean using the found ID
$contact = BeanFactory::getBean('Contacts', $row['id']);

if (!$contact || empty($contact->id)) {
    die(json_encode(['status' => 'error', 'message' => 'Contact not found']));
}

// Update custom fields
$contact->tag_c = 'vip'; 
$contact->call_status_c = 'deposit';
// print_r($dt);exit;
// $contact->last_deposit_date_c = $dt->format('Y-m-d H:i:s');
// $contact->last_deposit_date_c = TimeDate::getInstance()->nowDb();

$contact->save();
$dt = new DateTime('now', new DateTimeZone('Asia/Dhaka')); // GMT+6
$formatted_date = $dt->format('Y-m-d H:i:s');

$contactId = $db->quote($contact->id);

// Build and run the query
$query = "UPDATE contacts_cstm 
          SET last_deposit_date_c = '{$formatted_date}' 
          WHERE id_c = '$contactId'";
// print_r($query);exit;

$db->query($query);
echo json_encode([
    'status' => 'success',
    'message' => 'Contact updated successfully',
    'username' => $contact->last_name,
    'tag'       => $contact->tag_c,
    'call_status'   => $contact->call_status_c,
    'contact_id' => $contact->id
]);
